/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import java.util.Optional;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.ledger.ImmutablePayChannelObject;
import org.xrpl.xrpl4j.model.ledger.LedgerObject;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

@JsonSerialize(as=ImmutablePayChannelObject.class)
@JsonDeserialize(as=ImmutablePayChannelObject.class)
@Value.Immutable
public interface PayChannelObject
extends LedgerObject {
    public static ImmutablePayChannelObject.Builder builder() {
        return ImmutablePayChannelObject.builder();
    }

    @JsonProperty(value="LedgerEntryType")
    @Value.Derived
    default public LedgerObject.LedgerEntryType ledgerEntryType() {
        return LedgerObject.LedgerEntryType.PAY_CHANNEL;
    }

    @JsonProperty(value="Flags")
    @Value.Derived
    default public Flags flags() {
        return Flags.UNSET;
    }

    @JsonProperty(value="Account")
    public Address account();

    @JsonProperty(value="Destination")
    public Address destination();

    @JsonProperty(value="Amount")
    public XrpCurrencyAmount amount();

    @JsonProperty(value="Balance")
    public XrpCurrencyAmount balance();

    @JsonProperty(value="PublicKey")
    public String publicKey();

    @JsonProperty(value="SettleDelay")
    public UnsignedLong settleDelay();

    @JsonProperty(value="OwnerNode")
    public String ownerNode();

    @JsonProperty(value="PreviousTxnID")
    public Hash256 previousTransactionId();

    @JsonProperty(value="PreviousTxnLgrSeq")
    public UnsignedInteger previousTransactionLedgerSequence();

    @JsonProperty(value="Expiration")
    public Optional<UnsignedLong> expiration();

    @JsonProperty(value="CancelAfter")
    public Optional<UnsignedLong> cancelAfter();

    @JsonProperty(value="SourceTag")
    public Optional<UnsignedInteger> sourceTag();

    @JsonProperty(value="DestinationTag")
    public Optional<UnsignedInteger> destinationTag();

    public Hash256 index();
}

