/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.primitives.UnsignedInteger;
import java.util.Optional;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.flags.NfTokenOfferFlags;
import org.xrpl.xrpl4j.model.ledger.ImmutableNfTokenOfferObject;
import org.xrpl.xrpl4j.model.ledger.LedgerObject;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.CurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.NfTokenId;

@JsonSerialize(as=ImmutableNfTokenOfferObject.class)
@JsonDeserialize(as=ImmutableNfTokenOfferObject.class)
@Value.Immutable
public interface NfTokenOfferObject
extends LedgerObject {
    public static ImmutableNfTokenOfferObject.Builder builder() {
        return ImmutableNfTokenOfferObject.builder();
    }

    @JsonProperty(value="LedgerEntryType")
    @Value.Derived
    default public LedgerObject.LedgerEntryType ledgerEntryType() {
        return LedgerObject.LedgerEntryType.NFTOKEN_OFFER;
    }

    @JsonProperty(value="Amount")
    public CurrencyAmount amount();

    @JsonProperty(value="Owner")
    public Address owner();

    @JsonProperty(value="PreviousTxnID")
    public Hash256 previousTransactionId();

    @JsonProperty(value="PreviousTxnLgrSeq")
    public UnsignedInteger previousTransactionLedgerSequence();

    @JsonProperty(value="NFTokenID")
    public NfTokenId nfTokenId();

    public Optional<UnsignedInteger> expiration();

    @JsonProperty(value="Destination")
    public Optional<Address> destination();

    @JsonProperty(value="OwnerNode")
    public Optional<String> ownerNode();

    @JsonProperty(value="NFTokenOfferNode")
    public Optional<String> offerNode();

    @JsonProperty(value="Flags")
    public NfTokenOfferFlags flags();

    public Hash256 index();
}

