/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import org.xrpl.xrpl4j.model.ledger.ImmutableAccountRootObject;
import org.xrpl.xrpl4j.model.ledger.ImmutableAmmObject;
import org.xrpl.xrpl4j.model.ledger.ImmutableBridgeObject;
import org.xrpl.xrpl4j.model.ledger.ImmutableCheckObject;
import org.xrpl.xrpl4j.model.ledger.ImmutableDepositPreAuthObject;
import org.xrpl.xrpl4j.model.ledger.ImmutableDidObject;
import org.xrpl.xrpl4j.model.ledger.ImmutableEscrowObject;
import org.xrpl.xrpl4j.model.ledger.ImmutableNfTokenOfferObject;
import org.xrpl.xrpl4j.model.ledger.ImmutableNfTokenPageObject;
import org.xrpl.xrpl4j.model.ledger.ImmutableOfferObject;
import org.xrpl.xrpl4j.model.ledger.ImmutablePayChannelObject;
import org.xrpl.xrpl4j.model.ledger.ImmutableRippleStateObject;
import org.xrpl.xrpl4j.model.ledger.ImmutableSignerListObject;
import org.xrpl.xrpl4j.model.ledger.ImmutableTicketObject;
import org.xrpl.xrpl4j.model.ledger.ImmutableUnknownLedgerObject;
import org.xrpl.xrpl4j.model.ledger.ImmutableXChainOwnedClaimIdObject;
import org.xrpl.xrpl4j.model.ledger.ImmutableXChainOwnedCreateAccountClaimIdObject;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="LedgerEntryType", defaultImpl=ImmutableUnknownLedgerObject.class, visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=ImmutableAccountRootObject.class, name="AccountRoot"), @JsonSubTypes.Type(value=ImmutableCheckObject.class, name="Check"), @JsonSubTypes.Type(value=ImmutableDepositPreAuthObject.class, name="DepositPreauth"), @JsonSubTypes.Type(value=ImmutableEscrowObject.class, name="Escrow"), @JsonSubTypes.Type(value=ImmutableNfTokenOfferObject.class, name="NFTokenOffer"), @JsonSubTypes.Type(value=ImmutableOfferObject.class, name="Offer"), @JsonSubTypes.Type(value=ImmutablePayChannelObject.class, name="PayChannel"), @JsonSubTypes.Type(value=ImmutableRippleStateObject.class, name="RippleState"), @JsonSubTypes.Type(value=ImmutableSignerListObject.class, name="SignerList"), @JsonSubTypes.Type(value=ImmutableTicketObject.class, name="Ticket"), @JsonSubTypes.Type(value=ImmutableAmmObject.class, name="AMM"), @JsonSubTypes.Type(value=ImmutableNfTokenPageObject.class, name="NFTokenPage"), @JsonSubTypes.Type(value=ImmutableBridgeObject.class, name="Bridge"), @JsonSubTypes.Type(value=ImmutableXChainOwnedCreateAccountClaimIdObject.class, name="XChainOwnedCreateAccountClaimID"), @JsonSubTypes.Type(value=ImmutableXChainOwnedClaimIdObject.class, name="XChainOwnedClaimID"), @JsonSubTypes.Type(value=ImmutableDidObject.class, name="DID")})
public interface LedgerObject {

    public static enum LedgerEntryType {
        ACCOUNT_ROOT("AccountRoot"),
        AMENDMENTS("Amendments"),
        CHECK("Check"),
        DEPOSIT_PRE_AUTH("DepositPreauth"),
        DIRECTORY_NODE("DirectoryNode"),
        ESCROW("Escrow"),
        FEE_SETTINGS("FeeSettings"),
        LEDGER_HASHES("LedgerHashes"),
        NEGATIVE_UNL("NegativeUNL"),
        NFTOKEN_OFFER("NFTokenOffer"),
        OFFER("Offer"),
        PAY_CHANNEL("PayChannel"),
        RIPPLE_STATE("RippleState"),
        SIGNER_LIST("SignerList"),
        TICKET("Ticket"),
        NFTOKEN_PAGE("NFTokenPage"),
        AMM("AMM"),
        BRIDGE("Bridge"),
        XCHAIN_OWNED_CREATE_ACCOUNT_CLAIM_ID("XChainOwnedCreateAccountClaimID"),
        XCHAIN_OWNED_CLAIM_ID("XChainOwnedClaimID"),
        DID("DID");

        private final String value;

        private LedgerEntryType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static LedgerEntryType forValue(String value) {
            for (LedgerEntryType type : LedgerEntryType.values()) {
                if (!type.value.equals(value)) continue;
                return type;
            }
            throw new IllegalArgumentException("No matching LedgerEntryType enum value for String value " + value);
        }

        @JsonValue
        public String value() {
            return this.value;
        }
    }
}

