/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.client.transactions.TransactionResult;
import org.xrpl.xrpl4j.model.ledger.ImmutableLedgerHeader;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.Transaction;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

@JsonSerialize(as=ImmutableLedgerHeader.class)
@JsonDeserialize(as=ImmutableLedgerHeader.class)
@Value.Immutable
public interface LedgerHeader {
    public static ImmutableLedgerHeader.Builder builder() {
        return ImmutableLedgerHeader.builder();
    }

    @JsonProperty(value="ledger_index")
    public LedgerIndex ledgerIndex();

    @JsonProperty(value="ledger_hash")
    public Optional<Hash256> ledgerHash();

    @JsonProperty(value="account_hash")
    public Optional<Hash256> accountHash();

    @JsonProperty(value="close_time")
    public Optional<UnsignedLong> closeTime();

    @JsonProperty(value="close_time_human")
    @JsonFormat(pattern="yyyy-MMM-dd HH:mm:ss.SSSSSSSSS z", locale="en_US")
    public Optional<ZonedDateTime> closeTimeHuman();

    @Value.Default
    default public boolean closed() {
        return false;
    }

    @JsonProperty(value="parent_hash")
    public Hash256 parentHash();

    @JsonProperty(value="parent_close_time")
    public Optional<UnsignedLong> parentCloseTime();

    @JsonProperty(value="total_coins")
    public Optional<XrpCurrencyAmount> totalCoins();

    @JsonProperty(value="transaction_hash")
    public Optional<Hash256> transactionHash();

    public List<TransactionResult<? extends Transaction>> transactions();

    @JsonProperty(value="close_time_resolution")
    public Optional<UnsignedInteger> closeTimeResolution();
}

