/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.ledger.LedgerObject;
import org.xrpl.xrpl4j.model.ledger.XChainCreateAccountAttestation;
import org.xrpl.xrpl4j.model.ledger.XChainOwnedCreateAccountClaimIdObject;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.XChainBridge;
import org.xrpl.xrpl4j.model.transactions.XChainCount;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="XChainOwnedCreateAccountClaimIdObject", generator="Immutables")
@Immutable
public final class ImmutableXChainOwnedCreateAccountClaimIdObject
implements XChainOwnedCreateAccountClaimIdObject {
    private final transient LedgerObject.LedgerEntryType ledgerEntryType;
    private final transient Flags flags;
    private final Address account;
    private final XChainBridge xChainBridge;
    private final ImmutableList<XChainCreateAccountAttestation> xChainCreateAccountAttestations;
    private final XChainCount xChainAccountCreateCount;
    private final String ownerNode;
    private final Hash256 previousTransactionId;
    private final UnsignedInteger previousTransactionLedgerSequence;
    private final Hash256 index;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableXChainOwnedCreateAccountClaimIdObject(Address account, XChainBridge xChainBridge, ImmutableList<XChainCreateAccountAttestation> xChainCreateAccountAttestations, XChainCount xChainAccountCreateCount, String ownerNode, Hash256 previousTransactionId, UnsignedInteger previousTransactionLedgerSequence, Hash256 index) {
        this.account = account;
        this.xChainBridge = xChainBridge;
        this.xChainCreateAccountAttestations = xChainCreateAccountAttestations;
        this.xChainAccountCreateCount = xChainAccountCreateCount;
        this.ownerNode = ownerNode;
        this.previousTransactionId = previousTransactionId;
        this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        this.index = index;
        this.ledgerEntryType = this.initShim.ledgerEntryType();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private LedgerObject.LedgerEntryType ledgerEntryTypeInitialize() {
        return XChainOwnedCreateAccountClaimIdObject.super.ledgerEntryType();
    }

    private Flags flagsInitialize() {
        return XChainOwnedCreateAccountClaimIdObject.super.flags();
    }

    @Override
    @JsonProperty(value="LedgerEntryType")
    public LedgerObject.LedgerEntryType ledgerEntryType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ledgerEntryType() : this.ledgerEntryType;
    }

    @Override
    @JsonProperty(value="Flags")
    public Flags flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @JsonProperty(value="Account")
    public Address account() {
        return this.account;
    }

    @Override
    @JsonProperty(value="XChainBridge")
    public XChainBridge xChainBridge() {
        return this.xChainBridge;
    }

    @JsonProperty(value="XChainCreateAccountAttestations")
    public ImmutableList<XChainCreateAccountAttestation> xChainCreateAccountAttestations() {
        return this.xChainCreateAccountAttestations;
    }

    @Override
    @JsonProperty(value="XChainAccountCreateCount")
    public XChainCount xChainAccountCreateCount() {
        return this.xChainAccountCreateCount;
    }

    @Override
    @JsonProperty(value="OwnerNode")
    public String ownerNode() {
        return this.ownerNode;
    }

    @Override
    @JsonProperty(value="PreviousTxnID")
    public Hash256 previousTransactionId() {
        return this.previousTransactionId;
    }

    @Override
    @JsonProperty(value="PreviousTxnLgrSeq")
    public UnsignedInteger previousTransactionLedgerSequence() {
        return this.previousTransactionLedgerSequence;
    }

    @Override
    @JsonProperty(value="index")
    public Hash256 index() {
        return this.index;
    }

    public final ImmutableXChainOwnedCreateAccountClaimIdObject withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutableXChainOwnedCreateAccountClaimIdObject(newValue, this.xChainBridge, this.xChainCreateAccountAttestations, this.xChainAccountCreateCount, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableXChainOwnedCreateAccountClaimIdObject withXChainBridge(XChainBridge value) {
        if (this.xChainBridge == value) {
            return this;
        }
        XChainBridge newValue = Objects.requireNonNull(value, "xChainBridge");
        return new ImmutableXChainOwnedCreateAccountClaimIdObject(this.account, newValue, this.xChainCreateAccountAttestations, this.xChainAccountCreateCount, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableXChainOwnedCreateAccountClaimIdObject withXChainCreateAccountAttestations(XChainCreateAccountAttestation ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableXChainOwnedCreateAccountClaimIdObject(this.account, this.xChainBridge, (ImmutableList<XChainCreateAccountAttestation>)newValue, this.xChainAccountCreateCount, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableXChainOwnedCreateAccountClaimIdObject withXChainCreateAccountAttestations(Iterable<? extends XChainCreateAccountAttestation> elements) {
        if (this.xChainCreateAccountAttestations == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableXChainOwnedCreateAccountClaimIdObject(this.account, this.xChainBridge, (ImmutableList<XChainCreateAccountAttestation>)newValue, this.xChainAccountCreateCount, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableXChainOwnedCreateAccountClaimIdObject withXChainAccountCreateCount(XChainCount value) {
        if (this.xChainAccountCreateCount == value) {
            return this;
        }
        XChainCount newValue = Objects.requireNonNull(value, "xChainAccountCreateCount");
        return new ImmutableXChainOwnedCreateAccountClaimIdObject(this.account, this.xChainBridge, this.xChainCreateAccountAttestations, newValue, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableXChainOwnedCreateAccountClaimIdObject withOwnerNode(String value) {
        String newValue = Objects.requireNonNull(value, "ownerNode");
        if (this.ownerNode.equals(newValue)) {
            return this;
        }
        return new ImmutableXChainOwnedCreateAccountClaimIdObject(this.account, this.xChainBridge, this.xChainCreateAccountAttestations, this.xChainAccountCreateCount, newValue, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableXChainOwnedCreateAccountClaimIdObject withPreviousTransactionId(Hash256 value) {
        if (this.previousTransactionId == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "previousTransactionId");
        return new ImmutableXChainOwnedCreateAccountClaimIdObject(this.account, this.xChainBridge, this.xChainCreateAccountAttestations, this.xChainAccountCreateCount, this.ownerNode, newValue, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableXChainOwnedCreateAccountClaimIdObject withPreviousTransactionLedgerSequence(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "previousTransactionLedgerSequence");
        if (this.previousTransactionLedgerSequence.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableXChainOwnedCreateAccountClaimIdObject(this.account, this.xChainBridge, this.xChainCreateAccountAttestations, this.xChainAccountCreateCount, this.ownerNode, this.previousTransactionId, newValue, this.index);
    }

    public final ImmutableXChainOwnedCreateAccountClaimIdObject withIndex(Hash256 value) {
        if (this.index == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "index");
        return new ImmutableXChainOwnedCreateAccountClaimIdObject(this.account, this.xChainBridge, this.xChainCreateAccountAttestations, this.xChainAccountCreateCount, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableXChainOwnedCreateAccountClaimIdObject && this.equalTo(0, (ImmutableXChainOwnedCreateAccountClaimIdObject)another);
    }

    private boolean equalTo(int synthetic, ImmutableXChainOwnedCreateAccountClaimIdObject another) {
        return this.ledgerEntryType.equals((Object)another.ledgerEntryType) && this.flags.equals(another.flags) && this.account.equals(another.account) && this.xChainBridge.equals(another.xChainBridge) && this.xChainCreateAccountAttestations.equals(another.xChainCreateAccountAttestations) && this.xChainAccountCreateCount.equals(another.xChainAccountCreateCount) && this.ownerNode.equals(another.ownerNode) && this.previousTransactionId.equals(another.previousTransactionId) && this.previousTransactionLedgerSequence.equals((Object)another.previousTransactionLedgerSequence) && this.index.equals(another.index);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.ledgerEntryType.hashCode();
        h += (h << 5) + this.flags.hashCode();
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + this.xChainBridge.hashCode();
        h += (h << 5) + this.xChainCreateAccountAttestations.hashCode();
        h += (h << 5) + this.xChainAccountCreateCount.hashCode();
        h += (h << 5) + this.ownerNode.hashCode();
        h += (h << 5) + this.previousTransactionId.hashCode();
        h += (h << 5) + this.previousTransactionLedgerSequence.hashCode();
        h += (h << 5) + this.index.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"XChainOwnedCreateAccountClaimIdObject").omitNullValues().add("ledgerEntryType", (Object)this.ledgerEntryType).add("flags", (Object)this.flags).add("account", (Object)this.account).add("xChainBridge", (Object)this.xChainBridge).add("xChainCreateAccountAttestations", this.xChainCreateAccountAttestations).add("xChainAccountCreateCount", (Object)this.xChainAccountCreateCount).add("ownerNode", (Object)this.ownerNode).add("previousTransactionId", (Object)this.previousTransactionId).add("previousTransactionLedgerSequence", (Object)this.previousTransactionLedgerSequence).add("index", (Object)this.index).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableXChainOwnedCreateAccountClaimIdObject fromJson(Json json) {
        Builder builder = ImmutableXChainOwnedCreateAccountClaimIdObject.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.xChainBridge != null) {
            builder.xChainBridge(json.xChainBridge);
        }
        if (json.xChainCreateAccountAttestations != null) {
            builder.addAllXChainCreateAccountAttestations(json.xChainCreateAccountAttestations);
        }
        if (json.xChainAccountCreateCount != null) {
            builder.xChainAccountCreateCount(json.xChainAccountCreateCount);
        }
        if (json.ownerNode != null) {
            builder.ownerNode(json.ownerNode);
        }
        if (json.previousTransactionId != null) {
            builder.previousTransactionId(json.previousTransactionId);
        }
        if (json.previousTransactionLedgerSequence != null) {
            builder.previousTransactionLedgerSequence(json.previousTransactionLedgerSequence);
        }
        if (json.index != null) {
            builder.index(json.index);
        }
        return builder.build();
    }

    public static ImmutableXChainOwnedCreateAccountClaimIdObject copyOf(XChainOwnedCreateAccountClaimIdObject instance) {
        if (instance instanceof ImmutableXChainOwnedCreateAccountClaimIdObject) {
            return (ImmutableXChainOwnedCreateAccountClaimIdObject)instance;
        }
        return ImmutableXChainOwnedCreateAccountClaimIdObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="XChainOwnedCreateAccountClaimIdObject", generator="Immutables")
    private final class InitShim {
        private byte ledgerEntryTypeBuildStage = 0;
        private LedgerObject.LedgerEntryType ledgerEntryType;
        private byte flagsBuildStage = 0;
        private Flags flags;

        private InitShim() {
        }

        LedgerObject.LedgerEntryType ledgerEntryType() {
            if (this.ledgerEntryTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ledgerEntryTypeBuildStage == 0) {
                this.ledgerEntryTypeBuildStage = (byte)-1;
                this.ledgerEntryType = Objects.requireNonNull(ImmutableXChainOwnedCreateAccountClaimIdObject.this.ledgerEntryTypeInitialize(), "ledgerEntryType");
                this.ledgerEntryTypeBuildStage = 1;
            }
            return this.ledgerEntryType;
        }

        Flags flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = Objects.requireNonNull(ImmutableXChainOwnedCreateAccountClaimIdObject.this.flagsInitialize(), "flags");
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.ledgerEntryTypeBuildStage == -1) {
                attributes.add("ledgerEntryType");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build XChainOwnedCreateAccountClaimIdObject, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="XChainOwnedCreateAccountClaimIdObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private static final long INIT_BIT_X_CHAIN_BRIDGE = 2L;
        private static final long INIT_BIT_X_CHAIN_ACCOUNT_CREATE_COUNT = 4L;
        private static final long INIT_BIT_OWNER_NODE = 8L;
        private static final long INIT_BIT_PREVIOUS_TRANSACTION_ID = 16L;
        private static final long INIT_BIT_PREVIOUS_TRANSACTION_LEDGER_SEQUENCE = 32L;
        private static final long INIT_BIT_INDEX = 64L;
        private long initBits = 127L;
        @Nullable
        private Address account;
        @Nullable
        private XChainBridge xChainBridge;
        private ImmutableList.Builder<XChainCreateAccountAttestation> xChainCreateAccountAttestations = ImmutableList.builder();
        @Nullable
        private XChainCount xChainAccountCreateCount;
        @Nullable
        private String ownerNode;
        @Nullable
        private Hash256 previousTransactionId;
        @Nullable
        private UnsignedInteger previousTransactionLedgerSequence;
        @Nullable
        private Hash256 index;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(XChainOwnedCreateAccountClaimIdObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.account(instance.account());
            this.xChainBridge(instance.xChainBridge());
            this.addAllXChainCreateAccountAttestations(instance.xChainCreateAccountAttestations());
            this.xChainAccountCreateCount(instance.xChainAccountCreateCount());
            this.ownerNode(instance.ownerNode());
            this.previousTransactionId(instance.previousTransactionId());
            this.previousTransactionLedgerSequence(instance.previousTransactionLedgerSequence());
            this.index(instance.index());
            return this;
        }

        @JsonProperty(value="Account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="XChainBridge")
        @CanIgnoreReturnValue
        public final Builder xChainBridge(XChainBridge xChainBridge) {
            this.xChainBridge = Objects.requireNonNull(xChainBridge, "xChainBridge");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addXChainCreateAccountAttestations(XChainCreateAccountAttestation element) {
            this.xChainCreateAccountAttestations.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addXChainCreateAccountAttestations(XChainCreateAccountAttestation ... elements) {
            this.xChainCreateAccountAttestations.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="XChainCreateAccountAttestations")
        @CanIgnoreReturnValue
        public final Builder xChainCreateAccountAttestations(Iterable<? extends XChainCreateAccountAttestation> elements) {
            this.xChainCreateAccountAttestations = ImmutableList.builder();
            return this.addAllXChainCreateAccountAttestations(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllXChainCreateAccountAttestations(Iterable<? extends XChainCreateAccountAttestation> elements) {
            this.xChainCreateAccountAttestations.addAll(elements);
            return this;
        }

        @JsonProperty(value="XChainAccountCreateCount")
        @CanIgnoreReturnValue
        public final Builder xChainAccountCreateCount(XChainCount xChainAccountCreateCount) {
            this.xChainAccountCreateCount = Objects.requireNonNull(xChainAccountCreateCount, "xChainAccountCreateCount");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="OwnerNode")
        @CanIgnoreReturnValue
        public final Builder ownerNode(String ownerNode) {
            this.ownerNode = Objects.requireNonNull(ownerNode, "ownerNode");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="PreviousTxnID")
        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Hash256 previousTransactionId) {
            this.previousTransactionId = Objects.requireNonNull(previousTransactionId, "previousTransactionId");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(UnsignedInteger previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = Objects.requireNonNull(previousTransactionLedgerSequence, "previousTransactionLedgerSequence");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="index")
        @CanIgnoreReturnValue
        public final Builder index(Hash256 index) {
            this.index = Objects.requireNonNull(index, "index");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public ImmutableXChainOwnedCreateAccountClaimIdObject build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableXChainOwnedCreateAccountClaimIdObject(this.account, this.xChainBridge, this.xChainCreateAccountAttestations.build(), this.xChainAccountCreateCount, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("xChainBridge");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("xChainAccountCreateCount");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("ownerNode");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("previousTransactionId");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("previousTransactionLedgerSequence");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("index");
            }
            return "Cannot build XChainOwnedCreateAccountClaimIdObject, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="XChainOwnedCreateAccountClaimIdObject", generator="Immutables")
    static final class Json
    implements XChainOwnedCreateAccountClaimIdObject {
        @Nullable
        Address account;
        @Nullable
        XChainBridge xChainBridge;
        @Nullable
        List<XChainCreateAccountAttestation> xChainCreateAccountAttestations = ImmutableList.of();
        @Nullable
        XChainCount xChainAccountCreateCount;
        @Nullable
        String ownerNode;
        @Nullable
        Hash256 previousTransactionId;
        @Nullable
        UnsignedInteger previousTransactionLedgerSequence;
        @Nullable
        Hash256 index;

        Json() {
        }

        @JsonProperty(value="Account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="XChainBridge")
        public void setXChainBridge(XChainBridge xChainBridge) {
            this.xChainBridge = xChainBridge;
        }

        @JsonProperty(value="XChainCreateAccountAttestations")
        public void setXChainCreateAccountAttestations(List<XChainCreateAccountAttestation> xChainCreateAccountAttestations) {
            this.xChainCreateAccountAttestations = xChainCreateAccountAttestations;
        }

        @JsonProperty(value="XChainAccountCreateCount")
        public void setXChainAccountCreateCount(XChainCount xChainAccountCreateCount) {
            this.xChainAccountCreateCount = xChainAccountCreateCount;
        }

        @JsonProperty(value="OwnerNode")
        public void setOwnerNode(String ownerNode) {
            this.ownerNode = ownerNode;
        }

        @JsonProperty(value="PreviousTxnID")
        public void setPreviousTransactionId(Hash256 previousTransactionId) {
            this.previousTransactionId = previousTransactionId;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        public void setPreviousTransactionLedgerSequence(UnsignedInteger previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        }

        @JsonProperty(value="index")
        public void setIndex(Hash256 index) {
            this.index = index;
        }

        @Override
        @JsonIgnore
        public LedgerObject.LedgerEntryType ledgerEntryType() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public Flags flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XChainBridge xChainBridge() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<XChainCreateAccountAttestation> xChainCreateAccountAttestations() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XChainCount xChainAccountCreateCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String ownerNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 previousTransactionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger previousTransactionLedgerSequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 index() {
            throw new UnsupportedOperationException();
        }
    }
}

