/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.ledger.LedgerObject;
import org.xrpl.xrpl4j.model.ledger.XChainClaimAttestation;
import org.xrpl.xrpl4j.model.ledger.XChainOwnedClaimIdObject;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.XChainBridge;
import org.xrpl.xrpl4j.model.transactions.XChainClaimId;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="XChainOwnedClaimIdObject", generator="Immutables")
@Immutable
public final class ImmutableXChainOwnedClaimIdObject
implements XChainOwnedClaimIdObject {
    private final transient LedgerObject.LedgerEntryType ledgerEntryType;
    private final transient Flags flags;
    private final Address account;
    private final XChainBridge xChainBridge;
    private final XChainClaimId xChainClaimId;
    private final Address otherChainSource;
    private final ImmutableList<XChainClaimAttestation> xChainClaimAttestations;
    private final XrpCurrencyAmount signatureReward;
    private final String ownerNode;
    private final Hash256 previousTransactionId;
    private final UnsignedInteger previousTransactionLedgerSequence;
    private final Hash256 index;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableXChainOwnedClaimIdObject(Address account, XChainBridge xChainBridge, XChainClaimId xChainClaimId, Address otherChainSource, ImmutableList<XChainClaimAttestation> xChainClaimAttestations, XrpCurrencyAmount signatureReward, String ownerNode, Hash256 previousTransactionId, UnsignedInteger previousTransactionLedgerSequence, Hash256 index) {
        this.account = account;
        this.xChainBridge = xChainBridge;
        this.xChainClaimId = xChainClaimId;
        this.otherChainSource = otherChainSource;
        this.xChainClaimAttestations = xChainClaimAttestations;
        this.signatureReward = signatureReward;
        this.ownerNode = ownerNode;
        this.previousTransactionId = previousTransactionId;
        this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        this.index = index;
        this.ledgerEntryType = this.initShim.ledgerEntryType();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private LedgerObject.LedgerEntryType ledgerEntryTypeInitialize() {
        return XChainOwnedClaimIdObject.super.ledgerEntryType();
    }

    private Flags flagsInitialize() {
        return XChainOwnedClaimIdObject.super.flags();
    }

    @Override
    @JsonProperty(value="LedgerEntryType")
    public LedgerObject.LedgerEntryType ledgerEntryType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ledgerEntryType() : this.ledgerEntryType;
    }

    @Override
    @JsonProperty(value="Flags")
    public Flags flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @JsonProperty(value="Account")
    public Address account() {
        return this.account;
    }

    @Override
    @JsonProperty(value="XChainBridge")
    public XChainBridge xChainBridge() {
        return this.xChainBridge;
    }

    @Override
    @JsonProperty(value="XChainClaimID")
    public XChainClaimId xChainClaimId() {
        return this.xChainClaimId;
    }

    @Override
    @JsonProperty(value="OtherChainSource")
    public Address otherChainSource() {
        return this.otherChainSource;
    }

    @JsonProperty(value="XChainClaimAttestations")
    public ImmutableList<XChainClaimAttestation> xChainClaimAttestations() {
        return this.xChainClaimAttestations;
    }

    @Override
    @JsonProperty(value="SignatureReward")
    public XrpCurrencyAmount signatureReward() {
        return this.signatureReward;
    }

    @Override
    @JsonProperty(value="OwnerNode")
    public String ownerNode() {
        return this.ownerNode;
    }

    @Override
    @JsonProperty(value="PreviousTxnID")
    public Hash256 previousTransactionId() {
        return this.previousTransactionId;
    }

    @Override
    @JsonProperty(value="PreviousTxnLgrSeq")
    public UnsignedInteger previousTransactionLedgerSequence() {
        return this.previousTransactionLedgerSequence;
    }

    @Override
    @JsonProperty(value="index")
    public Hash256 index() {
        return this.index;
    }

    public final ImmutableXChainOwnedClaimIdObject withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutableXChainOwnedClaimIdObject(newValue, this.xChainBridge, this.xChainClaimId, this.otherChainSource, this.xChainClaimAttestations, this.signatureReward, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableXChainOwnedClaimIdObject withXChainBridge(XChainBridge value) {
        if (this.xChainBridge == value) {
            return this;
        }
        XChainBridge newValue = Objects.requireNonNull(value, "xChainBridge");
        return new ImmutableXChainOwnedClaimIdObject(this.account, newValue, this.xChainClaimId, this.otherChainSource, this.xChainClaimAttestations, this.signatureReward, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableXChainOwnedClaimIdObject withXChainClaimId(XChainClaimId value) {
        if (this.xChainClaimId == value) {
            return this;
        }
        XChainClaimId newValue = Objects.requireNonNull(value, "xChainClaimId");
        return new ImmutableXChainOwnedClaimIdObject(this.account, this.xChainBridge, newValue, this.otherChainSource, this.xChainClaimAttestations, this.signatureReward, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableXChainOwnedClaimIdObject withOtherChainSource(Address value) {
        if (this.otherChainSource == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "otherChainSource");
        return new ImmutableXChainOwnedClaimIdObject(this.account, this.xChainBridge, this.xChainClaimId, newValue, this.xChainClaimAttestations, this.signatureReward, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableXChainOwnedClaimIdObject withXChainClaimAttestations(XChainClaimAttestation ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableXChainOwnedClaimIdObject(this.account, this.xChainBridge, this.xChainClaimId, this.otherChainSource, (ImmutableList<XChainClaimAttestation>)newValue, this.signatureReward, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableXChainOwnedClaimIdObject withXChainClaimAttestations(Iterable<? extends XChainClaimAttestation> elements) {
        if (this.xChainClaimAttestations == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableXChainOwnedClaimIdObject(this.account, this.xChainBridge, this.xChainClaimId, this.otherChainSource, (ImmutableList<XChainClaimAttestation>)newValue, this.signatureReward, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableXChainOwnedClaimIdObject withSignatureReward(XrpCurrencyAmount value) {
        if (this.signatureReward == value) {
            return this;
        }
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "signatureReward");
        return new ImmutableXChainOwnedClaimIdObject(this.account, this.xChainBridge, this.xChainClaimId, this.otherChainSource, this.xChainClaimAttestations, newValue, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableXChainOwnedClaimIdObject withOwnerNode(String value) {
        String newValue = Objects.requireNonNull(value, "ownerNode");
        if (this.ownerNode.equals(newValue)) {
            return this;
        }
        return new ImmutableXChainOwnedClaimIdObject(this.account, this.xChainBridge, this.xChainClaimId, this.otherChainSource, this.xChainClaimAttestations, this.signatureReward, newValue, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableXChainOwnedClaimIdObject withPreviousTransactionId(Hash256 value) {
        if (this.previousTransactionId == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "previousTransactionId");
        return new ImmutableXChainOwnedClaimIdObject(this.account, this.xChainBridge, this.xChainClaimId, this.otherChainSource, this.xChainClaimAttestations, this.signatureReward, this.ownerNode, newValue, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableXChainOwnedClaimIdObject withPreviousTransactionLedgerSequence(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "previousTransactionLedgerSequence");
        if (this.previousTransactionLedgerSequence.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableXChainOwnedClaimIdObject(this.account, this.xChainBridge, this.xChainClaimId, this.otherChainSource, this.xChainClaimAttestations, this.signatureReward, this.ownerNode, this.previousTransactionId, newValue, this.index);
    }

    public final ImmutableXChainOwnedClaimIdObject withIndex(Hash256 value) {
        if (this.index == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "index");
        return new ImmutableXChainOwnedClaimIdObject(this.account, this.xChainBridge, this.xChainClaimId, this.otherChainSource, this.xChainClaimAttestations, this.signatureReward, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableXChainOwnedClaimIdObject && this.equalTo(0, (ImmutableXChainOwnedClaimIdObject)another);
    }

    private boolean equalTo(int synthetic, ImmutableXChainOwnedClaimIdObject another) {
        return this.ledgerEntryType.equals((Object)another.ledgerEntryType) && this.flags.equals(another.flags) && this.account.equals(another.account) && this.xChainBridge.equals(another.xChainBridge) && this.xChainClaimId.equals(another.xChainClaimId) && this.otherChainSource.equals(another.otherChainSource) && this.xChainClaimAttestations.equals(another.xChainClaimAttestations) && this.signatureReward.equals(another.signatureReward) && this.ownerNode.equals(another.ownerNode) && this.previousTransactionId.equals(another.previousTransactionId) && this.previousTransactionLedgerSequence.equals((Object)another.previousTransactionLedgerSequence) && this.index.equals(another.index);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.ledgerEntryType.hashCode();
        h += (h << 5) + this.flags.hashCode();
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + this.xChainBridge.hashCode();
        h += (h << 5) + this.xChainClaimId.hashCode();
        h += (h << 5) + this.otherChainSource.hashCode();
        h += (h << 5) + this.xChainClaimAttestations.hashCode();
        h += (h << 5) + this.signatureReward.hashCode();
        h += (h << 5) + this.ownerNode.hashCode();
        h += (h << 5) + this.previousTransactionId.hashCode();
        h += (h << 5) + this.previousTransactionLedgerSequence.hashCode();
        h += (h << 5) + this.index.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"XChainOwnedClaimIdObject").omitNullValues().add("ledgerEntryType", (Object)this.ledgerEntryType).add("flags", (Object)this.flags).add("account", (Object)this.account).add("xChainBridge", (Object)this.xChainBridge).add("xChainClaimId", (Object)this.xChainClaimId).add("otherChainSource", (Object)this.otherChainSource).add("xChainClaimAttestations", this.xChainClaimAttestations).add("signatureReward", (Object)this.signatureReward).add("ownerNode", (Object)this.ownerNode).add("previousTransactionId", (Object)this.previousTransactionId).add("previousTransactionLedgerSequence", (Object)this.previousTransactionLedgerSequence).add("index", (Object)this.index).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableXChainOwnedClaimIdObject fromJson(Json json) {
        Builder builder = ImmutableXChainOwnedClaimIdObject.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.xChainBridge != null) {
            builder.xChainBridge(json.xChainBridge);
        }
        if (json.xChainClaimId != null) {
            builder.xChainClaimId(json.xChainClaimId);
        }
        if (json.otherChainSource != null) {
            builder.otherChainSource(json.otherChainSource);
        }
        if (json.xChainClaimAttestations != null) {
            builder.addAllXChainClaimAttestations(json.xChainClaimAttestations);
        }
        if (json.signatureReward != null) {
            builder.signatureReward(json.signatureReward);
        }
        if (json.ownerNode != null) {
            builder.ownerNode(json.ownerNode);
        }
        if (json.previousTransactionId != null) {
            builder.previousTransactionId(json.previousTransactionId);
        }
        if (json.previousTransactionLedgerSequence != null) {
            builder.previousTransactionLedgerSequence(json.previousTransactionLedgerSequence);
        }
        if (json.index != null) {
            builder.index(json.index);
        }
        return builder.build();
    }

    public static ImmutableXChainOwnedClaimIdObject copyOf(XChainOwnedClaimIdObject instance) {
        if (instance instanceof ImmutableXChainOwnedClaimIdObject) {
            return (ImmutableXChainOwnedClaimIdObject)instance;
        }
        return ImmutableXChainOwnedClaimIdObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="XChainOwnedClaimIdObject", generator="Immutables")
    private final class InitShim {
        private byte ledgerEntryTypeBuildStage = 0;
        private LedgerObject.LedgerEntryType ledgerEntryType;
        private byte flagsBuildStage = 0;
        private Flags flags;

        private InitShim() {
        }

        LedgerObject.LedgerEntryType ledgerEntryType() {
            if (this.ledgerEntryTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ledgerEntryTypeBuildStage == 0) {
                this.ledgerEntryTypeBuildStage = (byte)-1;
                this.ledgerEntryType = Objects.requireNonNull(ImmutableXChainOwnedClaimIdObject.this.ledgerEntryTypeInitialize(), "ledgerEntryType");
                this.ledgerEntryTypeBuildStage = 1;
            }
            return this.ledgerEntryType;
        }

        Flags flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = Objects.requireNonNull(ImmutableXChainOwnedClaimIdObject.this.flagsInitialize(), "flags");
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.ledgerEntryTypeBuildStage == -1) {
                attributes.add("ledgerEntryType");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build XChainOwnedClaimIdObject, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="XChainOwnedClaimIdObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private static final long INIT_BIT_X_CHAIN_BRIDGE = 2L;
        private static final long INIT_BIT_X_CHAIN_CLAIM_ID = 4L;
        private static final long INIT_BIT_OTHER_CHAIN_SOURCE = 8L;
        private static final long INIT_BIT_SIGNATURE_REWARD = 16L;
        private static final long INIT_BIT_OWNER_NODE = 32L;
        private static final long INIT_BIT_PREVIOUS_TRANSACTION_ID = 64L;
        private static final long INIT_BIT_PREVIOUS_TRANSACTION_LEDGER_SEQUENCE = 128L;
        private static final long INIT_BIT_INDEX = 256L;
        private long initBits = 511L;
        @Nullable
        private Address account;
        @Nullable
        private XChainBridge xChainBridge;
        @Nullable
        private XChainClaimId xChainClaimId;
        @Nullable
        private Address otherChainSource;
        private ImmutableList.Builder<XChainClaimAttestation> xChainClaimAttestations = ImmutableList.builder();
        @Nullable
        private XrpCurrencyAmount signatureReward;
        @Nullable
        private String ownerNode;
        @Nullable
        private Hash256 previousTransactionId;
        @Nullable
        private UnsignedInteger previousTransactionLedgerSequence;
        @Nullable
        private Hash256 index;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(XChainOwnedClaimIdObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.account(instance.account());
            this.xChainBridge(instance.xChainBridge());
            this.xChainClaimId(instance.xChainClaimId());
            this.otherChainSource(instance.otherChainSource());
            this.addAllXChainClaimAttestations(instance.xChainClaimAttestations());
            this.signatureReward(instance.signatureReward());
            this.ownerNode(instance.ownerNode());
            this.previousTransactionId(instance.previousTransactionId());
            this.previousTransactionLedgerSequence(instance.previousTransactionLedgerSequence());
            this.index(instance.index());
            return this;
        }

        @JsonProperty(value="Account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="XChainBridge")
        @CanIgnoreReturnValue
        public final Builder xChainBridge(XChainBridge xChainBridge) {
            this.xChainBridge = Objects.requireNonNull(xChainBridge, "xChainBridge");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="XChainClaimID")
        @CanIgnoreReturnValue
        public final Builder xChainClaimId(XChainClaimId xChainClaimId) {
            this.xChainClaimId = Objects.requireNonNull(xChainClaimId, "xChainClaimId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="OtherChainSource")
        @CanIgnoreReturnValue
        public final Builder otherChainSource(Address otherChainSource) {
            this.otherChainSource = Objects.requireNonNull(otherChainSource, "otherChainSource");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addXChainClaimAttestations(XChainClaimAttestation element) {
            this.xChainClaimAttestations.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addXChainClaimAttestations(XChainClaimAttestation ... elements) {
            this.xChainClaimAttestations.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="XChainClaimAttestations")
        @CanIgnoreReturnValue
        public final Builder xChainClaimAttestations(Iterable<? extends XChainClaimAttestation> elements) {
            this.xChainClaimAttestations = ImmutableList.builder();
            return this.addAllXChainClaimAttestations(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllXChainClaimAttestations(Iterable<? extends XChainClaimAttestation> elements) {
            this.xChainClaimAttestations.addAll(elements);
            return this;
        }

        @JsonProperty(value="SignatureReward")
        @CanIgnoreReturnValue
        public final Builder signatureReward(XrpCurrencyAmount signatureReward) {
            this.signatureReward = Objects.requireNonNull(signatureReward, "signatureReward");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="OwnerNode")
        @CanIgnoreReturnValue
        public final Builder ownerNode(String ownerNode) {
            this.ownerNode = Objects.requireNonNull(ownerNode, "ownerNode");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="PreviousTxnID")
        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Hash256 previousTransactionId) {
            this.previousTransactionId = Objects.requireNonNull(previousTransactionId, "previousTransactionId");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(UnsignedInteger previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = Objects.requireNonNull(previousTransactionLedgerSequence, "previousTransactionLedgerSequence");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @JsonProperty(value="index")
        @CanIgnoreReturnValue
        public final Builder index(Hash256 index) {
            this.index = Objects.requireNonNull(index, "index");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public ImmutableXChainOwnedClaimIdObject build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableXChainOwnedClaimIdObject(this.account, this.xChainBridge, this.xChainClaimId, this.otherChainSource, this.xChainClaimAttestations.build(), this.signatureReward, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("xChainBridge");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("xChainClaimId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("otherChainSource");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("signatureReward");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("ownerNode");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("previousTransactionId");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("previousTransactionLedgerSequence");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("index");
            }
            return "Cannot build XChainOwnedClaimIdObject, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="XChainOwnedClaimIdObject", generator="Immutables")
    static final class Json
    implements XChainOwnedClaimIdObject {
        @Nullable
        Address account;
        @Nullable
        XChainBridge xChainBridge;
        @Nullable
        XChainClaimId xChainClaimId;
        @Nullable
        Address otherChainSource;
        @Nullable
        List<XChainClaimAttestation> xChainClaimAttestations = ImmutableList.of();
        @Nullable
        XrpCurrencyAmount signatureReward;
        @Nullable
        String ownerNode;
        @Nullable
        Hash256 previousTransactionId;
        @Nullable
        UnsignedInteger previousTransactionLedgerSequence;
        @Nullable
        Hash256 index;

        Json() {
        }

        @JsonProperty(value="Account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="XChainBridge")
        public void setXChainBridge(XChainBridge xChainBridge) {
            this.xChainBridge = xChainBridge;
        }

        @JsonProperty(value="XChainClaimID")
        public void setXChainClaimId(XChainClaimId xChainClaimId) {
            this.xChainClaimId = xChainClaimId;
        }

        @JsonProperty(value="OtherChainSource")
        public void setOtherChainSource(Address otherChainSource) {
            this.otherChainSource = otherChainSource;
        }

        @JsonProperty(value="XChainClaimAttestations")
        public void setXChainClaimAttestations(List<XChainClaimAttestation> xChainClaimAttestations) {
            this.xChainClaimAttestations = xChainClaimAttestations;
        }

        @JsonProperty(value="SignatureReward")
        public void setSignatureReward(XrpCurrencyAmount signatureReward) {
            this.signatureReward = signatureReward;
        }

        @JsonProperty(value="OwnerNode")
        public void setOwnerNode(String ownerNode) {
            this.ownerNode = ownerNode;
        }

        @JsonProperty(value="PreviousTxnID")
        public void setPreviousTransactionId(Hash256 previousTransactionId) {
            this.previousTransactionId = previousTransactionId;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        public void setPreviousTransactionLedgerSequence(UnsignedInteger previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        }

        @JsonProperty(value="index")
        public void setIndex(Hash256 index) {
            this.index = index;
        }

        @Override
        @JsonIgnore
        public LedgerObject.LedgerEntryType ledgerEntryType() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public Flags flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XChainBridge xChainBridge() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XChainClaimId xChainClaimId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address otherChainSource() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<XChainClaimAttestation> xChainClaimAttestations() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XrpCurrencyAmount signatureReward() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String ownerNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 previousTransactionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger previousTransactionLedgerSequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 index() {
            throw new UnsupportedOperationException();
        }
    }
}

