/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.crypto.keys.PublicKey;
import org.xrpl.xrpl4j.model.ledger.XChainCreateAccountProofSig;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.CurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="XChainCreateAccountProofSig", generator="Immutables")
@Immutable
public final class ImmutableXChainCreateAccountProofSig
implements XChainCreateAccountProofSig {
    private final CurrencyAmount amount;
    private final XrpCurrencyAmount signatureReward;
    private final Address attestationRewardAccount;
    private final Address attestationSignerAccount;
    private final Address destination;
    private final PublicKey publicKey;
    private final boolean wasLockingChainSend;

    private ImmutableXChainCreateAccountProofSig(CurrencyAmount amount, XrpCurrencyAmount signatureReward, Address attestationRewardAccount, Address attestationSignerAccount, Address destination, PublicKey publicKey, boolean wasLockingChainSend) {
        this.amount = amount;
        this.signatureReward = signatureReward;
        this.attestationRewardAccount = attestationRewardAccount;
        this.attestationSignerAccount = attestationSignerAccount;
        this.destination = destination;
        this.publicKey = publicKey;
        this.wasLockingChainSend = wasLockingChainSend;
    }

    @Override
    @JsonProperty(value="Amount")
    public CurrencyAmount amount() {
        return this.amount;
    }

    @Override
    @JsonProperty(value="SignatureReward")
    public XrpCurrencyAmount signatureReward() {
        return this.signatureReward;
    }

    @Override
    @JsonProperty(value="AttestationRewardAccount")
    public Address attestationRewardAccount() {
        return this.attestationRewardAccount;
    }

    @Override
    @JsonProperty(value="AttestationSignerAccount")
    public Address attestationSignerAccount() {
        return this.attestationSignerAccount;
    }

    @Override
    @JsonProperty(value="Destination")
    public Address destination() {
        return this.destination;
    }

    @Override
    @JsonProperty(value="PublicKey")
    public PublicKey publicKey() {
        return this.publicKey;
    }

    @Override
    @JsonProperty(value="WasLockingChainSend")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER)
    public boolean wasLockingChainSend() {
        return this.wasLockingChainSend;
    }

    public final ImmutableXChainCreateAccountProofSig withAmount(CurrencyAmount value) {
        if (this.amount == value) {
            return this;
        }
        CurrencyAmount newValue = Objects.requireNonNull(value, "amount");
        return new ImmutableXChainCreateAccountProofSig(newValue, this.signatureReward, this.attestationRewardAccount, this.attestationSignerAccount, this.destination, this.publicKey, this.wasLockingChainSend);
    }

    public final ImmutableXChainCreateAccountProofSig withSignatureReward(XrpCurrencyAmount value) {
        if (this.signatureReward == value) {
            return this;
        }
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "signatureReward");
        return new ImmutableXChainCreateAccountProofSig(this.amount, newValue, this.attestationRewardAccount, this.attestationSignerAccount, this.destination, this.publicKey, this.wasLockingChainSend);
    }

    public final ImmutableXChainCreateAccountProofSig withAttestationRewardAccount(Address value) {
        if (this.attestationRewardAccount == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "attestationRewardAccount");
        return new ImmutableXChainCreateAccountProofSig(this.amount, this.signatureReward, newValue, this.attestationSignerAccount, this.destination, this.publicKey, this.wasLockingChainSend);
    }

    public final ImmutableXChainCreateAccountProofSig withAttestationSignerAccount(Address value) {
        if (this.attestationSignerAccount == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "attestationSignerAccount");
        return new ImmutableXChainCreateAccountProofSig(this.amount, this.signatureReward, this.attestationRewardAccount, newValue, this.destination, this.publicKey, this.wasLockingChainSend);
    }

    public final ImmutableXChainCreateAccountProofSig withDestination(Address value) {
        if (this.destination == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "destination");
        return new ImmutableXChainCreateAccountProofSig(this.amount, this.signatureReward, this.attestationRewardAccount, this.attestationSignerAccount, newValue, this.publicKey, this.wasLockingChainSend);
    }

    public final ImmutableXChainCreateAccountProofSig withPublicKey(PublicKey value) {
        if (this.publicKey == value) {
            return this;
        }
        PublicKey newValue = Objects.requireNonNull(value, "publicKey");
        return new ImmutableXChainCreateAccountProofSig(this.amount, this.signatureReward, this.attestationRewardAccount, this.attestationSignerAccount, this.destination, newValue, this.wasLockingChainSend);
    }

    public final ImmutableXChainCreateAccountProofSig withWasLockingChainSend(boolean value) {
        if (this.wasLockingChainSend == value) {
            return this;
        }
        return new ImmutableXChainCreateAccountProofSig(this.amount, this.signatureReward, this.attestationRewardAccount, this.attestationSignerAccount, this.destination, this.publicKey, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableXChainCreateAccountProofSig && this.equalTo(0, (ImmutableXChainCreateAccountProofSig)another);
    }

    private boolean equalTo(int synthetic, ImmutableXChainCreateAccountProofSig another) {
        return this.amount.equals(another.amount) && this.signatureReward.equals(another.signatureReward) && this.attestationRewardAccount.equals(another.attestationRewardAccount) && this.attestationSignerAccount.equals(another.attestationSignerAccount) && this.destination.equals(another.destination) && this.publicKey.equals(another.publicKey) && this.wasLockingChainSend == another.wasLockingChainSend;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.amount.hashCode();
        h += (h << 5) + this.signatureReward.hashCode();
        h += (h << 5) + this.attestationRewardAccount.hashCode();
        h += (h << 5) + this.attestationSignerAccount.hashCode();
        h += (h << 5) + this.destination.hashCode();
        h += (h << 5) + this.publicKey.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.wasLockingChainSend);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"XChainCreateAccountProofSig").omitNullValues().add("amount", (Object)this.amount).add("signatureReward", (Object)this.signatureReward).add("attestationRewardAccount", (Object)this.attestationRewardAccount).add("attestationSignerAccount", (Object)this.attestationSignerAccount).add("destination", (Object)this.destination).add("publicKey", (Object)this.publicKey).add("wasLockingChainSend", this.wasLockingChainSend).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableXChainCreateAccountProofSig fromJson(Json json) {
        Builder builder = ImmutableXChainCreateAccountProofSig.builder();
        if (json.amount != null) {
            builder.amount(json.amount);
        }
        if (json.signatureReward != null) {
            builder.signatureReward(json.signatureReward);
        }
        if (json.attestationRewardAccount != null) {
            builder.attestationRewardAccount(json.attestationRewardAccount);
        }
        if (json.attestationSignerAccount != null) {
            builder.attestationSignerAccount(json.attestationSignerAccount);
        }
        if (json.destination != null) {
            builder.destination(json.destination);
        }
        if (json.publicKey != null) {
            builder.publicKey(json.publicKey);
        }
        if (json.wasLockingChainSendIsSet) {
            builder.wasLockingChainSend(json.wasLockingChainSend);
        }
        return builder.build();
    }

    public static ImmutableXChainCreateAccountProofSig copyOf(XChainCreateAccountProofSig instance) {
        if (instance instanceof ImmutableXChainCreateAccountProofSig) {
            return (ImmutableXChainCreateAccountProofSig)instance;
        }
        return ImmutableXChainCreateAccountProofSig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="XChainCreateAccountProofSig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_AMOUNT = 1L;
        private static final long INIT_BIT_SIGNATURE_REWARD = 2L;
        private static final long INIT_BIT_ATTESTATION_REWARD_ACCOUNT = 4L;
        private static final long INIT_BIT_ATTESTATION_SIGNER_ACCOUNT = 8L;
        private static final long INIT_BIT_DESTINATION = 16L;
        private static final long INIT_BIT_PUBLIC_KEY = 32L;
        private static final long INIT_BIT_WAS_LOCKING_CHAIN_SEND = 64L;
        private long initBits = 127L;
        @Nullable
        private CurrencyAmount amount;
        @Nullable
        private XrpCurrencyAmount signatureReward;
        @Nullable
        private Address attestationRewardAccount;
        @Nullable
        private Address attestationSignerAccount;
        @Nullable
        private Address destination;
        @Nullable
        private PublicKey publicKey;
        private boolean wasLockingChainSend;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(XChainCreateAccountProofSig instance) {
            Objects.requireNonNull(instance, "instance");
            this.amount(instance.amount());
            this.signatureReward(instance.signatureReward());
            this.attestationRewardAccount(instance.attestationRewardAccount());
            this.attestationSignerAccount(instance.attestationSignerAccount());
            this.destination(instance.destination());
            this.publicKey(instance.publicKey());
            this.wasLockingChainSend(instance.wasLockingChainSend());
            return this;
        }

        @JsonProperty(value="Amount")
        @CanIgnoreReturnValue
        public final Builder amount(CurrencyAmount amount) {
            this.amount = Objects.requireNonNull(amount, "amount");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="SignatureReward")
        @CanIgnoreReturnValue
        public final Builder signatureReward(XrpCurrencyAmount signatureReward) {
            this.signatureReward = Objects.requireNonNull(signatureReward, "signatureReward");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="AttestationRewardAccount")
        @CanIgnoreReturnValue
        public final Builder attestationRewardAccount(Address attestationRewardAccount) {
            this.attestationRewardAccount = Objects.requireNonNull(attestationRewardAccount, "attestationRewardAccount");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="AttestationSignerAccount")
        @CanIgnoreReturnValue
        public final Builder attestationSignerAccount(Address attestationSignerAccount) {
            this.attestationSignerAccount = Objects.requireNonNull(attestationSignerAccount, "attestationSignerAccount");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="Destination")
        @CanIgnoreReturnValue
        public final Builder destination(Address destination) {
            this.destination = Objects.requireNonNull(destination, "destination");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="PublicKey")
        @CanIgnoreReturnValue
        public final Builder publicKey(PublicKey publicKey) {
            this.publicKey = Objects.requireNonNull(publicKey, "publicKey");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="WasLockingChainSend")
        @JsonFormat(shape=JsonFormat.Shape.NUMBER)
        @CanIgnoreReturnValue
        public final Builder wasLockingChainSend(boolean wasLockingChainSend) {
            this.wasLockingChainSend = wasLockingChainSend;
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public ImmutableXChainCreateAccountProofSig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableXChainCreateAccountProofSig(this.amount, this.signatureReward, this.attestationRewardAccount, this.attestationSignerAccount, this.destination, this.publicKey, this.wasLockingChainSend);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("amount");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("signatureReward");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("attestationRewardAccount");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("attestationSignerAccount");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("destination");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("publicKey");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("wasLockingChainSend");
            }
            return "Cannot build XChainCreateAccountProofSig, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="XChainCreateAccountProofSig", generator="Immutables")
    static final class Json
    implements XChainCreateAccountProofSig {
        @Nullable
        CurrencyAmount amount;
        @Nullable
        XrpCurrencyAmount signatureReward;
        @Nullable
        Address attestationRewardAccount;
        @Nullable
        Address attestationSignerAccount;
        @Nullable
        Address destination;
        @Nullable
        PublicKey publicKey;
        boolean wasLockingChainSend;
        boolean wasLockingChainSendIsSet;

        Json() {
        }

        @JsonProperty(value="Amount")
        public void setAmount(CurrencyAmount amount) {
            this.amount = amount;
        }

        @JsonProperty(value="SignatureReward")
        public void setSignatureReward(XrpCurrencyAmount signatureReward) {
            this.signatureReward = signatureReward;
        }

        @JsonProperty(value="AttestationRewardAccount")
        public void setAttestationRewardAccount(Address attestationRewardAccount) {
            this.attestationRewardAccount = attestationRewardAccount;
        }

        @JsonProperty(value="AttestationSignerAccount")
        public void setAttestationSignerAccount(Address attestationSignerAccount) {
            this.attestationSignerAccount = attestationSignerAccount;
        }

        @JsonProperty(value="Destination")
        public void setDestination(Address destination) {
            this.destination = destination;
        }

        @JsonProperty(value="PublicKey")
        public void setPublicKey(PublicKey publicKey) {
            this.publicKey = publicKey;
        }

        @JsonProperty(value="WasLockingChainSend")
        @JsonFormat(shape=JsonFormat.Shape.NUMBER)
        public void setWasLockingChainSend(boolean wasLockingChainSend) {
            this.wasLockingChainSend = wasLockingChainSend;
            this.wasLockingChainSendIsSet = true;
        }

        @Override
        public CurrencyAmount amount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XrpCurrencyAmount signatureReward() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address attestationRewardAccount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address attestationSignerAccount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address destination() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PublicKey publicKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean wasLockingChainSend() {
            throw new UnsupportedOperationException();
        }
    }
}

