/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.crypto.keys.PublicKey;
import org.xrpl.xrpl4j.model.ledger.XChainClaimProofSig;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.CurrencyAmount;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="XChainClaimProofSig", generator="Immutables")
@Immutable
public final class ImmutableXChainClaimProofSig
implements XChainClaimProofSig {
    private final Address attestationSignerAccount;
    private final PublicKey publicKey;
    private final CurrencyAmount amount;
    private final Address attestationRewardAccount;
    private final boolean wasLockingChainSend;
    @Nullable
    private final Address destination;

    private ImmutableXChainClaimProofSig(Address attestationSignerAccount, PublicKey publicKey, CurrencyAmount amount, Address attestationRewardAccount, boolean wasLockingChainSend, @Nullable Address destination) {
        this.attestationSignerAccount = attestationSignerAccount;
        this.publicKey = publicKey;
        this.amount = amount;
        this.attestationRewardAccount = attestationRewardAccount;
        this.wasLockingChainSend = wasLockingChainSend;
        this.destination = destination;
    }

    @Override
    @JsonProperty(value="AttestationSignerAccount")
    public Address attestationSignerAccount() {
        return this.attestationSignerAccount;
    }

    @Override
    @JsonProperty(value="PublicKey")
    public PublicKey publicKey() {
        return this.publicKey;
    }

    @Override
    @JsonProperty(value="Amount")
    public CurrencyAmount amount() {
        return this.amount;
    }

    @Override
    @JsonProperty(value="AttestationRewardAccount")
    public Address attestationRewardAccount() {
        return this.attestationRewardAccount;
    }

    @Override
    @JsonProperty(value="WasLockingChainSend")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER)
    public boolean wasLockingChainSend() {
        return this.wasLockingChainSend;
    }

    @Override
    @JsonProperty(value="Destination")
    public Optional<Address> destination() {
        return Optional.ofNullable(this.destination);
    }

    public final ImmutableXChainClaimProofSig withAttestationSignerAccount(Address value) {
        if (this.attestationSignerAccount == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "attestationSignerAccount");
        return new ImmutableXChainClaimProofSig(newValue, this.publicKey, this.amount, this.attestationRewardAccount, this.wasLockingChainSend, this.destination);
    }

    public final ImmutableXChainClaimProofSig withPublicKey(PublicKey value) {
        if (this.publicKey == value) {
            return this;
        }
        PublicKey newValue = Objects.requireNonNull(value, "publicKey");
        return new ImmutableXChainClaimProofSig(this.attestationSignerAccount, newValue, this.amount, this.attestationRewardAccount, this.wasLockingChainSend, this.destination);
    }

    public final ImmutableXChainClaimProofSig withAmount(CurrencyAmount value) {
        if (this.amount == value) {
            return this;
        }
        CurrencyAmount newValue = Objects.requireNonNull(value, "amount");
        return new ImmutableXChainClaimProofSig(this.attestationSignerAccount, this.publicKey, newValue, this.attestationRewardAccount, this.wasLockingChainSend, this.destination);
    }

    public final ImmutableXChainClaimProofSig withAttestationRewardAccount(Address value) {
        if (this.attestationRewardAccount == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "attestationRewardAccount");
        return new ImmutableXChainClaimProofSig(this.attestationSignerAccount, this.publicKey, this.amount, newValue, this.wasLockingChainSend, this.destination);
    }

    public final ImmutableXChainClaimProofSig withWasLockingChainSend(boolean value) {
        if (this.wasLockingChainSend == value) {
            return this;
        }
        return new ImmutableXChainClaimProofSig(this.attestationSignerAccount, this.publicKey, this.amount, this.attestationRewardAccount, value, this.destination);
    }

    public final ImmutableXChainClaimProofSig withDestination(Address value) {
        Address newValue = Objects.requireNonNull(value, "destination");
        if (this.destination == newValue) {
            return this;
        }
        return new ImmutableXChainClaimProofSig(this.attestationSignerAccount, this.publicKey, this.amount, this.attestationRewardAccount, this.wasLockingChainSend, newValue);
    }

    public final ImmutableXChainClaimProofSig withDestination(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.destination == value) {
            return this;
        }
        return new ImmutableXChainClaimProofSig(this.attestationSignerAccount, this.publicKey, this.amount, this.attestationRewardAccount, this.wasLockingChainSend, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableXChainClaimProofSig && this.equalTo(0, (ImmutableXChainClaimProofSig)another);
    }

    private boolean equalTo(int synthetic, ImmutableXChainClaimProofSig another) {
        return this.attestationSignerAccount.equals(another.attestationSignerAccount) && this.publicKey.equals(another.publicKey) && this.amount.equals(another.amount) && this.attestationRewardAccount.equals(another.attestationRewardAccount) && this.wasLockingChainSend == another.wasLockingChainSend && Objects.equals(this.destination, another.destination);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.attestationSignerAccount.hashCode();
        h += (h << 5) + this.publicKey.hashCode();
        h += (h << 5) + this.amount.hashCode();
        h += (h << 5) + this.attestationRewardAccount.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.wasLockingChainSend);
        h += (h << 5) + Objects.hashCode(this.destination);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"XChainClaimProofSig").omitNullValues().add("attestationSignerAccount", (Object)this.attestationSignerAccount).add("publicKey", (Object)this.publicKey).add("amount", (Object)this.amount).add("attestationRewardAccount", (Object)this.attestationRewardAccount).add("wasLockingChainSend", this.wasLockingChainSend).add("destination", (Object)this.destination).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableXChainClaimProofSig fromJson(Json json) {
        Builder builder = ImmutableXChainClaimProofSig.builder();
        if (json.attestationSignerAccount != null) {
            builder.attestationSignerAccount(json.attestationSignerAccount);
        }
        if (json.publicKey != null) {
            builder.publicKey(json.publicKey);
        }
        if (json.amount != null) {
            builder.amount(json.amount);
        }
        if (json.attestationRewardAccount != null) {
            builder.attestationRewardAccount(json.attestationRewardAccount);
        }
        if (json.wasLockingChainSendIsSet) {
            builder.wasLockingChainSend(json.wasLockingChainSend);
        }
        if (json.destination != null) {
            builder.destination(json.destination);
        }
        return builder.build();
    }

    public static ImmutableXChainClaimProofSig copyOf(XChainClaimProofSig instance) {
        if (instance instanceof ImmutableXChainClaimProofSig) {
            return (ImmutableXChainClaimProofSig)instance;
        }
        return ImmutableXChainClaimProofSig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="XChainClaimProofSig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ATTESTATION_SIGNER_ACCOUNT = 1L;
        private static final long INIT_BIT_PUBLIC_KEY = 2L;
        private static final long INIT_BIT_AMOUNT = 4L;
        private static final long INIT_BIT_ATTESTATION_REWARD_ACCOUNT = 8L;
        private static final long INIT_BIT_WAS_LOCKING_CHAIN_SEND = 16L;
        private long initBits = 31L;
        @Nullable
        private Address attestationSignerAccount;
        @Nullable
        private PublicKey publicKey;
        @Nullable
        private CurrencyAmount amount;
        @Nullable
        private Address attestationRewardAccount;
        private boolean wasLockingChainSend;
        @Nullable
        private Address destination;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(XChainClaimProofSig instance) {
            Objects.requireNonNull(instance, "instance");
            this.attestationSignerAccount(instance.attestationSignerAccount());
            this.publicKey(instance.publicKey());
            this.amount(instance.amount());
            this.attestationRewardAccount(instance.attestationRewardAccount());
            this.wasLockingChainSend(instance.wasLockingChainSend());
            Optional<Address> destinationOptional = instance.destination();
            if (destinationOptional.isPresent()) {
                this.destination(destinationOptional);
            }
            return this;
        }

        @JsonProperty(value="AttestationSignerAccount")
        @CanIgnoreReturnValue
        public final Builder attestationSignerAccount(Address attestationSignerAccount) {
            this.attestationSignerAccount = Objects.requireNonNull(attestationSignerAccount, "attestationSignerAccount");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="PublicKey")
        @CanIgnoreReturnValue
        public final Builder publicKey(PublicKey publicKey) {
            this.publicKey = Objects.requireNonNull(publicKey, "publicKey");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="Amount")
        @CanIgnoreReturnValue
        public final Builder amount(CurrencyAmount amount) {
            this.amount = Objects.requireNonNull(amount, "amount");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="AttestationRewardAccount")
        @CanIgnoreReturnValue
        public final Builder attestationRewardAccount(Address attestationRewardAccount) {
            this.attestationRewardAccount = Objects.requireNonNull(attestationRewardAccount, "attestationRewardAccount");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="WasLockingChainSend")
        @JsonFormat(shape=JsonFormat.Shape.NUMBER)
        @CanIgnoreReturnValue
        public final Builder wasLockingChainSend(boolean wasLockingChainSend) {
            this.wasLockingChainSend = wasLockingChainSend;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder destination(Address destination) {
            this.destination = Objects.requireNonNull(destination, "destination");
            return this;
        }

        @JsonProperty(value="Destination")
        @CanIgnoreReturnValue
        public final Builder destination(Optional<? extends Address> destination) {
            this.destination = destination.orElse(null);
            return this;
        }

        public ImmutableXChainClaimProofSig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableXChainClaimProofSig(this.attestationSignerAccount, this.publicKey, this.amount, this.attestationRewardAccount, this.wasLockingChainSend, this.destination);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("attestationSignerAccount");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("publicKey");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("amount");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("attestationRewardAccount");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("wasLockingChainSend");
            }
            return "Cannot build XChainClaimProofSig, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="XChainClaimProofSig", generator="Immutables")
    static final class Json
    implements XChainClaimProofSig {
        @Nullable
        Address attestationSignerAccount;
        @Nullable
        PublicKey publicKey;
        @Nullable
        CurrencyAmount amount;
        @Nullable
        Address attestationRewardAccount;
        boolean wasLockingChainSend;
        boolean wasLockingChainSendIsSet;
        @Nullable
        Optional<Address> destination = Optional.empty();

        Json() {
        }

        @JsonProperty(value="AttestationSignerAccount")
        public void setAttestationSignerAccount(Address attestationSignerAccount) {
            this.attestationSignerAccount = attestationSignerAccount;
        }

        @JsonProperty(value="PublicKey")
        public void setPublicKey(PublicKey publicKey) {
            this.publicKey = publicKey;
        }

        @JsonProperty(value="Amount")
        public void setAmount(CurrencyAmount amount) {
            this.amount = amount;
        }

        @JsonProperty(value="AttestationRewardAccount")
        public void setAttestationRewardAccount(Address attestationRewardAccount) {
            this.attestationRewardAccount = attestationRewardAccount;
        }

        @JsonProperty(value="WasLockingChainSend")
        @JsonFormat(shape=JsonFormat.Shape.NUMBER)
        public void setWasLockingChainSend(boolean wasLockingChainSend) {
            this.wasLockingChainSend = wasLockingChainSend;
            this.wasLockingChainSendIsSet = true;
        }

        @JsonProperty(value="Destination")
        public void setDestination(Optional<Address> destination) {
            this.destination = destination;
        }

        @Override
        public Address attestationSignerAccount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PublicKey publicKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CurrencyAmount amount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address attestationRewardAccount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean wasLockingChainSend() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Address> destination() {
            throw new UnsupportedOperationException();
        }
    }
}

