/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.ledger.SignerEntry;
import org.xrpl.xrpl4j.model.transactions.Address;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SignerEntry", generator="Immutables")
@Immutable
public final class ImmutableSignerEntry
implements SignerEntry {
    private final Address account;
    private final UnsignedInteger signerWeight;

    private ImmutableSignerEntry(Address account, UnsignedInteger signerWeight) {
        this.account = account;
        this.signerWeight = signerWeight;
    }

    @Override
    @JsonProperty(value="Account")
    public Address account() {
        return this.account;
    }

    @Override
    @JsonProperty(value="SignerWeight")
    public UnsignedInteger signerWeight() {
        return this.signerWeight;
    }

    public final ImmutableSignerEntry withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutableSignerEntry(newValue, this.signerWeight);
    }

    public final ImmutableSignerEntry withSignerWeight(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "signerWeight");
        if (this.signerWeight.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableSignerEntry(this.account, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSignerEntry && this.equalTo(0, (ImmutableSignerEntry)another);
    }

    private boolean equalTo(int synthetic, ImmutableSignerEntry another) {
        return this.account.equals(another.account) && this.signerWeight.equals((Object)another.signerWeight);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + this.signerWeight.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SignerEntry").omitNullValues().add("account", (Object)this.account).add("signerWeight", (Object)this.signerWeight).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSignerEntry fromJson(Json json) {
        Builder builder = ImmutableSignerEntry.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.signerWeight != null) {
            builder.signerWeight(json.signerWeight);
        }
        return builder.build();
    }

    public static ImmutableSignerEntry copyOf(SignerEntry instance) {
        if (instance instanceof ImmutableSignerEntry) {
            return (ImmutableSignerEntry)instance;
        }
        return ImmutableSignerEntry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SignerEntry", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private static final long INIT_BIT_SIGNER_WEIGHT = 2L;
        private long initBits = 3L;
        @Nullable
        private Address account;
        @Nullable
        private UnsignedInteger signerWeight;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SignerEntry instance) {
            Objects.requireNonNull(instance, "instance");
            this.account(instance.account());
            this.signerWeight(instance.signerWeight());
            return this;
        }

        @JsonProperty(value="Account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="SignerWeight")
        @CanIgnoreReturnValue
        public final Builder signerWeight(UnsignedInteger signerWeight) {
            this.signerWeight = Objects.requireNonNull(signerWeight, "signerWeight");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSignerEntry build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSignerEntry(this.account, this.signerWeight);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("signerWeight");
            }
            return "Cannot build SignerEntry, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SignerEntry", generator="Immutables")
    static final class Json
    implements SignerEntry {
        @Nullable
        Address account;
        @Nullable
        UnsignedInteger signerWeight;

        Json() {
        }

        @JsonProperty(value="Account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="SignerWeight")
        public void setSignerWeight(UnsignedInteger signerWeight) {
            this.signerWeight = signerWeight;
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger signerWeight() {
            throw new UnsupportedOperationException();
        }
    }
}

