/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.flags.RippleStateFlags;
import org.xrpl.xrpl4j.model.ledger.LedgerObject;
import org.xrpl.xrpl4j.model.ledger.RippleStateObject;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.IssuedCurrencyAmount;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RippleStateObject", generator="Immutables")
@Immutable
public final class ImmutableRippleStateObject
implements RippleStateObject {
    private final transient LedgerObject.LedgerEntryType ledgerEntryType;
    private final RippleStateFlags flags;
    private final IssuedCurrencyAmount balance;
    private final IssuedCurrencyAmount lowLimit;
    private final IssuedCurrencyAmount highLimit;
    private final Hash256 previousTransactionId;
    private final UnsignedInteger previousTransactionLedgerSequence;
    @Nullable
    private final String lowNode;
    @Nullable
    private final String highNode;
    @Nullable
    private final UnsignedInteger lowQualityIn;
    @Nullable
    private final UnsignedInteger lowQualityOut;
    @Nullable
    private final UnsignedInteger highQualityIn;
    @Nullable
    private final UnsignedInteger highQualityOut;
    private final Hash256 index;

    private ImmutableRippleStateObject(RippleStateFlags flags, IssuedCurrencyAmount balance, IssuedCurrencyAmount lowLimit, IssuedCurrencyAmount highLimit, Hash256 previousTransactionId, UnsignedInteger previousTransactionLedgerSequence, @Nullable String lowNode, @Nullable String highNode, @Nullable UnsignedInteger lowQualityIn, @Nullable UnsignedInteger lowQualityOut, @Nullable UnsignedInteger highQualityIn, @Nullable UnsignedInteger highQualityOut, Hash256 index) {
        this.flags = flags;
        this.balance = balance;
        this.lowLimit = lowLimit;
        this.highLimit = highLimit;
        this.previousTransactionId = previousTransactionId;
        this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        this.lowNode = lowNode;
        this.highNode = highNode;
        this.lowQualityIn = lowQualityIn;
        this.lowQualityOut = lowQualityOut;
        this.highQualityIn = highQualityIn;
        this.highQualityOut = highQualityOut;
        this.index = index;
        this.ledgerEntryType = Objects.requireNonNull(RippleStateObject.super.ledgerEntryType(), "ledgerEntryType");
    }

    @Override
    @JsonProperty(value="LedgerEntryType")
    public LedgerObject.LedgerEntryType ledgerEntryType() {
        return this.ledgerEntryType;
    }

    @Override
    @JsonProperty(value="Flags")
    public RippleStateFlags flags() {
        return this.flags;
    }

    @Override
    @JsonProperty(value="Balance")
    public IssuedCurrencyAmount balance() {
        return this.balance;
    }

    @Override
    @JsonProperty(value="LowLimit")
    public IssuedCurrencyAmount lowLimit() {
        return this.lowLimit;
    }

    @Override
    @JsonProperty(value="HighLimit")
    public IssuedCurrencyAmount highLimit() {
        return this.highLimit;
    }

    @Override
    @JsonProperty(value="PreviousTxnID")
    public Hash256 previousTransactionId() {
        return this.previousTransactionId;
    }

    @Override
    @JsonProperty(value="PreviousTxnLgrSeq")
    public UnsignedInteger previousTransactionLedgerSequence() {
        return this.previousTransactionLedgerSequence;
    }

    @Override
    @JsonProperty(value="LowNode")
    public Optional<String> lowNode() {
        return Optional.ofNullable(this.lowNode);
    }

    @Override
    @JsonProperty(value="HighNode")
    public Optional<String> highNode() {
        return Optional.ofNullable(this.highNode);
    }

    @Override
    @JsonProperty(value="LowQualityIn")
    public Optional<UnsignedInteger> lowQualityIn() {
        return Optional.ofNullable(this.lowQualityIn);
    }

    @Override
    @JsonProperty(value="LowQualityOut")
    public Optional<UnsignedInteger> lowQualityOut() {
        return Optional.ofNullable(this.lowQualityOut);
    }

    @Override
    @JsonProperty(value="HighQualityIn")
    public Optional<UnsignedInteger> highQualityIn() {
        return Optional.ofNullable(this.highQualityIn);
    }

    @Override
    @JsonProperty(value="HighQualityOut")
    public Optional<UnsignedInteger> highQualityOut() {
        return Optional.ofNullable(this.highQualityOut);
    }

    @Override
    @JsonProperty(value="index")
    public Hash256 index() {
        return this.index;
    }

    public final ImmutableRippleStateObject withFlags(RippleStateFlags value) {
        if (this.flags == value) {
            return this;
        }
        RippleStateFlags newValue = Objects.requireNonNull(value, "flags");
        return new ImmutableRippleStateObject(newValue, this.balance, this.lowLimit, this.highLimit, this.previousTransactionId, this.previousTransactionLedgerSequence, this.lowNode, this.highNode, this.lowQualityIn, this.lowQualityOut, this.highQualityIn, this.highQualityOut, this.index);
    }

    public final ImmutableRippleStateObject withBalance(IssuedCurrencyAmount value) {
        if (this.balance == value) {
            return this;
        }
        IssuedCurrencyAmount newValue = Objects.requireNonNull(value, "balance");
        return new ImmutableRippleStateObject(this.flags, newValue, this.lowLimit, this.highLimit, this.previousTransactionId, this.previousTransactionLedgerSequence, this.lowNode, this.highNode, this.lowQualityIn, this.lowQualityOut, this.highQualityIn, this.highQualityOut, this.index);
    }

    public final ImmutableRippleStateObject withLowLimit(IssuedCurrencyAmount value) {
        if (this.lowLimit == value) {
            return this;
        }
        IssuedCurrencyAmount newValue = Objects.requireNonNull(value, "lowLimit");
        return new ImmutableRippleStateObject(this.flags, this.balance, newValue, this.highLimit, this.previousTransactionId, this.previousTransactionLedgerSequence, this.lowNode, this.highNode, this.lowQualityIn, this.lowQualityOut, this.highQualityIn, this.highQualityOut, this.index);
    }

    public final ImmutableRippleStateObject withHighLimit(IssuedCurrencyAmount value) {
        if (this.highLimit == value) {
            return this;
        }
        IssuedCurrencyAmount newValue = Objects.requireNonNull(value, "highLimit");
        return new ImmutableRippleStateObject(this.flags, this.balance, this.lowLimit, newValue, this.previousTransactionId, this.previousTransactionLedgerSequence, this.lowNode, this.highNode, this.lowQualityIn, this.lowQualityOut, this.highQualityIn, this.highQualityOut, this.index);
    }

    public final ImmutableRippleStateObject withPreviousTransactionId(Hash256 value) {
        if (this.previousTransactionId == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "previousTransactionId");
        return new ImmutableRippleStateObject(this.flags, this.balance, this.lowLimit, this.highLimit, newValue, this.previousTransactionLedgerSequence, this.lowNode, this.highNode, this.lowQualityIn, this.lowQualityOut, this.highQualityIn, this.highQualityOut, this.index);
    }

    public final ImmutableRippleStateObject withPreviousTransactionLedgerSequence(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "previousTransactionLedgerSequence");
        if (this.previousTransactionLedgerSequence.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableRippleStateObject(this.flags, this.balance, this.lowLimit, this.highLimit, this.previousTransactionId, newValue, this.lowNode, this.highNode, this.lowQualityIn, this.lowQualityOut, this.highQualityIn, this.highQualityOut, this.index);
    }

    public final ImmutableRippleStateObject withLowNode(String value) {
        String newValue = Objects.requireNonNull(value, "lowNode");
        if (Objects.equals(this.lowNode, newValue)) {
            return this;
        }
        return new ImmutableRippleStateObject(this.flags, this.balance, this.lowLimit, this.highLimit, this.previousTransactionId, this.previousTransactionLedgerSequence, newValue, this.highNode, this.lowQualityIn, this.lowQualityOut, this.highQualityIn, this.highQualityOut, this.index);
    }

    public final ImmutableRippleStateObject withLowNode(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.lowNode, value)) {
            return this;
        }
        return new ImmutableRippleStateObject(this.flags, this.balance, this.lowLimit, this.highLimit, this.previousTransactionId, this.previousTransactionLedgerSequence, value, this.highNode, this.lowQualityIn, this.lowQualityOut, this.highQualityIn, this.highQualityOut, this.index);
    }

    public final ImmutableRippleStateObject withHighNode(String value) {
        String newValue = Objects.requireNonNull(value, "highNode");
        if (Objects.equals(this.highNode, newValue)) {
            return this;
        }
        return new ImmutableRippleStateObject(this.flags, this.balance, this.lowLimit, this.highLimit, this.previousTransactionId, this.previousTransactionLedgerSequence, this.lowNode, newValue, this.lowQualityIn, this.lowQualityOut, this.highQualityIn, this.highQualityOut, this.index);
    }

    public final ImmutableRippleStateObject withHighNode(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.highNode, value)) {
            return this;
        }
        return new ImmutableRippleStateObject(this.flags, this.balance, this.lowLimit, this.highLimit, this.previousTransactionId, this.previousTransactionLedgerSequence, this.lowNode, value, this.lowQualityIn, this.lowQualityOut, this.highQualityIn, this.highQualityOut, this.index);
    }

    public final ImmutableRippleStateObject withLowQualityIn(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "lowQualityIn");
        if (Objects.equals(this.lowQualityIn, newValue)) {
            return this;
        }
        return new ImmutableRippleStateObject(this.flags, this.balance, this.lowLimit, this.highLimit, this.previousTransactionId, this.previousTransactionLedgerSequence, this.lowNode, this.highNode, newValue, this.lowQualityOut, this.highQualityIn, this.highQualityOut, this.index);
    }

    public final ImmutableRippleStateObject withLowQualityIn(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.lowQualityIn, value)) {
            return this;
        }
        return new ImmutableRippleStateObject(this.flags, this.balance, this.lowLimit, this.highLimit, this.previousTransactionId, this.previousTransactionLedgerSequence, this.lowNode, this.highNode, value, this.lowQualityOut, this.highQualityIn, this.highQualityOut, this.index);
    }

    public final ImmutableRippleStateObject withLowQualityOut(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "lowQualityOut");
        if (Objects.equals(this.lowQualityOut, newValue)) {
            return this;
        }
        return new ImmutableRippleStateObject(this.flags, this.balance, this.lowLimit, this.highLimit, this.previousTransactionId, this.previousTransactionLedgerSequence, this.lowNode, this.highNode, this.lowQualityIn, newValue, this.highQualityIn, this.highQualityOut, this.index);
    }

    public final ImmutableRippleStateObject withLowQualityOut(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.lowQualityOut, value)) {
            return this;
        }
        return new ImmutableRippleStateObject(this.flags, this.balance, this.lowLimit, this.highLimit, this.previousTransactionId, this.previousTransactionLedgerSequence, this.lowNode, this.highNode, this.lowQualityIn, value, this.highQualityIn, this.highQualityOut, this.index);
    }

    public final ImmutableRippleStateObject withHighQualityIn(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "highQualityIn");
        if (Objects.equals(this.highQualityIn, newValue)) {
            return this;
        }
        return new ImmutableRippleStateObject(this.flags, this.balance, this.lowLimit, this.highLimit, this.previousTransactionId, this.previousTransactionLedgerSequence, this.lowNode, this.highNode, this.lowQualityIn, this.lowQualityOut, newValue, this.highQualityOut, this.index);
    }

    public final ImmutableRippleStateObject withHighQualityIn(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.highQualityIn, value)) {
            return this;
        }
        return new ImmutableRippleStateObject(this.flags, this.balance, this.lowLimit, this.highLimit, this.previousTransactionId, this.previousTransactionLedgerSequence, this.lowNode, this.highNode, this.lowQualityIn, this.lowQualityOut, value, this.highQualityOut, this.index);
    }

    public final ImmutableRippleStateObject withHighQualityOut(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "highQualityOut");
        if (Objects.equals(this.highQualityOut, newValue)) {
            return this;
        }
        return new ImmutableRippleStateObject(this.flags, this.balance, this.lowLimit, this.highLimit, this.previousTransactionId, this.previousTransactionLedgerSequence, this.lowNode, this.highNode, this.lowQualityIn, this.lowQualityOut, this.highQualityIn, newValue, this.index);
    }

    public final ImmutableRippleStateObject withHighQualityOut(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.highQualityOut, value)) {
            return this;
        }
        return new ImmutableRippleStateObject(this.flags, this.balance, this.lowLimit, this.highLimit, this.previousTransactionId, this.previousTransactionLedgerSequence, this.lowNode, this.highNode, this.lowQualityIn, this.lowQualityOut, this.highQualityIn, value, this.index);
    }

    public final ImmutableRippleStateObject withIndex(Hash256 value) {
        if (this.index == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "index");
        return new ImmutableRippleStateObject(this.flags, this.balance, this.lowLimit, this.highLimit, this.previousTransactionId, this.previousTransactionLedgerSequence, this.lowNode, this.highNode, this.lowQualityIn, this.lowQualityOut, this.highQualityIn, this.highQualityOut, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRippleStateObject && this.equalTo(0, (ImmutableRippleStateObject)another);
    }

    private boolean equalTo(int synthetic, ImmutableRippleStateObject another) {
        return this.ledgerEntryType.equals((Object)another.ledgerEntryType) && this.flags.equals(another.flags) && this.balance.equals(another.balance) && this.lowLimit.equals(another.lowLimit) && this.highLimit.equals(another.highLimit) && this.previousTransactionId.equals(another.previousTransactionId) && this.previousTransactionLedgerSequence.equals((Object)another.previousTransactionLedgerSequence) && Objects.equals(this.lowNode, another.lowNode) && Objects.equals(this.highNode, another.highNode) && Objects.equals(this.lowQualityIn, another.lowQualityIn) && Objects.equals(this.lowQualityOut, another.lowQualityOut) && Objects.equals(this.highQualityIn, another.highQualityIn) && Objects.equals(this.highQualityOut, another.highQualityOut) && this.index.equals(another.index);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.ledgerEntryType.hashCode();
        h += (h << 5) + this.flags.hashCode();
        h += (h << 5) + this.balance.hashCode();
        h += (h << 5) + this.lowLimit.hashCode();
        h += (h << 5) + this.highLimit.hashCode();
        h += (h << 5) + this.previousTransactionId.hashCode();
        h += (h << 5) + this.previousTransactionLedgerSequence.hashCode();
        h += (h << 5) + Objects.hashCode(this.lowNode);
        h += (h << 5) + Objects.hashCode(this.highNode);
        h += (h << 5) + Objects.hashCode(this.lowQualityIn);
        h += (h << 5) + Objects.hashCode(this.lowQualityOut);
        h += (h << 5) + Objects.hashCode(this.highQualityIn);
        h += (h << 5) + Objects.hashCode(this.highQualityOut);
        h += (h << 5) + this.index.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RippleStateObject").omitNullValues().add("ledgerEntryType", (Object)this.ledgerEntryType).add("flags", (Object)this.flags).add("balance", (Object)this.balance).add("lowLimit", (Object)this.lowLimit).add("highLimit", (Object)this.highLimit).add("previousTransactionId", (Object)this.previousTransactionId).add("previousTransactionLedgerSequence", (Object)this.previousTransactionLedgerSequence).add("lowNode", (Object)this.lowNode).add("highNode", (Object)this.highNode).add("lowQualityIn", (Object)this.lowQualityIn).add("lowQualityOut", (Object)this.lowQualityOut).add("highQualityIn", (Object)this.highQualityIn).add("highQualityOut", (Object)this.highQualityOut).add("index", (Object)this.index).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRippleStateObject fromJson(Json json) {
        Builder builder = ImmutableRippleStateObject.builder();
        if (json.flags != null) {
            builder.flags(json.flags);
        }
        if (json.balance != null) {
            builder.balance(json.balance);
        }
        if (json.lowLimit != null) {
            builder.lowLimit(json.lowLimit);
        }
        if (json.highLimit != null) {
            builder.highLimit(json.highLimit);
        }
        if (json.previousTransactionId != null) {
            builder.previousTransactionId(json.previousTransactionId);
        }
        if (json.previousTransactionLedgerSequence != null) {
            builder.previousTransactionLedgerSequence(json.previousTransactionLedgerSequence);
        }
        if (json.lowNode != null) {
            builder.lowNode(json.lowNode);
        }
        if (json.highNode != null) {
            builder.highNode(json.highNode);
        }
        if (json.lowQualityIn != null) {
            builder.lowQualityIn(json.lowQualityIn);
        }
        if (json.lowQualityOut != null) {
            builder.lowQualityOut(json.lowQualityOut);
        }
        if (json.highQualityIn != null) {
            builder.highQualityIn(json.highQualityIn);
        }
        if (json.highQualityOut != null) {
            builder.highQualityOut(json.highQualityOut);
        }
        if (json.index != null) {
            builder.index(json.index);
        }
        return builder.build();
    }

    public static ImmutableRippleStateObject copyOf(RippleStateObject instance) {
        if (instance instanceof ImmutableRippleStateObject) {
            return (ImmutableRippleStateObject)instance;
        }
        return ImmutableRippleStateObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RippleStateObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_FLAGS = 1L;
        private static final long INIT_BIT_BALANCE = 2L;
        private static final long INIT_BIT_LOW_LIMIT = 4L;
        private static final long INIT_BIT_HIGH_LIMIT = 8L;
        private static final long INIT_BIT_PREVIOUS_TRANSACTION_ID = 16L;
        private static final long INIT_BIT_PREVIOUS_TRANSACTION_LEDGER_SEQUENCE = 32L;
        private static final long INIT_BIT_INDEX = 64L;
        private long initBits = 127L;
        @Nullable
        private RippleStateFlags flags;
        @Nullable
        private IssuedCurrencyAmount balance;
        @Nullable
        private IssuedCurrencyAmount lowLimit;
        @Nullable
        private IssuedCurrencyAmount highLimit;
        @Nullable
        private Hash256 previousTransactionId;
        @Nullable
        private UnsignedInteger previousTransactionLedgerSequence;
        @Nullable
        private String lowNode;
        @Nullable
        private String highNode;
        @Nullable
        private UnsignedInteger lowQualityIn;
        @Nullable
        private UnsignedInteger lowQualityOut;
        @Nullable
        private UnsignedInteger highQualityIn;
        @Nullable
        private UnsignedInteger highQualityOut;
        @Nullable
        private Hash256 index;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RippleStateObject instance) {
            Optional<UnsignedInteger> highQualityOutOptional;
            Optional<UnsignedInteger> highQualityInOptional;
            Optional<UnsignedInteger> lowQualityOutOptional;
            Optional<UnsignedInteger> lowQualityInOptional;
            Optional<String> highNodeOptional;
            Objects.requireNonNull(instance, "instance");
            this.flags(instance.flags());
            this.balance(instance.balance());
            this.lowLimit(instance.lowLimit());
            this.highLimit(instance.highLimit());
            this.previousTransactionId(instance.previousTransactionId());
            this.previousTransactionLedgerSequence(instance.previousTransactionLedgerSequence());
            Optional<String> lowNodeOptional = instance.lowNode();
            if (lowNodeOptional.isPresent()) {
                this.lowNode(lowNodeOptional);
            }
            if ((highNodeOptional = instance.highNode()).isPresent()) {
                this.highNode(highNodeOptional);
            }
            if ((lowQualityInOptional = instance.lowQualityIn()).isPresent()) {
                this.lowQualityIn(lowQualityInOptional);
            }
            if ((lowQualityOutOptional = instance.lowQualityOut()).isPresent()) {
                this.lowQualityOut(lowQualityOutOptional);
            }
            if ((highQualityInOptional = instance.highQualityIn()).isPresent()) {
                this.highQualityIn(highQualityInOptional);
            }
            if ((highQualityOutOptional = instance.highQualityOut()).isPresent()) {
                this.highQualityOut(highQualityOutOptional);
            }
            this.index(instance.index());
            return this;
        }

        @JsonProperty(value="Flags")
        @CanIgnoreReturnValue
        public final Builder flags(RippleStateFlags flags) {
            this.flags = Objects.requireNonNull(flags, "flags");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Balance")
        @CanIgnoreReturnValue
        public final Builder balance(IssuedCurrencyAmount balance) {
            this.balance = Objects.requireNonNull(balance, "balance");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="LowLimit")
        @CanIgnoreReturnValue
        public final Builder lowLimit(IssuedCurrencyAmount lowLimit) {
            this.lowLimit = Objects.requireNonNull(lowLimit, "lowLimit");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="HighLimit")
        @CanIgnoreReturnValue
        public final Builder highLimit(IssuedCurrencyAmount highLimit) {
            this.highLimit = Objects.requireNonNull(highLimit, "highLimit");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="PreviousTxnID")
        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Hash256 previousTransactionId) {
            this.previousTransactionId = Objects.requireNonNull(previousTransactionId, "previousTransactionId");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(UnsignedInteger previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = Objects.requireNonNull(previousTransactionLedgerSequence, "previousTransactionLedgerSequence");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lowNode(String lowNode) {
            this.lowNode = Objects.requireNonNull(lowNode, "lowNode");
            return this;
        }

        @JsonProperty(value="LowNode")
        @CanIgnoreReturnValue
        public final Builder lowNode(Optional<String> lowNode) {
            this.lowNode = lowNode.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder highNode(String highNode) {
            this.highNode = Objects.requireNonNull(highNode, "highNode");
            return this;
        }

        @JsonProperty(value="HighNode")
        @CanIgnoreReturnValue
        public final Builder highNode(Optional<String> highNode) {
            this.highNode = highNode.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lowQualityIn(UnsignedInteger lowQualityIn) {
            this.lowQualityIn = Objects.requireNonNull(lowQualityIn, "lowQualityIn");
            return this;
        }

        @JsonProperty(value="LowQualityIn")
        @CanIgnoreReturnValue
        public final Builder lowQualityIn(Optional<? extends UnsignedInteger> lowQualityIn) {
            this.lowQualityIn = lowQualityIn.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lowQualityOut(UnsignedInteger lowQualityOut) {
            this.lowQualityOut = Objects.requireNonNull(lowQualityOut, "lowQualityOut");
            return this;
        }

        @JsonProperty(value="LowQualityOut")
        @CanIgnoreReturnValue
        public final Builder lowQualityOut(Optional<? extends UnsignedInteger> lowQualityOut) {
            this.lowQualityOut = lowQualityOut.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder highQualityIn(UnsignedInteger highQualityIn) {
            this.highQualityIn = Objects.requireNonNull(highQualityIn, "highQualityIn");
            return this;
        }

        @JsonProperty(value="HighQualityIn")
        @CanIgnoreReturnValue
        public final Builder highQualityIn(Optional<? extends UnsignedInteger> highQualityIn) {
            this.highQualityIn = highQualityIn.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder highQualityOut(UnsignedInteger highQualityOut) {
            this.highQualityOut = Objects.requireNonNull(highQualityOut, "highQualityOut");
            return this;
        }

        @JsonProperty(value="HighQualityOut")
        @CanIgnoreReturnValue
        public final Builder highQualityOut(Optional<? extends UnsignedInteger> highQualityOut) {
            this.highQualityOut = highQualityOut.orElse(null);
            return this;
        }

        @JsonProperty(value="index")
        @CanIgnoreReturnValue
        public final Builder index(Hash256 index) {
            this.index = Objects.requireNonNull(index, "index");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public ImmutableRippleStateObject build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRippleStateObject(this.flags, this.balance, this.lowLimit, this.highLimit, this.previousTransactionId, this.previousTransactionLedgerSequence, this.lowNode, this.highNode, this.lowQualityIn, this.lowQualityOut, this.highQualityIn, this.highQualityOut, this.index);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("flags");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("balance");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("lowLimit");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("highLimit");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("previousTransactionId");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("previousTransactionLedgerSequence");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("index");
            }
            return "Cannot build RippleStateObject, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="RippleStateObject", generator="Immutables")
    static final class Json
    implements RippleStateObject {
        @Nullable
        RippleStateFlags flags;
        @Nullable
        IssuedCurrencyAmount balance;
        @Nullable
        IssuedCurrencyAmount lowLimit;
        @Nullable
        IssuedCurrencyAmount highLimit;
        @Nullable
        Hash256 previousTransactionId;
        @Nullable
        UnsignedInteger previousTransactionLedgerSequence;
        @Nullable
        Optional<String> lowNode = Optional.empty();
        @Nullable
        Optional<String> highNode = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> lowQualityIn = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> lowQualityOut = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> highQualityIn = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> highQualityOut = Optional.empty();
        @Nullable
        Hash256 index;

        Json() {
        }

        @JsonProperty(value="Flags")
        public void setFlags(RippleStateFlags flags) {
            this.flags = flags;
        }

        @JsonProperty(value="Balance")
        public void setBalance(IssuedCurrencyAmount balance) {
            this.balance = balance;
        }

        @JsonProperty(value="LowLimit")
        public void setLowLimit(IssuedCurrencyAmount lowLimit) {
            this.lowLimit = lowLimit;
        }

        @JsonProperty(value="HighLimit")
        public void setHighLimit(IssuedCurrencyAmount highLimit) {
            this.highLimit = highLimit;
        }

        @JsonProperty(value="PreviousTxnID")
        public void setPreviousTransactionId(Hash256 previousTransactionId) {
            this.previousTransactionId = previousTransactionId;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        public void setPreviousTransactionLedgerSequence(UnsignedInteger previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        }

        @JsonProperty(value="LowNode")
        public void setLowNode(Optional<String> lowNode) {
            this.lowNode = lowNode;
        }

        @JsonProperty(value="HighNode")
        public void setHighNode(Optional<String> highNode) {
            this.highNode = highNode;
        }

        @JsonProperty(value="LowQualityIn")
        public void setLowQualityIn(Optional<UnsignedInteger> lowQualityIn) {
            this.lowQualityIn = lowQualityIn;
        }

        @JsonProperty(value="LowQualityOut")
        public void setLowQualityOut(Optional<UnsignedInteger> lowQualityOut) {
            this.lowQualityOut = lowQualityOut;
        }

        @JsonProperty(value="HighQualityIn")
        public void setHighQualityIn(Optional<UnsignedInteger> highQualityIn) {
            this.highQualityIn = highQualityIn;
        }

        @JsonProperty(value="HighQualityOut")
        public void setHighQualityOut(Optional<UnsignedInteger> highQualityOut) {
            this.highQualityOut = highQualityOut;
        }

        @JsonProperty(value="index")
        public void setIndex(Hash256 index) {
            this.index = index;
        }

        @Override
        @JsonIgnore
        public LedgerObject.LedgerEntryType ledgerEntryType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RippleStateFlags flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IssuedCurrencyAmount balance() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IssuedCurrencyAmount lowLimit() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IssuedCurrencyAmount highLimit() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 previousTransactionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger previousTransactionLedgerSequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> lowNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> highNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> lowQualityIn() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> lowQualityOut() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> highQualityIn() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> highQualityOut() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 index() {
            throw new UnsupportedOperationException();
        }
    }
}

