/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.ledger.LedgerObject;
import org.xrpl.xrpl4j.model.ledger.NfTokenPageObject;
import org.xrpl.xrpl4j.model.ledger.NfTokenWrapper;
import org.xrpl.xrpl4j.model.transactions.Hash256;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="NfTokenPageObject", generator="Immutables")
@Immutable
public final class ImmutableNfTokenPageObject
implements NfTokenPageObject {
    private final transient LedgerObject.LedgerEntryType ledgerEntryType;
    private final ImmutableList<NfTokenWrapper> nfTokens;
    @Nullable
    private final Hash256 nextPageMin;
    @Nullable
    private final Hash256 previousPageMin;
    @Nullable
    private final Hash256 previousTransactionId;
    @Nullable
    private final LedgerIndex previousTransactionLedgerSequence;
    private final Hash256 index;

    private ImmutableNfTokenPageObject(ImmutableList<NfTokenWrapper> nfTokens, @Nullable Hash256 nextPageMin, @Nullable Hash256 previousPageMin, @Nullable Hash256 previousTransactionId, @Nullable LedgerIndex previousTransactionLedgerSequence, Hash256 index) {
        this.nfTokens = nfTokens;
        this.nextPageMin = nextPageMin;
        this.previousPageMin = previousPageMin;
        this.previousTransactionId = previousTransactionId;
        this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        this.index = index;
        this.ledgerEntryType = Objects.requireNonNull(NfTokenPageObject.super.ledgerEntryType(), "ledgerEntryType");
    }

    @Override
    @JsonProperty(value="LedgerEntryType")
    public LedgerObject.LedgerEntryType ledgerEntryType() {
        return this.ledgerEntryType;
    }

    @JsonProperty(value="NFTokens")
    public ImmutableList<NfTokenWrapper> nfTokens() {
        return this.nfTokens;
    }

    @Override
    @JsonProperty(value="NextPageMin")
    public Optional<Hash256> nextPageMin() {
        return Optional.ofNullable(this.nextPageMin);
    }

    @Override
    @JsonProperty(value="PreviousPageMin")
    public Optional<Hash256> previousPageMin() {
        return Optional.ofNullable(this.previousPageMin);
    }

    @Override
    @JsonProperty(value="PreviousTxnID")
    public Optional<Hash256> previousTransactionId() {
        return Optional.ofNullable(this.previousTransactionId);
    }

    @Override
    @JsonProperty(value="PreviousTxnLgrSeq")
    public Optional<LedgerIndex> previousTransactionLedgerSequence() {
        return Optional.ofNullable(this.previousTransactionLedgerSequence);
    }

    @Override
    @JsonProperty(value="index")
    public Hash256 index() {
        return this.index;
    }

    public final ImmutableNfTokenPageObject withNfTokens(NfTokenWrapper ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableNfTokenPageObject((ImmutableList<NfTokenWrapper>)newValue, this.nextPageMin, this.previousPageMin, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableNfTokenPageObject withNfTokens(Iterable<? extends NfTokenWrapper> elements) {
        if (this.nfTokens == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableNfTokenPageObject((ImmutableList<NfTokenWrapper>)newValue, this.nextPageMin, this.previousPageMin, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableNfTokenPageObject withNextPageMin(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "nextPageMin");
        if (this.nextPageMin == newValue) {
            return this;
        }
        return new ImmutableNfTokenPageObject(this.nfTokens, newValue, this.previousPageMin, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableNfTokenPageObject withNextPageMin(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.nextPageMin == value) {
            return this;
        }
        return new ImmutableNfTokenPageObject(this.nfTokens, value, this.previousPageMin, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableNfTokenPageObject withPreviousPageMin(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "previousPageMin");
        if (this.previousPageMin == newValue) {
            return this;
        }
        return new ImmutableNfTokenPageObject(this.nfTokens, this.nextPageMin, newValue, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableNfTokenPageObject withPreviousPageMin(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.previousPageMin == value) {
            return this;
        }
        return new ImmutableNfTokenPageObject(this.nfTokens, this.nextPageMin, value, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableNfTokenPageObject withPreviousTransactionId(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "previousTransactionId");
        if (this.previousTransactionId == newValue) {
            return this;
        }
        return new ImmutableNfTokenPageObject(this.nfTokens, this.nextPageMin, this.previousPageMin, newValue, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableNfTokenPageObject withPreviousTransactionId(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.previousTransactionId == value) {
            return this;
        }
        return new ImmutableNfTokenPageObject(this.nfTokens, this.nextPageMin, this.previousPageMin, value, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableNfTokenPageObject withPreviousTransactionLedgerSequence(LedgerIndex value) {
        LedgerIndex newValue = Objects.requireNonNull(value, "previousTransactionLedgerSequence");
        if (this.previousTransactionLedgerSequence == newValue) {
            return this;
        }
        return new ImmutableNfTokenPageObject(this.nfTokens, this.nextPageMin, this.previousPageMin, this.previousTransactionId, newValue, this.index);
    }

    public final ImmutableNfTokenPageObject withPreviousTransactionLedgerSequence(Optional<? extends LedgerIndex> optional) {
        LedgerIndex value = optional.orElse(null);
        if (this.previousTransactionLedgerSequence == value) {
            return this;
        }
        return new ImmutableNfTokenPageObject(this.nfTokens, this.nextPageMin, this.previousPageMin, this.previousTransactionId, value, this.index);
    }

    public final ImmutableNfTokenPageObject withIndex(Hash256 value) {
        if (this.index == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "index");
        return new ImmutableNfTokenPageObject(this.nfTokens, this.nextPageMin, this.previousPageMin, this.previousTransactionId, this.previousTransactionLedgerSequence, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNfTokenPageObject && this.equalTo(0, (ImmutableNfTokenPageObject)another);
    }

    private boolean equalTo(int synthetic, ImmutableNfTokenPageObject another) {
        return this.ledgerEntryType.equals((Object)another.ledgerEntryType) && this.nfTokens.equals(another.nfTokens) && Objects.equals(this.nextPageMin, another.nextPageMin) && Objects.equals(this.previousPageMin, another.previousPageMin) && Objects.equals(this.previousTransactionId, another.previousTransactionId) && Objects.equals(this.previousTransactionLedgerSequence, another.previousTransactionLedgerSequence) && this.index.equals(another.index);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.ledgerEntryType.hashCode();
        h += (h << 5) + this.nfTokens.hashCode();
        h += (h << 5) + Objects.hashCode(this.nextPageMin);
        h += (h << 5) + Objects.hashCode(this.previousPageMin);
        h += (h << 5) + Objects.hashCode(this.previousTransactionId);
        h += (h << 5) + Objects.hashCode(this.previousTransactionLedgerSequence);
        h += (h << 5) + this.index.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NfTokenPageObject").omitNullValues().add("ledgerEntryType", (Object)this.ledgerEntryType).add("nfTokens", this.nfTokens).add("nextPageMin", (Object)this.nextPageMin).add("previousPageMin", (Object)this.previousPageMin).add("previousTransactionId", (Object)this.previousTransactionId).add("previousTransactionLedgerSequence", (Object)this.previousTransactionLedgerSequence).add("index", (Object)this.index).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableNfTokenPageObject fromJson(Json json) {
        Builder builder = ImmutableNfTokenPageObject.builder();
        if (json.nfTokens != null) {
            builder.addAllNfTokens(json.nfTokens);
        }
        if (json.nextPageMin != null) {
            builder.nextPageMin(json.nextPageMin);
        }
        if (json.previousPageMin != null) {
            builder.previousPageMin(json.previousPageMin);
        }
        if (json.previousTransactionId != null) {
            builder.previousTransactionId(json.previousTransactionId);
        }
        if (json.previousTransactionLedgerSequence != null) {
            builder.previousTransactionLedgerSequence(json.previousTransactionLedgerSequence);
        }
        if (json.index != null) {
            builder.index(json.index);
        }
        return builder.build();
    }

    public static ImmutableNfTokenPageObject copyOf(NfTokenPageObject instance) {
        if (instance instanceof ImmutableNfTokenPageObject) {
            return (ImmutableNfTokenPageObject)instance;
        }
        return ImmutableNfTokenPageObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NfTokenPageObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_INDEX = 1L;
        private long initBits = 1L;
        private ImmutableList.Builder<NfTokenWrapper> nfTokens = ImmutableList.builder();
        @Nullable
        private Hash256 nextPageMin;
        @Nullable
        private Hash256 previousPageMin;
        @Nullable
        private Hash256 previousTransactionId;
        @Nullable
        private LedgerIndex previousTransactionLedgerSequence;
        @Nullable
        private Hash256 index;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(NfTokenPageObject instance) {
            Optional<LedgerIndex> previousTransactionLedgerSequenceOptional;
            Optional<Hash256> previousTransactionIdOptional;
            Optional<Hash256> previousPageMinOptional;
            Objects.requireNonNull(instance, "instance");
            this.addAllNfTokens(instance.nfTokens());
            Optional<Hash256> nextPageMinOptional = instance.nextPageMin();
            if (nextPageMinOptional.isPresent()) {
                this.nextPageMin(nextPageMinOptional);
            }
            if ((previousPageMinOptional = instance.previousPageMin()).isPresent()) {
                this.previousPageMin(previousPageMinOptional);
            }
            if ((previousTransactionIdOptional = instance.previousTransactionId()).isPresent()) {
                this.previousTransactionId(previousTransactionIdOptional);
            }
            if ((previousTransactionLedgerSequenceOptional = instance.previousTransactionLedgerSequence()).isPresent()) {
                this.previousTransactionLedgerSequence(previousTransactionLedgerSequenceOptional);
            }
            this.index(instance.index());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNfTokens(NfTokenWrapper element) {
            this.nfTokens.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNfTokens(NfTokenWrapper ... elements) {
            this.nfTokens.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="NFTokens")
        @CanIgnoreReturnValue
        public final Builder nfTokens(Iterable<? extends NfTokenWrapper> elements) {
            this.nfTokens = ImmutableList.builder();
            return this.addAllNfTokens(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllNfTokens(Iterable<? extends NfTokenWrapper> elements) {
            this.nfTokens.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nextPageMin(Hash256 nextPageMin) {
            this.nextPageMin = Objects.requireNonNull(nextPageMin, "nextPageMin");
            return this;
        }

        @JsonProperty(value="NextPageMin")
        @CanIgnoreReturnValue
        public final Builder nextPageMin(Optional<? extends Hash256> nextPageMin) {
            this.nextPageMin = nextPageMin.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder previousPageMin(Hash256 previousPageMin) {
            this.previousPageMin = Objects.requireNonNull(previousPageMin, "previousPageMin");
            return this;
        }

        @JsonProperty(value="PreviousPageMin")
        @CanIgnoreReturnValue
        public final Builder previousPageMin(Optional<? extends Hash256> previousPageMin) {
            this.previousPageMin = previousPageMin.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Hash256 previousTransactionId) {
            this.previousTransactionId = Objects.requireNonNull(previousTransactionId, "previousTransactionId");
            return this;
        }

        @JsonProperty(value="PreviousTxnID")
        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Optional<? extends Hash256> previousTransactionId) {
            this.previousTransactionId = previousTransactionId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(LedgerIndex previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = Objects.requireNonNull(previousTransactionLedgerSequence, "previousTransactionLedgerSequence");
            return this;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(Optional<? extends LedgerIndex> previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence.orElse(null);
            return this;
        }

        @JsonProperty(value="index")
        @CanIgnoreReturnValue
        public final Builder index(Hash256 index) {
            this.index = Objects.requireNonNull(index, "index");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableNfTokenPageObject build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNfTokenPageObject(this.nfTokens.build(), this.nextPageMin, this.previousPageMin, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("index");
            }
            return "Cannot build NfTokenPageObject, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="NfTokenPageObject", generator="Immutables")
    static final class Json
    implements NfTokenPageObject {
        @Nullable
        List<NfTokenWrapper> nfTokens = ImmutableList.of();
        @Nullable
        Optional<Hash256> nextPageMin = Optional.empty();
        @Nullable
        Optional<Hash256> previousPageMin = Optional.empty();
        @Nullable
        Optional<Hash256> previousTransactionId = Optional.empty();
        @Nullable
        Optional<LedgerIndex> previousTransactionLedgerSequence = Optional.empty();
        @Nullable
        Hash256 index;

        Json() {
        }

        @JsonProperty(value="NFTokens")
        public void setNfTokens(List<NfTokenWrapper> nfTokens) {
            this.nfTokens = nfTokens;
        }

        @JsonProperty(value="NextPageMin")
        public void setNextPageMin(Optional<Hash256> nextPageMin) {
            this.nextPageMin = nextPageMin;
        }

        @JsonProperty(value="PreviousPageMin")
        public void setPreviousPageMin(Optional<Hash256> previousPageMin) {
            this.previousPageMin = previousPageMin;
        }

        @JsonProperty(value="PreviousTxnID")
        public void setPreviousTransactionId(Optional<Hash256> previousTransactionId) {
            this.previousTransactionId = previousTransactionId;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        public void setPreviousTransactionLedgerSequence(Optional<LedgerIndex> previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        }

        @JsonProperty(value="index")
        public void setIndex(Hash256 index) {
            this.index = index;
        }

        @Override
        @JsonIgnore
        public LedgerObject.LedgerEntryType ledgerEntryType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<NfTokenWrapper> nfTokens() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> nextPageMin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> previousPageMin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> previousTransactionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerIndex> previousTransactionLedgerSequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 index() {
            throw new UnsupportedOperationException();
        }
    }
}

