/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.flags.NfTokenOfferFlags;
import org.xrpl.xrpl4j.model.ledger.LedgerObject;
import org.xrpl.xrpl4j.model.ledger.NfTokenOfferObject;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.CurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.NfTokenId;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="NfTokenOfferObject", generator="Immutables")
@Immutable
public final class ImmutableNfTokenOfferObject
implements NfTokenOfferObject {
    private final transient LedgerObject.LedgerEntryType ledgerEntryType;
    private final CurrencyAmount amount;
    private final Address owner;
    private final Hash256 previousTransactionId;
    private final UnsignedInteger previousTransactionLedgerSequence;
    private final NfTokenId nfTokenId;
    @Nullable
    private final UnsignedInteger expiration;
    @Nullable
    private final Address destination;
    @Nullable
    private final String ownerNode;
    @Nullable
    private final String offerNode;
    private final NfTokenOfferFlags flags;
    private final Hash256 index;

    private ImmutableNfTokenOfferObject(CurrencyAmount amount, Address owner, Hash256 previousTransactionId, UnsignedInteger previousTransactionLedgerSequence, NfTokenId nfTokenId, @Nullable UnsignedInteger expiration, @Nullable Address destination, @Nullable String ownerNode, @Nullable String offerNode, NfTokenOfferFlags flags, Hash256 index) {
        this.amount = amount;
        this.owner = owner;
        this.previousTransactionId = previousTransactionId;
        this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        this.nfTokenId = nfTokenId;
        this.expiration = expiration;
        this.destination = destination;
        this.ownerNode = ownerNode;
        this.offerNode = offerNode;
        this.flags = flags;
        this.index = index;
        this.ledgerEntryType = Objects.requireNonNull(NfTokenOfferObject.super.ledgerEntryType(), "ledgerEntryType");
    }

    @Override
    @JsonProperty(value="LedgerEntryType")
    public LedgerObject.LedgerEntryType ledgerEntryType() {
        return this.ledgerEntryType;
    }

    @Override
    @JsonProperty(value="Amount")
    public CurrencyAmount amount() {
        return this.amount;
    }

    @Override
    @JsonProperty(value="Owner")
    public Address owner() {
        return this.owner;
    }

    @Override
    @JsonProperty(value="PreviousTxnID")
    public Hash256 previousTransactionId() {
        return this.previousTransactionId;
    }

    @Override
    @JsonProperty(value="PreviousTxnLgrSeq")
    public UnsignedInteger previousTransactionLedgerSequence() {
        return this.previousTransactionLedgerSequence;
    }

    @Override
    @JsonProperty(value="NFTokenID")
    public NfTokenId nfTokenId() {
        return this.nfTokenId;
    }

    @Override
    @JsonProperty(value="expiration")
    public Optional<UnsignedInteger> expiration() {
        return Optional.ofNullable(this.expiration);
    }

    @Override
    @JsonProperty(value="Destination")
    public Optional<Address> destination() {
        return Optional.ofNullable(this.destination);
    }

    @Override
    @JsonProperty(value="OwnerNode")
    public Optional<String> ownerNode() {
        return Optional.ofNullable(this.ownerNode);
    }

    @Override
    @JsonProperty(value="NFTokenOfferNode")
    public Optional<String> offerNode() {
        return Optional.ofNullable(this.offerNode);
    }

    @Override
    @JsonProperty(value="Flags")
    public NfTokenOfferFlags flags() {
        return this.flags;
    }

    @Override
    @JsonProperty(value="index")
    public Hash256 index() {
        return this.index;
    }

    public final ImmutableNfTokenOfferObject withAmount(CurrencyAmount value) {
        if (this.amount == value) {
            return this;
        }
        CurrencyAmount newValue = Objects.requireNonNull(value, "amount");
        return new ImmutableNfTokenOfferObject(newValue, this.owner, this.previousTransactionId, this.previousTransactionLedgerSequence, this.nfTokenId, this.expiration, this.destination, this.ownerNode, this.offerNode, this.flags, this.index);
    }

    public final ImmutableNfTokenOfferObject withOwner(Address value) {
        if (this.owner == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "owner");
        return new ImmutableNfTokenOfferObject(this.amount, newValue, this.previousTransactionId, this.previousTransactionLedgerSequence, this.nfTokenId, this.expiration, this.destination, this.ownerNode, this.offerNode, this.flags, this.index);
    }

    public final ImmutableNfTokenOfferObject withPreviousTransactionId(Hash256 value) {
        if (this.previousTransactionId == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "previousTransactionId");
        return new ImmutableNfTokenOfferObject(this.amount, this.owner, newValue, this.previousTransactionLedgerSequence, this.nfTokenId, this.expiration, this.destination, this.ownerNode, this.offerNode, this.flags, this.index);
    }

    public final ImmutableNfTokenOfferObject withPreviousTransactionLedgerSequence(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "previousTransactionLedgerSequence");
        if (this.previousTransactionLedgerSequence.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableNfTokenOfferObject(this.amount, this.owner, this.previousTransactionId, newValue, this.nfTokenId, this.expiration, this.destination, this.ownerNode, this.offerNode, this.flags, this.index);
    }

    public final ImmutableNfTokenOfferObject withNfTokenId(NfTokenId value) {
        if (this.nfTokenId == value) {
            return this;
        }
        NfTokenId newValue = Objects.requireNonNull(value, "nfTokenId");
        return new ImmutableNfTokenOfferObject(this.amount, this.owner, this.previousTransactionId, this.previousTransactionLedgerSequence, newValue, this.expiration, this.destination, this.ownerNode, this.offerNode, this.flags, this.index);
    }

    public final ImmutableNfTokenOfferObject withExpiration(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "expiration");
        if (Objects.equals(this.expiration, newValue)) {
            return this;
        }
        return new ImmutableNfTokenOfferObject(this.amount, this.owner, this.previousTransactionId, this.previousTransactionLedgerSequence, this.nfTokenId, newValue, this.destination, this.ownerNode, this.offerNode, this.flags, this.index);
    }

    public final ImmutableNfTokenOfferObject withExpiration(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.expiration, value)) {
            return this;
        }
        return new ImmutableNfTokenOfferObject(this.amount, this.owner, this.previousTransactionId, this.previousTransactionLedgerSequence, this.nfTokenId, value, this.destination, this.ownerNode, this.offerNode, this.flags, this.index);
    }

    public final ImmutableNfTokenOfferObject withDestination(Address value) {
        Address newValue = Objects.requireNonNull(value, "destination");
        if (this.destination == newValue) {
            return this;
        }
        return new ImmutableNfTokenOfferObject(this.amount, this.owner, this.previousTransactionId, this.previousTransactionLedgerSequence, this.nfTokenId, this.expiration, newValue, this.ownerNode, this.offerNode, this.flags, this.index);
    }

    public final ImmutableNfTokenOfferObject withDestination(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.destination == value) {
            return this;
        }
        return new ImmutableNfTokenOfferObject(this.amount, this.owner, this.previousTransactionId, this.previousTransactionLedgerSequence, this.nfTokenId, this.expiration, value, this.ownerNode, this.offerNode, this.flags, this.index);
    }

    public final ImmutableNfTokenOfferObject withOwnerNode(String value) {
        String newValue = Objects.requireNonNull(value, "ownerNode");
        if (Objects.equals(this.ownerNode, newValue)) {
            return this;
        }
        return new ImmutableNfTokenOfferObject(this.amount, this.owner, this.previousTransactionId, this.previousTransactionLedgerSequence, this.nfTokenId, this.expiration, this.destination, newValue, this.offerNode, this.flags, this.index);
    }

    public final ImmutableNfTokenOfferObject withOwnerNode(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.ownerNode, value)) {
            return this;
        }
        return new ImmutableNfTokenOfferObject(this.amount, this.owner, this.previousTransactionId, this.previousTransactionLedgerSequence, this.nfTokenId, this.expiration, this.destination, value, this.offerNode, this.flags, this.index);
    }

    public final ImmutableNfTokenOfferObject withOfferNode(String value) {
        String newValue = Objects.requireNonNull(value, "offerNode");
        if (Objects.equals(this.offerNode, newValue)) {
            return this;
        }
        return new ImmutableNfTokenOfferObject(this.amount, this.owner, this.previousTransactionId, this.previousTransactionLedgerSequence, this.nfTokenId, this.expiration, this.destination, this.ownerNode, newValue, this.flags, this.index);
    }

    public final ImmutableNfTokenOfferObject withOfferNode(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.offerNode, value)) {
            return this;
        }
        return new ImmutableNfTokenOfferObject(this.amount, this.owner, this.previousTransactionId, this.previousTransactionLedgerSequence, this.nfTokenId, this.expiration, this.destination, this.ownerNode, value, this.flags, this.index);
    }

    public final ImmutableNfTokenOfferObject withFlags(NfTokenOfferFlags value) {
        if (this.flags == value) {
            return this;
        }
        NfTokenOfferFlags newValue = Objects.requireNonNull(value, "flags");
        return new ImmutableNfTokenOfferObject(this.amount, this.owner, this.previousTransactionId, this.previousTransactionLedgerSequence, this.nfTokenId, this.expiration, this.destination, this.ownerNode, this.offerNode, newValue, this.index);
    }

    public final ImmutableNfTokenOfferObject withIndex(Hash256 value) {
        if (this.index == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "index");
        return new ImmutableNfTokenOfferObject(this.amount, this.owner, this.previousTransactionId, this.previousTransactionLedgerSequence, this.nfTokenId, this.expiration, this.destination, this.ownerNode, this.offerNode, this.flags, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNfTokenOfferObject && this.equalTo(0, (ImmutableNfTokenOfferObject)another);
    }

    private boolean equalTo(int synthetic, ImmutableNfTokenOfferObject another) {
        return this.ledgerEntryType.equals((Object)another.ledgerEntryType) && this.amount.equals(another.amount) && this.owner.equals(another.owner) && this.previousTransactionId.equals(another.previousTransactionId) && this.previousTransactionLedgerSequence.equals((Object)another.previousTransactionLedgerSequence) && this.nfTokenId.equals(another.nfTokenId) && Objects.equals(this.expiration, another.expiration) && Objects.equals(this.destination, another.destination) && Objects.equals(this.ownerNode, another.ownerNode) && Objects.equals(this.offerNode, another.offerNode) && this.flags.equals(another.flags) && this.index.equals(another.index);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.ledgerEntryType.hashCode();
        h += (h << 5) + this.amount.hashCode();
        h += (h << 5) + this.owner.hashCode();
        h += (h << 5) + this.previousTransactionId.hashCode();
        h += (h << 5) + this.previousTransactionLedgerSequence.hashCode();
        h += (h << 5) + this.nfTokenId.hashCode();
        h += (h << 5) + Objects.hashCode(this.expiration);
        h += (h << 5) + Objects.hashCode(this.destination);
        h += (h << 5) + Objects.hashCode(this.ownerNode);
        h += (h << 5) + Objects.hashCode(this.offerNode);
        h += (h << 5) + this.flags.hashCode();
        h += (h << 5) + this.index.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NfTokenOfferObject").omitNullValues().add("ledgerEntryType", (Object)this.ledgerEntryType).add("amount", (Object)this.amount).add("owner", (Object)this.owner).add("previousTransactionId", (Object)this.previousTransactionId).add("previousTransactionLedgerSequence", (Object)this.previousTransactionLedgerSequence).add("nfTokenId", (Object)this.nfTokenId).add("expiration", (Object)this.expiration).add("destination", (Object)this.destination).add("ownerNode", (Object)this.ownerNode).add("offerNode", (Object)this.offerNode).add("flags", (Object)this.flags).add("index", (Object)this.index).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableNfTokenOfferObject fromJson(Json json) {
        Builder builder = ImmutableNfTokenOfferObject.builder();
        if (json.amount != null) {
            builder.amount(json.amount);
        }
        if (json.owner != null) {
            builder.owner(json.owner);
        }
        if (json.previousTransactionId != null) {
            builder.previousTransactionId(json.previousTransactionId);
        }
        if (json.previousTransactionLedgerSequence != null) {
            builder.previousTransactionLedgerSequence(json.previousTransactionLedgerSequence);
        }
        if (json.nfTokenId != null) {
            builder.nfTokenId(json.nfTokenId);
        }
        if (json.expiration != null) {
            builder.expiration(json.expiration);
        }
        if (json.destination != null) {
            builder.destination(json.destination);
        }
        if (json.ownerNode != null) {
            builder.ownerNode(json.ownerNode);
        }
        if (json.offerNode != null) {
            builder.offerNode(json.offerNode);
        }
        if (json.flags != null) {
            builder.flags(json.flags);
        }
        if (json.index != null) {
            builder.index(json.index);
        }
        return builder.build();
    }

    public static ImmutableNfTokenOfferObject copyOf(NfTokenOfferObject instance) {
        if (instance instanceof ImmutableNfTokenOfferObject) {
            return (ImmutableNfTokenOfferObject)instance;
        }
        return ImmutableNfTokenOfferObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NfTokenOfferObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_AMOUNT = 1L;
        private static final long INIT_BIT_OWNER = 2L;
        private static final long INIT_BIT_PREVIOUS_TRANSACTION_ID = 4L;
        private static final long INIT_BIT_PREVIOUS_TRANSACTION_LEDGER_SEQUENCE = 8L;
        private static final long INIT_BIT_NF_TOKEN_ID = 16L;
        private static final long INIT_BIT_FLAGS = 32L;
        private static final long INIT_BIT_INDEX = 64L;
        private long initBits = 127L;
        @Nullable
        private CurrencyAmount amount;
        @Nullable
        private Address owner;
        @Nullable
        private Hash256 previousTransactionId;
        @Nullable
        private UnsignedInteger previousTransactionLedgerSequence;
        @Nullable
        private NfTokenId nfTokenId;
        @Nullable
        private UnsignedInteger expiration;
        @Nullable
        private Address destination;
        @Nullable
        private String ownerNode;
        @Nullable
        private String offerNode;
        @Nullable
        private NfTokenOfferFlags flags;
        @Nullable
        private Hash256 index;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(NfTokenOfferObject instance) {
            Optional<String> offerNodeOptional;
            Optional<String> ownerNodeOptional;
            Optional<Address> destinationOptional;
            Objects.requireNonNull(instance, "instance");
            this.amount(instance.amount());
            this.owner(instance.owner());
            this.previousTransactionId(instance.previousTransactionId());
            this.previousTransactionLedgerSequence(instance.previousTransactionLedgerSequence());
            this.nfTokenId(instance.nfTokenId());
            Optional<UnsignedInteger> expirationOptional = instance.expiration();
            if (expirationOptional.isPresent()) {
                this.expiration(expirationOptional);
            }
            if ((destinationOptional = instance.destination()).isPresent()) {
                this.destination(destinationOptional);
            }
            if ((ownerNodeOptional = instance.ownerNode()).isPresent()) {
                this.ownerNode(ownerNodeOptional);
            }
            if ((offerNodeOptional = instance.offerNode()).isPresent()) {
                this.offerNode(offerNodeOptional);
            }
            this.flags(instance.flags());
            this.index(instance.index());
            return this;
        }

        @JsonProperty(value="Amount")
        @CanIgnoreReturnValue
        public final Builder amount(CurrencyAmount amount) {
            this.amount = Objects.requireNonNull(amount, "amount");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Owner")
        @CanIgnoreReturnValue
        public final Builder owner(Address owner) {
            this.owner = Objects.requireNonNull(owner, "owner");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="PreviousTxnID")
        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Hash256 previousTransactionId) {
            this.previousTransactionId = Objects.requireNonNull(previousTransactionId, "previousTransactionId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(UnsignedInteger previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = Objects.requireNonNull(previousTransactionLedgerSequence, "previousTransactionLedgerSequence");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="NFTokenID")
        @CanIgnoreReturnValue
        public final Builder nfTokenId(NfTokenId nfTokenId) {
            this.nfTokenId = Objects.requireNonNull(nfTokenId, "nfTokenId");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expiration(UnsignedInteger expiration) {
            this.expiration = Objects.requireNonNull(expiration, "expiration");
            return this;
        }

        @JsonProperty(value="expiration")
        @CanIgnoreReturnValue
        public final Builder expiration(Optional<? extends UnsignedInteger> expiration) {
            this.expiration = expiration.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder destination(Address destination) {
            this.destination = Objects.requireNonNull(destination, "destination");
            return this;
        }

        @JsonProperty(value="Destination")
        @CanIgnoreReturnValue
        public final Builder destination(Optional<? extends Address> destination) {
            this.destination = destination.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ownerNode(String ownerNode) {
            this.ownerNode = Objects.requireNonNull(ownerNode, "ownerNode");
            return this;
        }

        @JsonProperty(value="OwnerNode")
        @CanIgnoreReturnValue
        public final Builder ownerNode(Optional<String> ownerNode) {
            this.ownerNode = ownerNode.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder offerNode(String offerNode) {
            this.offerNode = Objects.requireNonNull(offerNode, "offerNode");
            return this;
        }

        @JsonProperty(value="NFTokenOfferNode")
        @CanIgnoreReturnValue
        public final Builder offerNode(Optional<String> offerNode) {
            this.offerNode = offerNode.orElse(null);
            return this;
        }

        @JsonProperty(value="Flags")
        @CanIgnoreReturnValue
        public final Builder flags(NfTokenOfferFlags flags) {
            this.flags = Objects.requireNonNull(flags, "flags");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="index")
        @CanIgnoreReturnValue
        public final Builder index(Hash256 index) {
            this.index = Objects.requireNonNull(index, "index");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public ImmutableNfTokenOfferObject build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNfTokenOfferObject(this.amount, this.owner, this.previousTransactionId, this.previousTransactionLedgerSequence, this.nfTokenId, this.expiration, this.destination, this.ownerNode, this.offerNode, this.flags, this.index);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("amount");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("owner");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("previousTransactionId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("previousTransactionLedgerSequence");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("nfTokenId");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("flags");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("index");
            }
            return "Cannot build NfTokenOfferObject, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="NfTokenOfferObject", generator="Immutables")
    static final class Json
    implements NfTokenOfferObject {
        @Nullable
        CurrencyAmount amount;
        @Nullable
        Address owner;
        @Nullable
        Hash256 previousTransactionId;
        @Nullable
        UnsignedInteger previousTransactionLedgerSequence;
        @Nullable
        NfTokenId nfTokenId;
        @Nullable
        Optional<UnsignedInteger> expiration = Optional.empty();
        @Nullable
        Optional<Address> destination = Optional.empty();
        @Nullable
        Optional<String> ownerNode = Optional.empty();
        @Nullable
        Optional<String> offerNode = Optional.empty();
        @Nullable
        NfTokenOfferFlags flags;
        @Nullable
        Hash256 index;

        Json() {
        }

        @JsonProperty(value="Amount")
        public void setAmount(CurrencyAmount amount) {
            this.amount = amount;
        }

        @JsonProperty(value="Owner")
        public void setOwner(Address owner) {
            this.owner = owner;
        }

        @JsonProperty(value="PreviousTxnID")
        public void setPreviousTransactionId(Hash256 previousTransactionId) {
            this.previousTransactionId = previousTransactionId;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        public void setPreviousTransactionLedgerSequence(UnsignedInteger previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        }

        @JsonProperty(value="NFTokenID")
        public void setNfTokenId(NfTokenId nfTokenId) {
            this.nfTokenId = nfTokenId;
        }

        @JsonProperty(value="expiration")
        public void setExpiration(Optional<UnsignedInteger> expiration) {
            this.expiration = expiration;
        }

        @JsonProperty(value="Destination")
        public void setDestination(Optional<Address> destination) {
            this.destination = destination;
        }

        @JsonProperty(value="OwnerNode")
        public void setOwnerNode(Optional<String> ownerNode) {
            this.ownerNode = ownerNode;
        }

        @JsonProperty(value="NFTokenOfferNode")
        public void setOfferNode(Optional<String> offerNode) {
            this.offerNode = offerNode;
        }

        @JsonProperty(value="Flags")
        public void setFlags(NfTokenOfferFlags flags) {
            this.flags = flags;
        }

        @JsonProperty(value="index")
        public void setIndex(Hash256 index) {
            this.index = index;
        }

        @Override
        @JsonIgnore
        public LedgerObject.LedgerEntryType ledgerEntryType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CurrencyAmount amount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address owner() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 previousTransactionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger previousTransactionLedgerSequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NfTokenId nfTokenId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> expiration() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Address> destination() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> ownerNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> offerNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NfTokenOfferFlags flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 index() {
            throw new UnsupportedOperationException();
        }
    }
}

