/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.ledger.NfToken;
import org.xrpl.xrpl4j.model.transactions.NfTokenId;
import org.xrpl.xrpl4j.model.transactions.NfTokenUri;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="NfToken", generator="Immutables")
@Immutable
public final class ImmutableNfToken
implements NfToken {
    private final NfTokenId nfTokenId;
    @Nullable
    private final NfTokenUri uri;

    private ImmutableNfToken(NfTokenId nfTokenId, @Nullable NfTokenUri uri) {
        this.nfTokenId = nfTokenId;
        this.uri = uri;
    }

    @Override
    @JsonProperty(value="NFTokenID")
    public NfTokenId nfTokenId() {
        return this.nfTokenId;
    }

    @Override
    @JsonProperty(value="URI")
    public Optional<NfTokenUri> uri() {
        return Optional.ofNullable(this.uri);
    }

    public final ImmutableNfToken withNfTokenId(NfTokenId value) {
        if (this.nfTokenId == value) {
            return this;
        }
        NfTokenId newValue = Objects.requireNonNull(value, "nfTokenId");
        return new ImmutableNfToken(newValue, this.uri);
    }

    public final ImmutableNfToken withUri(NfTokenUri value) {
        NfTokenUri newValue = Objects.requireNonNull(value, "uri");
        if (this.uri == newValue) {
            return this;
        }
        return new ImmutableNfToken(this.nfTokenId, newValue);
    }

    public final ImmutableNfToken withUri(Optional<? extends NfTokenUri> optional) {
        NfTokenUri value = optional.orElse(null);
        if (this.uri == value) {
            return this;
        }
        return new ImmutableNfToken(this.nfTokenId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNfToken && this.equalTo(0, (ImmutableNfToken)another);
    }

    private boolean equalTo(int synthetic, ImmutableNfToken another) {
        return this.nfTokenId.equals(another.nfTokenId) && Objects.equals(this.uri, another.uri);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.nfTokenId.hashCode();
        h += (h << 5) + Objects.hashCode(this.uri);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NfToken").omitNullValues().add("nfTokenId", (Object)this.nfTokenId).add("uri", (Object)this.uri).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableNfToken fromJson(Json json) {
        Builder builder = ImmutableNfToken.builder();
        if (json.nfTokenId != null) {
            builder.nfTokenId(json.nfTokenId);
        }
        if (json.uri != null) {
            builder.uri(json.uri);
        }
        return builder.build();
    }

    public static ImmutableNfToken copyOf(NfToken instance) {
        if (instance instanceof ImmutableNfToken) {
            return (ImmutableNfToken)instance;
        }
        return ImmutableNfToken.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NfToken", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NF_TOKEN_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private NfTokenId nfTokenId;
        @Nullable
        private NfTokenUri uri;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(NfToken instance) {
            Objects.requireNonNull(instance, "instance");
            this.nfTokenId(instance.nfTokenId());
            Optional<NfTokenUri> uriOptional = instance.uri();
            if (uriOptional.isPresent()) {
                this.uri(uriOptional);
            }
            return this;
        }

        @JsonProperty(value="NFTokenID")
        @CanIgnoreReturnValue
        public final Builder nfTokenId(NfTokenId nfTokenId) {
            this.nfTokenId = Objects.requireNonNull(nfTokenId, "nfTokenId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder uri(NfTokenUri uri) {
            this.uri = Objects.requireNonNull(uri, "uri");
            return this;
        }

        @JsonProperty(value="URI")
        @CanIgnoreReturnValue
        public final Builder uri(Optional<? extends NfTokenUri> uri) {
            this.uri = uri.orElse(null);
            return this;
        }

        public ImmutableNfToken build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNfToken(this.nfTokenId, this.uri);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("nfTokenId");
            }
            return "Cannot build NfToken, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="NfToken", generator="Immutables")
    static final class Json
    implements NfToken {
        @Nullable
        NfTokenId nfTokenId;
        @Nullable
        Optional<NfTokenUri> uri = Optional.empty();

        Json() {
        }

        @JsonProperty(value="NFTokenID")
        public void setNfTokenId(NfTokenId nfTokenId) {
            this.nfTokenId = nfTokenId;
        }

        @JsonProperty(value="URI")
        public void setUri(Optional<NfTokenUri> uri) {
            this.uri = uri;
        }

        @Override
        public NfTokenId nfTokenId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<NfTokenUri> uri() {
            throw new UnsupportedOperationException();
        }
    }
}

