/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.ledger.DidObject;
import org.xrpl.xrpl4j.model.ledger.LedgerObject;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.DidData;
import org.xrpl.xrpl4j.model.transactions.DidDocument;
import org.xrpl.xrpl4j.model.transactions.DidUri;
import org.xrpl.xrpl4j.model.transactions.Hash256;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DidObject", generator="Immutables")
@Immutable
public final class ImmutableDidObject
implements DidObject {
    private final transient LedgerObject.LedgerEntryType ledgerEntryType;
    private final transient Flags flags;
    private final Address account;
    @Nullable
    private final DidDocument didDocument;
    @Nullable
    private final DidData data;
    @Nullable
    private final DidUri uri;
    private final String ownerNode;
    private final Hash256 previousTransactionId;
    private final UnsignedInteger previousTransactionLedgerSequence;
    private final Hash256 index;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableDidObject(Address account, @Nullable DidDocument didDocument, @Nullable DidData data, @Nullable DidUri uri, String ownerNode, Hash256 previousTransactionId, UnsignedInteger previousTransactionLedgerSequence, Hash256 index) {
        this.account = account;
        this.didDocument = didDocument;
        this.data = data;
        this.uri = uri;
        this.ownerNode = ownerNode;
        this.previousTransactionId = previousTransactionId;
        this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        this.index = index;
        this.ledgerEntryType = this.initShim.ledgerEntryType();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private LedgerObject.LedgerEntryType ledgerEntryTypeInitialize() {
        return DidObject.super.ledgerEntryType();
    }

    private Flags flagsInitialize() {
        return DidObject.super.flags();
    }

    @Override
    @JsonProperty(value="LedgerEntryType")
    public LedgerObject.LedgerEntryType ledgerEntryType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ledgerEntryType() : this.ledgerEntryType;
    }

    @Override
    @JsonProperty(value="Flags")
    public Flags flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @JsonProperty(value="Account")
    public Address account() {
        return this.account;
    }

    @Override
    @JsonProperty(value="DIDDocument")
    public Optional<DidDocument> didDocument() {
        return Optional.ofNullable(this.didDocument);
    }

    @Override
    @JsonProperty(value="Data")
    public Optional<DidData> data() {
        return Optional.ofNullable(this.data);
    }

    @Override
    @JsonProperty(value="URI")
    public Optional<DidUri> uri() {
        return Optional.ofNullable(this.uri);
    }

    @Override
    @JsonProperty(value="OwnerNode")
    public String ownerNode() {
        return this.ownerNode;
    }

    @Override
    @JsonProperty(value="PreviousTxnID")
    public Hash256 previousTransactionId() {
        return this.previousTransactionId;
    }

    @Override
    @JsonProperty(value="PreviousTxnLgrSeq")
    public UnsignedInteger previousTransactionLedgerSequence() {
        return this.previousTransactionLedgerSequence;
    }

    @Override
    @JsonProperty(value="index")
    public Hash256 index() {
        return this.index;
    }

    public final ImmutableDidObject withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutableDidObject(newValue, this.didDocument, this.data, this.uri, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableDidObject withDidDocument(DidDocument value) {
        DidDocument newValue = Objects.requireNonNull(value, "didDocument");
        if (this.didDocument == newValue) {
            return this;
        }
        return new ImmutableDidObject(this.account, newValue, this.data, this.uri, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableDidObject withDidDocument(Optional<? extends DidDocument> optional) {
        DidDocument value = optional.orElse(null);
        if (this.didDocument == value) {
            return this;
        }
        return new ImmutableDidObject(this.account, value, this.data, this.uri, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableDidObject withData(DidData value) {
        DidData newValue = Objects.requireNonNull(value, "data");
        if (this.data == newValue) {
            return this;
        }
        return new ImmutableDidObject(this.account, this.didDocument, newValue, this.uri, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableDidObject withData(Optional<? extends DidData> optional) {
        DidData value = optional.orElse(null);
        if (this.data == value) {
            return this;
        }
        return new ImmutableDidObject(this.account, this.didDocument, value, this.uri, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableDidObject withUri(DidUri value) {
        DidUri newValue = Objects.requireNonNull(value, "uri");
        if (this.uri == newValue) {
            return this;
        }
        return new ImmutableDidObject(this.account, this.didDocument, this.data, newValue, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableDidObject withUri(Optional<? extends DidUri> optional) {
        DidUri value = optional.orElse(null);
        if (this.uri == value) {
            return this;
        }
        return new ImmutableDidObject(this.account, this.didDocument, this.data, value, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableDidObject withOwnerNode(String value) {
        String newValue = Objects.requireNonNull(value, "ownerNode");
        if (this.ownerNode.equals(newValue)) {
            return this;
        }
        return new ImmutableDidObject(this.account, this.didDocument, this.data, this.uri, newValue, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableDidObject withPreviousTransactionId(Hash256 value) {
        if (this.previousTransactionId == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "previousTransactionId");
        return new ImmutableDidObject(this.account, this.didDocument, this.data, this.uri, this.ownerNode, newValue, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableDidObject withPreviousTransactionLedgerSequence(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "previousTransactionLedgerSequence");
        if (this.previousTransactionLedgerSequence.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableDidObject(this.account, this.didDocument, this.data, this.uri, this.ownerNode, this.previousTransactionId, newValue, this.index);
    }

    public final ImmutableDidObject withIndex(Hash256 value) {
        if (this.index == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "index");
        return new ImmutableDidObject(this.account, this.didDocument, this.data, this.uri, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDidObject && this.equalTo(0, (ImmutableDidObject)another);
    }

    private boolean equalTo(int synthetic, ImmutableDidObject another) {
        return this.ledgerEntryType.equals((Object)another.ledgerEntryType) && this.flags.equals(another.flags) && this.account.equals(another.account) && Objects.equals(this.didDocument, another.didDocument) && Objects.equals(this.data, another.data) && Objects.equals(this.uri, another.uri) && this.ownerNode.equals(another.ownerNode) && this.previousTransactionId.equals(another.previousTransactionId) && this.previousTransactionLedgerSequence.equals((Object)another.previousTransactionLedgerSequence) && this.index.equals(another.index);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.ledgerEntryType.hashCode();
        h += (h << 5) + this.flags.hashCode();
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + Objects.hashCode(this.didDocument);
        h += (h << 5) + Objects.hashCode(this.data);
        h += (h << 5) + Objects.hashCode(this.uri);
        h += (h << 5) + this.ownerNode.hashCode();
        h += (h << 5) + this.previousTransactionId.hashCode();
        h += (h << 5) + this.previousTransactionLedgerSequence.hashCode();
        h += (h << 5) + this.index.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DidObject").omitNullValues().add("ledgerEntryType", (Object)this.ledgerEntryType).add("flags", (Object)this.flags).add("account", (Object)this.account).add("didDocument", (Object)this.didDocument).add("data", (Object)this.data).add("uri", (Object)this.uri).add("ownerNode", (Object)this.ownerNode).add("previousTransactionId", (Object)this.previousTransactionId).add("previousTransactionLedgerSequence", (Object)this.previousTransactionLedgerSequence).add("index", (Object)this.index).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDidObject fromJson(Json json) {
        Builder builder = ImmutableDidObject.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.didDocument != null) {
            builder.didDocument(json.didDocument);
        }
        if (json.data != null) {
            builder.data(json.data);
        }
        if (json.uri != null) {
            builder.uri(json.uri);
        }
        if (json.ownerNode != null) {
            builder.ownerNode(json.ownerNode);
        }
        if (json.previousTransactionId != null) {
            builder.previousTransactionId(json.previousTransactionId);
        }
        if (json.previousTransactionLedgerSequence != null) {
            builder.previousTransactionLedgerSequence(json.previousTransactionLedgerSequence);
        }
        if (json.index != null) {
            builder.index(json.index);
        }
        return builder.build();
    }

    public static ImmutableDidObject copyOf(DidObject instance) {
        if (instance instanceof ImmutableDidObject) {
            return (ImmutableDidObject)instance;
        }
        return ImmutableDidObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DidObject", generator="Immutables")
    private final class InitShim {
        private byte ledgerEntryTypeBuildStage = 0;
        private LedgerObject.LedgerEntryType ledgerEntryType;
        private byte flagsBuildStage = 0;
        private Flags flags;

        private InitShim() {
        }

        LedgerObject.LedgerEntryType ledgerEntryType() {
            if (this.ledgerEntryTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ledgerEntryTypeBuildStage == 0) {
                this.ledgerEntryTypeBuildStage = (byte)-1;
                this.ledgerEntryType = Objects.requireNonNull(ImmutableDidObject.this.ledgerEntryTypeInitialize(), "ledgerEntryType");
                this.ledgerEntryTypeBuildStage = 1;
            }
            return this.ledgerEntryType;
        }

        Flags flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = Objects.requireNonNull(ImmutableDidObject.this.flagsInitialize(), "flags");
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.ledgerEntryTypeBuildStage == -1) {
                attributes.add("ledgerEntryType");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build DidObject, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="DidObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private static final long INIT_BIT_OWNER_NODE = 2L;
        private static final long INIT_BIT_PREVIOUS_TRANSACTION_ID = 4L;
        private static final long INIT_BIT_PREVIOUS_TRANSACTION_LEDGER_SEQUENCE = 8L;
        private static final long INIT_BIT_INDEX = 16L;
        private long initBits = 31L;
        @Nullable
        private Address account;
        @Nullable
        private DidDocument didDocument;
        @Nullable
        private DidData data;
        @Nullable
        private DidUri uri;
        @Nullable
        private String ownerNode;
        @Nullable
        private Hash256 previousTransactionId;
        @Nullable
        private UnsignedInteger previousTransactionLedgerSequence;
        @Nullable
        private Hash256 index;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DidObject instance) {
            Optional<DidUri> uriOptional;
            Optional<DidData> dataOptional;
            Objects.requireNonNull(instance, "instance");
            this.account(instance.account());
            Optional<DidDocument> didDocumentOptional = instance.didDocument();
            if (didDocumentOptional.isPresent()) {
                this.didDocument(didDocumentOptional);
            }
            if ((dataOptional = instance.data()).isPresent()) {
                this.data(dataOptional);
            }
            if ((uriOptional = instance.uri()).isPresent()) {
                this.uri(uriOptional);
            }
            this.ownerNode(instance.ownerNode());
            this.previousTransactionId(instance.previousTransactionId());
            this.previousTransactionLedgerSequence(instance.previousTransactionLedgerSequence());
            this.index(instance.index());
            return this;
        }

        @JsonProperty(value="Account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder didDocument(DidDocument didDocument) {
            this.didDocument = Objects.requireNonNull(didDocument, "didDocument");
            return this;
        }

        @JsonProperty(value="DIDDocument")
        @CanIgnoreReturnValue
        public final Builder didDocument(Optional<? extends DidDocument> didDocument) {
            this.didDocument = didDocument.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder data(DidData data) {
            this.data = Objects.requireNonNull(data, "data");
            return this;
        }

        @JsonProperty(value="Data")
        @CanIgnoreReturnValue
        public final Builder data(Optional<? extends DidData> data) {
            this.data = data.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder uri(DidUri uri) {
            this.uri = Objects.requireNonNull(uri, "uri");
            return this;
        }

        @JsonProperty(value="URI")
        @CanIgnoreReturnValue
        public final Builder uri(Optional<? extends DidUri> uri) {
            this.uri = uri.orElse(null);
            return this;
        }

        @JsonProperty(value="OwnerNode")
        @CanIgnoreReturnValue
        public final Builder ownerNode(String ownerNode) {
            this.ownerNode = Objects.requireNonNull(ownerNode, "ownerNode");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="PreviousTxnID")
        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Hash256 previousTransactionId) {
            this.previousTransactionId = Objects.requireNonNull(previousTransactionId, "previousTransactionId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(UnsignedInteger previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = Objects.requireNonNull(previousTransactionLedgerSequence, "previousTransactionLedgerSequence");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="index")
        @CanIgnoreReturnValue
        public final Builder index(Hash256 index) {
            this.index = Objects.requireNonNull(index, "index");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableDidObject build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDidObject(this.account, this.didDocument, this.data, this.uri, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ownerNode");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("previousTransactionId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("previousTransactionLedgerSequence");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("index");
            }
            return "Cannot build DidObject, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DidObject", generator="Immutables")
    static final class Json
    implements DidObject {
        @Nullable
        Address account;
        @Nullable
        Optional<DidDocument> didDocument = Optional.empty();
        @Nullable
        Optional<DidData> data = Optional.empty();
        @Nullable
        Optional<DidUri> uri = Optional.empty();
        @Nullable
        String ownerNode;
        @Nullable
        Hash256 previousTransactionId;
        @Nullable
        UnsignedInteger previousTransactionLedgerSequence;
        @Nullable
        Hash256 index;

        Json() {
        }

        @JsonProperty(value="Account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="DIDDocument")
        public void setDidDocument(Optional<DidDocument> didDocument) {
            this.didDocument = didDocument;
        }

        @JsonProperty(value="Data")
        public void setData(Optional<DidData> data) {
            this.data = data;
        }

        @JsonProperty(value="URI")
        public void setUri(Optional<DidUri> uri) {
            this.uri = uri;
        }

        @JsonProperty(value="OwnerNode")
        public void setOwnerNode(String ownerNode) {
            this.ownerNode = ownerNode;
        }

        @JsonProperty(value="PreviousTxnID")
        public void setPreviousTransactionId(Hash256 previousTransactionId) {
            this.previousTransactionId = previousTransactionId;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        public void setPreviousTransactionLedgerSequence(UnsignedInteger previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        }

        @JsonProperty(value="index")
        public void setIndex(Hash256 index) {
            this.index = index;
        }

        @Override
        @JsonIgnore
        public LedgerObject.LedgerEntryType ledgerEntryType() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public Flags flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<DidDocument> didDocument() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<DidData> data() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<DidUri> uri() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String ownerNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 previousTransactionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger previousTransactionLedgerSequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 index() {
            throw new UnsupportedOperationException();
        }
    }
}

