/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.ledger.CheckObject;
import org.xrpl.xrpl4j.model.ledger.LedgerObject;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.CurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.Hash256;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CheckObject", generator="Immutables")
@Immutable
public final class ImmutableCheckObject
implements CheckObject {
    private final transient LedgerObject.LedgerEntryType ledgerEntryType;
    private final Address account;
    @Nullable
    private final UnsignedInteger sourceTag;
    private final Address destination;
    @Nullable
    private final UnsignedInteger destinationTag;
    private final transient Flags flags;
    private final String ownerNode;
    private final Hash256 previousTxnId;
    private final UnsignedInteger previousTransactionLedgerSequence;
    private final CurrencyAmount sendMax;
    private final UnsignedInteger sequence;
    @Nullable
    private final String destinationNode;
    @Nullable
    private final UnsignedInteger expiration;
    @Nullable
    private final Hash256 invoiceId;
    private final Hash256 index;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableCheckObject(Address account, @Nullable UnsignedInteger sourceTag, Address destination, @Nullable UnsignedInteger destinationTag, String ownerNode, Hash256 previousTxnId, UnsignedInteger previousTransactionLedgerSequence, CurrencyAmount sendMax, UnsignedInteger sequence, @Nullable String destinationNode, @Nullable UnsignedInteger expiration, @Nullable Hash256 invoiceId, Hash256 index) {
        this.account = account;
        this.sourceTag = sourceTag;
        this.destination = destination;
        this.destinationTag = destinationTag;
        this.ownerNode = ownerNode;
        this.previousTxnId = previousTxnId;
        this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        this.sendMax = sendMax;
        this.sequence = sequence;
        this.destinationNode = destinationNode;
        this.expiration = expiration;
        this.invoiceId = invoiceId;
        this.index = index;
        this.ledgerEntryType = this.initShim.ledgerEntryType();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private LedgerObject.LedgerEntryType ledgerEntryTypeInitialize() {
        return CheckObject.super.ledgerEntryType();
    }

    private Flags flagsInitialize() {
        return CheckObject.super.flags();
    }

    @Override
    @JsonProperty(value="LedgerEntryType")
    public LedgerObject.LedgerEntryType ledgerEntryType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ledgerEntryType() : this.ledgerEntryType;
    }

    @Override
    @JsonProperty(value="Account")
    public Address account() {
        return this.account;
    }

    @Override
    @JsonProperty(value="SourceTag")
    public Optional<UnsignedInteger> sourceTag() {
        return Optional.ofNullable(this.sourceTag);
    }

    @Override
    @JsonProperty(value="Destination")
    public Address destination() {
        return this.destination;
    }

    @Override
    @JsonProperty(value="DestinationTag")
    public Optional<UnsignedInteger> destinationTag() {
        return Optional.ofNullable(this.destinationTag);
    }

    @Override
    @JsonProperty(value="Flags")
    public Flags flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @JsonProperty(value="OwnerNode")
    public String ownerNode() {
        return this.ownerNode;
    }

    @Override
    @JsonProperty(value="PreviousTxnID")
    public Hash256 previousTxnId() {
        return this.previousTxnId;
    }

    @Override
    @JsonProperty(value="PreviousTxnLgrSeq")
    public UnsignedInteger previousTransactionLedgerSequence() {
        return this.previousTransactionLedgerSequence;
    }

    @Override
    @JsonProperty(value="SendMax")
    public CurrencyAmount sendMax() {
        return this.sendMax;
    }

    @Override
    @JsonProperty(value="Sequence")
    public UnsignedInteger sequence() {
        return this.sequence;
    }

    @Override
    @JsonProperty(value="DestinationNode")
    public Optional<String> destinationNode() {
        return Optional.ofNullable(this.destinationNode);
    }

    @Override
    @JsonProperty(value="Expiration")
    public Optional<UnsignedInteger> expiration() {
        return Optional.ofNullable(this.expiration);
    }

    @Override
    @JsonProperty(value="InvoiceID")
    public Optional<Hash256> invoiceId() {
        return Optional.ofNullable(this.invoiceId);
    }

    @Override
    @JsonProperty(value="index")
    public Hash256 index() {
        return this.index;
    }

    public final ImmutableCheckObject withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutableCheckObject(newValue, this.sourceTag, this.destination, this.destinationTag, this.ownerNode, this.previousTxnId, this.previousTransactionLedgerSequence, this.sendMax, this.sequence, this.destinationNode, this.expiration, this.invoiceId, this.index);
    }

    public final ImmutableCheckObject withSourceTag(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "sourceTag");
        if (Objects.equals(this.sourceTag, newValue)) {
            return this;
        }
        return new ImmutableCheckObject(this.account, newValue, this.destination, this.destinationTag, this.ownerNode, this.previousTxnId, this.previousTransactionLedgerSequence, this.sendMax, this.sequence, this.destinationNode, this.expiration, this.invoiceId, this.index);
    }

    public final ImmutableCheckObject withSourceTag(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.sourceTag, value)) {
            return this;
        }
        return new ImmutableCheckObject(this.account, value, this.destination, this.destinationTag, this.ownerNode, this.previousTxnId, this.previousTransactionLedgerSequence, this.sendMax, this.sequence, this.destinationNode, this.expiration, this.invoiceId, this.index);
    }

    public final ImmutableCheckObject withDestination(Address value) {
        if (this.destination == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "destination");
        return new ImmutableCheckObject(this.account, this.sourceTag, newValue, this.destinationTag, this.ownerNode, this.previousTxnId, this.previousTransactionLedgerSequence, this.sendMax, this.sequence, this.destinationNode, this.expiration, this.invoiceId, this.index);
    }

    public final ImmutableCheckObject withDestinationTag(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "destinationTag");
        if (Objects.equals(this.destinationTag, newValue)) {
            return this;
        }
        return new ImmutableCheckObject(this.account, this.sourceTag, this.destination, newValue, this.ownerNode, this.previousTxnId, this.previousTransactionLedgerSequence, this.sendMax, this.sequence, this.destinationNode, this.expiration, this.invoiceId, this.index);
    }

    public final ImmutableCheckObject withDestinationTag(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.destinationTag, value)) {
            return this;
        }
        return new ImmutableCheckObject(this.account, this.sourceTag, this.destination, value, this.ownerNode, this.previousTxnId, this.previousTransactionLedgerSequence, this.sendMax, this.sequence, this.destinationNode, this.expiration, this.invoiceId, this.index);
    }

    public final ImmutableCheckObject withOwnerNode(String value) {
        String newValue = Objects.requireNonNull(value, "ownerNode");
        if (this.ownerNode.equals(newValue)) {
            return this;
        }
        return new ImmutableCheckObject(this.account, this.sourceTag, this.destination, this.destinationTag, newValue, this.previousTxnId, this.previousTransactionLedgerSequence, this.sendMax, this.sequence, this.destinationNode, this.expiration, this.invoiceId, this.index);
    }

    public final ImmutableCheckObject withPreviousTxnId(Hash256 value) {
        if (this.previousTxnId == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "previousTxnId");
        return new ImmutableCheckObject(this.account, this.sourceTag, this.destination, this.destinationTag, this.ownerNode, newValue, this.previousTransactionLedgerSequence, this.sendMax, this.sequence, this.destinationNode, this.expiration, this.invoiceId, this.index);
    }

    public final ImmutableCheckObject withPreviousTransactionLedgerSequence(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "previousTransactionLedgerSequence");
        if (this.previousTransactionLedgerSequence.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableCheckObject(this.account, this.sourceTag, this.destination, this.destinationTag, this.ownerNode, this.previousTxnId, newValue, this.sendMax, this.sequence, this.destinationNode, this.expiration, this.invoiceId, this.index);
    }

    public final ImmutableCheckObject withSendMax(CurrencyAmount value) {
        if (this.sendMax == value) {
            return this;
        }
        CurrencyAmount newValue = Objects.requireNonNull(value, "sendMax");
        return new ImmutableCheckObject(this.account, this.sourceTag, this.destination, this.destinationTag, this.ownerNode, this.previousTxnId, this.previousTransactionLedgerSequence, newValue, this.sequence, this.destinationNode, this.expiration, this.invoiceId, this.index);
    }

    public final ImmutableCheckObject withSequence(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "sequence");
        if (this.sequence.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableCheckObject(this.account, this.sourceTag, this.destination, this.destinationTag, this.ownerNode, this.previousTxnId, this.previousTransactionLedgerSequence, this.sendMax, newValue, this.destinationNode, this.expiration, this.invoiceId, this.index);
    }

    public final ImmutableCheckObject withDestinationNode(String value) {
        String newValue = Objects.requireNonNull(value, "destinationNode");
        if (Objects.equals(this.destinationNode, newValue)) {
            return this;
        }
        return new ImmutableCheckObject(this.account, this.sourceTag, this.destination, this.destinationTag, this.ownerNode, this.previousTxnId, this.previousTransactionLedgerSequence, this.sendMax, this.sequence, newValue, this.expiration, this.invoiceId, this.index);
    }

    public final ImmutableCheckObject withDestinationNode(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.destinationNode, value)) {
            return this;
        }
        return new ImmutableCheckObject(this.account, this.sourceTag, this.destination, this.destinationTag, this.ownerNode, this.previousTxnId, this.previousTransactionLedgerSequence, this.sendMax, this.sequence, value, this.expiration, this.invoiceId, this.index);
    }

    public final ImmutableCheckObject withExpiration(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "expiration");
        if (Objects.equals(this.expiration, newValue)) {
            return this;
        }
        return new ImmutableCheckObject(this.account, this.sourceTag, this.destination, this.destinationTag, this.ownerNode, this.previousTxnId, this.previousTransactionLedgerSequence, this.sendMax, this.sequence, this.destinationNode, newValue, this.invoiceId, this.index);
    }

    public final ImmutableCheckObject withExpiration(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.expiration, value)) {
            return this;
        }
        return new ImmutableCheckObject(this.account, this.sourceTag, this.destination, this.destinationTag, this.ownerNode, this.previousTxnId, this.previousTransactionLedgerSequence, this.sendMax, this.sequence, this.destinationNode, value, this.invoiceId, this.index);
    }

    public final ImmutableCheckObject withInvoiceId(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "invoiceId");
        if (this.invoiceId == newValue) {
            return this;
        }
        return new ImmutableCheckObject(this.account, this.sourceTag, this.destination, this.destinationTag, this.ownerNode, this.previousTxnId, this.previousTransactionLedgerSequence, this.sendMax, this.sequence, this.destinationNode, this.expiration, newValue, this.index);
    }

    public final ImmutableCheckObject withInvoiceId(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.invoiceId == value) {
            return this;
        }
        return new ImmutableCheckObject(this.account, this.sourceTag, this.destination, this.destinationTag, this.ownerNode, this.previousTxnId, this.previousTransactionLedgerSequence, this.sendMax, this.sequence, this.destinationNode, this.expiration, value, this.index);
    }

    public final ImmutableCheckObject withIndex(Hash256 value) {
        if (this.index == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "index");
        return new ImmutableCheckObject(this.account, this.sourceTag, this.destination, this.destinationTag, this.ownerNode, this.previousTxnId, this.previousTransactionLedgerSequence, this.sendMax, this.sequence, this.destinationNode, this.expiration, this.invoiceId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCheckObject && this.equalTo(0, (ImmutableCheckObject)another);
    }

    private boolean equalTo(int synthetic, ImmutableCheckObject another) {
        return this.ledgerEntryType.equals((Object)another.ledgerEntryType) && this.account.equals(another.account) && Objects.equals(this.sourceTag, another.sourceTag) && this.destination.equals(another.destination) && Objects.equals(this.destinationTag, another.destinationTag) && this.flags.equals(another.flags) && this.ownerNode.equals(another.ownerNode) && this.previousTxnId.equals(another.previousTxnId) && this.previousTransactionLedgerSequence.equals((Object)another.previousTransactionLedgerSequence) && this.sendMax.equals(another.sendMax) && this.sequence.equals((Object)another.sequence) && Objects.equals(this.destinationNode, another.destinationNode) && Objects.equals(this.expiration, another.expiration) && Objects.equals(this.invoiceId, another.invoiceId) && this.index.equals(another.index);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.ledgerEntryType.hashCode();
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + Objects.hashCode(this.sourceTag);
        h += (h << 5) + this.destination.hashCode();
        h += (h << 5) + Objects.hashCode(this.destinationTag);
        h += (h << 5) + this.flags.hashCode();
        h += (h << 5) + this.ownerNode.hashCode();
        h += (h << 5) + this.previousTxnId.hashCode();
        h += (h << 5) + this.previousTransactionLedgerSequence.hashCode();
        h += (h << 5) + this.sendMax.hashCode();
        h += (h << 5) + this.sequence.hashCode();
        h += (h << 5) + Objects.hashCode(this.destinationNode);
        h += (h << 5) + Objects.hashCode(this.expiration);
        h += (h << 5) + Objects.hashCode(this.invoiceId);
        h += (h << 5) + this.index.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CheckObject").omitNullValues().add("ledgerEntryType", (Object)this.ledgerEntryType).add("account", (Object)this.account).add("sourceTag", (Object)this.sourceTag).add("destination", (Object)this.destination).add("destinationTag", (Object)this.destinationTag).add("flags", (Object)this.flags).add("ownerNode", (Object)this.ownerNode).add("previousTxnId", (Object)this.previousTxnId).add("previousTransactionLedgerSequence", (Object)this.previousTransactionLedgerSequence).add("sendMax", (Object)this.sendMax).add("sequence", (Object)this.sequence).add("destinationNode", (Object)this.destinationNode).add("expiration", (Object)this.expiration).add("invoiceId", (Object)this.invoiceId).add("index", (Object)this.index).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCheckObject fromJson(Json json) {
        Builder builder = ImmutableCheckObject.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.sourceTag != null) {
            builder.sourceTag(json.sourceTag);
        }
        if (json.destination != null) {
            builder.destination(json.destination);
        }
        if (json.destinationTag != null) {
            builder.destinationTag(json.destinationTag);
        }
        if (json.ownerNode != null) {
            builder.ownerNode(json.ownerNode);
        }
        if (json.previousTxnId != null) {
            builder.previousTxnId(json.previousTxnId);
        }
        if (json.previousTransactionLedgerSequence != null) {
            builder.previousTransactionLedgerSequence(json.previousTransactionLedgerSequence);
        }
        if (json.sendMax != null) {
            builder.sendMax(json.sendMax);
        }
        if (json.sequence != null) {
            builder.sequence(json.sequence);
        }
        if (json.destinationNode != null) {
            builder.destinationNode(json.destinationNode);
        }
        if (json.expiration != null) {
            builder.expiration(json.expiration);
        }
        if (json.invoiceId != null) {
            builder.invoiceId(json.invoiceId);
        }
        if (json.index != null) {
            builder.index(json.index);
        }
        return builder.build();
    }

    public static ImmutableCheckObject copyOf(CheckObject instance) {
        if (instance instanceof ImmutableCheckObject) {
            return (ImmutableCheckObject)instance;
        }
        return ImmutableCheckObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CheckObject", generator="Immutables")
    private final class InitShim {
        private byte ledgerEntryTypeBuildStage = 0;
        private LedgerObject.LedgerEntryType ledgerEntryType;
        private byte flagsBuildStage = 0;
        private Flags flags;

        private InitShim() {
        }

        LedgerObject.LedgerEntryType ledgerEntryType() {
            if (this.ledgerEntryTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ledgerEntryTypeBuildStage == 0) {
                this.ledgerEntryTypeBuildStage = (byte)-1;
                this.ledgerEntryType = Objects.requireNonNull(ImmutableCheckObject.this.ledgerEntryTypeInitialize(), "ledgerEntryType");
                this.ledgerEntryTypeBuildStage = 1;
            }
            return this.ledgerEntryType;
        }

        Flags flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = Objects.requireNonNull(ImmutableCheckObject.this.flagsInitialize(), "flags");
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.ledgerEntryTypeBuildStage == -1) {
                attributes.add("ledgerEntryType");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build CheckObject, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="CheckObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private static final long INIT_BIT_DESTINATION = 2L;
        private static final long INIT_BIT_OWNER_NODE = 4L;
        private static final long INIT_BIT_PREVIOUS_TXN_ID = 8L;
        private static final long INIT_BIT_PREVIOUS_TRANSACTION_LEDGER_SEQUENCE = 16L;
        private static final long INIT_BIT_SEND_MAX = 32L;
        private static final long INIT_BIT_SEQUENCE = 64L;
        private static final long INIT_BIT_INDEX = 128L;
        private long initBits = 255L;
        @Nullable
        private Address account;
        @Nullable
        private UnsignedInteger sourceTag;
        @Nullable
        private Address destination;
        @Nullable
        private UnsignedInteger destinationTag;
        @Nullable
        private String ownerNode;
        @Nullable
        private Hash256 previousTxnId;
        @Nullable
        private UnsignedInteger previousTransactionLedgerSequence;
        @Nullable
        private CurrencyAmount sendMax;
        @Nullable
        private UnsignedInteger sequence;
        @Nullable
        private String destinationNode;
        @Nullable
        private UnsignedInteger expiration;
        @Nullable
        private Hash256 invoiceId;
        @Nullable
        private Hash256 index;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CheckObject instance) {
            Optional<Hash256> invoiceIdOptional;
            Optional<UnsignedInteger> expirationOptional;
            Objects.requireNonNull(instance, "instance");
            this.account(instance.account());
            Optional<UnsignedInteger> sourceTagOptional = instance.sourceTag();
            if (sourceTagOptional.isPresent()) {
                this.sourceTag(sourceTagOptional);
            }
            this.destination(instance.destination());
            Optional<UnsignedInteger> destinationTagOptional = instance.destinationTag();
            if (destinationTagOptional.isPresent()) {
                this.destinationTag(destinationTagOptional);
            }
            this.ownerNode(instance.ownerNode());
            this.previousTxnId(instance.previousTxnId());
            this.previousTransactionLedgerSequence(instance.previousTransactionLedgerSequence());
            this.sendMax(instance.sendMax());
            this.sequence(instance.sequence());
            Optional<String> destinationNodeOptional = instance.destinationNode();
            if (destinationNodeOptional.isPresent()) {
                this.destinationNode(destinationNodeOptional);
            }
            if ((expirationOptional = instance.expiration()).isPresent()) {
                this.expiration(expirationOptional);
            }
            if ((invoiceIdOptional = instance.invoiceId()).isPresent()) {
                this.invoiceId(invoiceIdOptional);
            }
            this.index(instance.index());
            return this;
        }

        @JsonProperty(value="Account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceTag(UnsignedInteger sourceTag) {
            this.sourceTag = Objects.requireNonNull(sourceTag, "sourceTag");
            return this;
        }

        @JsonProperty(value="SourceTag")
        @CanIgnoreReturnValue
        public final Builder sourceTag(Optional<? extends UnsignedInteger> sourceTag) {
            this.sourceTag = sourceTag.orElse(null);
            return this;
        }

        @JsonProperty(value="Destination")
        @CanIgnoreReturnValue
        public final Builder destination(Address destination) {
            this.destination = Objects.requireNonNull(destination, "destination");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder destinationTag(UnsignedInteger destinationTag) {
            this.destinationTag = Objects.requireNonNull(destinationTag, "destinationTag");
            return this;
        }

        @JsonProperty(value="DestinationTag")
        @CanIgnoreReturnValue
        public final Builder destinationTag(Optional<? extends UnsignedInteger> destinationTag) {
            this.destinationTag = destinationTag.orElse(null);
            return this;
        }

        @JsonProperty(value="OwnerNode")
        @CanIgnoreReturnValue
        public final Builder ownerNode(String ownerNode) {
            this.ownerNode = Objects.requireNonNull(ownerNode, "ownerNode");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="PreviousTxnID")
        @CanIgnoreReturnValue
        public final Builder previousTxnId(Hash256 previousTxnId) {
            this.previousTxnId = Objects.requireNonNull(previousTxnId, "previousTxnId");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(UnsignedInteger previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = Objects.requireNonNull(previousTransactionLedgerSequence, "previousTransactionLedgerSequence");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="SendMax")
        @CanIgnoreReturnValue
        public final Builder sendMax(CurrencyAmount sendMax) {
            this.sendMax = Objects.requireNonNull(sendMax, "sendMax");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="Sequence")
        @CanIgnoreReturnValue
        public final Builder sequence(UnsignedInteger sequence) {
            this.sequence = Objects.requireNonNull(sequence, "sequence");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder destinationNode(String destinationNode) {
            this.destinationNode = Objects.requireNonNull(destinationNode, "destinationNode");
            return this;
        }

        @JsonProperty(value="DestinationNode")
        @CanIgnoreReturnValue
        public final Builder destinationNode(Optional<String> destinationNode) {
            this.destinationNode = destinationNode.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expiration(UnsignedInteger expiration) {
            this.expiration = Objects.requireNonNull(expiration, "expiration");
            return this;
        }

        @JsonProperty(value="Expiration")
        @CanIgnoreReturnValue
        public final Builder expiration(Optional<? extends UnsignedInteger> expiration) {
            this.expiration = expiration.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder invoiceId(Hash256 invoiceId) {
            this.invoiceId = Objects.requireNonNull(invoiceId, "invoiceId");
            return this;
        }

        @JsonProperty(value="InvoiceID")
        @CanIgnoreReturnValue
        public final Builder invoiceId(Optional<? extends Hash256> invoiceId) {
            this.invoiceId = invoiceId.orElse(null);
            return this;
        }

        @JsonProperty(value="index")
        @CanIgnoreReturnValue
        public final Builder index(Hash256 index) {
            this.index = Objects.requireNonNull(index, "index");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public ImmutableCheckObject build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCheckObject(this.account, this.sourceTag, this.destination, this.destinationTag, this.ownerNode, this.previousTxnId, this.previousTransactionLedgerSequence, this.sendMax, this.sequence, this.destinationNode, this.expiration, this.invoiceId, this.index);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("destination");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("ownerNode");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("previousTxnId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("previousTransactionLedgerSequence");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("sendMax");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("sequence");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("index");
            }
            return "Cannot build CheckObject, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CheckObject", generator="Immutables")
    static final class Json
    implements CheckObject {
        @Nullable
        Address account;
        @Nullable
        Optional<UnsignedInteger> sourceTag = Optional.empty();
        @Nullable
        Address destination;
        @Nullable
        Optional<UnsignedInteger> destinationTag = Optional.empty();
        @Nullable
        String ownerNode;
        @Nullable
        Hash256 previousTxnId;
        @Nullable
        UnsignedInteger previousTransactionLedgerSequence;
        @Nullable
        CurrencyAmount sendMax;
        @Nullable
        UnsignedInteger sequence;
        @Nullable
        Optional<String> destinationNode = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> expiration = Optional.empty();
        @Nullable
        Optional<Hash256> invoiceId = Optional.empty();
        @Nullable
        Hash256 index;

        Json() {
        }

        @JsonProperty(value="Account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="SourceTag")
        public void setSourceTag(Optional<UnsignedInteger> sourceTag) {
            this.sourceTag = sourceTag;
        }

        @JsonProperty(value="Destination")
        public void setDestination(Address destination) {
            this.destination = destination;
        }

        @JsonProperty(value="DestinationTag")
        public void setDestinationTag(Optional<UnsignedInteger> destinationTag) {
            this.destinationTag = destinationTag;
        }

        @JsonProperty(value="OwnerNode")
        public void setOwnerNode(String ownerNode) {
            this.ownerNode = ownerNode;
        }

        @JsonProperty(value="PreviousTxnID")
        public void setPreviousTxnId(Hash256 previousTxnId) {
            this.previousTxnId = previousTxnId;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        public void setPreviousTransactionLedgerSequence(UnsignedInteger previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        }

        @JsonProperty(value="SendMax")
        public void setSendMax(CurrencyAmount sendMax) {
            this.sendMax = sendMax;
        }

        @JsonProperty(value="Sequence")
        public void setSequence(UnsignedInteger sequence) {
            this.sequence = sequence;
        }

        @JsonProperty(value="DestinationNode")
        public void setDestinationNode(Optional<String> destinationNode) {
            this.destinationNode = destinationNode;
        }

        @JsonProperty(value="Expiration")
        public void setExpiration(Optional<UnsignedInteger> expiration) {
            this.expiration = expiration;
        }

        @JsonProperty(value="InvoiceID")
        public void setInvoiceId(Optional<Hash256> invoiceId) {
            this.invoiceId = invoiceId;
        }

        @JsonProperty(value="index")
        public void setIndex(Hash256 index) {
            this.index = index;
        }

        @Override
        @JsonIgnore
        public LedgerObject.LedgerEntryType ledgerEntryType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> sourceTag() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address destination() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> destinationTag() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public Flags flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String ownerNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 previousTxnId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger previousTransactionLedgerSequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CurrencyAmount sendMax() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger sequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> destinationNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> expiration() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> invoiceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 index() {
            throw new UnsupportedOperationException();
        }
    }
}

