/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.ledger.BridgeObject;
import org.xrpl.xrpl4j.model.ledger.LedgerObject;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.XChainBridge;
import org.xrpl.xrpl4j.model.transactions.XChainClaimId;
import org.xrpl.xrpl4j.model.transactions.XChainCount;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="BridgeObject", generator="Immutables")
@Immutable
public final class ImmutableBridgeObject
implements BridgeObject {
    private final transient LedgerObject.LedgerEntryType ledgerEntryType;
    private final transient Flags flags;
    private final Address account;
    @Nullable
    private final XrpCurrencyAmount minAccountCreateAmount;
    private final XrpCurrencyAmount signatureReward;
    private final XChainBridge xChainBridge;
    private final XChainClaimId xChainClaimId;
    private final XChainCount xChainAccountCreateCount;
    private final XChainCount xChainAccountClaimCount;
    private final String ownerNode;
    private final Hash256 previousTransactionId;
    private final UnsignedInteger previousTransactionLedgerSequence;
    private final Hash256 index;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBridgeObject(Address account, @Nullable XrpCurrencyAmount minAccountCreateAmount, XrpCurrencyAmount signatureReward, XChainBridge xChainBridge, XChainClaimId xChainClaimId, XChainCount xChainAccountCreateCount, XChainCount xChainAccountClaimCount, String ownerNode, Hash256 previousTransactionId, UnsignedInteger previousTransactionLedgerSequence, Hash256 index) {
        this.account = account;
        this.minAccountCreateAmount = minAccountCreateAmount;
        this.signatureReward = signatureReward;
        this.xChainBridge = xChainBridge;
        this.xChainClaimId = xChainClaimId;
        this.xChainAccountCreateCount = xChainAccountCreateCount;
        this.xChainAccountClaimCount = xChainAccountClaimCount;
        this.ownerNode = ownerNode;
        this.previousTransactionId = previousTransactionId;
        this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        this.index = index;
        this.ledgerEntryType = this.initShim.ledgerEntryType();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private LedgerObject.LedgerEntryType ledgerEntryTypeInitialize() {
        return BridgeObject.super.ledgerEntryType();
    }

    private Flags flagsInitialize() {
        return BridgeObject.super.flags();
    }

    @Override
    @JsonProperty(value="LedgerEntryType")
    public LedgerObject.LedgerEntryType ledgerEntryType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ledgerEntryType() : this.ledgerEntryType;
    }

    @Override
    @JsonProperty(value="Flags")
    public Flags flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @JsonProperty(value="Account")
    public Address account() {
        return this.account;
    }

    @Override
    @JsonProperty(value="MinAccountCreateAmount")
    public Optional<XrpCurrencyAmount> minAccountCreateAmount() {
        return Optional.ofNullable(this.minAccountCreateAmount);
    }

    @Override
    @JsonProperty(value="SignatureReward")
    public XrpCurrencyAmount signatureReward() {
        return this.signatureReward;
    }

    @Override
    @JsonProperty(value="XChainBridge")
    public XChainBridge xChainBridge() {
        return this.xChainBridge;
    }

    @Override
    @JsonProperty(value="XChainClaimID")
    public XChainClaimId xChainClaimId() {
        return this.xChainClaimId;
    }

    @Override
    @JsonProperty(value="XChainAccountCreateCount")
    public XChainCount xChainAccountCreateCount() {
        return this.xChainAccountCreateCount;
    }

    @Override
    @JsonProperty(value="XChainAccountClaimCount")
    public XChainCount xChainAccountClaimCount() {
        return this.xChainAccountClaimCount;
    }

    @Override
    @JsonProperty(value="OwnerNode")
    public String ownerNode() {
        return this.ownerNode;
    }

    @Override
    @JsonProperty(value="PreviousTxnID")
    public Hash256 previousTransactionId() {
        return this.previousTransactionId;
    }

    @Override
    @JsonProperty(value="PreviousTxnLgrSeq")
    public UnsignedInteger previousTransactionLedgerSequence() {
        return this.previousTransactionLedgerSequence;
    }

    @Override
    @JsonProperty(value="index")
    public Hash256 index() {
        return this.index;
    }

    public final ImmutableBridgeObject withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutableBridgeObject(newValue, this.minAccountCreateAmount, this.signatureReward, this.xChainBridge, this.xChainClaimId, this.xChainAccountCreateCount, this.xChainAccountClaimCount, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableBridgeObject withMinAccountCreateAmount(XrpCurrencyAmount value) {
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "minAccountCreateAmount");
        if (this.minAccountCreateAmount == newValue) {
            return this;
        }
        return new ImmutableBridgeObject(this.account, newValue, this.signatureReward, this.xChainBridge, this.xChainClaimId, this.xChainAccountCreateCount, this.xChainAccountClaimCount, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableBridgeObject withMinAccountCreateAmount(Optional<? extends XrpCurrencyAmount> optional) {
        XrpCurrencyAmount value = optional.orElse(null);
        if (this.minAccountCreateAmount == value) {
            return this;
        }
        return new ImmutableBridgeObject(this.account, value, this.signatureReward, this.xChainBridge, this.xChainClaimId, this.xChainAccountCreateCount, this.xChainAccountClaimCount, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableBridgeObject withSignatureReward(XrpCurrencyAmount value) {
        if (this.signatureReward == value) {
            return this;
        }
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "signatureReward");
        return new ImmutableBridgeObject(this.account, this.minAccountCreateAmount, newValue, this.xChainBridge, this.xChainClaimId, this.xChainAccountCreateCount, this.xChainAccountClaimCount, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableBridgeObject withXChainBridge(XChainBridge value) {
        if (this.xChainBridge == value) {
            return this;
        }
        XChainBridge newValue = Objects.requireNonNull(value, "xChainBridge");
        return new ImmutableBridgeObject(this.account, this.minAccountCreateAmount, this.signatureReward, newValue, this.xChainClaimId, this.xChainAccountCreateCount, this.xChainAccountClaimCount, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableBridgeObject withXChainClaimId(XChainClaimId value) {
        if (this.xChainClaimId == value) {
            return this;
        }
        XChainClaimId newValue = Objects.requireNonNull(value, "xChainClaimId");
        return new ImmutableBridgeObject(this.account, this.minAccountCreateAmount, this.signatureReward, this.xChainBridge, newValue, this.xChainAccountCreateCount, this.xChainAccountClaimCount, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableBridgeObject withXChainAccountCreateCount(XChainCount value) {
        if (this.xChainAccountCreateCount == value) {
            return this;
        }
        XChainCount newValue = Objects.requireNonNull(value, "xChainAccountCreateCount");
        return new ImmutableBridgeObject(this.account, this.minAccountCreateAmount, this.signatureReward, this.xChainBridge, this.xChainClaimId, newValue, this.xChainAccountClaimCount, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableBridgeObject withXChainAccountClaimCount(XChainCount value) {
        if (this.xChainAccountClaimCount == value) {
            return this;
        }
        XChainCount newValue = Objects.requireNonNull(value, "xChainAccountClaimCount");
        return new ImmutableBridgeObject(this.account, this.minAccountCreateAmount, this.signatureReward, this.xChainBridge, this.xChainClaimId, this.xChainAccountCreateCount, newValue, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableBridgeObject withOwnerNode(String value) {
        String newValue = Objects.requireNonNull(value, "ownerNode");
        if (this.ownerNode.equals(newValue)) {
            return this;
        }
        return new ImmutableBridgeObject(this.account, this.minAccountCreateAmount, this.signatureReward, this.xChainBridge, this.xChainClaimId, this.xChainAccountCreateCount, this.xChainAccountClaimCount, newValue, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableBridgeObject withPreviousTransactionId(Hash256 value) {
        if (this.previousTransactionId == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "previousTransactionId");
        return new ImmutableBridgeObject(this.account, this.minAccountCreateAmount, this.signatureReward, this.xChainBridge, this.xChainClaimId, this.xChainAccountCreateCount, this.xChainAccountClaimCount, this.ownerNode, newValue, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableBridgeObject withPreviousTransactionLedgerSequence(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "previousTransactionLedgerSequence");
        if (this.previousTransactionLedgerSequence.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableBridgeObject(this.account, this.minAccountCreateAmount, this.signatureReward, this.xChainBridge, this.xChainClaimId, this.xChainAccountCreateCount, this.xChainAccountClaimCount, this.ownerNode, this.previousTransactionId, newValue, this.index);
    }

    public final ImmutableBridgeObject withIndex(Hash256 value) {
        if (this.index == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "index");
        return new ImmutableBridgeObject(this.account, this.minAccountCreateAmount, this.signatureReward, this.xChainBridge, this.xChainClaimId, this.xChainAccountCreateCount, this.xChainAccountClaimCount, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBridgeObject && this.equalTo(0, (ImmutableBridgeObject)another);
    }

    private boolean equalTo(int synthetic, ImmutableBridgeObject another) {
        return this.ledgerEntryType.equals((Object)another.ledgerEntryType) && this.flags.equals(another.flags) && this.account.equals(another.account) && Objects.equals(this.minAccountCreateAmount, another.minAccountCreateAmount) && this.signatureReward.equals(another.signatureReward) && this.xChainBridge.equals(another.xChainBridge) && this.xChainClaimId.equals(another.xChainClaimId) && this.xChainAccountCreateCount.equals(another.xChainAccountCreateCount) && this.xChainAccountClaimCount.equals(another.xChainAccountClaimCount) && this.ownerNode.equals(another.ownerNode) && this.previousTransactionId.equals(another.previousTransactionId) && this.previousTransactionLedgerSequence.equals((Object)another.previousTransactionLedgerSequence) && this.index.equals(another.index);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.ledgerEntryType.hashCode();
        h += (h << 5) + this.flags.hashCode();
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + Objects.hashCode(this.minAccountCreateAmount);
        h += (h << 5) + this.signatureReward.hashCode();
        h += (h << 5) + this.xChainBridge.hashCode();
        h += (h << 5) + this.xChainClaimId.hashCode();
        h += (h << 5) + this.xChainAccountCreateCount.hashCode();
        h += (h << 5) + this.xChainAccountClaimCount.hashCode();
        h += (h << 5) + this.ownerNode.hashCode();
        h += (h << 5) + this.previousTransactionId.hashCode();
        h += (h << 5) + this.previousTransactionLedgerSequence.hashCode();
        h += (h << 5) + this.index.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"BridgeObject").omitNullValues().add("ledgerEntryType", (Object)this.ledgerEntryType).add("flags", (Object)this.flags).add("account", (Object)this.account).add("minAccountCreateAmount", (Object)this.minAccountCreateAmount).add("signatureReward", (Object)this.signatureReward).add("xChainBridge", (Object)this.xChainBridge).add("xChainClaimId", (Object)this.xChainClaimId).add("xChainAccountCreateCount", (Object)this.xChainAccountCreateCount).add("xChainAccountClaimCount", (Object)this.xChainAccountClaimCount).add("ownerNode", (Object)this.ownerNode).add("previousTransactionId", (Object)this.previousTransactionId).add("previousTransactionLedgerSequence", (Object)this.previousTransactionLedgerSequence).add("index", (Object)this.index).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableBridgeObject fromJson(Json json) {
        Builder builder = ImmutableBridgeObject.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.minAccountCreateAmount != null) {
            builder.minAccountCreateAmount(json.minAccountCreateAmount);
        }
        if (json.signatureReward != null) {
            builder.signatureReward(json.signatureReward);
        }
        if (json.xChainBridge != null) {
            builder.xChainBridge(json.xChainBridge);
        }
        if (json.xChainClaimId != null) {
            builder.xChainClaimId(json.xChainClaimId);
        }
        if (json.xChainAccountCreateCount != null) {
            builder.xChainAccountCreateCount(json.xChainAccountCreateCount);
        }
        if (json.xChainAccountClaimCount != null) {
            builder.xChainAccountClaimCount(json.xChainAccountClaimCount);
        }
        if (json.ownerNode != null) {
            builder.ownerNode(json.ownerNode);
        }
        if (json.previousTransactionId != null) {
            builder.previousTransactionId(json.previousTransactionId);
        }
        if (json.previousTransactionLedgerSequence != null) {
            builder.previousTransactionLedgerSequence(json.previousTransactionLedgerSequence);
        }
        if (json.index != null) {
            builder.index(json.index);
        }
        return builder.build();
    }

    public static ImmutableBridgeObject copyOf(BridgeObject instance) {
        if (instance instanceof ImmutableBridgeObject) {
            return (ImmutableBridgeObject)instance;
        }
        return ImmutableBridgeObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BridgeObject", generator="Immutables")
    private final class InitShim {
        private byte ledgerEntryTypeBuildStage = 0;
        private LedgerObject.LedgerEntryType ledgerEntryType;
        private byte flagsBuildStage = 0;
        private Flags flags;

        private InitShim() {
        }

        LedgerObject.LedgerEntryType ledgerEntryType() {
            if (this.ledgerEntryTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ledgerEntryTypeBuildStage == 0) {
                this.ledgerEntryTypeBuildStage = (byte)-1;
                this.ledgerEntryType = Objects.requireNonNull(ImmutableBridgeObject.this.ledgerEntryTypeInitialize(), "ledgerEntryType");
                this.ledgerEntryTypeBuildStage = 1;
            }
            return this.ledgerEntryType;
        }

        Flags flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = Objects.requireNonNull(ImmutableBridgeObject.this.flagsInitialize(), "flags");
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.ledgerEntryTypeBuildStage == -1) {
                attributes.add("ledgerEntryType");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build BridgeObject, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="BridgeObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private static final long INIT_BIT_SIGNATURE_REWARD = 2L;
        private static final long INIT_BIT_X_CHAIN_BRIDGE = 4L;
        private static final long INIT_BIT_X_CHAIN_CLAIM_ID = 8L;
        private static final long INIT_BIT_X_CHAIN_ACCOUNT_CREATE_COUNT = 16L;
        private static final long INIT_BIT_X_CHAIN_ACCOUNT_CLAIM_COUNT = 32L;
        private static final long INIT_BIT_OWNER_NODE = 64L;
        private static final long INIT_BIT_PREVIOUS_TRANSACTION_ID = 128L;
        private static final long INIT_BIT_PREVIOUS_TRANSACTION_LEDGER_SEQUENCE = 256L;
        private static final long INIT_BIT_INDEX = 512L;
        private long initBits = 1023L;
        @Nullable
        private Address account;
        @Nullable
        private XrpCurrencyAmount minAccountCreateAmount;
        @Nullable
        private XrpCurrencyAmount signatureReward;
        @Nullable
        private XChainBridge xChainBridge;
        @Nullable
        private XChainClaimId xChainClaimId;
        @Nullable
        private XChainCount xChainAccountCreateCount;
        @Nullable
        private XChainCount xChainAccountClaimCount;
        @Nullable
        private String ownerNode;
        @Nullable
        private Hash256 previousTransactionId;
        @Nullable
        private UnsignedInteger previousTransactionLedgerSequence;
        @Nullable
        private Hash256 index;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BridgeObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.account(instance.account());
            Optional<XrpCurrencyAmount> minAccountCreateAmountOptional = instance.minAccountCreateAmount();
            if (minAccountCreateAmountOptional.isPresent()) {
                this.minAccountCreateAmount(minAccountCreateAmountOptional);
            }
            this.signatureReward(instance.signatureReward());
            this.xChainBridge(instance.xChainBridge());
            this.xChainClaimId(instance.xChainClaimId());
            this.xChainAccountCreateCount(instance.xChainAccountCreateCount());
            this.xChainAccountClaimCount(instance.xChainAccountClaimCount());
            this.ownerNode(instance.ownerNode());
            this.previousTransactionId(instance.previousTransactionId());
            this.previousTransactionLedgerSequence(instance.previousTransactionLedgerSequence());
            this.index(instance.index());
            return this;
        }

        @JsonProperty(value="Account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder minAccountCreateAmount(XrpCurrencyAmount minAccountCreateAmount) {
            this.minAccountCreateAmount = Objects.requireNonNull(minAccountCreateAmount, "minAccountCreateAmount");
            return this;
        }

        @JsonProperty(value="MinAccountCreateAmount")
        @CanIgnoreReturnValue
        public final Builder minAccountCreateAmount(Optional<? extends XrpCurrencyAmount> minAccountCreateAmount) {
            this.minAccountCreateAmount = minAccountCreateAmount.orElse(null);
            return this;
        }

        @JsonProperty(value="SignatureReward")
        @CanIgnoreReturnValue
        public final Builder signatureReward(XrpCurrencyAmount signatureReward) {
            this.signatureReward = Objects.requireNonNull(signatureReward, "signatureReward");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="XChainBridge")
        @CanIgnoreReturnValue
        public final Builder xChainBridge(XChainBridge xChainBridge) {
            this.xChainBridge = Objects.requireNonNull(xChainBridge, "xChainBridge");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="XChainClaimID")
        @CanIgnoreReturnValue
        public final Builder xChainClaimId(XChainClaimId xChainClaimId) {
            this.xChainClaimId = Objects.requireNonNull(xChainClaimId, "xChainClaimId");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="XChainAccountCreateCount")
        @CanIgnoreReturnValue
        public final Builder xChainAccountCreateCount(XChainCount xChainAccountCreateCount) {
            this.xChainAccountCreateCount = Objects.requireNonNull(xChainAccountCreateCount, "xChainAccountCreateCount");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="XChainAccountClaimCount")
        @CanIgnoreReturnValue
        public final Builder xChainAccountClaimCount(XChainCount xChainAccountClaimCount) {
            this.xChainAccountClaimCount = Objects.requireNonNull(xChainAccountClaimCount, "xChainAccountClaimCount");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="OwnerNode")
        @CanIgnoreReturnValue
        public final Builder ownerNode(String ownerNode) {
            this.ownerNode = Objects.requireNonNull(ownerNode, "ownerNode");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="PreviousTxnID")
        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Hash256 previousTransactionId) {
            this.previousTransactionId = Objects.requireNonNull(previousTransactionId, "previousTransactionId");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(UnsignedInteger previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = Objects.requireNonNull(previousTransactionLedgerSequence, "previousTransactionLedgerSequence");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        @JsonProperty(value="index")
        @CanIgnoreReturnValue
        public final Builder index(Hash256 index) {
            this.index = Objects.requireNonNull(index, "index");
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        public ImmutableBridgeObject build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBridgeObject(this.account, this.minAccountCreateAmount, this.signatureReward, this.xChainBridge, this.xChainClaimId, this.xChainAccountCreateCount, this.xChainAccountClaimCount, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("signatureReward");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("xChainBridge");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("xChainClaimId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("xChainAccountCreateCount");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("xChainAccountClaimCount");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("ownerNode");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("previousTransactionId");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("previousTransactionLedgerSequence");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("index");
            }
            return "Cannot build BridgeObject, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="BridgeObject", generator="Immutables")
    static final class Json
    implements BridgeObject {
        @Nullable
        Address account;
        @Nullable
        Optional<XrpCurrencyAmount> minAccountCreateAmount = Optional.empty();
        @Nullable
        XrpCurrencyAmount signatureReward;
        @Nullable
        XChainBridge xChainBridge;
        @Nullable
        XChainClaimId xChainClaimId;
        @Nullable
        XChainCount xChainAccountCreateCount;
        @Nullable
        XChainCount xChainAccountClaimCount;
        @Nullable
        String ownerNode;
        @Nullable
        Hash256 previousTransactionId;
        @Nullable
        UnsignedInteger previousTransactionLedgerSequence;
        @Nullable
        Hash256 index;

        Json() {
        }

        @JsonProperty(value="Account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="MinAccountCreateAmount")
        public void setMinAccountCreateAmount(Optional<XrpCurrencyAmount> minAccountCreateAmount) {
            this.minAccountCreateAmount = minAccountCreateAmount;
        }

        @JsonProperty(value="SignatureReward")
        public void setSignatureReward(XrpCurrencyAmount signatureReward) {
            this.signatureReward = signatureReward;
        }

        @JsonProperty(value="XChainBridge")
        public void setXChainBridge(XChainBridge xChainBridge) {
            this.xChainBridge = xChainBridge;
        }

        @JsonProperty(value="XChainClaimID")
        public void setXChainClaimId(XChainClaimId xChainClaimId) {
            this.xChainClaimId = xChainClaimId;
        }

        @JsonProperty(value="XChainAccountCreateCount")
        public void setXChainAccountCreateCount(XChainCount xChainAccountCreateCount) {
            this.xChainAccountCreateCount = xChainAccountCreateCount;
        }

        @JsonProperty(value="XChainAccountClaimCount")
        public void setXChainAccountClaimCount(XChainCount xChainAccountClaimCount) {
            this.xChainAccountClaimCount = xChainAccountClaimCount;
        }

        @JsonProperty(value="OwnerNode")
        public void setOwnerNode(String ownerNode) {
            this.ownerNode = ownerNode;
        }

        @JsonProperty(value="PreviousTxnID")
        public void setPreviousTransactionId(Hash256 previousTransactionId) {
            this.previousTransactionId = previousTransactionId;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        public void setPreviousTransactionLedgerSequence(UnsignedInteger previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        }

        @JsonProperty(value="index")
        public void setIndex(Hash256 index) {
            this.index = index;
        }

        @Override
        @JsonIgnore
        public LedgerObject.LedgerEntryType ledgerEntryType() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public Flags flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<XrpCurrencyAmount> minAccountCreateAmount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XrpCurrencyAmount signatureReward() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XChainBridge xChainBridge() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XChainClaimId xChainClaimId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XChainCount xChainAccountCreateCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XChainCount xChainAccountClaimCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String ownerNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 previousTransactionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger previousTransactionLedgerSequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 index() {
            throw new UnsupportedOperationException();
        }
    }
}

