/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.ledger.AuctionSlot;
import org.xrpl.xrpl4j.model.ledger.AuthAccountWrapper;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.IssuedCurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.TradingFee;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AuctionSlot", generator="Immutables")
@Immutable
public final class ImmutableAuctionSlot
implements AuctionSlot {
    private final Address account;
    private final ImmutableList<AuthAccountWrapper> authAccounts;
    private final transient List<Address> authAccountsAddresses;
    private final TradingFee discountedFee;
    private final IssuedCurrencyAmount price;
    private final UnsignedInteger expiration;

    private ImmutableAuctionSlot(Address account, ImmutableList<AuthAccountWrapper> authAccounts, TradingFee discountedFee, IssuedCurrencyAmount price, UnsignedInteger expiration) {
        this.account = account;
        this.authAccounts = authAccounts;
        this.discountedFee = discountedFee;
        this.price = price;
        this.expiration = expiration;
        this.authAccountsAddresses = Objects.requireNonNull(AuctionSlot.super.authAccountsAddresses(), "authAccountsAddresses");
    }

    @Override
    @JsonProperty(value="Account")
    public Address account() {
        return this.account;
    }

    @JsonProperty(value="AuthAccounts")
    public ImmutableList<AuthAccountWrapper> authAccounts() {
        return this.authAccounts;
    }

    @Override
    @JsonProperty(value="authAccountsAddresses")
    @JsonIgnore
    public List<Address> authAccountsAddresses() {
        return this.authAccountsAddresses;
    }

    @Override
    @JsonProperty(value="DiscountedFee")
    public TradingFee discountedFee() {
        return this.discountedFee;
    }

    @Override
    @JsonProperty(value="Price")
    public IssuedCurrencyAmount price() {
        return this.price;
    }

    @Override
    @JsonProperty(value="Expiration")
    public UnsignedInteger expiration() {
        return this.expiration;
    }

    public final ImmutableAuctionSlot withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutableAuctionSlot(newValue, this.authAccounts, this.discountedFee, this.price, this.expiration);
    }

    public final ImmutableAuctionSlot withAuthAccounts(AuthAccountWrapper ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableAuctionSlot(this.account, (ImmutableList<AuthAccountWrapper>)newValue, this.discountedFee, this.price, this.expiration);
    }

    public final ImmutableAuctionSlot withAuthAccounts(Iterable<? extends AuthAccountWrapper> elements) {
        if (this.authAccounts == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableAuctionSlot(this.account, (ImmutableList<AuthAccountWrapper>)newValue, this.discountedFee, this.price, this.expiration);
    }

    public final ImmutableAuctionSlot withDiscountedFee(TradingFee value) {
        if (this.discountedFee == value) {
            return this;
        }
        TradingFee newValue = Objects.requireNonNull(value, "discountedFee");
        return new ImmutableAuctionSlot(this.account, this.authAccounts, newValue, this.price, this.expiration);
    }

    public final ImmutableAuctionSlot withPrice(IssuedCurrencyAmount value) {
        if (this.price == value) {
            return this;
        }
        IssuedCurrencyAmount newValue = Objects.requireNonNull(value, "price");
        return new ImmutableAuctionSlot(this.account, this.authAccounts, this.discountedFee, newValue, this.expiration);
    }

    public final ImmutableAuctionSlot withExpiration(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "expiration");
        if (this.expiration.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableAuctionSlot(this.account, this.authAccounts, this.discountedFee, this.price, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAuctionSlot && this.equalTo(0, (ImmutableAuctionSlot)another);
    }

    private boolean equalTo(int synthetic, ImmutableAuctionSlot another) {
        return this.account.equals(another.account) && this.authAccounts.equals(another.authAccounts) && this.authAccountsAddresses.equals(another.authAccountsAddresses) && this.discountedFee.equals(another.discountedFee) && this.price.equals(another.price) && this.expiration.equals((Object)another.expiration);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + this.authAccounts.hashCode();
        h += (h << 5) + this.authAccountsAddresses.hashCode();
        h += (h << 5) + this.discountedFee.hashCode();
        h += (h << 5) + this.price.hashCode();
        h += (h << 5) + this.expiration.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AuctionSlot").omitNullValues().add("account", (Object)this.account).add("authAccounts", this.authAccounts).add("authAccountsAddresses", this.authAccountsAddresses).add("discountedFee", (Object)this.discountedFee).add("price", (Object)this.price).add("expiration", (Object)this.expiration).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAuctionSlot fromJson(Json json) {
        Builder builder = ImmutableAuctionSlot.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.authAccounts != null) {
            builder.addAllAuthAccounts(json.authAccounts);
        }
        if (json.discountedFee != null) {
            builder.discountedFee(json.discountedFee);
        }
        if (json.price != null) {
            builder.price(json.price);
        }
        if (json.expiration != null) {
            builder.expiration(json.expiration);
        }
        return builder.build();
    }

    public static ImmutableAuctionSlot copyOf(AuctionSlot instance) {
        if (instance instanceof ImmutableAuctionSlot) {
            return (ImmutableAuctionSlot)instance;
        }
        return ImmutableAuctionSlot.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AuctionSlot", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private static final long INIT_BIT_DISCOUNTED_FEE = 2L;
        private static final long INIT_BIT_PRICE = 4L;
        private static final long INIT_BIT_EXPIRATION = 8L;
        private long initBits = 15L;
        @Nullable
        private Address account;
        private ImmutableList.Builder<AuthAccountWrapper> authAccounts = ImmutableList.builder();
        @Nullable
        private TradingFee discountedFee;
        @Nullable
        private IssuedCurrencyAmount price;
        @Nullable
        private UnsignedInteger expiration;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AuctionSlot instance) {
            Objects.requireNonNull(instance, "instance");
            this.account(instance.account());
            this.addAllAuthAccounts(instance.authAccounts());
            this.discountedFee(instance.discountedFee());
            this.price(instance.price());
            this.expiration(instance.expiration());
            return this;
        }

        @JsonProperty(value="Account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAuthAccounts(AuthAccountWrapper element) {
            this.authAccounts.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAuthAccounts(AuthAccountWrapper ... elements) {
            this.authAccounts.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="AuthAccounts")
        @CanIgnoreReturnValue
        public final Builder authAccounts(Iterable<? extends AuthAccountWrapper> elements) {
            this.authAccounts = ImmutableList.builder();
            return this.addAllAuthAccounts(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAuthAccounts(Iterable<? extends AuthAccountWrapper> elements) {
            this.authAccounts.addAll(elements);
            return this;
        }

        @JsonProperty(value="DiscountedFee")
        @CanIgnoreReturnValue
        public final Builder discountedFee(TradingFee discountedFee) {
            this.discountedFee = Objects.requireNonNull(discountedFee, "discountedFee");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="Price")
        @CanIgnoreReturnValue
        public final Builder price(IssuedCurrencyAmount price) {
            this.price = Objects.requireNonNull(price, "price");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="Expiration")
        @CanIgnoreReturnValue
        public final Builder expiration(UnsignedInteger expiration) {
            this.expiration = Objects.requireNonNull(expiration, "expiration");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableAuctionSlot build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAuctionSlot(this.account, this.authAccounts.build(), this.discountedFee, this.price, this.expiration);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("discountedFee");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("price");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("expiration");
            }
            return "Cannot build AuctionSlot, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AuctionSlot", generator="Immutables")
    static final class Json
    implements AuctionSlot {
        @Nullable
        Address account;
        @Nullable
        List<AuthAccountWrapper> authAccounts = ImmutableList.of();
        @Nullable
        TradingFee discountedFee;
        @Nullable
        IssuedCurrencyAmount price;
        @Nullable
        UnsignedInteger expiration;

        Json() {
        }

        @JsonProperty(value="Account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="AuthAccounts")
        public void setAuthAccounts(List<AuthAccountWrapper> authAccounts) {
            this.authAccounts = authAccounts;
        }

        @JsonProperty(value="DiscountedFee")
        public void setDiscountedFee(TradingFee discountedFee) {
            this.discountedFee = discountedFee;
        }

        @JsonProperty(value="Price")
        public void setPrice(IssuedCurrencyAmount price) {
            this.price = price;
        }

        @JsonProperty(value="Expiration")
        public void setExpiration(UnsignedInteger expiration) {
            this.expiration = expiration;
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<AuthAccountWrapper> authAccounts() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public List<Address> authAccountsAddresses() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TradingFee discountedFee() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IssuedCurrencyAmount price() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger expiration() {
            throw new UnsupportedOperationException();
        }
    }
}

