/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.ledger.Attestation;
import org.xrpl.xrpl4j.model.ledger.AttestationCreateAccount;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.CurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.XChainBridge;
import org.xrpl.xrpl4j.model.transactions.XChainCount;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AttestationCreateAccount", generator="Immutables")
@Immutable
public final class ImmutableAttestationCreateAccount
implements AttestationCreateAccount {
    private final XChainBridge xChainBridge;
    private final Address otherChainSource;
    private final Address attestationRewardAccount;
    private final CurrencyAmount amount;
    private final boolean wasLockingChainSend;
    private final XChainCount xChainAccountCreateCount;
    private final Address destination;
    private final XrpCurrencyAmount signatureReward;

    private ImmutableAttestationCreateAccount(XChainBridge xChainBridge, Address otherChainSource, Address attestationRewardAccount, CurrencyAmount amount, boolean wasLockingChainSend, XChainCount xChainAccountCreateCount, Address destination, XrpCurrencyAmount signatureReward) {
        this.xChainBridge = xChainBridge;
        this.otherChainSource = otherChainSource;
        this.attestationRewardAccount = attestationRewardAccount;
        this.amount = amount;
        this.wasLockingChainSend = wasLockingChainSend;
        this.xChainAccountCreateCount = xChainAccountCreateCount;
        this.destination = destination;
        this.signatureReward = signatureReward;
    }

    @Override
    @JsonProperty(value="XChainBridge")
    public XChainBridge xChainBridge() {
        return this.xChainBridge;
    }

    @Override
    @JsonProperty(value="OtherChainSource")
    public Address otherChainSource() {
        return this.otherChainSource;
    }

    @Override
    @JsonProperty(value="AttestationRewardAccount")
    public Address attestationRewardAccount() {
        return this.attestationRewardAccount;
    }

    @Override
    @JsonProperty(value="Amount")
    public CurrencyAmount amount() {
        return this.amount;
    }

    @Override
    @JsonProperty(value="WasLockingChainSend")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER)
    public boolean wasLockingChainSend() {
        return this.wasLockingChainSend;
    }

    @Override
    @JsonProperty(value="XChainAccountCreateCount")
    public XChainCount xChainAccountCreateCount() {
        return this.xChainAccountCreateCount;
    }

    @Override
    @JsonProperty(value="Destination")
    public Address destination() {
        return this.destination;
    }

    @Override
    @JsonProperty(value="SignatureReward")
    public XrpCurrencyAmount signatureReward() {
        return this.signatureReward;
    }

    public final ImmutableAttestationCreateAccount withXChainBridge(XChainBridge value) {
        if (this.xChainBridge == value) {
            return this;
        }
        XChainBridge newValue = Objects.requireNonNull(value, "xChainBridge");
        return new ImmutableAttestationCreateAccount(newValue, this.otherChainSource, this.attestationRewardAccount, this.amount, this.wasLockingChainSend, this.xChainAccountCreateCount, this.destination, this.signatureReward);
    }

    public final ImmutableAttestationCreateAccount withOtherChainSource(Address value) {
        if (this.otherChainSource == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "otherChainSource");
        return new ImmutableAttestationCreateAccount(this.xChainBridge, newValue, this.attestationRewardAccount, this.amount, this.wasLockingChainSend, this.xChainAccountCreateCount, this.destination, this.signatureReward);
    }

    public final ImmutableAttestationCreateAccount withAttestationRewardAccount(Address value) {
        if (this.attestationRewardAccount == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "attestationRewardAccount");
        return new ImmutableAttestationCreateAccount(this.xChainBridge, this.otherChainSource, newValue, this.amount, this.wasLockingChainSend, this.xChainAccountCreateCount, this.destination, this.signatureReward);
    }

    public final ImmutableAttestationCreateAccount withAmount(CurrencyAmount value) {
        if (this.amount == value) {
            return this;
        }
        CurrencyAmount newValue = Objects.requireNonNull(value, "amount");
        return new ImmutableAttestationCreateAccount(this.xChainBridge, this.otherChainSource, this.attestationRewardAccount, newValue, this.wasLockingChainSend, this.xChainAccountCreateCount, this.destination, this.signatureReward);
    }

    public final ImmutableAttestationCreateAccount withWasLockingChainSend(boolean value) {
        if (this.wasLockingChainSend == value) {
            return this;
        }
        return new ImmutableAttestationCreateAccount(this.xChainBridge, this.otherChainSource, this.attestationRewardAccount, this.amount, value, this.xChainAccountCreateCount, this.destination, this.signatureReward);
    }

    public final ImmutableAttestationCreateAccount withXChainAccountCreateCount(XChainCount value) {
        if (this.xChainAccountCreateCount == value) {
            return this;
        }
        XChainCount newValue = Objects.requireNonNull(value, "xChainAccountCreateCount");
        return new ImmutableAttestationCreateAccount(this.xChainBridge, this.otherChainSource, this.attestationRewardAccount, this.amount, this.wasLockingChainSend, newValue, this.destination, this.signatureReward);
    }

    public final ImmutableAttestationCreateAccount withDestination(Address value) {
        if (this.destination == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "destination");
        return new ImmutableAttestationCreateAccount(this.xChainBridge, this.otherChainSource, this.attestationRewardAccount, this.amount, this.wasLockingChainSend, this.xChainAccountCreateCount, newValue, this.signatureReward);
    }

    public final ImmutableAttestationCreateAccount withSignatureReward(XrpCurrencyAmount value) {
        if (this.signatureReward == value) {
            return this;
        }
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "signatureReward");
        return new ImmutableAttestationCreateAccount(this.xChainBridge, this.otherChainSource, this.attestationRewardAccount, this.amount, this.wasLockingChainSend, this.xChainAccountCreateCount, this.destination, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAttestationCreateAccount && this.equalTo(0, (ImmutableAttestationCreateAccount)another);
    }

    private boolean equalTo(int synthetic, ImmutableAttestationCreateAccount another) {
        return this.xChainBridge.equals(another.xChainBridge) && this.otherChainSource.equals(another.otherChainSource) && this.attestationRewardAccount.equals(another.attestationRewardAccount) && this.amount.equals(another.amount) && this.wasLockingChainSend == another.wasLockingChainSend && this.xChainAccountCreateCount.equals(another.xChainAccountCreateCount) && this.destination.equals(another.destination) && this.signatureReward.equals(another.signatureReward);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.xChainBridge.hashCode();
        h += (h << 5) + this.otherChainSource.hashCode();
        h += (h << 5) + this.attestationRewardAccount.hashCode();
        h += (h << 5) + this.amount.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.wasLockingChainSend);
        h += (h << 5) + this.xChainAccountCreateCount.hashCode();
        h += (h << 5) + this.destination.hashCode();
        h += (h << 5) + this.signatureReward.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AttestationCreateAccount").omitNullValues().add("xChainBridge", (Object)this.xChainBridge).add("otherChainSource", (Object)this.otherChainSource).add("attestationRewardAccount", (Object)this.attestationRewardAccount).add("amount", (Object)this.amount).add("wasLockingChainSend", this.wasLockingChainSend).add("xChainAccountCreateCount", (Object)this.xChainAccountCreateCount).add("destination", (Object)this.destination).add("signatureReward", (Object)this.signatureReward).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAttestationCreateAccount fromJson(Json json) {
        Builder builder = ImmutableAttestationCreateAccount.builder();
        if (json.xChainBridge != null) {
            builder.xChainBridge(json.xChainBridge);
        }
        if (json.otherChainSource != null) {
            builder.otherChainSource(json.otherChainSource);
        }
        if (json.attestationRewardAccount != null) {
            builder.attestationRewardAccount(json.attestationRewardAccount);
        }
        if (json.amount != null) {
            builder.amount(json.amount);
        }
        if (json.wasLockingChainSendIsSet) {
            builder.wasLockingChainSend(json.wasLockingChainSend);
        }
        if (json.xChainAccountCreateCount != null) {
            builder.xChainAccountCreateCount(json.xChainAccountCreateCount);
        }
        if (json.destination != null) {
            builder.destination(json.destination);
        }
        if (json.signatureReward != null) {
            builder.signatureReward(json.signatureReward);
        }
        return builder.build();
    }

    public static ImmutableAttestationCreateAccount copyOf(AttestationCreateAccount instance) {
        if (instance instanceof ImmutableAttestationCreateAccount) {
            return (ImmutableAttestationCreateAccount)instance;
        }
        return ImmutableAttestationCreateAccount.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AttestationCreateAccount", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_X_CHAIN_BRIDGE = 1L;
        private static final long INIT_BIT_OTHER_CHAIN_SOURCE = 2L;
        private static final long INIT_BIT_ATTESTATION_REWARD_ACCOUNT = 4L;
        private static final long INIT_BIT_AMOUNT = 8L;
        private static final long INIT_BIT_WAS_LOCKING_CHAIN_SEND = 16L;
        private static final long INIT_BIT_X_CHAIN_ACCOUNT_CREATE_COUNT = 32L;
        private static final long INIT_BIT_DESTINATION = 64L;
        private static final long INIT_BIT_SIGNATURE_REWARD = 128L;
        private long initBits = 255L;
        @Nullable
        private XChainBridge xChainBridge;
        @Nullable
        private Address otherChainSource;
        @Nullable
        private Address attestationRewardAccount;
        @Nullable
        private CurrencyAmount amount;
        private boolean wasLockingChainSend;
        @Nullable
        private XChainCount xChainAccountCreateCount;
        @Nullable
        private Address destination;
        @Nullable
        private XrpCurrencyAmount signatureReward;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Attestation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AttestationCreateAccount instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Attestation instance;
            long bits = 0L;
            if (object instanceof Attestation) {
                instance = (Attestation)object;
                if ((bits & 0x10L) == 0L) {
                    this.wasLockingChainSend(instance.wasLockingChainSend());
                    bits |= 0x10L;
                }
                if ((bits & 1L) == 0L) {
                    this.amount(instance.amount());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.otherChainSource(instance.otherChainSource());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.xChainBridge(instance.xChainBridge());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.attestationRewardAccount(instance.attestationRewardAccount());
                    bits |= 8L;
                }
            }
            if (object instanceof AttestationCreateAccount) {
                instance = (AttestationCreateAccount)object;
                if ((bits & 1L) == 0L) {
                    this.amount(instance.amount());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.otherChainSource(instance.otherChainSource());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.xChainBridge(instance.xChainBridge());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.attestationRewardAccount(instance.attestationRewardAccount());
                    bits |= 8L;
                }
                this.xChainAccountCreateCount(instance.xChainAccountCreateCount());
                this.destination(instance.destination());
                if ((bits & 0x10L) == 0L) {
                    this.wasLockingChainSend(instance.wasLockingChainSend());
                    bits |= 0x10L;
                }
                this.signatureReward(instance.signatureReward());
            }
        }

        @JsonProperty(value="XChainBridge")
        @CanIgnoreReturnValue
        public final Builder xChainBridge(XChainBridge xChainBridge) {
            this.xChainBridge = Objects.requireNonNull(xChainBridge, "xChainBridge");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="OtherChainSource")
        @CanIgnoreReturnValue
        public final Builder otherChainSource(Address otherChainSource) {
            this.otherChainSource = Objects.requireNonNull(otherChainSource, "otherChainSource");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="AttestationRewardAccount")
        @CanIgnoreReturnValue
        public final Builder attestationRewardAccount(Address attestationRewardAccount) {
            this.attestationRewardAccount = Objects.requireNonNull(attestationRewardAccount, "attestationRewardAccount");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="Amount")
        @CanIgnoreReturnValue
        public final Builder amount(CurrencyAmount amount) {
            this.amount = Objects.requireNonNull(amount, "amount");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="WasLockingChainSend")
        @JsonFormat(shape=JsonFormat.Shape.NUMBER)
        @CanIgnoreReturnValue
        public final Builder wasLockingChainSend(boolean wasLockingChainSend) {
            this.wasLockingChainSend = wasLockingChainSend;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="XChainAccountCreateCount")
        @CanIgnoreReturnValue
        public final Builder xChainAccountCreateCount(XChainCount xChainAccountCreateCount) {
            this.xChainAccountCreateCount = Objects.requireNonNull(xChainAccountCreateCount, "xChainAccountCreateCount");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="Destination")
        @CanIgnoreReturnValue
        public final Builder destination(Address destination) {
            this.destination = Objects.requireNonNull(destination, "destination");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="SignatureReward")
        @CanIgnoreReturnValue
        public final Builder signatureReward(XrpCurrencyAmount signatureReward) {
            this.signatureReward = Objects.requireNonNull(signatureReward, "signatureReward");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public ImmutableAttestationCreateAccount build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAttestationCreateAccount(this.xChainBridge, this.otherChainSource, this.attestationRewardAccount, this.amount, this.wasLockingChainSend, this.xChainAccountCreateCount, this.destination, this.signatureReward);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("xChainBridge");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("otherChainSource");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("attestationRewardAccount");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("amount");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("wasLockingChainSend");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("xChainAccountCreateCount");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("destination");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("signatureReward");
            }
            return "Cannot build AttestationCreateAccount, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AttestationCreateAccount", generator="Immutables")
    static final class Json
    implements AttestationCreateAccount {
        @Nullable
        XChainBridge xChainBridge;
        @Nullable
        Address otherChainSource;
        @Nullable
        Address attestationRewardAccount;
        @Nullable
        CurrencyAmount amount;
        boolean wasLockingChainSend;
        boolean wasLockingChainSendIsSet;
        @Nullable
        XChainCount xChainAccountCreateCount;
        @Nullable
        Address destination;
        @Nullable
        XrpCurrencyAmount signatureReward;

        Json() {
        }

        @JsonProperty(value="XChainBridge")
        public void setXChainBridge(XChainBridge xChainBridge) {
            this.xChainBridge = xChainBridge;
        }

        @JsonProperty(value="OtherChainSource")
        public void setOtherChainSource(Address otherChainSource) {
            this.otherChainSource = otherChainSource;
        }

        @JsonProperty(value="AttestationRewardAccount")
        public void setAttestationRewardAccount(Address attestationRewardAccount) {
            this.attestationRewardAccount = attestationRewardAccount;
        }

        @JsonProperty(value="Amount")
        public void setAmount(CurrencyAmount amount) {
            this.amount = amount;
        }

        @JsonProperty(value="WasLockingChainSend")
        @JsonFormat(shape=JsonFormat.Shape.NUMBER)
        public void setWasLockingChainSend(boolean wasLockingChainSend) {
            this.wasLockingChainSend = wasLockingChainSend;
            this.wasLockingChainSendIsSet = true;
        }

        @JsonProperty(value="XChainAccountCreateCount")
        public void setXChainAccountCreateCount(XChainCount xChainAccountCreateCount) {
            this.xChainAccountCreateCount = xChainAccountCreateCount;
        }

        @JsonProperty(value="Destination")
        public void setDestination(Address destination) {
            this.destination = destination;
        }

        @JsonProperty(value="SignatureReward")
        public void setSignatureReward(XrpCurrencyAmount signatureReward) {
            this.signatureReward = signatureReward;
        }

        @Override
        public XChainBridge xChainBridge() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address otherChainSource() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address attestationRewardAccount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CurrencyAmount amount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean wasLockingChainSend() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XChainCount xChainAccountCreateCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address destination() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XrpCurrencyAmount signatureReward() {
            throw new UnsupportedOperationException();
        }
    }
}

