/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.ledger.Attestation;
import org.xrpl.xrpl4j.model.ledger.AttestationClaim;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.CurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.XChainBridge;
import org.xrpl.xrpl4j.model.transactions.XChainClaimId;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AttestationClaim", generator="Immutables")
@Immutable
public final class ImmutableAttestationClaim
implements AttestationClaim {
    private final XChainBridge xChainBridge;
    private final Address otherChainSource;
    private final Address attestationRewardAccount;
    private final CurrencyAmount amount;
    private final boolean wasLockingChainSend;
    @Nullable
    private final Address destination;
    private final XChainClaimId xChainClaimId;

    private ImmutableAttestationClaim(XChainBridge xChainBridge, Address otherChainSource, Address attestationRewardAccount, CurrencyAmount amount, boolean wasLockingChainSend, @Nullable Address destination, XChainClaimId xChainClaimId) {
        this.xChainBridge = xChainBridge;
        this.otherChainSource = otherChainSource;
        this.attestationRewardAccount = attestationRewardAccount;
        this.amount = amount;
        this.wasLockingChainSend = wasLockingChainSend;
        this.destination = destination;
        this.xChainClaimId = xChainClaimId;
    }

    @Override
    @JsonProperty(value="XChainBridge")
    public XChainBridge xChainBridge() {
        return this.xChainBridge;
    }

    @Override
    @JsonProperty(value="OtherChainSource")
    public Address otherChainSource() {
        return this.otherChainSource;
    }

    @Override
    @JsonProperty(value="AttestationRewardAccount")
    public Address attestationRewardAccount() {
        return this.attestationRewardAccount;
    }

    @Override
    @JsonProperty(value="Amount")
    public CurrencyAmount amount() {
        return this.amount;
    }

    @Override
    @JsonProperty(value="WasLockingChainSend")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER)
    public boolean wasLockingChainSend() {
        return this.wasLockingChainSend;
    }

    @Override
    @JsonProperty(value="Destination")
    public Optional<Address> destination() {
        return Optional.ofNullable(this.destination);
    }

    @Override
    @JsonProperty(value="XChainClaimID")
    public XChainClaimId xChainClaimId() {
        return this.xChainClaimId;
    }

    public final ImmutableAttestationClaim withXChainBridge(XChainBridge value) {
        if (this.xChainBridge == value) {
            return this;
        }
        XChainBridge newValue = Objects.requireNonNull(value, "xChainBridge");
        return new ImmutableAttestationClaim(newValue, this.otherChainSource, this.attestationRewardAccount, this.amount, this.wasLockingChainSend, this.destination, this.xChainClaimId);
    }

    public final ImmutableAttestationClaim withOtherChainSource(Address value) {
        if (this.otherChainSource == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "otherChainSource");
        return new ImmutableAttestationClaim(this.xChainBridge, newValue, this.attestationRewardAccount, this.amount, this.wasLockingChainSend, this.destination, this.xChainClaimId);
    }

    public final ImmutableAttestationClaim withAttestationRewardAccount(Address value) {
        if (this.attestationRewardAccount == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "attestationRewardAccount");
        return new ImmutableAttestationClaim(this.xChainBridge, this.otherChainSource, newValue, this.amount, this.wasLockingChainSend, this.destination, this.xChainClaimId);
    }

    public final ImmutableAttestationClaim withAmount(CurrencyAmount value) {
        if (this.amount == value) {
            return this;
        }
        CurrencyAmount newValue = Objects.requireNonNull(value, "amount");
        return new ImmutableAttestationClaim(this.xChainBridge, this.otherChainSource, this.attestationRewardAccount, newValue, this.wasLockingChainSend, this.destination, this.xChainClaimId);
    }

    public final ImmutableAttestationClaim withWasLockingChainSend(boolean value) {
        if (this.wasLockingChainSend == value) {
            return this;
        }
        return new ImmutableAttestationClaim(this.xChainBridge, this.otherChainSource, this.attestationRewardAccount, this.amount, value, this.destination, this.xChainClaimId);
    }

    public final ImmutableAttestationClaim withDestination(Address value) {
        Address newValue = Objects.requireNonNull(value, "destination");
        if (this.destination == newValue) {
            return this;
        }
        return new ImmutableAttestationClaim(this.xChainBridge, this.otherChainSource, this.attestationRewardAccount, this.amount, this.wasLockingChainSend, newValue, this.xChainClaimId);
    }

    public final ImmutableAttestationClaim withDestination(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.destination == value) {
            return this;
        }
        return new ImmutableAttestationClaim(this.xChainBridge, this.otherChainSource, this.attestationRewardAccount, this.amount, this.wasLockingChainSend, value, this.xChainClaimId);
    }

    public final ImmutableAttestationClaim withXChainClaimId(XChainClaimId value) {
        if (this.xChainClaimId == value) {
            return this;
        }
        XChainClaimId newValue = Objects.requireNonNull(value, "xChainClaimId");
        return new ImmutableAttestationClaim(this.xChainBridge, this.otherChainSource, this.attestationRewardAccount, this.amount, this.wasLockingChainSend, this.destination, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAttestationClaim && this.equalTo(0, (ImmutableAttestationClaim)another);
    }

    private boolean equalTo(int synthetic, ImmutableAttestationClaim another) {
        return this.xChainBridge.equals(another.xChainBridge) && this.otherChainSource.equals(another.otherChainSource) && this.attestationRewardAccount.equals(another.attestationRewardAccount) && this.amount.equals(another.amount) && this.wasLockingChainSend == another.wasLockingChainSend && Objects.equals(this.destination, another.destination) && this.xChainClaimId.equals(another.xChainClaimId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.xChainBridge.hashCode();
        h += (h << 5) + this.otherChainSource.hashCode();
        h += (h << 5) + this.attestationRewardAccount.hashCode();
        h += (h << 5) + this.amount.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.wasLockingChainSend);
        h += (h << 5) + Objects.hashCode(this.destination);
        h += (h << 5) + this.xChainClaimId.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AttestationClaim").omitNullValues().add("xChainBridge", (Object)this.xChainBridge).add("otherChainSource", (Object)this.otherChainSource).add("attestationRewardAccount", (Object)this.attestationRewardAccount).add("amount", (Object)this.amount).add("wasLockingChainSend", this.wasLockingChainSend).add("destination", (Object)this.destination).add("xChainClaimId", (Object)this.xChainClaimId).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAttestationClaim fromJson(Json json) {
        Builder builder = ImmutableAttestationClaim.builder();
        if (json.xChainBridge != null) {
            builder.xChainBridge(json.xChainBridge);
        }
        if (json.otherChainSource != null) {
            builder.otherChainSource(json.otherChainSource);
        }
        if (json.attestationRewardAccount != null) {
            builder.attestationRewardAccount(json.attestationRewardAccount);
        }
        if (json.amount != null) {
            builder.amount(json.amount);
        }
        if (json.wasLockingChainSendIsSet) {
            builder.wasLockingChainSend(json.wasLockingChainSend);
        }
        if (json.destination != null) {
            builder.destination(json.destination);
        }
        if (json.xChainClaimId != null) {
            builder.xChainClaimId(json.xChainClaimId);
        }
        return builder.build();
    }

    public static ImmutableAttestationClaim copyOf(AttestationClaim instance) {
        if (instance instanceof ImmutableAttestationClaim) {
            return (ImmutableAttestationClaim)instance;
        }
        return ImmutableAttestationClaim.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AttestationClaim", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_X_CHAIN_BRIDGE = 1L;
        private static final long INIT_BIT_OTHER_CHAIN_SOURCE = 2L;
        private static final long INIT_BIT_ATTESTATION_REWARD_ACCOUNT = 4L;
        private static final long INIT_BIT_AMOUNT = 8L;
        private static final long INIT_BIT_WAS_LOCKING_CHAIN_SEND = 16L;
        private static final long INIT_BIT_X_CHAIN_CLAIM_ID = 32L;
        private long initBits = 63L;
        @Nullable
        private XChainBridge xChainBridge;
        @Nullable
        private Address otherChainSource;
        @Nullable
        private Address attestationRewardAccount;
        @Nullable
        private CurrencyAmount amount;
        private boolean wasLockingChainSend;
        @Nullable
        private Address destination;
        @Nullable
        private XChainClaimId xChainClaimId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AttestationClaim instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Attestation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Attestation instance;
            long bits = 0L;
            if (object instanceof AttestationClaim) {
                Optional<Address> destinationOptional;
                instance = (AttestationClaim)object;
                if ((bits & 1L) == 0L) {
                    this.amount(instance.amount());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.otherChainSource(instance.otherChainSource());
                    bits |= 2L;
                }
                this.xChainClaimId(instance.xChainClaimId());
                if ((bits & 4L) == 0L) {
                    this.xChainBridge(instance.xChainBridge());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.attestationRewardAccount(instance.attestationRewardAccount());
                    bits |= 8L;
                }
                if ((destinationOptional = instance.destination()).isPresent()) {
                    this.destination(destinationOptional);
                }
                if ((bits & 0x10L) == 0L) {
                    this.wasLockingChainSend(instance.wasLockingChainSend());
                    bits |= 0x10L;
                }
            }
            if (object instanceof Attestation) {
                instance = (Attestation)object;
                if ((bits & 0x10L) == 0L) {
                    this.wasLockingChainSend(instance.wasLockingChainSend());
                    bits |= 0x10L;
                }
                if ((bits & 1L) == 0L) {
                    this.amount(instance.amount());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.otherChainSource(instance.otherChainSource());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.xChainBridge(instance.xChainBridge());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.attestationRewardAccount(instance.attestationRewardAccount());
                    bits |= 8L;
                }
            }
        }

        @JsonProperty(value="XChainBridge")
        @CanIgnoreReturnValue
        public final Builder xChainBridge(XChainBridge xChainBridge) {
            this.xChainBridge = Objects.requireNonNull(xChainBridge, "xChainBridge");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="OtherChainSource")
        @CanIgnoreReturnValue
        public final Builder otherChainSource(Address otherChainSource) {
            this.otherChainSource = Objects.requireNonNull(otherChainSource, "otherChainSource");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="AttestationRewardAccount")
        @CanIgnoreReturnValue
        public final Builder attestationRewardAccount(Address attestationRewardAccount) {
            this.attestationRewardAccount = Objects.requireNonNull(attestationRewardAccount, "attestationRewardAccount");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="Amount")
        @CanIgnoreReturnValue
        public final Builder amount(CurrencyAmount amount) {
            this.amount = Objects.requireNonNull(amount, "amount");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="WasLockingChainSend")
        @JsonFormat(shape=JsonFormat.Shape.NUMBER)
        @CanIgnoreReturnValue
        public final Builder wasLockingChainSend(boolean wasLockingChainSend) {
            this.wasLockingChainSend = wasLockingChainSend;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder destination(Address destination) {
            this.destination = Objects.requireNonNull(destination, "destination");
            return this;
        }

        @JsonProperty(value="Destination")
        @CanIgnoreReturnValue
        public final Builder destination(Optional<? extends Address> destination) {
            this.destination = destination.orElse(null);
            return this;
        }

        @JsonProperty(value="XChainClaimID")
        @CanIgnoreReturnValue
        public final Builder xChainClaimId(XChainClaimId xChainClaimId) {
            this.xChainClaimId = Objects.requireNonNull(xChainClaimId, "xChainClaimId");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutableAttestationClaim build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAttestationClaim(this.xChainBridge, this.otherChainSource, this.attestationRewardAccount, this.amount, this.wasLockingChainSend, this.destination, this.xChainClaimId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("xChainBridge");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("otherChainSource");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("attestationRewardAccount");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("amount");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("wasLockingChainSend");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("xChainClaimId");
            }
            return "Cannot build AttestationClaim, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AttestationClaim", generator="Immutables")
    static final class Json
    implements AttestationClaim {
        @Nullable
        XChainBridge xChainBridge;
        @Nullable
        Address otherChainSource;
        @Nullable
        Address attestationRewardAccount;
        @Nullable
        CurrencyAmount amount;
        boolean wasLockingChainSend;
        boolean wasLockingChainSendIsSet;
        @Nullable
        Optional<Address> destination = Optional.empty();
        @Nullable
        XChainClaimId xChainClaimId;

        Json() {
        }

        @JsonProperty(value="XChainBridge")
        public void setXChainBridge(XChainBridge xChainBridge) {
            this.xChainBridge = xChainBridge;
        }

        @JsonProperty(value="OtherChainSource")
        public void setOtherChainSource(Address otherChainSource) {
            this.otherChainSource = otherChainSource;
        }

        @JsonProperty(value="AttestationRewardAccount")
        public void setAttestationRewardAccount(Address attestationRewardAccount) {
            this.attestationRewardAccount = attestationRewardAccount;
        }

        @JsonProperty(value="Amount")
        public void setAmount(CurrencyAmount amount) {
            this.amount = amount;
        }

        @JsonProperty(value="WasLockingChainSend")
        @JsonFormat(shape=JsonFormat.Shape.NUMBER)
        public void setWasLockingChainSend(boolean wasLockingChainSend) {
            this.wasLockingChainSend = wasLockingChainSend;
            this.wasLockingChainSendIsSet = true;
        }

        @JsonProperty(value="Destination")
        public void setDestination(Optional<Address> destination) {
            this.destination = destination;
        }

        @JsonProperty(value="XChainClaimID")
        public void setXChainClaimId(XChainClaimId xChainClaimId) {
            this.xChainClaimId = xChainClaimId;
        }

        @Override
        public XChainBridge xChainBridge() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address otherChainSource() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address attestationRewardAccount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CurrencyAmount amount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean wasLockingChainSend() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Address> destination() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XChainClaimId xChainClaimId() {
            throw new UnsupportedOperationException();
        }
    }
}

