/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.ledger.AmmObject;
import org.xrpl.xrpl4j.model.ledger.AuctionSlot;
import org.xrpl.xrpl4j.model.ledger.Issue;
import org.xrpl.xrpl4j.model.ledger.LedgerObject;
import org.xrpl.xrpl4j.model.ledger.VoteEntry;
import org.xrpl.xrpl4j.model.ledger.VoteEntryWrapper;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.IssuedCurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.TradingFee;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AmmObject", generator="Immutables")
@Immutable
public final class ImmutableAmmObject
implements AmmObject {
    private final transient LedgerObject.LedgerEntryType ledgerEntryType;
    private final transient Flags flags;
    private final Issue asset;
    private final Issue asset2;
    private final Address account;
    @Nullable
    private final AuctionSlot auctionSlot;
    private final IssuedCurrencyAmount lpTokenBalance;
    private final TradingFee tradingFee;
    private final ImmutableList<VoteEntryWrapper> voteSlots;
    private final String ownerNode;
    private final transient List<VoteEntry> voteSlotsUnwrapped;
    private final Hash256 index;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableAmmObject(Issue asset, Issue asset2, Address account, @Nullable AuctionSlot auctionSlot, IssuedCurrencyAmount lpTokenBalance, TradingFee tradingFee, ImmutableList<VoteEntryWrapper> voteSlots, String ownerNode, Hash256 index) {
        this.asset = asset;
        this.asset2 = asset2;
        this.account = account;
        this.auctionSlot = auctionSlot;
        this.lpTokenBalance = lpTokenBalance;
        this.tradingFee = tradingFee;
        this.voteSlots = voteSlots;
        this.ownerNode = ownerNode;
        this.index = index;
        this.ledgerEntryType = this.initShim.ledgerEntryType();
        this.flags = this.initShim.flags();
        this.voteSlotsUnwrapped = this.initShim.voteSlotsUnwrapped();
        this.initShim = null;
    }

    private LedgerObject.LedgerEntryType ledgerEntryTypeInitialize() {
        return AmmObject.super.ledgerEntryType();
    }

    private Flags flagsInitialize() {
        return AmmObject.super.flags();
    }

    private List<VoteEntry> voteSlotsUnwrappedInitialize() {
        return AmmObject.super.voteSlotsUnwrapped();
    }

    @Override
    @JsonProperty(value="LedgerEntryType")
    public LedgerObject.LedgerEntryType ledgerEntryType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ledgerEntryType() : this.ledgerEntryType;
    }

    @Override
    @JsonProperty(value="Flags")
    public Flags flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @JsonProperty(value="Asset")
    public Issue asset() {
        return this.asset;
    }

    @Override
    @JsonProperty(value="Asset2")
    public Issue asset2() {
        return this.asset2;
    }

    @Override
    @JsonProperty(value="Account")
    public Address account() {
        return this.account;
    }

    @Override
    @JsonProperty(value="AuctionSlot")
    public Optional<AuctionSlot> auctionSlot() {
        return Optional.ofNullable(this.auctionSlot);
    }

    @Override
    @JsonProperty(value="LPTokenBalance")
    public IssuedCurrencyAmount lpTokenBalance() {
        return this.lpTokenBalance;
    }

    @Override
    @JsonProperty(value="TradingFee")
    public TradingFee tradingFee() {
        return this.tradingFee;
    }

    @JsonProperty(value="VoteSlots")
    public ImmutableList<VoteEntryWrapper> voteSlots() {
        return this.voteSlots;
    }

    @Override
    @JsonProperty(value="OwnerNode")
    public String ownerNode() {
        return this.ownerNode;
    }

    @Override
    @JsonProperty(value="voteSlotsUnwrapped")
    @JsonIgnore
    public List<VoteEntry> voteSlotsUnwrapped() {
        InitShim shim = this.initShim;
        return shim != null ? shim.voteSlotsUnwrapped() : this.voteSlotsUnwrapped;
    }

    @Override
    @JsonProperty(value="index")
    public Hash256 index() {
        return this.index;
    }

    public final ImmutableAmmObject withAsset(Issue value) {
        if (this.asset == value) {
            return this;
        }
        Issue newValue = Objects.requireNonNull(value, "asset");
        return new ImmutableAmmObject(newValue, this.asset2, this.account, this.auctionSlot, this.lpTokenBalance, this.tradingFee, this.voteSlots, this.ownerNode, this.index);
    }

    public final ImmutableAmmObject withAsset2(Issue value) {
        if (this.asset2 == value) {
            return this;
        }
        Issue newValue = Objects.requireNonNull(value, "asset2");
        return new ImmutableAmmObject(this.asset, newValue, this.account, this.auctionSlot, this.lpTokenBalance, this.tradingFee, this.voteSlots, this.ownerNode, this.index);
    }

    public final ImmutableAmmObject withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutableAmmObject(this.asset, this.asset2, newValue, this.auctionSlot, this.lpTokenBalance, this.tradingFee, this.voteSlots, this.ownerNode, this.index);
    }

    public final ImmutableAmmObject withAuctionSlot(AuctionSlot value) {
        AuctionSlot newValue = Objects.requireNonNull(value, "auctionSlot");
        if (this.auctionSlot == newValue) {
            return this;
        }
        return new ImmutableAmmObject(this.asset, this.asset2, this.account, newValue, this.lpTokenBalance, this.tradingFee, this.voteSlots, this.ownerNode, this.index);
    }

    public final ImmutableAmmObject withAuctionSlot(Optional<? extends AuctionSlot> optional) {
        AuctionSlot value = optional.orElse(null);
        if (this.auctionSlot == value) {
            return this;
        }
        return new ImmutableAmmObject(this.asset, this.asset2, this.account, value, this.lpTokenBalance, this.tradingFee, this.voteSlots, this.ownerNode, this.index);
    }

    public final ImmutableAmmObject withLpTokenBalance(IssuedCurrencyAmount value) {
        if (this.lpTokenBalance == value) {
            return this;
        }
        IssuedCurrencyAmount newValue = Objects.requireNonNull(value, "lpTokenBalance");
        return new ImmutableAmmObject(this.asset, this.asset2, this.account, this.auctionSlot, newValue, this.tradingFee, this.voteSlots, this.ownerNode, this.index);
    }

    public final ImmutableAmmObject withTradingFee(TradingFee value) {
        if (this.tradingFee == value) {
            return this;
        }
        TradingFee newValue = Objects.requireNonNull(value, "tradingFee");
        return new ImmutableAmmObject(this.asset, this.asset2, this.account, this.auctionSlot, this.lpTokenBalance, newValue, this.voteSlots, this.ownerNode, this.index);
    }

    public final ImmutableAmmObject withVoteSlots(VoteEntryWrapper ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableAmmObject(this.asset, this.asset2, this.account, this.auctionSlot, this.lpTokenBalance, this.tradingFee, (ImmutableList<VoteEntryWrapper>)newValue, this.ownerNode, this.index);
    }

    public final ImmutableAmmObject withVoteSlots(Iterable<? extends VoteEntryWrapper> elements) {
        if (this.voteSlots == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableAmmObject(this.asset, this.asset2, this.account, this.auctionSlot, this.lpTokenBalance, this.tradingFee, (ImmutableList<VoteEntryWrapper>)newValue, this.ownerNode, this.index);
    }

    public final ImmutableAmmObject withOwnerNode(String value) {
        String newValue = Objects.requireNonNull(value, "ownerNode");
        if (this.ownerNode.equals(newValue)) {
            return this;
        }
        return new ImmutableAmmObject(this.asset, this.asset2, this.account, this.auctionSlot, this.lpTokenBalance, this.tradingFee, this.voteSlots, newValue, this.index);
    }

    public final ImmutableAmmObject withIndex(Hash256 value) {
        if (this.index == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "index");
        return new ImmutableAmmObject(this.asset, this.asset2, this.account, this.auctionSlot, this.lpTokenBalance, this.tradingFee, this.voteSlots, this.ownerNode, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAmmObject && this.equalTo(0, (ImmutableAmmObject)another);
    }

    private boolean equalTo(int synthetic, ImmutableAmmObject another) {
        return this.ledgerEntryType.equals((Object)another.ledgerEntryType) && this.flags.equals(another.flags) && this.asset.equals(another.asset) && this.asset2.equals(another.asset2) && this.account.equals(another.account) && Objects.equals(this.auctionSlot, another.auctionSlot) && this.lpTokenBalance.equals(another.lpTokenBalance) && this.tradingFee.equals(another.tradingFee) && this.voteSlots.equals(another.voteSlots) && this.ownerNode.equals(another.ownerNode) && this.voteSlotsUnwrapped.equals(another.voteSlotsUnwrapped) && this.index.equals(another.index);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.ledgerEntryType.hashCode();
        h += (h << 5) + this.flags.hashCode();
        h += (h << 5) + this.asset.hashCode();
        h += (h << 5) + this.asset2.hashCode();
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + Objects.hashCode(this.auctionSlot);
        h += (h << 5) + this.lpTokenBalance.hashCode();
        h += (h << 5) + this.tradingFee.hashCode();
        h += (h << 5) + this.voteSlots.hashCode();
        h += (h << 5) + this.ownerNode.hashCode();
        h += (h << 5) + this.voteSlotsUnwrapped.hashCode();
        h += (h << 5) + this.index.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AmmObject").omitNullValues().add("ledgerEntryType", (Object)this.ledgerEntryType).add("flags", (Object)this.flags).add("asset", (Object)this.asset).add("asset2", (Object)this.asset2).add("account", (Object)this.account).add("auctionSlot", (Object)this.auctionSlot).add("lpTokenBalance", (Object)this.lpTokenBalance).add("tradingFee", (Object)this.tradingFee).add("voteSlots", this.voteSlots).add("ownerNode", (Object)this.ownerNode).add("voteSlotsUnwrapped", this.voteSlotsUnwrapped).add("index", (Object)this.index).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAmmObject fromJson(Json json) {
        Builder builder = ImmutableAmmObject.builder();
        if (json.asset != null) {
            builder.asset(json.asset);
        }
        if (json.asset2 != null) {
            builder.asset2(json.asset2);
        }
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.auctionSlot != null) {
            builder.auctionSlot(json.auctionSlot);
        }
        if (json.lpTokenBalance != null) {
            builder.lpTokenBalance(json.lpTokenBalance);
        }
        if (json.tradingFee != null) {
            builder.tradingFee(json.tradingFee);
        }
        if (json.voteSlots != null) {
            builder.addAllVoteSlots(json.voteSlots);
        }
        if (json.ownerNode != null) {
            builder.ownerNode(json.ownerNode);
        }
        if (json.index != null) {
            builder.index(json.index);
        }
        return builder.build();
    }

    public static ImmutableAmmObject copyOf(AmmObject instance) {
        if (instance instanceof ImmutableAmmObject) {
            return (ImmutableAmmObject)instance;
        }
        return ImmutableAmmObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AmmObject", generator="Immutables")
    private final class InitShim {
        private byte ledgerEntryTypeBuildStage = 0;
        private LedgerObject.LedgerEntryType ledgerEntryType;
        private byte flagsBuildStage = 0;
        private Flags flags;
        private byte voteSlotsUnwrappedBuildStage = 0;
        private List<VoteEntry> voteSlotsUnwrapped;

        private InitShim() {
        }

        LedgerObject.LedgerEntryType ledgerEntryType() {
            if (this.ledgerEntryTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ledgerEntryTypeBuildStage == 0) {
                this.ledgerEntryTypeBuildStage = (byte)-1;
                this.ledgerEntryType = Objects.requireNonNull(ImmutableAmmObject.this.ledgerEntryTypeInitialize(), "ledgerEntryType");
                this.ledgerEntryTypeBuildStage = 1;
            }
            return this.ledgerEntryType;
        }

        Flags flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = Objects.requireNonNull(ImmutableAmmObject.this.flagsInitialize(), "flags");
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        List<VoteEntry> voteSlotsUnwrapped() {
            if (this.voteSlotsUnwrappedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.voteSlotsUnwrappedBuildStage == 0) {
                this.voteSlotsUnwrappedBuildStage = (byte)-1;
                this.voteSlotsUnwrapped = Objects.requireNonNull(ImmutableAmmObject.this.voteSlotsUnwrappedInitialize(), "voteSlotsUnwrapped");
                this.voteSlotsUnwrappedBuildStage = 1;
            }
            return this.voteSlotsUnwrapped;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.ledgerEntryTypeBuildStage == -1) {
                attributes.add("ledgerEntryType");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.voteSlotsUnwrappedBuildStage == -1) {
                attributes.add("voteSlotsUnwrapped");
            }
            return "Cannot build AmmObject, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="AmmObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ASSET = 1L;
        private static final long INIT_BIT_ASSET2 = 2L;
        private static final long INIT_BIT_ACCOUNT = 4L;
        private static final long INIT_BIT_LP_TOKEN_BALANCE = 8L;
        private static final long INIT_BIT_TRADING_FEE = 16L;
        private static final long INIT_BIT_OWNER_NODE = 32L;
        private static final long INIT_BIT_INDEX = 64L;
        private long initBits = 127L;
        @Nullable
        private Issue asset;
        @Nullable
        private Issue asset2;
        @Nullable
        private Address account;
        @Nullable
        private AuctionSlot auctionSlot;
        @Nullable
        private IssuedCurrencyAmount lpTokenBalance;
        @Nullable
        private TradingFee tradingFee;
        private ImmutableList.Builder<VoteEntryWrapper> voteSlots = ImmutableList.builder();
        @Nullable
        private String ownerNode;
        @Nullable
        private Hash256 index;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AmmObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.asset(instance.asset());
            this.asset2(instance.asset2());
            this.account(instance.account());
            Optional<AuctionSlot> auctionSlotOptional = instance.auctionSlot();
            if (auctionSlotOptional.isPresent()) {
                this.auctionSlot(auctionSlotOptional);
            }
            this.lpTokenBalance(instance.lpTokenBalance());
            this.tradingFee(instance.tradingFee());
            this.addAllVoteSlots(instance.voteSlots());
            this.ownerNode(instance.ownerNode());
            this.index(instance.index());
            return this;
        }

        @JsonProperty(value="Asset")
        @CanIgnoreReturnValue
        public final Builder asset(Issue asset) {
            this.asset = Objects.requireNonNull(asset, "asset");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Asset2")
        @CanIgnoreReturnValue
        public final Builder asset2(Issue asset2) {
            this.asset2 = Objects.requireNonNull(asset2, "asset2");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="Account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder auctionSlot(AuctionSlot auctionSlot) {
            this.auctionSlot = Objects.requireNonNull(auctionSlot, "auctionSlot");
            return this;
        }

        @JsonProperty(value="AuctionSlot")
        @CanIgnoreReturnValue
        public final Builder auctionSlot(Optional<? extends AuctionSlot> auctionSlot) {
            this.auctionSlot = auctionSlot.orElse(null);
            return this;
        }

        @JsonProperty(value="LPTokenBalance")
        @CanIgnoreReturnValue
        public final Builder lpTokenBalance(IssuedCurrencyAmount lpTokenBalance) {
            this.lpTokenBalance = Objects.requireNonNull(lpTokenBalance, "lpTokenBalance");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="TradingFee")
        @CanIgnoreReturnValue
        public final Builder tradingFee(TradingFee tradingFee) {
            this.tradingFee = Objects.requireNonNull(tradingFee, "tradingFee");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addVoteSlots(VoteEntryWrapper element) {
            this.voteSlots.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addVoteSlots(VoteEntryWrapper ... elements) {
            this.voteSlots.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="VoteSlots")
        @CanIgnoreReturnValue
        public final Builder voteSlots(Iterable<? extends VoteEntryWrapper> elements) {
            this.voteSlots = ImmutableList.builder();
            return this.addAllVoteSlots(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllVoteSlots(Iterable<? extends VoteEntryWrapper> elements) {
            this.voteSlots.addAll(elements);
            return this;
        }

        @JsonProperty(value="OwnerNode")
        @CanIgnoreReturnValue
        public final Builder ownerNode(String ownerNode) {
            this.ownerNode = Objects.requireNonNull(ownerNode, "ownerNode");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="index")
        @CanIgnoreReturnValue
        public final Builder index(Hash256 index) {
            this.index = Objects.requireNonNull(index, "index");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public ImmutableAmmObject build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAmmObject(this.asset, this.asset2, this.account, this.auctionSlot, this.lpTokenBalance, this.tradingFee, this.voteSlots.build(), this.ownerNode, this.index);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("asset");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("asset2");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("account");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("lpTokenBalance");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("tradingFee");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("ownerNode");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("index");
            }
            return "Cannot build AmmObject, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AmmObject", generator="Immutables")
    static final class Json
    implements AmmObject {
        @Nullable
        Issue asset;
        @Nullable
        Issue asset2;
        @Nullable
        Address account;
        @Nullable
        Optional<AuctionSlot> auctionSlot = Optional.empty();
        @Nullable
        IssuedCurrencyAmount lpTokenBalance;
        @Nullable
        TradingFee tradingFee;
        @Nullable
        List<VoteEntryWrapper> voteSlots = ImmutableList.of();
        @Nullable
        String ownerNode;
        @Nullable
        Hash256 index;

        Json() {
        }

        @JsonProperty(value="Asset")
        public void setAsset(Issue asset) {
            this.asset = asset;
        }

        @JsonProperty(value="Asset2")
        public void setAsset2(Issue asset2) {
            this.asset2 = asset2;
        }

        @JsonProperty(value="Account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="AuctionSlot")
        public void setAuctionSlot(Optional<AuctionSlot> auctionSlot) {
            this.auctionSlot = auctionSlot;
        }

        @JsonProperty(value="LPTokenBalance")
        public void setLpTokenBalance(IssuedCurrencyAmount lpTokenBalance) {
            this.lpTokenBalance = lpTokenBalance;
        }

        @JsonProperty(value="TradingFee")
        public void setTradingFee(TradingFee tradingFee) {
            this.tradingFee = tradingFee;
        }

        @JsonProperty(value="VoteSlots")
        public void setVoteSlots(List<VoteEntryWrapper> voteSlots) {
            this.voteSlots = voteSlots;
        }

        @JsonProperty(value="OwnerNode")
        public void setOwnerNode(String ownerNode) {
            this.ownerNode = ownerNode;
        }

        @JsonProperty(value="index")
        public void setIndex(Hash256 index) {
            this.index = index;
        }

        @Override
        @JsonIgnore
        public LedgerObject.LedgerEntryType ledgerEntryType() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public Flags flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Issue asset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Issue asset2() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<AuctionSlot> auctionSlot() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IssuedCurrencyAmount lpTokenBalance() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TradingFee tradingFee() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<VoteEntryWrapper> voteSlots() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String ownerNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public List<VoteEntry> voteSlotsUnwrapped() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 index() {
            throw new UnsupportedOperationException();
        }
    }
}

