/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.annotations.Beta;
import com.google.common.primitives.UnsignedInteger;
import java.util.Optional;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.ledger.ImmutableDidObject;
import org.xrpl.xrpl4j.model.ledger.LedgerObject;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.DidData;
import org.xrpl.xrpl4j.model.transactions.DidDocument;
import org.xrpl.xrpl4j.model.transactions.DidUri;
import org.xrpl.xrpl4j.model.transactions.Hash256;

@JsonSerialize(as=ImmutableDidObject.class)
@JsonDeserialize(as=ImmutableDidObject.class)
@Beta
@Value.Immutable
public interface DidObject
extends LedgerObject {
    public static ImmutableDidObject.Builder builder() {
        return ImmutableDidObject.builder();
    }

    @JsonProperty(value="LedgerEntryType")
    @Value.Derived
    default public LedgerObject.LedgerEntryType ledgerEntryType() {
        return LedgerObject.LedgerEntryType.DID;
    }

    @JsonProperty(value="Flags")
    @Value.Derived
    default public Flags flags() {
        return Flags.UNSET;
    }

    @JsonProperty(value="Account")
    public Address account();

    @JsonProperty(value="DIDDocument")
    public Optional<DidDocument> didDocument();

    @JsonProperty(value="Data")
    public Optional<DidData> data();

    @JsonProperty(value="URI")
    public Optional<DidUri> uri();

    @JsonProperty(value="OwnerNode")
    public String ownerNode();

    @JsonProperty(value="PreviousTxnID")
    public Hash256 previousTransactionId();

    @JsonProperty(value="PreviousTxnLgrSeq")
    public UnsignedInteger previousTransactionLedgerSequence();

    public Hash256 index();
}

