/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.primitives.UnsignedInteger;
import java.util.Optional;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.ledger.ImmutableCheckObject;
import org.xrpl.xrpl4j.model.ledger.LedgerObject;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.CurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.Hash256;

@JsonSerialize(as=ImmutableCheckObject.class)
@JsonDeserialize(as=ImmutableCheckObject.class)
@Value.Immutable
public interface CheckObject
extends LedgerObject {
    public static ImmutableCheckObject.Builder builder() {
        return ImmutableCheckObject.builder();
    }

    @JsonProperty(value="LedgerEntryType")
    @Value.Derived
    default public LedgerObject.LedgerEntryType ledgerEntryType() {
        return LedgerObject.LedgerEntryType.CHECK;
    }

    @JsonProperty(value="Account")
    public Address account();

    @JsonProperty(value="SourceTag")
    public Optional<UnsignedInteger> sourceTag();

    @JsonProperty(value="Destination")
    public Address destination();

    @JsonProperty(value="DestinationTag")
    public Optional<UnsignedInteger> destinationTag();

    @JsonProperty(value="Flags")
    @Value.Derived
    default public Flags flags() {
        return Flags.UNSET;
    }

    @JsonProperty(value="OwnerNode")
    public String ownerNode();

    @JsonProperty(value="PreviousTxnID")
    public Hash256 previousTxnId();

    @JsonProperty(value="PreviousTxnLgrSeq")
    public UnsignedInteger previousTransactionLedgerSequence();

    @JsonProperty(value="SendMax")
    public CurrencyAmount sendMax();

    @JsonProperty(value="Sequence")
    public UnsignedInteger sequence();

    @JsonProperty(value="DestinationNode")
    public Optional<String> destinationNode();

    @JsonProperty(value="Expiration")
    public Optional<UnsignedInteger> expiration();

    @JsonProperty(value="InvoiceID")
    public Optional<Hash256> invoiceId();

    public Hash256 index();
}

