/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.annotations.Beta;
import com.google.common.primitives.UnsignedInteger;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.ledger.AuthAccount;
import org.xrpl.xrpl4j.model.ledger.AuthAccountWrapper;
import org.xrpl.xrpl4j.model.ledger.ImmutableAuctionSlot;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.IssuedCurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.TradingFee;

@JsonSerialize(as=ImmutableAuctionSlot.class)
@JsonDeserialize(as=ImmutableAuctionSlot.class)
@Value.Immutable
@Beta
public interface AuctionSlot {
    public static ImmutableAuctionSlot.Builder builder() {
        return ImmutableAuctionSlot.builder();
    }

    @JsonProperty(value="Account")
    public Address account();

    @JsonProperty(value="AuthAccounts")
    public List<AuthAccountWrapper> authAccounts();

    @JsonIgnore
    @Value.Derived
    default public List<Address> authAccountsAddresses() {
        return this.authAccounts().stream().map(AuthAccountWrapper::authAccount).map(AuthAccount::account).collect(Collectors.toList());
    }

    @JsonProperty(value="DiscountedFee")
    public TradingFee discountedFee();

    @JsonProperty(value="Price")
    public IssuedCurrencyAmount price();

    @JsonProperty(value="Expiration")
    public UnsignedInteger expiration();
}

