/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.annotations.Beta;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.ledger.AuctionSlot;
import org.xrpl.xrpl4j.model.ledger.ImmutableAmmObject;
import org.xrpl.xrpl4j.model.ledger.Issue;
import org.xrpl.xrpl4j.model.ledger.LedgerObject;
import org.xrpl.xrpl4j.model.ledger.VoteEntry;
import org.xrpl.xrpl4j.model.ledger.VoteEntryWrapper;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.IssuedCurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.TradingFee;

@JsonSerialize(as=ImmutableAmmObject.class)
@JsonDeserialize(as=ImmutableAmmObject.class)
@Value.Immutable
@Beta
public interface AmmObject
extends LedgerObject {
    public static ImmutableAmmObject.Builder builder() {
        return ImmutableAmmObject.builder();
    }

    @JsonProperty(value="LedgerEntryType")
    @Value.Derived
    default public LedgerObject.LedgerEntryType ledgerEntryType() {
        return LedgerObject.LedgerEntryType.AMM;
    }

    @JsonProperty(value="Flags")
    @Value.Derived
    default public Flags flags() {
        return Flags.UNSET;
    }

    @JsonProperty(value="Asset")
    public Issue asset();

    @JsonProperty(value="Asset2")
    public Issue asset2();

    @JsonProperty(value="Account")
    public Address account();

    @JsonProperty(value="AuctionSlot")
    public Optional<AuctionSlot> auctionSlot();

    @JsonProperty(value="LPTokenBalance")
    public IssuedCurrencyAmount lpTokenBalance();

    @JsonProperty(value="TradingFee")
    public TradingFee tradingFee();

    @JsonProperty(value="VoteSlots")
    public List<VoteEntryWrapper> voteSlots();

    @JsonProperty(value="OwnerNode")
    public String ownerNode();

    @JsonIgnore
    @Value.Derived
    default public List<VoteEntry> voteSlotsUnwrapped() {
        return this.voteSlots().stream().map(VoteEntryWrapper::voteEntry).collect(Collectors.toList());
    }

    public Hash256 index();
}

