/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.annotations.Beta;
import com.google.common.primitives.UnsignedInteger;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.flags.AccountRootFlags;
import org.xrpl.xrpl4j.model.ledger.ImmutableAccountRootObject;
import org.xrpl.xrpl4j.model.ledger.LedgerObject;
import org.xrpl.xrpl4j.model.ledger.SignerListObject;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

@JsonSerialize(as=ImmutableAccountRootObject.class)
@JsonDeserialize(as=ImmutableAccountRootObject.class)
@Value.Immutable
public interface AccountRootObject
extends LedgerObject {
    public static ImmutableAccountRootObject.Builder builder() {
        return ImmutableAccountRootObject.builder();
    }

    @JsonProperty(value="LedgerEntryType")
    @Value.Derived
    default public LedgerObject.LedgerEntryType ledgerEntryType() {
        return LedgerObject.LedgerEntryType.ACCOUNT_ROOT;
    }

    @JsonProperty(value="Account")
    public Address account();

    @JsonProperty(value="Balance")
    public XrpCurrencyAmount balance();

    @JsonProperty(value="Flags")
    public AccountRootFlags flags();

    @JsonProperty(value="OwnerCount")
    public UnsignedInteger ownerCount();

    @JsonProperty(value="PreviousTxnID")
    public Hash256 previousTransactionId();

    @JsonProperty(value="PreviousTxnLgrSeq")
    public UnsignedInteger previousTransactionLedgerSequence();

    @JsonProperty(value="Sequence")
    public UnsignedInteger sequence();

    @JsonProperty(value="AccountTxnID")
    public Optional<Hash256> accountTransactionId();

    @JsonProperty(value="Domain")
    public Optional<String> domain();

    @JsonProperty(value="EmailHash")
    public Optional<String> emailHash();

    @JsonProperty(value="MessageKey")
    public Optional<String> messageKey();

    @JsonProperty(value="RegularKey")
    public Optional<Address> regularKey();

    @JsonProperty(value="TickSize")
    public Optional<UnsignedInteger> tickSize();

    @JsonProperty(value="TransferRate")
    public Optional<UnsignedInteger> transferRate();

    @JsonProperty(value="signer_lists")
    public List<SignerListObject> signerLists();

    @JsonProperty(value="TicketCount")
    public Optional<UnsignedInteger> ticketCount();

    @JsonProperty(value="BurnedNFTokens")
    public Optional<UnsignedInteger> burnedNfTokens();

    @JsonProperty(value="MintedNFTokens")
    public Optional<UnsignedInteger> mintedNfTokens();

    @JsonProperty(value="NFTokenMinter")
    public Optional<Address> nfTokenMinter();

    @JsonProperty(value="AMMID")
    @Beta
    public Optional<Hash256> ammId();

    public Hash256 index();
}

