/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.jackson.modules;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xrpl.xrpl4j.model.ledger.ImmutableUnknownLedgerObject;
import org.xrpl.xrpl4j.model.ledger.UnknownLedgerObject;

public class UnknownLedgerObjectDeserializer
extends StdDeserializer<UnknownLedgerObject> {
    static Logger logger = LoggerFactory.getLogger(UnknownLedgerObjectDeserializer.class);

    protected UnknownLedgerObjectDeserializer() {
        super(UnknownLedgerObject.class);
    }

    public UnknownLedgerObject deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException, JacksonException {
        JsonNode treeNode = (JsonNode)jsonParser.readValueAsTree();
        ImmutableUnknownLedgerObject ledgerObject = UnknownLedgerObject.builder().properties(treeNode).build();
        logger.warn("Encountered an unknown LedgerObject of type {}. xrpl4j either does not yet support this LedgerObject type, or the version you are using does not support this LedgerObject type.", (Object)ledgerObject.ledgerEntryType());
        return ledgerObject;
    }
}

