/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.jackson.modules;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Map;
import org.xrpl.xrpl4j.model.transactions.metadata.AffectedNode;
import org.xrpl.xrpl4j.model.transactions.metadata.CreatedNode;
import org.xrpl.xrpl4j.model.transactions.metadata.DeletedNode;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaLedgerEntryType;
import org.xrpl.xrpl4j.model.transactions.metadata.MetaLedgerObject;
import org.xrpl.xrpl4j.model.transactions.metadata.ModifiedNode;

public class AffectedNodeDeserializer
extends StdDeserializer<AffectedNode> {
    public AffectedNodeDeserializer() {
        super(AffectedNode.class);
    }

    public AffectedNode deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        ObjectMapper codec = (ObjectMapper)jsonParser.getCodec();
        JsonNode jsonNode = (JsonNode)jsonParser.readValueAsTree();
        Map.Entry nodeFieldAndValue = (Map.Entry)jsonNode.fields().next();
        String affectedNodeType = (String)nodeFieldAndValue.getKey();
        MetaLedgerEntryType ledgerEntryType = MetaLedgerEntryType.of(((JsonNode)nodeFieldAndValue.getValue()).get("LedgerEntryType").asText());
        Class<? extends MetaLedgerObject> ledgerObjectClass = ledgerEntryType.ledgerObjectType();
        switch (affectedNodeType) {
            case "CreatedNode": {
                return (AffectedNode)codec.treeToValue((TreeNode)nodeFieldAndValue.getValue(), codec.getTypeFactory().constructParametricType(CreatedNode.class, new Class[]{ledgerObjectClass}));
            }
            case "ModifiedNode": {
                return (AffectedNode)codec.treeToValue((TreeNode)nodeFieldAndValue.getValue(), codec.getTypeFactory().constructParametricType(ModifiedNode.class, new Class[]{ledgerObjectClass}));
            }
            case "DeletedNode": {
                return (AffectedNode)codec.treeToValue((TreeNode)nodeFieldAndValue.getValue(), codec.getTypeFactory().constructParametricType(DeletedNode.class, new Class[]{ledgerObjectClass}));
            }
        }
        throw JsonMappingException.from((JsonParser)jsonParser, (String)String.format("Unrecognized AffectedNode type %s.", affectedNodeType));
    }
}

