/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.jackson.modules;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import java.io.IOException;
import java.util.Optional;
import org.xrpl.xrpl4j.model.client.accounts.AccountTransactionsTransaction;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.Transaction;

public class AccountTransactionsTransactionDeserializer
extends StdDeserializer<AccountTransactionsTransaction<?>> {
    public AccountTransactionsTransactionDeserializer() {
        super(AccountTransactionsTransaction.class);
    }

    public AccountTransactionsTransaction<?> deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        ObjectMapper objectMapper = (ObjectMapper)jsonParser.getCodec();
        JsonNode node = (JsonNode)objectMapper.readTree(jsonParser);
        Transaction transaction = (Transaction)objectMapper.readValue(node.toString(), Transaction.class);
        long ledgerIndex = node.get("ledger_index").asLong(-1L);
        String hash = node.get("hash").asText();
        Optional<UnsignedLong> closeDate = Optional.ofNullable(node.get("date")).map(JsonNode::asLong).map(UnsignedLong::valueOf);
        return AccountTransactionsTransaction.builder().transaction(transaction).ledgerIndex(LedgerIndex.of(UnsignedInteger.valueOf((long)ledgerIndex))).hash(Hash256.of(hash)).closeDate(closeDate).build();
    }
}

