/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.immutables;

public class FluentCompareTo<T extends Comparable<? super T>> {
    private final T value;

    private FluentCompareTo(T value) {
        this.value = value;
    }

    public static <T extends Comparable<? super T>> FluentCompareTo<T> is(T value) {
        return new FluentCompareTo<T>(value);
    }

    public static <T extends Comparable<? super T>> FluentCompareTo<T> isNot(T value) {
        return new FluentCompareTo<T>(value);
    }

    public boolean equalTo(T other) {
        return this.value.equals(other);
    }

    public boolean notEqualTo(T other) {
        return !this.equalTo(other);
    }

    public boolean lessThan(T other) {
        return this.value.compareTo(other) < 0;
    }

    public boolean notLessThan(T other) {
        return !this.lessThan(other);
    }

    public boolean lessThanOrEqualTo(T other) {
        return this.value.compareTo(other) <= 0;
    }

    public boolean notLessThanOrEqualTo(T other) {
        return !this.lessThanOrEqualTo(other);
    }

    public boolean greaterThan(T other) {
        return this.value.compareTo(other) > 0;
    }

    public boolean notGreaterThan(T other) {
        return !this.greaterThan(other);
    }

    public boolean greaterThanEqualTo(T other) {
        return this.value.compareTo(other) >= 0;
    }

    public boolean notGreaterThanEqualTo(T other) {
        return !this.greaterThanEqualTo(other);
    }

    public boolean between(T startInclusive, T endExclusive) {
        return this.greaterThanEqualTo(startInclusive) && this.lessThan(endExclusive);
    }

    public boolean notBetween(T startInclusive, T endExclusive) {
        return !this.between(startInclusive, endExclusive);
    }

    public boolean betweenExclusive(T startExclusive, T endExclusive) {
        return this.greaterThan(startExclusive) && this.lessThan(endExclusive);
    }

    public boolean notBetweenExclusive(T startExclusive, T endExclusive) {
        return !this.betweenExclusive(startExclusive, endExclusive);
    }

    public T getValue() {
        return this.value;
    }
}

