/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.flags;

import org.xrpl.xrpl4j.model.flags.TransactionFlags;

public class PaymentFlags
extends TransactionFlags {
    public static final PaymentFlags UNSET = new PaymentFlags(0L);
    protected static final PaymentFlags NO_DIRECT_RIPPLE = new PaymentFlags(65536L);
    protected static final PaymentFlags PARTIAL_PAYMENT = new PaymentFlags(131072L);
    protected static final PaymentFlags LIMIT_QUALITY = new PaymentFlags(262144L);

    private PaymentFlags(long value) {
        super(value);
    }

    private PaymentFlags() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PaymentFlags of(long value) {
        return new PaymentFlags(value);
    }

    private static PaymentFlags of(boolean tfFullyCanonicalSig, boolean tfNoDirectRipple, boolean tfPartialPayment, boolean tfLimitQuality) {
        return new PaymentFlags(PaymentFlags.of(tfFullyCanonicalSig ? TransactionFlags.FULLY_CANONICAL_SIG : UNSET, tfNoDirectRipple ? NO_DIRECT_RIPPLE : UNSET, tfPartialPayment ? PARTIAL_PAYMENT : UNSET, tfLimitQuality ? LIMIT_QUALITY : UNSET).getValue());
    }

    public static PaymentFlags empty() {
        return new PaymentFlags();
    }

    public boolean tfNoDirectRipple() {
        return this.isSet(NO_DIRECT_RIPPLE);
    }

    public boolean tfPartialPayment() {
        return this.isSet(PARTIAL_PAYMENT);
    }

    public boolean tfLimitQuality() {
        return this.isSet(LIMIT_QUALITY);
    }

    public static class Builder {
        private boolean tfNoDirectRipple = false;
        private boolean tfPartialPayment = false;
        private boolean tfLimitQuality = false;

        public Builder tfNoDirectRipple(boolean tfNoDirectRipple) {
            this.tfNoDirectRipple = tfNoDirectRipple;
            return this;
        }

        public Builder tfPartialPayment(boolean tfPartialPayment) {
            this.tfPartialPayment = tfPartialPayment;
            return this;
        }

        public Builder tfLimitQuality(boolean tfLimitQuality) {
            this.tfLimitQuality = tfLimitQuality;
            return this;
        }

        public PaymentFlags build() {
            return PaymentFlags.of(true, this.tfNoDirectRipple, this.tfPartialPayment, this.tfLimitQuality);
        }
    }
}

