/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.flags;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public class Flags {
    public static final Flags UNSET = new Flags(0L);
    private final Optional<Long> value;

    Flags(long value) {
        this.value = Optional.of(value);
    }

    Flags() {
        this.value = Optional.empty();
    }

    public static Flags of(long value) {
        return new Flags(value);
    }

    public static Flags of(Flags flag, Flags ... others) {
        return flag.bitwiseOr(Arrays.stream(others).reduce(Flags::bitwiseOr).orElse(UNSET));
    }

    public long getValue() {
        return this.value.orElse(0L);
    }

    public boolean isEmpty() {
        return !this.value.isPresent();
    }

    Flags bitwiseOr(Flags other) {
        return Flags.of(this.getValue() | other.getValue());
    }

    Flags bitwiseAnd(Flags other) {
        return Flags.of(this.getValue() & other.getValue());
    }

    public boolean isSet(Flags flag) {
        return !flag.equals(UNSET) && this.bitwiseAnd(flag).equals(flag);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        Flags flags = (Flags)obj;
        return this.getValue() == flags.getValue();
    }

    public int hashCode() {
        return Objects.hash(this.getValue());
    }

    public String toString() {
        return String.valueOf(this.value.orElse(0L));
    }
}

