/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.flags;

import com.google.common.base.Preconditions;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.flags.TransactionFlags;

public class AccountSetTransactionFlags
extends TransactionFlags {
    protected static final AccountSetTransactionFlags UNSET = new AccountSetTransactionFlags(0L);
    protected static final AccountSetTransactionFlags REQUIRE_DEST_TAG = new AccountSetTransactionFlags(65536L);
    protected static final AccountSetTransactionFlags OPTIONAL_DEST_TAG = new AccountSetTransactionFlags(131072L);
    protected static final AccountSetTransactionFlags REQUIRE_AUTH = new AccountSetTransactionFlags(262144L);
    protected static final AccountSetTransactionFlags OPTIONAL_AUTH = new AccountSetTransactionFlags(524288L);
    protected static final AccountSetTransactionFlags DISALLOW_XRP = new AccountSetTransactionFlags(0x100000L);
    protected static final AccountSetTransactionFlags ALLOW_XRP = new AccountSetTransactionFlags(0x200000L);

    private AccountSetTransactionFlags(long value) {
        super(value);
    }

    private AccountSetTransactionFlags() {
    }

    private static AccountSetTransactionFlags of(boolean tfFullyCanonicalSig, boolean tfRequireDestTag, boolean tfOptionalDestTag, boolean tfRequireAuth, boolean tfOptionalAuth, boolean tfDisallowXrp, boolean tfAllowXrp) {
        Preconditions.checkArgument((!tfRequireDestTag || !tfOptionalDestTag ? 1 : 0) != 0, (Object)"tfRequireDestTag and tfOptionalDestTag cannot both be set to true.");
        Preconditions.checkArgument((!tfRequireAuth || !tfOptionalAuth ? 1 : 0) != 0, (Object)"tfRequireAuth and tfOptionalAuth cannot both be set to true.");
        Preconditions.checkArgument((!tfDisallowXrp || !tfAllowXrp ? 1 : 0) != 0, (Object)"tfDisallowXrp and tfAllowXrp cannot both be set to true.");
        return new AccountSetTransactionFlags(Flags.of(tfFullyCanonicalSig ? TransactionFlags.FULLY_CANONICAL_SIG : UNSET, tfRequireDestTag ? REQUIRE_DEST_TAG : UNSET, tfOptionalDestTag ? OPTIONAL_DEST_TAG : UNSET, tfRequireAuth ? REQUIRE_AUTH : UNSET, tfOptionalAuth ? OPTIONAL_AUTH : UNSET, tfDisallowXrp ? DISALLOW_XRP : UNSET, tfAllowXrp ? ALLOW_XRP : UNSET).getValue());
    }

    public static AccountSetTransactionFlags of(long value) {
        AccountSetTransactionFlags flags = new AccountSetTransactionFlags(value);
        Preconditions.checkArgument((!flags.tfRequireDestTag() || !flags.tfOptionalDestTag() ? 1 : 0) != 0, (Object)"tfRequireDestTag and tfOptionalDestTag cannot both be set to true.");
        Preconditions.checkArgument((!flags.tfRequireAuth() || !flags.tfOptionalAuth() ? 1 : 0) != 0, (Object)"tfRequireAuth and tfOptionalAuth cannot both be set to true.");
        Preconditions.checkArgument((!flags.tfDisallowXrp() || !flags.tfAllowXrp() ? 1 : 0) != 0, (Object)"tfDisallowXrp and tfAllowXrp cannot both be set to true.");
        return flags;
    }

    public static AccountSetTransactionFlags empty() {
        return new AccountSetTransactionFlags();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean tfFullyCanonicalSig() {
        return this.isSet(TransactionFlags.FULLY_CANONICAL_SIG);
    }

    public boolean tfRequireDestTag() {
        return this.isSet(REQUIRE_DEST_TAG);
    }

    public boolean tfOptionalDestTag() {
        return this.isSet(OPTIONAL_DEST_TAG);
    }

    public boolean tfRequireAuth() {
        return this.isSet(REQUIRE_AUTH);
    }

    public boolean tfOptionalAuth() {
        return this.isSet(OPTIONAL_AUTH);
    }

    public boolean tfDisallowXrp() {
        return this.isSet(DISALLOW_XRP);
    }

    public boolean tfAllowXrp() {
        return this.isSet(ALLOW_XRP);
    }

    public static class Builder {
        private boolean tfRequireDestTag = false;
        private boolean tfOptionalDestTag = false;
        private boolean tfRequireAuth = false;
        private boolean tfOptionalAuth = false;
        private boolean tfDisallowXrp = false;
        private boolean tfAllowXrp = false;

        public Builder tfRequireDestTag() {
            this.tfRequireDestTag = true;
            return this;
        }

        public Builder tfOptionalDestTag() {
            this.tfOptionalDestTag = true;
            return this;
        }

        public Builder tfRequireAuth() {
            this.tfRequireAuth = true;
            return this;
        }

        public Builder tfOptionalAuth() {
            this.tfOptionalAuth = true;
            return this;
        }

        public Builder tfDisallowXrp() {
            this.tfDisallowXrp = true;
            return this;
        }

        public Builder tfAllowXrp() {
            this.tfAllowXrp = true;
            return this;
        }

        public AccountSetTransactionFlags build() {
            return AccountSetTransactionFlags.of(true, this.tfRequireDestTag, this.tfOptionalDestTag, this.tfRequireAuth, this.tfOptionalAuth, this.tfDisallowXrp, this.tfAllowXrp);
        }
    }
}

