/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.transactions;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.UnsignedLong;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.XrplResult;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.client.transactions.TransactionResult;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.Transaction;
import org.xrpl.xrpl4j.model.transactions.TransactionMetadata;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TransactionResult", generator="Immutables")
@Immutable
public final class ImmutableTransactionResult<TxnType extends Transaction>
implements TransactionResult<TxnType> {
    @Nullable
    private final String status;
    private final TxnType transaction;
    @Nullable
    private final LedgerIndex ledgerIndex;
    private final Hash256 hash;
    private final boolean validated;
    @Nullable
    private final TransactionMetadata metadata;
    @Nullable
    private final UnsignedLong closeDate;

    private ImmutableTransactionResult(Builder<TxnType> builder) {
        this.status = ((Builder)builder).status;
        this.transaction = ((Builder)builder).transaction;
        this.ledgerIndex = ((Builder)builder).ledgerIndex;
        this.hash = ((Builder)builder).hash;
        this.metadata = ((Builder)builder).metadata;
        this.closeDate = ((Builder)builder).closeDate;
        this.validated = ((Builder)builder).validatedIsSet() ? ((Builder)builder).validated : TransactionResult.super.validated();
    }

    private ImmutableTransactionResult(@Nullable String status, TxnType transaction, @Nullable LedgerIndex ledgerIndex, Hash256 hash, boolean validated, @Nullable TransactionMetadata metadata, @Nullable UnsignedLong closeDate) {
        this.status = status;
        this.transaction = transaction;
        this.ledgerIndex = ledgerIndex;
        this.hash = hash;
        this.validated = validated;
        this.metadata = metadata;
        this.closeDate = closeDate;
    }

    @Override
    @JsonProperty(value="status")
    public Optional<String> status() {
        return Optional.ofNullable(this.status);
    }

    @Override
    @JsonProperty(value="transaction")
    @JsonUnwrapped
    public TxnType transaction() {
        return this.transaction;
    }

    @Override
    @JsonProperty(value="ledger_index")
    public Optional<LedgerIndex> ledgerIndex() {
        return Optional.ofNullable(this.ledgerIndex);
    }

    @Override
    @JsonProperty(value="hash")
    public Hash256 hash() {
        return this.hash;
    }

    @Override
    @JsonProperty(value="validated")
    public boolean validated() {
        return this.validated;
    }

    @Override
    @JsonProperty(value="meta")
    @JsonAlias(value={"metaData"})
    public Optional<TransactionMetadata> metadata() {
        return Optional.ofNullable(this.metadata);
    }

    @Override
    @JsonProperty(value="date")
    public Optional<UnsignedLong> closeDate() {
        return Optional.ofNullable(this.closeDate);
    }

    public final ImmutableTransactionResult<TxnType> withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (Objects.equals(this.status, newValue)) {
            return this;
        }
        return new ImmutableTransactionResult<TxnType>(newValue, this.transaction, this.ledgerIndex, this.hash, this.validated, this.metadata, this.closeDate);
    }

    public final ImmutableTransactionResult<TxnType> withStatus(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.status, value)) {
            return this;
        }
        return new ImmutableTransactionResult<TxnType>(value, this.transaction, this.ledgerIndex, this.hash, this.validated, this.metadata, this.closeDate);
    }

    public final ImmutableTransactionResult<TxnType> withTransaction(TxnType value) {
        if (this.transaction == value) {
            return this;
        }
        Transaction newValue = (Transaction)Objects.requireNonNull(value, "transaction");
        return new ImmutableTransactionResult<Transaction>(this.status, newValue, this.ledgerIndex, this.hash, this.validated, this.metadata, this.closeDate);
    }

    public final ImmutableTransactionResult<TxnType> withLedgerIndex(LedgerIndex value) {
        LedgerIndex newValue = Objects.requireNonNull(value, "ledgerIndex");
        if (this.ledgerIndex == newValue) {
            return this;
        }
        return new ImmutableTransactionResult<TxnType>(this.status, this.transaction, newValue, this.hash, this.validated, this.metadata, this.closeDate);
    }

    public final ImmutableTransactionResult<TxnType> withLedgerIndex(Optional<? extends LedgerIndex> optional) {
        LedgerIndex value = optional.orElse(null);
        if (this.ledgerIndex == value) {
            return this;
        }
        return new ImmutableTransactionResult<TxnType>(this.status, this.transaction, value, this.hash, this.validated, this.metadata, this.closeDate);
    }

    public final ImmutableTransactionResult<TxnType> withHash(Hash256 value) {
        if (this.hash == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "hash");
        return new ImmutableTransactionResult<TxnType>(this.status, this.transaction, this.ledgerIndex, newValue, this.validated, this.metadata, this.closeDate);
    }

    public final ImmutableTransactionResult<TxnType> withValidated(boolean value) {
        if (this.validated == value) {
            return this;
        }
        return new ImmutableTransactionResult<TxnType>(this.status, this.transaction, this.ledgerIndex, this.hash, value, this.metadata, this.closeDate);
    }

    public final ImmutableTransactionResult<TxnType> withMetadata(TransactionMetadata value) {
        TransactionMetadata newValue = Objects.requireNonNull(value, "metadata");
        if (this.metadata == newValue) {
            return this;
        }
        return new ImmutableTransactionResult<TxnType>(this.status, this.transaction, this.ledgerIndex, this.hash, this.validated, newValue, this.closeDate);
    }

    public final ImmutableTransactionResult<TxnType> withMetadata(Optional<? extends TransactionMetadata> optional) {
        TransactionMetadata value = optional.orElse(null);
        if (this.metadata == value) {
            return this;
        }
        return new ImmutableTransactionResult<TxnType>(this.status, this.transaction, this.ledgerIndex, this.hash, this.validated, value, this.closeDate);
    }

    public final ImmutableTransactionResult<TxnType> withCloseDate(UnsignedLong value) {
        UnsignedLong newValue = Objects.requireNonNull(value, "closeDate");
        if (Objects.equals(this.closeDate, newValue)) {
            return this;
        }
        return new ImmutableTransactionResult<TxnType>(this.status, this.transaction, this.ledgerIndex, this.hash, this.validated, this.metadata, newValue);
    }

    public final ImmutableTransactionResult<TxnType> withCloseDate(Optional<? extends UnsignedLong> optional) {
        UnsignedLong value = optional.orElse(null);
        if (Objects.equals(this.closeDate, value)) {
            return this;
        }
        return new ImmutableTransactionResult<TxnType>(this.status, this.transaction, this.ledgerIndex, this.hash, this.validated, this.metadata, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTransactionResult && this.equalTo(0, (ImmutableTransactionResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableTransactionResult<?> another) {
        return Objects.equals(this.status, another.status) && this.transaction.equals(another.transaction) && Objects.equals(this.ledgerIndex, another.ledgerIndex) && this.hash.equals(another.hash) && this.validated == another.validated && Objects.equals(this.metadata, another.metadata) && Objects.equals(this.closeDate, another.closeDate);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + this.transaction.hashCode();
        h += (h << 5) + Objects.hashCode(this.ledgerIndex);
        h += (h << 5) + this.hash.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.validated);
        h += (h << 5) + Objects.hashCode(this.metadata);
        h += (h << 5) + Objects.hashCode(this.closeDate);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TransactionResult").omitNullValues().add("status", (Object)this.status).add("transaction", this.transaction).add("ledgerIndex", (Object)this.ledgerIndex).add("hash", (Object)this.hash).add("validated", this.validated).add("metadata", (Object)this.metadata).add("closeDate", (Object)this.closeDate).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static <TxnType extends Transaction> ImmutableTransactionResult<TxnType> fromJson(Json<TxnType> json) {
        Builder builder = ImmutableTransactionResult.builder();
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.transaction != null) {
            builder.transaction(json.transaction);
        }
        if (json.ledgerIndex != null) {
            builder.ledgerIndex(json.ledgerIndex);
        }
        if (json.hash != null) {
            builder.hash(json.hash);
        }
        if (json.validatedIsSet) {
            builder.validated(json.validated);
        }
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        if (json.closeDate != null) {
            builder.closeDate(json.closeDate);
        }
        return builder.build();
    }

    public static <TxnType extends Transaction> ImmutableTransactionResult<TxnType> copyOf(TransactionResult<TxnType> instance) {
        if (instance instanceof ImmutableTransactionResult) {
            return (ImmutableTransactionResult)instance;
        }
        return ImmutableTransactionResult.builder().from(instance).build();
    }

    public static <TxnType extends Transaction> Builder<TxnType> builder() {
        return new Builder();
    }

    @Generated(from="TransactionResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<TxnType extends Transaction> {
        private static final long INIT_BIT_TRANSACTION = 1L;
        private static final long INIT_BIT_HASH = 2L;
        private static final long OPT_BIT_VALIDATED = 1L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private String status;
        @Nullable
        private TxnType transaction;
        @Nullable
        private LedgerIndex ledgerIndex;
        @Nullable
        private Hash256 hash;
        private boolean validated;
        @Nullable
        private TransactionMetadata metadata;
        @Nullable
        private UnsignedLong closeDate;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<TxnType> from(TransactionResult<TxnType> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<TxnType> from(XrplResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            XrplResult instance;
            long bits = 0L;
            if (object instanceof TransactionResult) {
                Optional<TransactionMetadata> metadataOptional;
                instance = (TransactionResult)object;
                Optional<UnsignedLong> closeDateOptional = instance.closeDate();
                if (closeDateOptional.isPresent()) {
                    this.closeDate(closeDateOptional);
                }
                if ((metadataOptional = instance.metadata()).isPresent()) {
                    this.metadata(metadataOptional);
                }
                this.validated(instance.validated());
                Optional<LedgerIndex> ledgerIndexOptional = instance.ledgerIndex();
                if (ledgerIndexOptional.isPresent()) {
                    this.ledgerIndex(ledgerIndexOptional);
                }
                this.transaction(instance.transaction());
                this.hash(instance.hash());
                if ((bits & 1L) == 0L) {
                    Optional<String> statusOptional = instance.status();
                    if (statusOptional.isPresent()) {
                        this.status(statusOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof XrplResult) {
                instance = (XrplResult)object;
                if ((bits & 1L) == 0L) {
                    Optional<String> statusOptional = instance.status();
                    if (statusOptional.isPresent()) {
                        this.status(statusOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder<TxnType> status(String status) {
            this.status = Objects.requireNonNull(status, "status");
            return this;
        }

        @JsonProperty(value="status")
        @CanIgnoreReturnValue
        public final Builder<TxnType> status(Optional<String> status) {
            this.status = status.orElse(null);
            return this;
        }

        @JsonProperty(value="transaction")
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder<TxnType> transaction(TxnType transaction) {
            this.transaction = (Transaction)Objects.requireNonNull(transaction, "transaction");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<TxnType> ledgerIndex(LedgerIndex ledgerIndex) {
            this.ledgerIndex = Objects.requireNonNull(ledgerIndex, "ledgerIndex");
            return this;
        }

        @JsonProperty(value="ledger_index")
        @CanIgnoreReturnValue
        public final Builder<TxnType> ledgerIndex(Optional<? extends LedgerIndex> ledgerIndex) {
            this.ledgerIndex = ledgerIndex.orElse(null);
            return this;
        }

        @JsonProperty(value="hash")
        @CanIgnoreReturnValue
        public final Builder<TxnType> hash(Hash256 hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="validated")
        @CanIgnoreReturnValue
        public final Builder<TxnType> validated(boolean validated) {
            this.validated = validated;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<TxnType> metadata(TransactionMetadata metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata");
            return this;
        }

        @JsonProperty(value="meta")
        @JsonAlias(value={"metaData"})
        @CanIgnoreReturnValue
        public final Builder<TxnType> metadata(Optional<? extends TransactionMetadata> metadata) {
            this.metadata = metadata.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<TxnType> closeDate(UnsignedLong closeDate) {
            this.closeDate = Objects.requireNonNull(closeDate, "closeDate");
            return this;
        }

        @JsonProperty(value="date")
        @CanIgnoreReturnValue
        public final Builder<TxnType> closeDate(Optional<? extends UnsignedLong> closeDate) {
            this.closeDate = closeDate.orElse(null);
            return this;
        }

        public ImmutableTransactionResult<TxnType> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTransactionResult(this);
        }

        private boolean validatedIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("transaction");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build TransactionResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TransactionResult", generator="Immutables")
    static final class Json<TxnType extends Transaction>
    implements TransactionResult<TxnType> {
        @Nullable
        Optional<String> status = Optional.empty();
        @Nullable
        TxnType transaction;
        @Nullable
        Optional<LedgerIndex> ledgerIndex = Optional.empty();
        @Nullable
        Hash256 hash;
        boolean validated;
        boolean validatedIsSet;
        @Nullable
        Optional<TransactionMetadata> metadata = Optional.empty();
        @Nullable
        Optional<UnsignedLong> closeDate = Optional.empty();

        Json() {
        }

        @JsonProperty(value="status")
        public void setStatus(Optional<String> status) {
            this.status = status;
        }

        @JsonProperty(value="transaction")
        @JsonUnwrapped
        public void setTransaction(TxnType transaction) {
            this.transaction = transaction;
        }

        @JsonProperty(value="ledger_index")
        public void setLedgerIndex(Optional<LedgerIndex> ledgerIndex) {
            this.ledgerIndex = ledgerIndex;
        }

        @JsonProperty(value="hash")
        public void setHash(Hash256 hash) {
            this.hash = hash;
        }

        @JsonProperty(value="validated")
        public void setValidated(boolean validated) {
            this.validated = validated;
            this.validatedIsSet = true;
        }

        @JsonProperty(value="meta")
        @JsonAlias(value={"metaData"})
        public void setMetadata(Optional<TransactionMetadata> metadata) {
            this.metadata = metadata;
        }

        @JsonProperty(value="date")
        public void setCloseDate(Optional<UnsignedLong> closeDate) {
            this.closeDate = closeDate;
        }

        @Override
        public Optional<String> status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TxnType transaction() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerIndex> ledgerIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 hash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean validated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<TransactionMetadata> metadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedLong> closeDate() {
            throw new UnsupportedOperationException();
        }
    }
}

