/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.transactions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.XrplResult;
import org.xrpl.xrpl4j.model.client.transactions.SubmitMultiSignedResult;
import org.xrpl.xrpl4j.model.client.transactions.TransactionResult;
import org.xrpl.xrpl4j.model.transactions.Transaction;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SubmitMultiSignedResult", generator="Immutables")
@Immutable
public final class ImmutableSubmitMultiSignedResult<TxnType extends Transaction>
implements SubmitMultiSignedResult<TxnType> {
    @Nullable
    private final String status;
    private final String engineResult;
    private final Integer engineResultCode;
    private final String engineResultMessage;
    private final String transactionBlob;
    private final TransactionResult<TxnType> transaction;

    private ImmutableSubmitMultiSignedResult(@Nullable String status, String engineResult, Integer engineResultCode, String engineResultMessage, String transactionBlob, TransactionResult<TxnType> transaction) {
        this.status = status;
        this.engineResult = engineResult;
        this.engineResultCode = engineResultCode;
        this.engineResultMessage = engineResultMessage;
        this.transactionBlob = transactionBlob;
        this.transaction = transaction;
    }

    @Override
    @JsonProperty(value="status")
    public Optional<String> status() {
        return Optional.ofNullable(this.status);
    }

    @Override
    @JsonProperty(value="engine_result")
    public String engineResult() {
        return this.engineResult;
    }

    @Override
    @JsonProperty(value="engine_result_code")
    public Integer engineResultCode() {
        return this.engineResultCode;
    }

    @Override
    @JsonProperty(value="engine_result_message")
    public String engineResultMessage() {
        return this.engineResultMessage;
    }

    @Override
    @JsonProperty(value="tx_blob")
    public String transactionBlob() {
        return this.transactionBlob;
    }

    @Override
    @JsonProperty(value="tx_json")
    public TransactionResult<TxnType> transaction() {
        return this.transaction;
    }

    public final ImmutableSubmitMultiSignedResult<TxnType> withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (Objects.equals(this.status, newValue)) {
            return this;
        }
        return new ImmutableSubmitMultiSignedResult<TxnType>(newValue, this.engineResult, this.engineResultCode, this.engineResultMessage, this.transactionBlob, this.transaction);
    }

    public final ImmutableSubmitMultiSignedResult<TxnType> withStatus(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.status, value)) {
            return this;
        }
        return new ImmutableSubmitMultiSignedResult<TxnType>(value, this.engineResult, this.engineResultCode, this.engineResultMessage, this.transactionBlob, this.transaction);
    }

    public final ImmutableSubmitMultiSignedResult<TxnType> withEngineResult(String value) {
        String newValue = Objects.requireNonNull(value, "engineResult");
        if (this.engineResult.equals(newValue)) {
            return this;
        }
        return new ImmutableSubmitMultiSignedResult<TxnType>(this.status, newValue, this.engineResultCode, this.engineResultMessage, this.transactionBlob, this.transaction);
    }

    public final ImmutableSubmitMultiSignedResult<TxnType> withEngineResultCode(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "engineResultCode");
        if (this.engineResultCode.equals(newValue)) {
            return this;
        }
        return new ImmutableSubmitMultiSignedResult<TxnType>(this.status, this.engineResult, newValue, this.engineResultMessage, this.transactionBlob, this.transaction);
    }

    public final ImmutableSubmitMultiSignedResult<TxnType> withEngineResultMessage(String value) {
        String newValue = Objects.requireNonNull(value, "engineResultMessage");
        if (this.engineResultMessage.equals(newValue)) {
            return this;
        }
        return new ImmutableSubmitMultiSignedResult<TxnType>(this.status, this.engineResult, this.engineResultCode, newValue, this.transactionBlob, this.transaction);
    }

    public final ImmutableSubmitMultiSignedResult<TxnType> withTransactionBlob(String value) {
        String newValue = Objects.requireNonNull(value, "transactionBlob");
        if (this.transactionBlob.equals(newValue)) {
            return this;
        }
        return new ImmutableSubmitMultiSignedResult<TxnType>(this.status, this.engineResult, this.engineResultCode, this.engineResultMessage, newValue, this.transaction);
    }

    public final ImmutableSubmitMultiSignedResult<TxnType> withTransaction(TransactionResult<TxnType> value) {
        if (this.transaction == value) {
            return this;
        }
        TransactionResult<TxnType> newValue = Objects.requireNonNull(value, "transaction");
        return new ImmutableSubmitMultiSignedResult<TxnType>(this.status, this.engineResult, this.engineResultCode, this.engineResultMessage, this.transactionBlob, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSubmitMultiSignedResult && this.equalTo(0, (ImmutableSubmitMultiSignedResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableSubmitMultiSignedResult<?> another) {
        return Objects.equals(this.status, another.status) && this.engineResult.equals(another.engineResult) && this.engineResultCode.equals(another.engineResultCode) && this.engineResultMessage.equals(another.engineResultMessage) && this.transactionBlob.equals(another.transactionBlob) && this.transaction.equals(another.transaction);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + this.engineResult.hashCode();
        h += (h << 5) + this.engineResultCode.hashCode();
        h += (h << 5) + this.engineResultMessage.hashCode();
        h += (h << 5) + this.transactionBlob.hashCode();
        h += (h << 5) + this.transaction.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SubmitMultiSignedResult").omitNullValues().add("status", (Object)this.status).add("engineResult", (Object)this.engineResult).add("engineResultCode", (Object)this.engineResultCode).add("engineResultMessage", (Object)this.engineResultMessage).add("transactionBlob", (Object)this.transactionBlob).add("transaction", this.transaction).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static <TxnType extends Transaction> ImmutableSubmitMultiSignedResult<TxnType> fromJson(Json<TxnType> json) {
        Builder builder = ImmutableSubmitMultiSignedResult.builder();
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.engineResult != null) {
            builder.engineResult(json.engineResult);
        }
        if (json.engineResultCode != null) {
            builder.engineResultCode(json.engineResultCode);
        }
        if (json.engineResultMessage != null) {
            builder.engineResultMessage(json.engineResultMessage);
        }
        if (json.transactionBlob != null) {
            builder.transactionBlob(json.transactionBlob);
        }
        if (json.transaction != null) {
            builder.transaction(json.transaction);
        }
        return builder.build();
    }

    public static <TxnType extends Transaction> ImmutableSubmitMultiSignedResult<TxnType> copyOf(SubmitMultiSignedResult<TxnType> instance) {
        if (instance instanceof ImmutableSubmitMultiSignedResult) {
            return (ImmutableSubmitMultiSignedResult)instance;
        }
        return ImmutableSubmitMultiSignedResult.builder().from(instance).build();
    }

    public static <TxnType extends Transaction> Builder<TxnType> builder() {
        return new Builder();
    }

    @Generated(from="SubmitMultiSignedResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<TxnType extends Transaction> {
        private static final long INIT_BIT_ENGINE_RESULT = 1L;
        private static final long INIT_BIT_ENGINE_RESULT_CODE = 2L;
        private static final long INIT_BIT_ENGINE_RESULT_MESSAGE = 4L;
        private static final long INIT_BIT_TRANSACTION_BLOB = 8L;
        private static final long INIT_BIT_TRANSACTION = 16L;
        private long initBits = 31L;
        @Nullable
        private String status;
        @Nullable
        private String engineResult;
        @Nullable
        private Integer engineResultCode;
        @Nullable
        private String engineResultMessage;
        @Nullable
        private String transactionBlob;
        @Nullable
        private TransactionResult<TxnType> transaction;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<TxnType> from(SubmitMultiSignedResult<TxnType> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<TxnType> from(XrplResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional<String> statusOptional;
            XrplResult instance;
            long bits = 0L;
            if (object instanceof SubmitMultiSignedResult) {
                instance = (SubmitMultiSignedResult)object;
                this.engineResultMessage(instance.engineResultMessage());
                this.transactionBlob(instance.transactionBlob());
                this.engineResult(instance.engineResult());
                this.engineResultCode(instance.engineResultCode());
                this.transaction(instance.transaction());
                if ((bits & 1L) == 0L) {
                    statusOptional = instance.status();
                    if (statusOptional.isPresent()) {
                        this.status(statusOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof XrplResult) {
                instance = (XrplResult)object;
                if ((bits & 1L) == 0L) {
                    statusOptional = instance.status();
                    if (statusOptional.isPresent()) {
                        this.status(statusOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder<TxnType> status(String status) {
            this.status = Objects.requireNonNull(status, "status");
            return this;
        }

        @JsonProperty(value="status")
        @CanIgnoreReturnValue
        public final Builder<TxnType> status(Optional<String> status) {
            this.status = status.orElse(null);
            return this;
        }

        @JsonProperty(value="engine_result")
        @CanIgnoreReturnValue
        public final Builder<TxnType> engineResult(String engineResult) {
            this.engineResult = Objects.requireNonNull(engineResult, "engineResult");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="engine_result_code")
        @CanIgnoreReturnValue
        public final Builder<TxnType> engineResultCode(Integer engineResultCode) {
            this.engineResultCode = Objects.requireNonNull(engineResultCode, "engineResultCode");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="engine_result_message")
        @CanIgnoreReturnValue
        public final Builder<TxnType> engineResultMessage(String engineResultMessage) {
            this.engineResultMessage = Objects.requireNonNull(engineResultMessage, "engineResultMessage");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="tx_blob")
        @CanIgnoreReturnValue
        public final Builder<TxnType> transactionBlob(String transactionBlob) {
            this.transactionBlob = Objects.requireNonNull(transactionBlob, "transactionBlob");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="tx_json")
        @CanIgnoreReturnValue
        public final Builder<TxnType> transaction(TransactionResult<TxnType> transaction) {
            this.transaction = Objects.requireNonNull(transaction, "transaction");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableSubmitMultiSignedResult<TxnType> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSubmitMultiSignedResult(this.status, this.engineResult, this.engineResultCode, this.engineResultMessage, this.transactionBlob, this.transaction);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("engineResult");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("engineResultCode");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("engineResultMessage");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("transactionBlob");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("transaction");
            }
            return "Cannot build SubmitMultiSignedResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SubmitMultiSignedResult", generator="Immutables")
    static final class Json<TxnType extends Transaction>
    implements SubmitMultiSignedResult<TxnType> {
        @Nullable
        Optional<String> status = Optional.empty();
        @Nullable
        String engineResult;
        @Nullable
        Integer engineResultCode;
        @Nullable
        String engineResultMessage;
        @Nullable
        String transactionBlob;
        @Nullable
        TransactionResult<TxnType> transaction;

        Json() {
        }

        @JsonProperty(value="status")
        public void setStatus(Optional<String> status) {
            this.status = status;
        }

        @JsonProperty(value="engine_result")
        public void setEngineResult(String engineResult) {
            this.engineResult = engineResult;
        }

        @JsonProperty(value="engine_result_code")
        public void setEngineResultCode(Integer engineResultCode) {
            this.engineResultCode = engineResultCode;
        }

        @JsonProperty(value="engine_result_message")
        public void setEngineResultMessage(String engineResultMessage) {
            this.engineResultMessage = engineResultMessage;
        }

        @JsonProperty(value="tx_blob")
        public void setTransactionBlob(String transactionBlob) {
            this.transactionBlob = transactionBlob;
        }

        @JsonProperty(value="tx_json")
        public void setTransaction(TransactionResult<TxnType> transaction) {
            this.transaction = transaction;
        }

        @Override
        public Optional<String> status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String engineResult() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer engineResultCode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String engineResultMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String transactionBlob() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TransactionResult<TxnType> transaction() {
            throw new UnsupportedOperationException();
        }
    }
}

