/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.serverinfo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.google.common.collect.Range;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.client.serverinfo.ClioServerInfo;
import org.xrpl.xrpl4j.model.client.serverinfo.ImmutableJobType;
import org.xrpl.xrpl4j.model.client.serverinfo.ImmutableLastClose;
import org.xrpl.xrpl4j.model.client.serverinfo.ImmutableLoad;
import org.xrpl.xrpl4j.model.client.serverinfo.ImmutableValidatedLedger;
import org.xrpl.xrpl4j.model.client.serverinfo.LedgerRangeUtils;
import org.xrpl.xrpl4j.model.client.serverinfo.ReportingModeServerInfo;
import org.xrpl.xrpl4j.model.client.serverinfo.RippledServerInfo;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.NetworkId;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

public interface ServerInfo {
    default public void handle(Consumer<RippledServerInfo> rippledServerInfoHandler, Consumer<ClioServerInfo> clioServerInfoHandler, Consumer<ReportingModeServerInfo> reportingModeServerInfoHandler) {
        Objects.requireNonNull(rippledServerInfoHandler);
        Objects.requireNonNull(clioServerInfoHandler);
        Objects.requireNonNull(reportingModeServerInfoHandler);
        if (RippledServerInfo.class.isAssignableFrom(this.getClass())) {
            rippledServerInfoHandler.accept((RippledServerInfo)this);
        } else if (ClioServerInfo.class.isAssignableFrom(this.getClass())) {
            clioServerInfoHandler.accept((ClioServerInfo)this);
        } else if (ReportingModeServerInfo.class.isAssignableFrom(this.getClass())) {
            reportingModeServerInfoHandler.accept((ReportingModeServerInfo)this);
        } else {
            throw new IllegalStateException(String.format("Unsupported ServerInfo Type: %s", this.getClass()));
        }
    }

    default public <R> R map(Function<RippledServerInfo, R> rippledServerInfoMapper, Function<ClioServerInfo, R> clioServerInfoMapper, Function<ReportingModeServerInfo, R> reportingModeServerInfoMapper) {
        Objects.requireNonNull(rippledServerInfoMapper);
        Objects.requireNonNull(clioServerInfoMapper);
        Objects.requireNonNull(reportingModeServerInfoMapper);
        if (RippledServerInfo.class.isAssignableFrom(this.getClass())) {
            return rippledServerInfoMapper.apply((RippledServerInfo)this);
        }
        if (ClioServerInfo.class.isAssignableFrom(this.getClass())) {
            return clioServerInfoMapper.apply((ClioServerInfo)this);
        }
        if (ReportingModeServerInfo.class.isAssignableFrom(this.getClass())) {
            return reportingModeServerInfoMapper.apply((ReportingModeServerInfo)this);
        }
        throw new IllegalStateException(String.format("Unsupported ServerInfo Type: %s", this.getClass()));
    }

    @JsonProperty(value="complete_ledgers")
    @JsonDeserialize(using=CompleteLedgersDeserializer.class)
    public List<Range<UnsignedLong>> completeLedgers();

    @JsonIgnore
    @Value.Derived
    default public boolean isLedgerInCompleteLedgers(UnsignedLong ledgerIndex) {
        return this.completeLedgers().stream().anyMatch(range -> range.contains((Comparable)ledgerIndex));
    }

    @JsonProperty(value="load_factor")
    public Optional<BigDecimal> loadFactor();

    @JsonProperty(value="validated_ledger")
    public Optional<ValidatedLedger> validatedLedger();

    @JsonProperty(value="validation_quorum")
    public Optional<UnsignedInteger> validationQuorum();

    @JsonProperty(value="network_id")
    public Optional<NetworkId> networkId();

    @JsonSerialize(as=ImmutableValidatedLedger.class)
    @JsonDeserialize(as=ImmutableValidatedLedger.class)
    @Value.Immutable
    public static interface ValidatedLedger {
        public static ImmutableValidatedLedger.Builder builder() {
            return ImmutableValidatedLedger.builder();
        }

        public UnsignedInteger age();

        public Hash256 hash();

        @JsonProperty(value="reserve_base_xrp")
        @JsonSerialize(using=CurrencyAmountToXrpSerializer.class)
        @JsonDeserialize(using=XrpToCurrencyAmountDeserializer.class)
        public XrpCurrencyAmount reserveBaseXrp();

        @JsonProperty(value="reserve_inc_xrp")
        @JsonSerialize(using=CurrencyAmountToXrpSerializer.class)
        @JsonDeserialize(using=XrpToCurrencyAmountDeserializer.class)
        public XrpCurrencyAmount reserveIncXrp();

        @JsonProperty(value="seq")
        public LedgerIndex sequence();

        @JsonProperty(value="base_fee_xrp")
        public BigDecimal baseFeeXrp();

        public static class CurrencyAmountToXrpSerializer
        extends StdScalarSerializer<XrpCurrencyAmount> {
            public CurrencyAmountToXrpSerializer() {
                super(XrpCurrencyAmount.class, false);
            }

            public void serialize(XrpCurrencyAmount amount, JsonGenerator gen, SerializerProvider provider) throws IOException {
                gen.writeNumber(amount.toXrp());
            }
        }

        public static class XrpToCurrencyAmountDeserializer
        extends JsonDeserializer<XrpCurrencyAmount> {
            public XrpCurrencyAmount deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
                JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
                return XrpCurrencyAmount.ofXrp(new BigDecimal(node.asText()));
            }
        }
    }

    @JsonSerialize(as=ImmutableLoad.class)
    @JsonDeserialize(as=ImmutableLoad.class)
    @Value.Immutable
    public static interface Load {
        public static ImmutableLoad.Builder builder() {
            return ImmutableLoad.builder();
        }

        @JsonProperty(value="job_types")
        public List<JobType> jobTypes();

        public UnsignedInteger threads();
    }

    @JsonSerialize(as=ImmutableLastClose.class)
    @JsonDeserialize(as=ImmutableLastClose.class)
    @Value.Immutable
    public static interface LastClose {
        public static ImmutableLastClose.Builder builder() {
            return ImmutableLastClose.builder();
        }

        @JsonProperty(value="converge_time_s")
        public BigDecimal convergeTimeSeconds();

        public UnsignedInteger proposers();
    }

    @JsonSerialize(as=ImmutableJobType.class)
    @JsonDeserialize(as=ImmutableJobType.class)
    @Value.Immutable
    public static interface JobType {
        public static ImmutableJobType.Builder builder() {
            return ImmutableJobType.builder();
        }

        @JsonProperty(value="job_type")
        public String jobType();

        @JsonProperty(value="in_progress")
        public Optional<UnsignedInteger> inProgress();

        @JsonProperty(value="peak_time")
        public Optional<UnsignedInteger> peakTime();

        @JsonProperty(value="per_second")
        public Optional<UnsignedInteger> perSecond();

        @JsonProperty(value="avg_time")
        public Optional<UnsignedInteger> averageTime();
    }

    public static class CompleteLedgersDeserializer
    extends JsonDeserializer<List<Range<UnsignedLong>>> {
        public List<Range<UnsignedLong>> deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return LedgerRangeUtils.completeLedgersToListOfRange(node.asText());
        }
    }
}

