/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.serverinfo;

import com.google.common.collect.Range;
import com.google.common.primitives.UnsignedLong;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerRangeUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(LedgerRangeUtils.class);

    public static List<Range<UnsignedLong>> completeLedgersToListOfRange(String completeLedgers) {
        return Stream.of(completeLedgers.split(",")).map(String::trim).filter($ -> !$.equals("empty")).map(range -> {
            String[] parts = range.split("-");
            if (parts.length == 1) {
                try {
                    return Range.singleton((Comparable)UnsignedLong.valueOf((String)parts[0]));
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (parts.length == 2) {
                UnsignedLong upper;
                UnsignedLong lower;
                try {
                    lower = UnsignedLong.valueOf((String)parts[0]);
                }
                catch (Exception e) {
                    LOGGER.warn("Unable to parse valid lower bound number (ignoring range).", (Throwable)e);
                    return null;
                }
                try {
                    upper = UnsignedLong.valueOf((String)parts[1]);
                }
                catch (Exception e) {
                    LOGGER.warn("Unable to parse valid upper bound number (ignoring range).", (Throwable)e);
                    return null;
                }
                return Range.closed((Comparable)lower, (Comparable)upper);
            }
            LOGGER.warn("Range had too many dashes (ignoring range)");
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

