/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.serverinfo;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.client.serverinfo.ServerInfo;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ServerInfo.ValidatedLedger", generator="Immutables")
@Immutable
public final class ImmutableValidatedLedger
implements ServerInfo.ValidatedLedger {
    private final UnsignedInteger age;
    private final Hash256 hash;
    private final XrpCurrencyAmount reserveBaseXrp;
    private final XrpCurrencyAmount reserveIncXrp;
    private final LedgerIndex sequence;
    private final BigDecimal baseFeeXrp;

    private ImmutableValidatedLedger(UnsignedInteger age, Hash256 hash, XrpCurrencyAmount reserveBaseXrp, XrpCurrencyAmount reserveIncXrp, LedgerIndex sequence, BigDecimal baseFeeXrp) {
        this.age = age;
        this.hash = hash;
        this.reserveBaseXrp = reserveBaseXrp;
        this.reserveIncXrp = reserveIncXrp;
        this.sequence = sequence;
        this.baseFeeXrp = baseFeeXrp;
    }

    @Override
    @JsonProperty(value="age")
    public UnsignedInteger age() {
        return this.age;
    }

    @Override
    @JsonProperty(value="hash")
    public Hash256 hash() {
        return this.hash;
    }

    @Override
    @JsonProperty(value="reserve_base_xrp")
    @JsonSerialize(using=ServerInfo.ValidatedLedger.CurrencyAmountToXrpSerializer.class)
    @JsonDeserialize(using=ServerInfo.ValidatedLedger.XrpToCurrencyAmountDeserializer.class)
    public XrpCurrencyAmount reserveBaseXrp() {
        return this.reserveBaseXrp;
    }

    @Override
    @JsonProperty(value="reserve_inc_xrp")
    @JsonSerialize(using=ServerInfo.ValidatedLedger.CurrencyAmountToXrpSerializer.class)
    @JsonDeserialize(using=ServerInfo.ValidatedLedger.XrpToCurrencyAmountDeserializer.class)
    public XrpCurrencyAmount reserveIncXrp() {
        return this.reserveIncXrp;
    }

    @Override
    @JsonProperty(value="seq")
    public LedgerIndex sequence() {
        return this.sequence;
    }

    @Override
    @JsonProperty(value="base_fee_xrp")
    public BigDecimal baseFeeXrp() {
        return this.baseFeeXrp;
    }

    public final ImmutableValidatedLedger withAge(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "age");
        if (this.age.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableValidatedLedger(newValue, this.hash, this.reserveBaseXrp, this.reserveIncXrp, this.sequence, this.baseFeeXrp);
    }

    public final ImmutableValidatedLedger withHash(Hash256 value) {
        if (this.hash == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "hash");
        return new ImmutableValidatedLedger(this.age, newValue, this.reserveBaseXrp, this.reserveIncXrp, this.sequence, this.baseFeeXrp);
    }

    public final ImmutableValidatedLedger withReserveBaseXrp(XrpCurrencyAmount value) {
        if (this.reserveBaseXrp == value) {
            return this;
        }
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "reserveBaseXrp");
        return new ImmutableValidatedLedger(this.age, this.hash, newValue, this.reserveIncXrp, this.sequence, this.baseFeeXrp);
    }

    public final ImmutableValidatedLedger withReserveIncXrp(XrpCurrencyAmount value) {
        if (this.reserveIncXrp == value) {
            return this;
        }
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "reserveIncXrp");
        return new ImmutableValidatedLedger(this.age, this.hash, this.reserveBaseXrp, newValue, this.sequence, this.baseFeeXrp);
    }

    public final ImmutableValidatedLedger withSequence(LedgerIndex value) {
        if (this.sequence == value) {
            return this;
        }
        LedgerIndex newValue = Objects.requireNonNull(value, "sequence");
        return new ImmutableValidatedLedger(this.age, this.hash, this.reserveBaseXrp, this.reserveIncXrp, newValue, this.baseFeeXrp);
    }

    public final ImmutableValidatedLedger withBaseFeeXrp(BigDecimal value) {
        BigDecimal newValue = Objects.requireNonNull(value, "baseFeeXrp");
        if (this.baseFeeXrp.equals(newValue)) {
            return this;
        }
        return new ImmutableValidatedLedger(this.age, this.hash, this.reserveBaseXrp, this.reserveIncXrp, this.sequence, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableValidatedLedger && this.equalTo(0, (ImmutableValidatedLedger)another);
    }

    private boolean equalTo(int synthetic, ImmutableValidatedLedger another) {
        return this.age.equals((Object)another.age) && this.hash.equals(another.hash) && this.reserveBaseXrp.equals(another.reserveBaseXrp) && this.reserveIncXrp.equals(another.reserveIncXrp) && this.sequence.equals(another.sequence) && this.baseFeeXrp.equals(another.baseFeeXrp);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.age.hashCode();
        h += (h << 5) + this.hash.hashCode();
        h += (h << 5) + this.reserveBaseXrp.hashCode();
        h += (h << 5) + this.reserveIncXrp.hashCode();
        h += (h << 5) + this.sequence.hashCode();
        h += (h << 5) + this.baseFeeXrp.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ValidatedLedger").omitNullValues().add("age", (Object)this.age).add("hash", (Object)this.hash).add("reserveBaseXrp", (Object)this.reserveBaseXrp).add("reserveIncXrp", (Object)this.reserveIncXrp).add("sequence", (Object)this.sequence).add("baseFeeXrp", (Object)this.baseFeeXrp).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableValidatedLedger fromJson(Json json) {
        Builder builder = ImmutableValidatedLedger.builder();
        if (json.age != null) {
            builder.age(json.age);
        }
        if (json.hash != null) {
            builder.hash(json.hash);
        }
        if (json.reserveBaseXrp != null) {
            builder.reserveBaseXrp(json.reserveBaseXrp);
        }
        if (json.reserveIncXrp != null) {
            builder.reserveIncXrp(json.reserveIncXrp);
        }
        if (json.sequence != null) {
            builder.sequence(json.sequence);
        }
        if (json.baseFeeXrp != null) {
            builder.baseFeeXrp(json.baseFeeXrp);
        }
        return builder.build();
    }

    public static ImmutableValidatedLedger copyOf(ServerInfo.ValidatedLedger instance) {
        if (instance instanceof ImmutableValidatedLedger) {
            return (ImmutableValidatedLedger)instance;
        }
        return ImmutableValidatedLedger.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ServerInfo.ValidatedLedger", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_AGE = 1L;
        private static final long INIT_BIT_HASH = 2L;
        private static final long INIT_BIT_RESERVE_BASE_XRP = 4L;
        private static final long INIT_BIT_RESERVE_INC_XRP = 8L;
        private static final long INIT_BIT_SEQUENCE = 16L;
        private static final long INIT_BIT_BASE_FEE_XRP = 32L;
        private long initBits = 63L;
        @Nullable
        private UnsignedInteger age;
        @Nullable
        private Hash256 hash;
        @Nullable
        private XrpCurrencyAmount reserveBaseXrp;
        @Nullable
        private XrpCurrencyAmount reserveIncXrp;
        @Nullable
        private LedgerIndex sequence;
        @Nullable
        private BigDecimal baseFeeXrp;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ServerInfo.ValidatedLedger instance) {
            Objects.requireNonNull(instance, "instance");
            this.age(instance.age());
            this.hash(instance.hash());
            this.reserveBaseXrp(instance.reserveBaseXrp());
            this.reserveIncXrp(instance.reserveIncXrp());
            this.sequence(instance.sequence());
            this.baseFeeXrp(instance.baseFeeXrp());
            return this;
        }

        @JsonProperty(value="age")
        @CanIgnoreReturnValue
        public final Builder age(UnsignedInteger age) {
            this.age = Objects.requireNonNull(age, "age");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="hash")
        @CanIgnoreReturnValue
        public final Builder hash(Hash256 hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="reserve_base_xrp")
        @JsonSerialize(using=ServerInfo.ValidatedLedger.CurrencyAmountToXrpSerializer.class)
        @JsonDeserialize(using=ServerInfo.ValidatedLedger.XrpToCurrencyAmountDeserializer.class)
        @CanIgnoreReturnValue
        public final Builder reserveBaseXrp(XrpCurrencyAmount reserveBaseXrp) {
            this.reserveBaseXrp = Objects.requireNonNull(reserveBaseXrp, "reserveBaseXrp");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="reserve_inc_xrp")
        @JsonSerialize(using=ServerInfo.ValidatedLedger.CurrencyAmountToXrpSerializer.class)
        @JsonDeserialize(using=ServerInfo.ValidatedLedger.XrpToCurrencyAmountDeserializer.class)
        @CanIgnoreReturnValue
        public final Builder reserveIncXrp(XrpCurrencyAmount reserveIncXrp) {
            this.reserveIncXrp = Objects.requireNonNull(reserveIncXrp, "reserveIncXrp");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="seq")
        @CanIgnoreReturnValue
        public final Builder sequence(LedgerIndex sequence) {
            this.sequence = Objects.requireNonNull(sequence, "sequence");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="base_fee_xrp")
        @CanIgnoreReturnValue
        public final Builder baseFeeXrp(BigDecimal baseFeeXrp) {
            this.baseFeeXrp = Objects.requireNonNull(baseFeeXrp, "baseFeeXrp");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutableValidatedLedger build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableValidatedLedger(this.age, this.hash, this.reserveBaseXrp, this.reserveIncXrp, this.sequence, this.baseFeeXrp);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("age");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("hash");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("reserveBaseXrp");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("reserveIncXrp");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("sequence");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("baseFeeXrp");
            }
            return "Cannot build ValidatedLedger, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ServerInfo.ValidatedLedger", generator="Immutables")
    static final class Json
    implements ServerInfo.ValidatedLedger {
        @Nullable
        UnsignedInteger age;
        @Nullable
        Hash256 hash;
        @Nullable
        XrpCurrencyAmount reserveBaseXrp;
        @Nullable
        XrpCurrencyAmount reserveIncXrp;
        @Nullable
        LedgerIndex sequence;
        @Nullable
        BigDecimal baseFeeXrp;

        Json() {
        }

        @JsonProperty(value="age")
        public void setAge(UnsignedInteger age) {
            this.age = age;
        }

        @JsonProperty(value="hash")
        public void setHash(Hash256 hash) {
            this.hash = hash;
        }

        @JsonProperty(value="reserve_base_xrp")
        @JsonSerialize(using=ServerInfo.ValidatedLedger.CurrencyAmountToXrpSerializer.class)
        @JsonDeserialize(using=ServerInfo.ValidatedLedger.XrpToCurrencyAmountDeserializer.class)
        public void setReserveBaseXrp(XrpCurrencyAmount reserveBaseXrp) {
            this.reserveBaseXrp = reserveBaseXrp;
        }

        @JsonProperty(value="reserve_inc_xrp")
        @JsonSerialize(using=ServerInfo.ValidatedLedger.CurrencyAmountToXrpSerializer.class)
        @JsonDeserialize(using=ServerInfo.ValidatedLedger.XrpToCurrencyAmountDeserializer.class)
        public void setReserveIncXrp(XrpCurrencyAmount reserveIncXrp) {
            this.reserveIncXrp = reserveIncXrp;
        }

        @JsonProperty(value="seq")
        public void setSequence(LedgerIndex sequence) {
            this.sequence = sequence;
        }

        @JsonProperty(value="base_fee_xrp")
        public void setBaseFeeXrp(BigDecimal baseFeeXrp) {
            this.baseFeeXrp = baseFeeXrp;
        }

        @Override
        public UnsignedInteger age() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 hash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XrpCurrencyAmount reserveBaseXrp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XrpCurrencyAmount reserveIncXrp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LedgerIndex sequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal baseFeeXrp() {
            throw new UnsupportedOperationException();
        }
    }
}

