/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.serverinfo;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.XrplResult;
import org.xrpl.xrpl4j.model.client.serverinfo.ServerInfo;
import org.xrpl.xrpl4j.model.client.serverinfo.ServerInfoResult;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ServerInfoResult", generator="Immutables")
@Immutable
public final class ImmutableServerInfoResult
implements ServerInfoResult {
    @Nullable
    private final String status;
    private final ServerInfo info;

    private ImmutableServerInfoResult(@Nullable String status, ServerInfo info) {
        this.status = status;
        this.info = info;
    }

    @Override
    @JsonProperty(value="status")
    public Optional<String> status() {
        return Optional.ofNullable(this.status);
    }

    @Override
    @JsonProperty(value="info")
    public ServerInfo info() {
        return this.info;
    }

    public final ImmutableServerInfoResult withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (Objects.equals(this.status, newValue)) {
            return this;
        }
        return new ImmutableServerInfoResult(newValue, this.info);
    }

    public final ImmutableServerInfoResult withStatus(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.status, value)) {
            return this;
        }
        return new ImmutableServerInfoResult(value, this.info);
    }

    public final ImmutableServerInfoResult withInfo(ServerInfo value) {
        if (this.info == value) {
            return this;
        }
        ServerInfo newValue = Objects.requireNonNull(value, "info");
        return new ImmutableServerInfoResult(this.status, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableServerInfoResult && this.equalTo(0, (ImmutableServerInfoResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableServerInfoResult another) {
        return Objects.equals(this.status, another.status) && this.info.equals(another.info);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + this.info.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ServerInfoResult").omitNullValues().add("status", (Object)this.status).add("info", (Object)this.info).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableServerInfoResult fromJson(Json json) {
        Builder builder = ImmutableServerInfoResult.builder();
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.info != null) {
            builder.info(json.info);
        }
        return builder.build();
    }

    public static ImmutableServerInfoResult copyOf(ServerInfoResult instance) {
        if (instance instanceof ImmutableServerInfoResult) {
            return (ImmutableServerInfoResult)instance;
        }
        return ImmutableServerInfoResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ServerInfoResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_INFO = 1L;
        private long initBits = 1L;
        @Nullable
        private String status;
        @Nullable
        private ServerInfo info;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(XrplResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ServerInfoResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional<String> statusOptional;
            XrplResult instance;
            long bits = 0L;
            if (object instanceof XrplResult) {
                instance = (XrplResult)object;
                if ((bits & 1L) == 0L) {
                    statusOptional = instance.status();
                    if (statusOptional.isPresent()) {
                        this.status(statusOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof ServerInfoResult) {
                instance = (ServerInfoResult)object;
                if ((bits & 1L) == 0L) {
                    statusOptional = instance.status();
                    if (statusOptional.isPresent()) {
                        this.status(statusOptional);
                    }
                    bits |= 1L;
                }
                this.info(instance.info());
            }
        }

        @CanIgnoreReturnValue
        public final Builder status(String status) {
            this.status = Objects.requireNonNull(status, "status");
            return this;
        }

        @JsonProperty(value="status")
        @CanIgnoreReturnValue
        public final Builder status(Optional<String> status) {
            this.status = status.orElse(null);
            return this;
        }

        @JsonProperty(value="info")
        @CanIgnoreReturnValue
        public final Builder info(ServerInfo info) {
            this.info = Objects.requireNonNull(info, "info");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableServerInfoResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableServerInfoResult(this.status, this.info);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("info");
            }
            return "Cannot build ServerInfoResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ServerInfoResult", generator="Immutables")
    static final class Json
    implements ServerInfoResult {
        @Nullable
        Optional<String> status = Optional.empty();
        @Nullable
        ServerInfo info;

        Json() {
        }

        @JsonProperty(value="status")
        public void setStatus(Optional<String> status) {
            this.status = status;
        }

        @JsonProperty(value="info")
        public void setInfo(ServerInfo info) {
            this.info = info;
        }

        @Override
        public Optional<String> status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ServerInfo info() {
            throw new UnsupportedOperationException();
        }
    }
}

