/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.serverinfo;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.serverinfo.ReportingModeServerInfo;
import org.xrpl.xrpl4j.model.client.serverinfo.ServerInfo;
import org.xrpl.xrpl4j.model.transactions.NetworkId;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ReportingModeServerInfo", generator="Immutables")
@Immutable
public final class ImmutableReportingModeServerInfo
implements ReportingModeServerInfo {
    private final ImmutableList<Range<UnsignedLong>> completeLedgers;
    @Nullable
    private final BigDecimal loadFactor;
    @Nullable
    private final ServerInfo.ValidatedLedger validatedLedger;
    @Nullable
    private final UnsignedInteger validationQuorum;
    @Nullable
    private final NetworkId networkId;
    private final boolean amendmentBlocked;
    private final String buildVersion;
    private final String hostId;
    private final UnsignedLong ioLatencyMs;
    private final ServerInfo.LastClose lastClose;
    @Nullable
    private final ServerInfo.Load load;
    @Nullable
    private final BigDecimal loadFactorLocal;
    @Nullable
    private final BigDecimal loadFactorNet;
    @Nullable
    private final BigDecimal loadFactorCluster;
    @Nullable
    private final BigDecimal loadFactorFeeEscalation;
    @Nullable
    private final BigDecimal loadFactorFeeQueue;
    @Nullable
    private final BigDecimal loadFactorServer;
    private final String publicKeyNode;
    private final String serverState;
    private final String serverStateDurationUs;
    private final ZonedDateTime time;
    private final UnsignedLong upTime;
    @Nullable
    private final ServerInfo.ValidatedLedger closedLedger;
    @Nullable
    private final String publicKeyValidator;
    @Nullable
    private final String validatorListExpires;

    private ImmutableReportingModeServerInfo(Builder builder) {
        this.completeLedgers = builder.completeLedgers.build();
        this.loadFactor = builder.loadFactor;
        this.validatedLedger = builder.validatedLedger;
        this.validationQuorum = builder.validationQuorum;
        this.networkId = builder.networkId;
        this.buildVersion = builder.buildVersion;
        this.hostId = builder.hostId;
        this.ioLatencyMs = builder.ioLatencyMs;
        this.lastClose = builder.lastClose;
        this.load = builder.load;
        this.loadFactorLocal = builder.loadFactorLocal;
        this.loadFactorNet = builder.loadFactorNet;
        this.loadFactorCluster = builder.loadFactorCluster;
        this.loadFactorFeeEscalation = builder.loadFactorFeeEscalation;
        this.loadFactorFeeQueue = builder.loadFactorFeeQueue;
        this.loadFactorServer = builder.loadFactorServer;
        this.publicKeyNode = builder.publicKeyNode;
        this.serverState = builder.serverState;
        this.serverStateDurationUs = builder.serverStateDurationUs;
        this.time = builder.time;
        this.upTime = builder.upTime;
        this.closedLedger = builder.closedLedger;
        this.publicKeyValidator = builder.publicKeyValidator;
        this.validatorListExpires = builder.validatorListExpires;
        this.amendmentBlocked = builder.amendmentBlockedIsSet() ? builder.amendmentBlocked : ReportingModeServerInfo.super.amendmentBlocked();
    }

    private ImmutableReportingModeServerInfo(ImmutableList<Range<UnsignedLong>> completeLedgers, @Nullable BigDecimal loadFactor, @Nullable ServerInfo.ValidatedLedger validatedLedger, @Nullable UnsignedInteger validationQuorum, @Nullable NetworkId networkId, boolean amendmentBlocked, String buildVersion, String hostId, UnsignedLong ioLatencyMs, ServerInfo.LastClose lastClose, @Nullable ServerInfo.Load load, @Nullable BigDecimal loadFactorLocal, @Nullable BigDecimal loadFactorNet, @Nullable BigDecimal loadFactorCluster, @Nullable BigDecimal loadFactorFeeEscalation, @Nullable BigDecimal loadFactorFeeQueue, @Nullable BigDecimal loadFactorServer, String publicKeyNode, String serverState, String serverStateDurationUs, ZonedDateTime time, UnsignedLong upTime, @Nullable ServerInfo.ValidatedLedger closedLedger, @Nullable String publicKeyValidator, @Nullable String validatorListExpires) {
        this.completeLedgers = completeLedgers;
        this.loadFactor = loadFactor;
        this.validatedLedger = validatedLedger;
        this.validationQuorum = validationQuorum;
        this.networkId = networkId;
        this.amendmentBlocked = amendmentBlocked;
        this.buildVersion = buildVersion;
        this.hostId = hostId;
        this.ioLatencyMs = ioLatencyMs;
        this.lastClose = lastClose;
        this.load = load;
        this.loadFactorLocal = loadFactorLocal;
        this.loadFactorNet = loadFactorNet;
        this.loadFactorCluster = loadFactorCluster;
        this.loadFactorFeeEscalation = loadFactorFeeEscalation;
        this.loadFactorFeeQueue = loadFactorFeeQueue;
        this.loadFactorServer = loadFactorServer;
        this.publicKeyNode = publicKeyNode;
        this.serverState = serverState;
        this.serverStateDurationUs = serverStateDurationUs;
        this.time = time;
        this.upTime = upTime;
        this.closedLedger = closedLedger;
        this.publicKeyValidator = publicKeyValidator;
        this.validatorListExpires = validatorListExpires;
    }

    @JsonProperty(value="complete_ledgers")
    @JsonDeserialize(using=ServerInfo.CompleteLedgersDeserializer.class)
    public ImmutableList<Range<UnsignedLong>> completeLedgers() {
        return this.completeLedgers;
    }

    @Override
    @JsonProperty(value="load_factor")
    public Optional<BigDecimal> loadFactor() {
        return Optional.ofNullable(this.loadFactor);
    }

    @Override
    @JsonProperty(value="validated_ledger")
    public Optional<ServerInfo.ValidatedLedger> validatedLedger() {
        return Optional.ofNullable(this.validatedLedger);
    }

    @Override
    @JsonProperty(value="validation_quorum")
    public Optional<UnsignedInteger> validationQuorum() {
        return Optional.ofNullable(this.validationQuorum);
    }

    @Override
    @JsonProperty(value="network_id")
    public Optional<NetworkId> networkId() {
        return Optional.ofNullable(this.networkId);
    }

    @Override
    @JsonProperty(value="amendment_blocked")
    public boolean amendmentBlocked() {
        return this.amendmentBlocked;
    }

    @Override
    @JsonProperty(value="build_version")
    public String buildVersion() {
        return this.buildVersion;
    }

    @Override
    @JsonProperty(value="hostid")
    public String hostId() {
        return this.hostId;
    }

    @Override
    @JsonProperty(value="io_latency_ms")
    public UnsignedLong ioLatencyMs() {
        return this.ioLatencyMs;
    }

    @Override
    @JsonProperty(value="last_close")
    public ServerInfo.LastClose lastClose() {
        return this.lastClose;
    }

    @Override
    @JsonProperty(value="load")
    public Optional<ServerInfo.Load> load() {
        return Optional.ofNullable(this.load);
    }

    @Override
    @JsonProperty(value="load_factor_local")
    public Optional<BigDecimal> loadFactorLocal() {
        return Optional.ofNullable(this.loadFactorLocal);
    }

    @Override
    @JsonProperty(value="load_factor_net")
    public Optional<BigDecimal> loadFactorNet() {
        return Optional.ofNullable(this.loadFactorNet);
    }

    @Override
    @JsonProperty(value="load_factor_cluster")
    public Optional<BigDecimal> loadFactorCluster() {
        return Optional.ofNullable(this.loadFactorCluster);
    }

    @Override
    @JsonProperty(value="load_factor_fee_escalation")
    public Optional<BigDecimal> loadFactorFeeEscalation() {
        return Optional.ofNullable(this.loadFactorFeeEscalation);
    }

    @Override
    @JsonProperty(value="load_factor_fee_queue")
    public Optional<BigDecimal> loadFactorFeeQueue() {
        return Optional.ofNullable(this.loadFactorFeeQueue);
    }

    @Override
    @JsonProperty(value="load_factor_server")
    public Optional<BigDecimal> loadFactorServer() {
        return Optional.ofNullable(this.loadFactorServer);
    }

    @Override
    @JsonProperty(value="pubkey_node")
    public String publicKeyNode() {
        return this.publicKeyNode;
    }

    @Override
    @JsonProperty(value="server_state")
    public String serverState() {
        return this.serverState;
    }

    @Override
    @JsonProperty(value="server_state_duration_us")
    public String serverStateDurationUs() {
        return this.serverStateDurationUs;
    }

    @Override
    @JsonProperty(value="time")
    @JsonFormat(pattern="yyyy-MMM-dd HH:mm:ss.SSSSSS z", locale="en_US")
    public ZonedDateTime time() {
        return this.time;
    }

    @Override
    @JsonProperty(value="uptime")
    public UnsignedLong upTime() {
        return this.upTime;
    }

    @Override
    @JsonProperty(value="closed_ledger")
    public Optional<ServerInfo.ValidatedLedger> closedLedger() {
        return Optional.ofNullable(this.closedLedger);
    }

    @Override
    @JsonProperty(value="pubkey_validator")
    public Optional<String> publicKeyValidator() {
        return Optional.ofNullable(this.publicKeyValidator);
    }

    @Override
    @JsonProperty(value="validator_list_expires")
    public Optional<String> validatorListExpires() {
        return Optional.ofNullable(this.validatorListExpires);
    }

    @SafeVarargs
    public final ImmutableReportingModeServerInfo withCompleteLedgers(Range<UnsignedLong> ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableReportingModeServerInfo((ImmutableList<Range<UnsignedLong>>)newValue, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, this.load, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.closedLedger, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withCompleteLedgers(Iterable<? extends Range<UnsignedLong>> elements) {
        if (this.completeLedgers == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableReportingModeServerInfo((ImmutableList<Range<UnsignedLong>>)newValue, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, this.load, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.closedLedger, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withLoadFactor(BigDecimal value) {
        BigDecimal newValue = Objects.requireNonNull(value, "loadFactor");
        if (Objects.equals(this.loadFactor, newValue)) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, newValue, this.validatedLedger, this.validationQuorum, this.networkId, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, this.load, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.closedLedger, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withLoadFactor(Optional<? extends BigDecimal> optional) {
        BigDecimal value = optional.orElse(null);
        if (Objects.equals(this.loadFactor, value)) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, value, this.validatedLedger, this.validationQuorum, this.networkId, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, this.load, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.closedLedger, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withValidatedLedger(ServerInfo.ValidatedLedger value) {
        ServerInfo.ValidatedLedger newValue = Objects.requireNonNull(value, "validatedLedger");
        if (this.validatedLedger == newValue) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, newValue, this.validationQuorum, this.networkId, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, this.load, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.closedLedger, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withValidatedLedger(Optional<? extends ServerInfo.ValidatedLedger> optional) {
        ServerInfo.ValidatedLedger value = optional.orElse(null);
        if (this.validatedLedger == value) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, value, this.validationQuorum, this.networkId, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, this.load, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.closedLedger, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withValidationQuorum(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "validationQuorum");
        if (Objects.equals(this.validationQuorum, newValue)) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, newValue, this.networkId, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, this.load, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.closedLedger, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withValidationQuorum(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.validationQuorum, value)) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, value, this.networkId, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, this.load, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.closedLedger, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withNetworkId(NetworkId value) {
        NetworkId newValue = Objects.requireNonNull(value, "networkId");
        if (this.networkId == newValue) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, newValue, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, this.load, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.closedLedger, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withNetworkId(Optional<? extends NetworkId> optional) {
        NetworkId value = optional.orElse(null);
        if (this.networkId == value) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, value, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, this.load, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.closedLedger, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withAmendmentBlocked(boolean value) {
        if (this.amendmentBlocked == value) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, value, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, this.load, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.closedLedger, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withBuildVersion(String value) {
        String newValue = Objects.requireNonNull(value, "buildVersion");
        if (this.buildVersion.equals(newValue)) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.amendmentBlocked, newValue, this.hostId, this.ioLatencyMs, this.lastClose, this.load, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.closedLedger, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withHostId(String value) {
        String newValue = Objects.requireNonNull(value, "hostId");
        if (this.hostId.equals(newValue)) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.amendmentBlocked, this.buildVersion, newValue, this.ioLatencyMs, this.lastClose, this.load, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.closedLedger, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withIoLatencyMs(UnsignedLong value) {
        UnsignedLong newValue = Objects.requireNonNull(value, "ioLatencyMs");
        if (this.ioLatencyMs.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.amendmentBlocked, this.buildVersion, this.hostId, newValue, this.lastClose, this.load, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.closedLedger, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withLastClose(ServerInfo.LastClose value) {
        if (this.lastClose == value) {
            return this;
        }
        ServerInfo.LastClose newValue = Objects.requireNonNull(value, "lastClose");
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, newValue, this.load, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.closedLedger, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withLoad(ServerInfo.Load value) {
        ServerInfo.Load newValue = Objects.requireNonNull(value, "load");
        if (this.load == newValue) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, newValue, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.closedLedger, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withLoad(Optional<? extends ServerInfo.Load> optional) {
        ServerInfo.Load value = optional.orElse(null);
        if (this.load == value) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, value, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.closedLedger, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withLoadFactorLocal(BigDecimal value) {
        BigDecimal newValue = Objects.requireNonNull(value, "loadFactorLocal");
        if (Objects.equals(this.loadFactorLocal, newValue)) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, this.load, newValue, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.closedLedger, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withLoadFactorLocal(Optional<? extends BigDecimal> optional) {
        BigDecimal value = optional.orElse(null);
        if (Objects.equals(this.loadFactorLocal, value)) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, this.load, value, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.closedLedger, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withLoadFactorNet(BigDecimal value) {
        BigDecimal newValue = Objects.requireNonNull(value, "loadFactorNet");
        if (Objects.equals(this.loadFactorNet, newValue)) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, this.load, this.loadFactorLocal, newValue, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.closedLedger, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withLoadFactorNet(Optional<? extends BigDecimal> optional) {
        BigDecimal value = optional.orElse(null);
        if (Objects.equals(this.loadFactorNet, value)) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, this.load, this.loadFactorLocal, value, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.closedLedger, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withLoadFactorCluster(BigDecimal value) {
        BigDecimal newValue = Objects.requireNonNull(value, "loadFactorCluster");
        if (Objects.equals(this.loadFactorCluster, newValue)) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, this.load, this.loadFactorLocal, this.loadFactorNet, newValue, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.closedLedger, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withLoadFactorCluster(Optional<? extends BigDecimal> optional) {
        BigDecimal value = optional.orElse(null);
        if (Objects.equals(this.loadFactorCluster, value)) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, this.load, this.loadFactorLocal, this.loadFactorNet, value, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.closedLedger, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withLoadFactorFeeEscalation(BigDecimal value) {
        BigDecimal newValue = Objects.requireNonNull(value, "loadFactorFeeEscalation");
        if (Objects.equals(this.loadFactorFeeEscalation, newValue)) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, this.load, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, newValue, this.loadFactorFeeQueue, this.loadFactorServer, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.closedLedger, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withLoadFactorFeeEscalation(Optional<? extends BigDecimal> optional) {
        BigDecimal value = optional.orElse(null);
        if (Objects.equals(this.loadFactorFeeEscalation, value)) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, this.load, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, value, this.loadFactorFeeQueue, this.loadFactorServer, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.closedLedger, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withLoadFactorFeeQueue(BigDecimal value) {
        BigDecimal newValue = Objects.requireNonNull(value, "loadFactorFeeQueue");
        if (Objects.equals(this.loadFactorFeeQueue, newValue)) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, this.load, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, newValue, this.loadFactorServer, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.closedLedger, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withLoadFactorFeeQueue(Optional<? extends BigDecimal> optional) {
        BigDecimal value = optional.orElse(null);
        if (Objects.equals(this.loadFactorFeeQueue, value)) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, this.load, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, value, this.loadFactorServer, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.closedLedger, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withLoadFactorServer(BigDecimal value) {
        BigDecimal newValue = Objects.requireNonNull(value, "loadFactorServer");
        if (Objects.equals(this.loadFactorServer, newValue)) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, this.load, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, newValue, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.closedLedger, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withLoadFactorServer(Optional<? extends BigDecimal> optional) {
        BigDecimal value = optional.orElse(null);
        if (Objects.equals(this.loadFactorServer, value)) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, this.load, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, value, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.closedLedger, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withPublicKeyNode(String value) {
        String newValue = Objects.requireNonNull(value, "publicKeyNode");
        if (this.publicKeyNode.equals(newValue)) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, this.load, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, newValue, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.closedLedger, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withServerState(String value) {
        String newValue = Objects.requireNonNull(value, "serverState");
        if (this.serverState.equals(newValue)) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, this.load, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.publicKeyNode, newValue, this.serverStateDurationUs, this.time, this.upTime, this.closedLedger, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withServerStateDurationUs(String value) {
        String newValue = Objects.requireNonNull(value, "serverStateDurationUs");
        if (this.serverStateDurationUs.equals(newValue)) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, this.load, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.publicKeyNode, this.serverState, newValue, this.time, this.upTime, this.closedLedger, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withTime(ZonedDateTime value) {
        if (this.time == value) {
            return this;
        }
        ZonedDateTime newValue = Objects.requireNonNull(value, "time");
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, this.load, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.publicKeyNode, this.serverState, this.serverStateDurationUs, newValue, this.upTime, this.closedLedger, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withUpTime(UnsignedLong value) {
        UnsignedLong newValue = Objects.requireNonNull(value, "upTime");
        if (this.upTime.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, this.load, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, newValue, this.closedLedger, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withClosedLedger(ServerInfo.ValidatedLedger value) {
        ServerInfo.ValidatedLedger newValue = Objects.requireNonNull(value, "closedLedger");
        if (this.closedLedger == newValue) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, this.load, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, this.upTime, newValue, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withClosedLedger(Optional<? extends ServerInfo.ValidatedLedger> optional) {
        ServerInfo.ValidatedLedger value = optional.orElse(null);
        if (this.closedLedger == value) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, this.load, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, this.upTime, value, this.publicKeyValidator, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withPublicKeyValidator(String value) {
        String newValue = Objects.requireNonNull(value, "publicKeyValidator");
        if (Objects.equals(this.publicKeyValidator, newValue)) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, this.load, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.closedLedger, newValue, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withPublicKeyValidator(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.publicKeyValidator, value)) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, this.load, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.closedLedger, value, this.validatorListExpires);
    }

    public final ImmutableReportingModeServerInfo withValidatorListExpires(String value) {
        String newValue = Objects.requireNonNull(value, "validatorListExpires");
        if (Objects.equals(this.validatorListExpires, newValue)) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, this.load, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.closedLedger, this.publicKeyValidator, newValue);
    }

    public final ImmutableReportingModeServerInfo withValidatorListExpires(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.validatorListExpires, value)) {
            return this;
        }
        return new ImmutableReportingModeServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.amendmentBlocked, this.buildVersion, this.hostId, this.ioLatencyMs, this.lastClose, this.load, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.publicKeyNode, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.closedLedger, this.publicKeyValidator, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReportingModeServerInfo && this.equalTo(0, (ImmutableReportingModeServerInfo)another);
    }

    private boolean equalTo(int synthetic, ImmutableReportingModeServerInfo another) {
        return this.completeLedgers.equals(another.completeLedgers) && Objects.equals(this.loadFactor, another.loadFactor) && Objects.equals(this.validatedLedger, another.validatedLedger) && Objects.equals(this.validationQuorum, another.validationQuorum) && Objects.equals(this.networkId, another.networkId) && this.amendmentBlocked == another.amendmentBlocked && this.buildVersion.equals(another.buildVersion) && this.hostId.equals(another.hostId) && this.ioLatencyMs.equals((Object)another.ioLatencyMs) && this.lastClose.equals(another.lastClose) && Objects.equals(this.load, another.load) && Objects.equals(this.loadFactorLocal, another.loadFactorLocal) && Objects.equals(this.loadFactorNet, another.loadFactorNet) && Objects.equals(this.loadFactorCluster, another.loadFactorCluster) && Objects.equals(this.loadFactorFeeEscalation, another.loadFactorFeeEscalation) && Objects.equals(this.loadFactorFeeQueue, another.loadFactorFeeQueue) && Objects.equals(this.loadFactorServer, another.loadFactorServer) && this.publicKeyNode.equals(another.publicKeyNode) && this.serverState.equals(another.serverState) && this.serverStateDurationUs.equals(another.serverStateDurationUs) && this.time.equals(another.time) && this.upTime.equals((Object)another.upTime) && Objects.equals(this.closedLedger, another.closedLedger) && Objects.equals(this.publicKeyValidator, another.publicKeyValidator) && Objects.equals(this.validatorListExpires, another.validatorListExpires);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.completeLedgers.hashCode();
        h += (h << 5) + Objects.hashCode(this.loadFactor);
        h += (h << 5) + Objects.hashCode(this.validatedLedger);
        h += (h << 5) + Objects.hashCode(this.validationQuorum);
        h += (h << 5) + Objects.hashCode(this.networkId);
        h += (h << 5) + Booleans.hashCode((boolean)this.amendmentBlocked);
        h += (h << 5) + this.buildVersion.hashCode();
        h += (h << 5) + this.hostId.hashCode();
        h += (h << 5) + this.ioLatencyMs.hashCode();
        h += (h << 5) + this.lastClose.hashCode();
        h += (h << 5) + Objects.hashCode(this.load);
        h += (h << 5) + Objects.hashCode(this.loadFactorLocal);
        h += (h << 5) + Objects.hashCode(this.loadFactorNet);
        h += (h << 5) + Objects.hashCode(this.loadFactorCluster);
        h += (h << 5) + Objects.hashCode(this.loadFactorFeeEscalation);
        h += (h << 5) + Objects.hashCode(this.loadFactorFeeQueue);
        h += (h << 5) + Objects.hashCode(this.loadFactorServer);
        h += (h << 5) + this.publicKeyNode.hashCode();
        h += (h << 5) + this.serverState.hashCode();
        h += (h << 5) + this.serverStateDurationUs.hashCode();
        h += (h << 5) + this.time.hashCode();
        h += (h << 5) + this.upTime.hashCode();
        h += (h << 5) + Objects.hashCode(this.closedLedger);
        h += (h << 5) + Objects.hashCode(this.publicKeyValidator);
        h += (h << 5) + Objects.hashCode(this.validatorListExpires);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ReportingModeServerInfo").omitNullValues().add("completeLedgers", this.completeLedgers).add("loadFactor", (Object)this.loadFactor).add("validatedLedger", (Object)this.validatedLedger).add("validationQuorum", (Object)this.validationQuorum).add("networkId", (Object)this.networkId).add("amendmentBlocked", this.amendmentBlocked).add("buildVersion", (Object)this.buildVersion).add("hostId", (Object)this.hostId).add("ioLatencyMs", (Object)this.ioLatencyMs).add("lastClose", (Object)this.lastClose).add("load", (Object)this.load).add("loadFactorLocal", (Object)this.loadFactorLocal).add("loadFactorNet", (Object)this.loadFactorNet).add("loadFactorCluster", (Object)this.loadFactorCluster).add("loadFactorFeeEscalation", (Object)this.loadFactorFeeEscalation).add("loadFactorFeeQueue", (Object)this.loadFactorFeeQueue).add("loadFactorServer", (Object)this.loadFactorServer).add("publicKeyNode", (Object)this.publicKeyNode).add("serverState", (Object)this.serverState).add("serverStateDurationUs", (Object)this.serverStateDurationUs).add("time", (Object)this.time).add("upTime", (Object)this.upTime).add("closedLedger", (Object)this.closedLedger).add("publicKeyValidator", (Object)this.publicKeyValidator).add("validatorListExpires", (Object)this.validatorListExpires).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableReportingModeServerInfo fromJson(Json json) {
        Builder builder = ImmutableReportingModeServerInfo.builder();
        if (json.completeLedgers != null) {
            builder.addAllCompleteLedgers(json.completeLedgers);
        }
        if (json.loadFactor != null) {
            builder.loadFactor(json.loadFactor);
        }
        if (json.validatedLedger != null) {
            builder.validatedLedger(json.validatedLedger);
        }
        if (json.validationQuorum != null) {
            builder.validationQuorum(json.validationQuorum);
        }
        if (json.networkId != null) {
            builder.networkId(json.networkId);
        }
        if (json.amendmentBlockedIsSet) {
            builder.amendmentBlocked(json.amendmentBlocked);
        }
        if (json.buildVersion != null) {
            builder.buildVersion(json.buildVersion);
        }
        if (json.hostId != null) {
            builder.hostId(json.hostId);
        }
        if (json.ioLatencyMs != null) {
            builder.ioLatencyMs(json.ioLatencyMs);
        }
        if (json.lastClose != null) {
            builder.lastClose(json.lastClose);
        }
        if (json.load != null) {
            builder.load(json.load);
        }
        if (json.loadFactorLocal != null) {
            builder.loadFactorLocal(json.loadFactorLocal);
        }
        if (json.loadFactorNet != null) {
            builder.loadFactorNet(json.loadFactorNet);
        }
        if (json.loadFactorCluster != null) {
            builder.loadFactorCluster(json.loadFactorCluster);
        }
        if (json.loadFactorFeeEscalation != null) {
            builder.loadFactorFeeEscalation(json.loadFactorFeeEscalation);
        }
        if (json.loadFactorFeeQueue != null) {
            builder.loadFactorFeeQueue(json.loadFactorFeeQueue);
        }
        if (json.loadFactorServer != null) {
            builder.loadFactorServer(json.loadFactorServer);
        }
        if (json.publicKeyNode != null) {
            builder.publicKeyNode(json.publicKeyNode);
        }
        if (json.serverState != null) {
            builder.serverState(json.serverState);
        }
        if (json.serverStateDurationUs != null) {
            builder.serverStateDurationUs(json.serverStateDurationUs);
        }
        if (json.time != null) {
            builder.time(json.time);
        }
        if (json.upTime != null) {
            builder.upTime(json.upTime);
        }
        if (json.closedLedger != null) {
            builder.closedLedger(json.closedLedger);
        }
        if (json.publicKeyValidator != null) {
            builder.publicKeyValidator(json.publicKeyValidator);
        }
        if (json.validatorListExpires != null) {
            builder.validatorListExpires(json.validatorListExpires);
        }
        return builder.build();
    }

    public static ImmutableReportingModeServerInfo copyOf(ReportingModeServerInfo instance) {
        if (instance instanceof ImmutableReportingModeServerInfo) {
            return (ImmutableReportingModeServerInfo)instance;
        }
        return ImmutableReportingModeServerInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ReportingModeServerInfo", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_BUILD_VERSION = 1L;
        private static final long INIT_BIT_HOST_ID = 2L;
        private static final long INIT_BIT_IO_LATENCY_MS = 4L;
        private static final long INIT_BIT_LAST_CLOSE = 8L;
        private static final long INIT_BIT_PUBLIC_KEY_NODE = 16L;
        private static final long INIT_BIT_SERVER_STATE = 32L;
        private static final long INIT_BIT_SERVER_STATE_DURATION_US = 64L;
        private static final long INIT_BIT_TIME = 128L;
        private static final long INIT_BIT_UP_TIME = 256L;
        private static final long OPT_BIT_AMENDMENT_BLOCKED = 1L;
        private long initBits = 511L;
        private long optBits;
        private ImmutableList.Builder<Range<UnsignedLong>> completeLedgers = ImmutableList.builder();
        @Nullable
        private BigDecimal loadFactor;
        @Nullable
        private ServerInfo.ValidatedLedger validatedLedger;
        @Nullable
        private UnsignedInteger validationQuorum;
        @Nullable
        private NetworkId networkId;
        private boolean amendmentBlocked;
        @Nullable
        private String buildVersion;
        @Nullable
        private String hostId;
        @Nullable
        private UnsignedLong ioLatencyMs;
        @Nullable
        private ServerInfo.LastClose lastClose;
        @Nullable
        private ServerInfo.Load load;
        @Nullable
        private BigDecimal loadFactorLocal;
        @Nullable
        private BigDecimal loadFactorNet;
        @Nullable
        private BigDecimal loadFactorCluster;
        @Nullable
        private BigDecimal loadFactorFeeEscalation;
        @Nullable
        private BigDecimal loadFactorFeeQueue;
        @Nullable
        private BigDecimal loadFactorServer;
        @Nullable
        private String publicKeyNode;
        @Nullable
        private String serverState;
        @Nullable
        private String serverStateDurationUs;
        @Nullable
        private ZonedDateTime time;
        @Nullable
        private UnsignedLong upTime;
        @Nullable
        private ServerInfo.ValidatedLedger closedLedger;
        @Nullable
        private String publicKeyValidator;
        @Nullable
        private String validatorListExpires;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ReportingModeServerInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ServerInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ServerInfo instance;
            long bits = 0L;
            if (object instanceof ReportingModeServerInfo) {
                Optional<BigDecimal> loadFactorLocalOptional;
                Optional<String> publicKeyValidatorOptional;
                Optional<BigDecimal> loadFactorServerOptional;
                Optional<BigDecimal> loadFactorFeeEscalationOptional;
                Optional<ServerInfo.ValidatedLedger> closedLedgerOptional;
                instance = (ReportingModeServerInfo)object;
                this.amendmentBlocked(instance.amendmentBlocked());
                if ((bits & 1L) == 0L) {
                    this.addAllCompleteLedgers(instance.completeLedgers());
                    bits |= 1L;
                }
                if ((closedLedgerOptional = instance.closedLedger()).isPresent()) {
                    this.closedLedger(closedLedgerOptional);
                }
                this.ioLatencyMs(instance.ioLatencyMs());
                this.serverState(instance.serverState());
                Optional<ServerInfo.Load> loadOptional = instance.load();
                if (loadOptional.isPresent()) {
                    this.load(loadOptional);
                }
                this.publicKeyNode(instance.publicKeyNode());
                Optional<BigDecimal> loadFactorClusterOptional = instance.loadFactorCluster();
                if (loadFactorClusterOptional.isPresent()) {
                    this.loadFactorCluster(loadFactorClusterOptional);
                }
                if ((bits & 2L) == 0L) {
                    Optional<NetworkId> networkIdOptional = instance.networkId();
                    if (networkIdOptional.isPresent()) {
                        this.networkId(networkIdOptional);
                    }
                    bits |= 2L;
                }
                if ((loadFactorFeeEscalationOptional = instance.loadFactorFeeEscalation()).isPresent()) {
                    this.loadFactorFeeEscalation(loadFactorFeeEscalationOptional);
                }
                if ((loadFactorServerOptional = instance.loadFactorServer()).isPresent()) {
                    this.loadFactorServer(loadFactorServerOptional);
                }
                this.serverStateDurationUs(instance.serverStateDurationUs());
                this.buildVersion(instance.buildVersion());
                Optional<String> validatorListExpiresOptional = instance.validatorListExpires();
                if (validatorListExpiresOptional.isPresent()) {
                    this.validatorListExpires(validatorListExpiresOptional);
                }
                if ((bits & 4L) == 0L) {
                    Optional<ServerInfo.ValidatedLedger> validatedLedgerOptional = instance.validatedLedger();
                    if (validatedLedgerOptional.isPresent()) {
                        this.validatedLedger(validatedLedgerOptional);
                    }
                    bits |= 4L;
                }
                this.hostId(instance.hostId());
                Optional<BigDecimal> loadFactorFeeQueueOptional = instance.loadFactorFeeQueue();
                if (loadFactorFeeQueueOptional.isPresent()) {
                    this.loadFactorFeeQueue(loadFactorFeeQueueOptional);
                }
                this.lastClose(instance.lastClose());
                Optional<BigDecimal> loadFactorNetOptional = instance.loadFactorNet();
                if (loadFactorNetOptional.isPresent()) {
                    this.loadFactorNet(loadFactorNetOptional);
                }
                this.upTime(instance.upTime());
                if ((bits & 8L) == 0L) {
                    Optional<BigDecimal> loadFactorOptional = instance.loadFactor();
                    if (loadFactorOptional.isPresent()) {
                        this.loadFactor(loadFactorOptional);
                    }
                    bits |= 8L;
                }
                if ((publicKeyValidatorOptional = instance.publicKeyValidator()).isPresent()) {
                    this.publicKeyValidator(publicKeyValidatorOptional);
                }
                if ((loadFactorLocalOptional = instance.loadFactorLocal()).isPresent()) {
                    this.loadFactorLocal(loadFactorLocalOptional);
                }
                if ((bits & 0x10L) == 0L) {
                    Optional<UnsignedInteger> validationQuorumOptional = instance.validationQuorum();
                    if (validationQuorumOptional.isPresent()) {
                        this.validationQuorum(validationQuorumOptional);
                    }
                    bits |= 0x10L;
                }
                this.time(instance.time());
            }
            if (object instanceof ServerInfo) {
                instance = (ServerInfo)object;
                if ((bits & 1L) == 0L) {
                    this.addAllCompleteLedgers(instance.completeLedgers());
                    bits |= 1L;
                }
                if ((bits & 0x10L) == 0L) {
                    Optional<UnsignedInteger> validationQuorumOptional = instance.validationQuorum();
                    if (validationQuorumOptional.isPresent()) {
                        this.validationQuorum(validationQuorumOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 2L) == 0L) {
                    Optional<NetworkId> networkIdOptional = instance.networkId();
                    if (networkIdOptional.isPresent()) {
                        this.networkId(networkIdOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 8L) == 0L) {
                    Optional<BigDecimal> loadFactorOptional = instance.loadFactor();
                    if (loadFactorOptional.isPresent()) {
                        this.loadFactor(loadFactorOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 4L) == 0L) {
                    Optional<ServerInfo.ValidatedLedger> validatedLedgerOptional = instance.validatedLedger();
                    if (validatedLedgerOptional.isPresent()) {
                        this.validatedLedger(validatedLedgerOptional);
                    }
                    bits |= 4L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder addCompleteLedgers(Range<UnsignedLong> element) {
            this.completeLedgers.add(element);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addCompleteLedgers(Range<UnsignedLong> ... elements) {
            this.completeLedgers.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="complete_ledgers")
        @JsonDeserialize(using=ServerInfo.CompleteLedgersDeserializer.class)
        @CanIgnoreReturnValue
        public final Builder completeLedgers(Iterable<? extends Range<UnsignedLong>> elements) {
            this.completeLedgers = ImmutableList.builder();
            return this.addAllCompleteLedgers(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCompleteLedgers(Iterable<? extends Range<UnsignedLong>> elements) {
            this.completeLedgers.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder loadFactor(BigDecimal loadFactor) {
            this.loadFactor = Objects.requireNonNull(loadFactor, "loadFactor");
            return this;
        }

        @JsonProperty(value="load_factor")
        @CanIgnoreReturnValue
        public final Builder loadFactor(Optional<? extends BigDecimal> loadFactor) {
            this.loadFactor = loadFactor.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder validatedLedger(ServerInfo.ValidatedLedger validatedLedger) {
            this.validatedLedger = Objects.requireNonNull(validatedLedger, "validatedLedger");
            return this;
        }

        @JsonProperty(value="validated_ledger")
        @CanIgnoreReturnValue
        public final Builder validatedLedger(Optional<? extends ServerInfo.ValidatedLedger> validatedLedger) {
            this.validatedLedger = validatedLedger.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder validationQuorum(UnsignedInteger validationQuorum) {
            this.validationQuorum = Objects.requireNonNull(validationQuorum, "validationQuorum");
            return this;
        }

        @JsonProperty(value="validation_quorum")
        @CanIgnoreReturnValue
        public final Builder validationQuorum(Optional<? extends UnsignedInteger> validationQuorum) {
            this.validationQuorum = validationQuorum.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder networkId(NetworkId networkId) {
            this.networkId = Objects.requireNonNull(networkId, "networkId");
            return this;
        }

        @JsonProperty(value="network_id")
        @CanIgnoreReturnValue
        public final Builder networkId(Optional<? extends NetworkId> networkId) {
            this.networkId = networkId.orElse(null);
            return this;
        }

        @JsonProperty(value="amendment_blocked")
        @CanIgnoreReturnValue
        public final Builder amendmentBlocked(boolean amendmentBlocked) {
            this.amendmentBlocked = amendmentBlocked;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="build_version")
        @CanIgnoreReturnValue
        public final Builder buildVersion(String buildVersion) {
            this.buildVersion = Objects.requireNonNull(buildVersion, "buildVersion");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="hostid")
        @CanIgnoreReturnValue
        public final Builder hostId(String hostId) {
            this.hostId = Objects.requireNonNull(hostId, "hostId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="io_latency_ms")
        @CanIgnoreReturnValue
        public final Builder ioLatencyMs(UnsignedLong ioLatencyMs) {
            this.ioLatencyMs = Objects.requireNonNull(ioLatencyMs, "ioLatencyMs");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="last_close")
        @CanIgnoreReturnValue
        public final Builder lastClose(ServerInfo.LastClose lastClose) {
            this.lastClose = Objects.requireNonNull(lastClose, "lastClose");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder load(ServerInfo.Load load) {
            this.load = Objects.requireNonNull(load, "load");
            return this;
        }

        @JsonProperty(value="load")
        @CanIgnoreReturnValue
        public final Builder load(Optional<? extends ServerInfo.Load> load) {
            this.load = load.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder loadFactorLocal(BigDecimal loadFactorLocal) {
            this.loadFactorLocal = Objects.requireNonNull(loadFactorLocal, "loadFactorLocal");
            return this;
        }

        @JsonProperty(value="load_factor_local")
        @CanIgnoreReturnValue
        public final Builder loadFactorLocal(Optional<? extends BigDecimal> loadFactorLocal) {
            this.loadFactorLocal = loadFactorLocal.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder loadFactorNet(BigDecimal loadFactorNet) {
            this.loadFactorNet = Objects.requireNonNull(loadFactorNet, "loadFactorNet");
            return this;
        }

        @JsonProperty(value="load_factor_net")
        @CanIgnoreReturnValue
        public final Builder loadFactorNet(Optional<? extends BigDecimal> loadFactorNet) {
            this.loadFactorNet = loadFactorNet.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder loadFactorCluster(BigDecimal loadFactorCluster) {
            this.loadFactorCluster = Objects.requireNonNull(loadFactorCluster, "loadFactorCluster");
            return this;
        }

        @JsonProperty(value="load_factor_cluster")
        @CanIgnoreReturnValue
        public final Builder loadFactorCluster(Optional<? extends BigDecimal> loadFactorCluster) {
            this.loadFactorCluster = loadFactorCluster.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder loadFactorFeeEscalation(BigDecimal loadFactorFeeEscalation) {
            this.loadFactorFeeEscalation = Objects.requireNonNull(loadFactorFeeEscalation, "loadFactorFeeEscalation");
            return this;
        }

        @JsonProperty(value="load_factor_fee_escalation")
        @CanIgnoreReturnValue
        public final Builder loadFactorFeeEscalation(Optional<? extends BigDecimal> loadFactorFeeEscalation) {
            this.loadFactorFeeEscalation = loadFactorFeeEscalation.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder loadFactorFeeQueue(BigDecimal loadFactorFeeQueue) {
            this.loadFactorFeeQueue = Objects.requireNonNull(loadFactorFeeQueue, "loadFactorFeeQueue");
            return this;
        }

        @JsonProperty(value="load_factor_fee_queue")
        @CanIgnoreReturnValue
        public final Builder loadFactorFeeQueue(Optional<? extends BigDecimal> loadFactorFeeQueue) {
            this.loadFactorFeeQueue = loadFactorFeeQueue.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder loadFactorServer(BigDecimal loadFactorServer) {
            this.loadFactorServer = Objects.requireNonNull(loadFactorServer, "loadFactorServer");
            return this;
        }

        @JsonProperty(value="load_factor_server")
        @CanIgnoreReturnValue
        public final Builder loadFactorServer(Optional<? extends BigDecimal> loadFactorServer) {
            this.loadFactorServer = loadFactorServer.orElse(null);
            return this;
        }

        @JsonProperty(value="pubkey_node")
        @CanIgnoreReturnValue
        public final Builder publicKeyNode(String publicKeyNode) {
            this.publicKeyNode = Objects.requireNonNull(publicKeyNode, "publicKeyNode");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="server_state")
        @CanIgnoreReturnValue
        public final Builder serverState(String serverState) {
            this.serverState = Objects.requireNonNull(serverState, "serverState");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="server_state_duration_us")
        @CanIgnoreReturnValue
        public final Builder serverStateDurationUs(String serverStateDurationUs) {
            this.serverStateDurationUs = Objects.requireNonNull(serverStateDurationUs, "serverStateDurationUs");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="time")
        @JsonFormat(pattern="yyyy-MMM-dd HH:mm:ss.SSSSSS z", locale="en_US")
        @CanIgnoreReturnValue
        public final Builder time(ZonedDateTime time) {
            this.time = Objects.requireNonNull(time, "time");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @JsonProperty(value="uptime")
        @CanIgnoreReturnValue
        public final Builder upTime(UnsignedLong upTime) {
            this.upTime = Objects.requireNonNull(upTime, "upTime");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder closedLedger(ServerInfo.ValidatedLedger closedLedger) {
            this.closedLedger = Objects.requireNonNull(closedLedger, "closedLedger");
            return this;
        }

        @JsonProperty(value="closed_ledger")
        @CanIgnoreReturnValue
        public final Builder closedLedger(Optional<? extends ServerInfo.ValidatedLedger> closedLedger) {
            this.closedLedger = closedLedger.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder publicKeyValidator(String publicKeyValidator) {
            this.publicKeyValidator = Objects.requireNonNull(publicKeyValidator, "publicKeyValidator");
            return this;
        }

        @JsonProperty(value="pubkey_validator")
        @CanIgnoreReturnValue
        public final Builder publicKeyValidator(Optional<String> publicKeyValidator) {
            this.publicKeyValidator = publicKeyValidator.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder validatorListExpires(String validatorListExpires) {
            this.validatorListExpires = Objects.requireNonNull(validatorListExpires, "validatorListExpires");
            return this;
        }

        @JsonProperty(value="validator_list_expires")
        @CanIgnoreReturnValue
        public final Builder validatorListExpires(Optional<String> validatorListExpires) {
            this.validatorListExpires = validatorListExpires.orElse(null);
            return this;
        }

        public ImmutableReportingModeServerInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReportingModeServerInfo(this);
        }

        private boolean amendmentBlockedIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("buildVersion");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("hostId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("ioLatencyMs");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("lastClose");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("publicKeyNode");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("serverState");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("serverStateDurationUs");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("time");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("upTime");
            }
            return "Cannot build ReportingModeServerInfo, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ReportingModeServerInfo", generator="Immutables")
    static final class Json
    implements ReportingModeServerInfo {
        @Nullable
        List<Range<UnsignedLong>> completeLedgers = ImmutableList.of();
        @Nullable
        Optional<BigDecimal> loadFactor = Optional.empty();
        @Nullable
        Optional<ServerInfo.ValidatedLedger> validatedLedger = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> validationQuorum = Optional.empty();
        @Nullable
        Optional<NetworkId> networkId = Optional.empty();
        boolean amendmentBlocked;
        boolean amendmentBlockedIsSet;
        @Nullable
        String buildVersion;
        @Nullable
        String hostId;
        @Nullable
        UnsignedLong ioLatencyMs;
        @Nullable
        ServerInfo.LastClose lastClose;
        @Nullable
        Optional<ServerInfo.Load> load = Optional.empty();
        @Nullable
        Optional<BigDecimal> loadFactorLocal = Optional.empty();
        @Nullable
        Optional<BigDecimal> loadFactorNet = Optional.empty();
        @Nullable
        Optional<BigDecimal> loadFactorCluster = Optional.empty();
        @Nullable
        Optional<BigDecimal> loadFactorFeeEscalation = Optional.empty();
        @Nullable
        Optional<BigDecimal> loadFactorFeeQueue = Optional.empty();
        @Nullable
        Optional<BigDecimal> loadFactorServer = Optional.empty();
        @Nullable
        String publicKeyNode;
        @Nullable
        String serverState;
        @Nullable
        String serverStateDurationUs;
        @Nullable
        ZonedDateTime time;
        @Nullable
        UnsignedLong upTime;
        @Nullable
        Optional<ServerInfo.ValidatedLedger> closedLedger = Optional.empty();
        @Nullable
        Optional<String> publicKeyValidator = Optional.empty();
        @Nullable
        Optional<String> validatorListExpires = Optional.empty();

        Json() {
        }

        @JsonProperty(value="complete_ledgers")
        @JsonDeserialize(using=ServerInfo.CompleteLedgersDeserializer.class)
        public void setCompleteLedgers(List<Range<UnsignedLong>> completeLedgers) {
            this.completeLedgers = completeLedgers;
        }

        @JsonProperty(value="load_factor")
        public void setLoadFactor(Optional<BigDecimal> loadFactor) {
            this.loadFactor = loadFactor;
        }

        @JsonProperty(value="validated_ledger")
        public void setValidatedLedger(Optional<ServerInfo.ValidatedLedger> validatedLedger) {
            this.validatedLedger = validatedLedger;
        }

        @JsonProperty(value="validation_quorum")
        public void setValidationQuorum(Optional<UnsignedInteger> validationQuorum) {
            this.validationQuorum = validationQuorum;
        }

        @JsonProperty(value="network_id")
        public void setNetworkId(Optional<NetworkId> networkId) {
            this.networkId = networkId;
        }

        @JsonProperty(value="amendment_blocked")
        public void setAmendmentBlocked(boolean amendmentBlocked) {
            this.amendmentBlocked = amendmentBlocked;
            this.amendmentBlockedIsSet = true;
        }

        @JsonProperty(value="build_version")
        public void setBuildVersion(String buildVersion) {
            this.buildVersion = buildVersion;
        }

        @JsonProperty(value="hostid")
        public void setHostId(String hostId) {
            this.hostId = hostId;
        }

        @JsonProperty(value="io_latency_ms")
        public void setIoLatencyMs(UnsignedLong ioLatencyMs) {
            this.ioLatencyMs = ioLatencyMs;
        }

        @JsonProperty(value="last_close")
        public void setLastClose(ServerInfo.LastClose lastClose) {
            this.lastClose = lastClose;
        }

        @JsonProperty(value="load")
        public void setLoad(Optional<ServerInfo.Load> load) {
            this.load = load;
        }

        @JsonProperty(value="load_factor_local")
        public void setLoadFactorLocal(Optional<BigDecimal> loadFactorLocal) {
            this.loadFactorLocal = loadFactorLocal;
        }

        @JsonProperty(value="load_factor_net")
        public void setLoadFactorNet(Optional<BigDecimal> loadFactorNet) {
            this.loadFactorNet = loadFactorNet;
        }

        @JsonProperty(value="load_factor_cluster")
        public void setLoadFactorCluster(Optional<BigDecimal> loadFactorCluster) {
            this.loadFactorCluster = loadFactorCluster;
        }

        @JsonProperty(value="load_factor_fee_escalation")
        public void setLoadFactorFeeEscalation(Optional<BigDecimal> loadFactorFeeEscalation) {
            this.loadFactorFeeEscalation = loadFactorFeeEscalation;
        }

        @JsonProperty(value="load_factor_fee_queue")
        public void setLoadFactorFeeQueue(Optional<BigDecimal> loadFactorFeeQueue) {
            this.loadFactorFeeQueue = loadFactorFeeQueue;
        }

        @JsonProperty(value="load_factor_server")
        public void setLoadFactorServer(Optional<BigDecimal> loadFactorServer) {
            this.loadFactorServer = loadFactorServer;
        }

        @JsonProperty(value="pubkey_node")
        public void setPublicKeyNode(String publicKeyNode) {
            this.publicKeyNode = publicKeyNode;
        }

        @JsonProperty(value="server_state")
        public void setServerState(String serverState) {
            this.serverState = serverState;
        }

        @JsonProperty(value="server_state_duration_us")
        public void setServerStateDurationUs(String serverStateDurationUs) {
            this.serverStateDurationUs = serverStateDurationUs;
        }

        @JsonProperty(value="time")
        @JsonFormat(pattern="yyyy-MMM-dd HH:mm:ss.SSSSSS z", locale="en_US")
        public void setTime(ZonedDateTime time) {
            this.time = time;
        }

        @JsonProperty(value="uptime")
        public void setUpTime(UnsignedLong upTime) {
            this.upTime = upTime;
        }

        @JsonProperty(value="closed_ledger")
        public void setClosedLedger(Optional<ServerInfo.ValidatedLedger> closedLedger) {
            this.closedLedger = closedLedger;
        }

        @JsonProperty(value="pubkey_validator")
        public void setPublicKeyValidator(Optional<String> publicKeyValidator) {
            this.publicKeyValidator = publicKeyValidator;
        }

        @JsonProperty(value="validator_list_expires")
        public void setValidatorListExpires(Optional<String> validatorListExpires) {
            this.validatorListExpires = validatorListExpires;
        }

        @Override
        public List<Range<UnsignedLong>> completeLedgers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<BigDecimal> loadFactor() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ServerInfo.ValidatedLedger> validatedLedger() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> validationQuorum() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<NetworkId> networkId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean amendmentBlocked() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String buildVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String hostId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedLong ioLatencyMs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ServerInfo.LastClose lastClose() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ServerInfo.Load> load() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<BigDecimal> loadFactorLocal() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<BigDecimal> loadFactorNet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<BigDecimal> loadFactorCluster() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<BigDecimal> loadFactorFeeEscalation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<BigDecimal> loadFactorFeeQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<BigDecimal> loadFactorServer() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String publicKeyNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String serverState() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String serverStateDurationUs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ZonedDateTime time() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedLong upTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ServerInfo.ValidatedLedger> closedLedger() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> publicKeyValidator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> validatorListExpires() {
            throw new UnsupportedOperationException();
        }
    }
}

