/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.serverinfo;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.serverinfo.ServerInfo;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ServerInfo.JobType", generator="Immutables")
@Immutable
public final class ImmutableJobType
implements ServerInfo.JobType {
    private final String jobType;
    @Nullable
    private final UnsignedInteger inProgress;
    @Nullable
    private final UnsignedInteger peakTime;
    @Nullable
    private final UnsignedInteger perSecond;
    @Nullable
    private final UnsignedInteger averageTime;

    private ImmutableJobType(String jobType, @Nullable UnsignedInteger inProgress, @Nullable UnsignedInteger peakTime, @Nullable UnsignedInteger perSecond, @Nullable UnsignedInteger averageTime) {
        this.jobType = jobType;
        this.inProgress = inProgress;
        this.peakTime = peakTime;
        this.perSecond = perSecond;
        this.averageTime = averageTime;
    }

    @Override
    @JsonProperty(value="job_type")
    public String jobType() {
        return this.jobType;
    }

    @Override
    @JsonProperty(value="in_progress")
    public Optional<UnsignedInteger> inProgress() {
        return Optional.ofNullable(this.inProgress);
    }

    @Override
    @JsonProperty(value="peak_time")
    public Optional<UnsignedInteger> peakTime() {
        return Optional.ofNullable(this.peakTime);
    }

    @Override
    @JsonProperty(value="per_second")
    public Optional<UnsignedInteger> perSecond() {
        return Optional.ofNullable(this.perSecond);
    }

    @Override
    @JsonProperty(value="avg_time")
    public Optional<UnsignedInteger> averageTime() {
        return Optional.ofNullable(this.averageTime);
    }

    public final ImmutableJobType withJobType(String value) {
        String newValue = Objects.requireNonNull(value, "jobType");
        if (this.jobType.equals(newValue)) {
            return this;
        }
        return new ImmutableJobType(newValue, this.inProgress, this.peakTime, this.perSecond, this.averageTime);
    }

    public final ImmutableJobType withInProgress(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "inProgress");
        if (Objects.equals(this.inProgress, newValue)) {
            return this;
        }
        return new ImmutableJobType(this.jobType, newValue, this.peakTime, this.perSecond, this.averageTime);
    }

    public final ImmutableJobType withInProgress(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.inProgress, value)) {
            return this;
        }
        return new ImmutableJobType(this.jobType, value, this.peakTime, this.perSecond, this.averageTime);
    }

    public final ImmutableJobType withPeakTime(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "peakTime");
        if (Objects.equals(this.peakTime, newValue)) {
            return this;
        }
        return new ImmutableJobType(this.jobType, this.inProgress, newValue, this.perSecond, this.averageTime);
    }

    public final ImmutableJobType withPeakTime(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.peakTime, value)) {
            return this;
        }
        return new ImmutableJobType(this.jobType, this.inProgress, value, this.perSecond, this.averageTime);
    }

    public final ImmutableJobType withPerSecond(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "perSecond");
        if (Objects.equals(this.perSecond, newValue)) {
            return this;
        }
        return new ImmutableJobType(this.jobType, this.inProgress, this.peakTime, newValue, this.averageTime);
    }

    public final ImmutableJobType withPerSecond(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.perSecond, value)) {
            return this;
        }
        return new ImmutableJobType(this.jobType, this.inProgress, this.peakTime, value, this.averageTime);
    }

    public final ImmutableJobType withAverageTime(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "averageTime");
        if (Objects.equals(this.averageTime, newValue)) {
            return this;
        }
        return new ImmutableJobType(this.jobType, this.inProgress, this.peakTime, this.perSecond, newValue);
    }

    public final ImmutableJobType withAverageTime(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.averageTime, value)) {
            return this;
        }
        return new ImmutableJobType(this.jobType, this.inProgress, this.peakTime, this.perSecond, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJobType && this.equalTo(0, (ImmutableJobType)another);
    }

    private boolean equalTo(int synthetic, ImmutableJobType another) {
        return this.jobType.equals(another.jobType) && Objects.equals(this.inProgress, another.inProgress) && Objects.equals(this.peakTime, another.peakTime) && Objects.equals(this.perSecond, another.perSecond) && Objects.equals(this.averageTime, another.averageTime);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.jobType.hashCode();
        h += (h << 5) + Objects.hashCode(this.inProgress);
        h += (h << 5) + Objects.hashCode(this.peakTime);
        h += (h << 5) + Objects.hashCode(this.perSecond);
        h += (h << 5) + Objects.hashCode(this.averageTime);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"JobType").omitNullValues().add("jobType", (Object)this.jobType).add("inProgress", (Object)this.inProgress).add("peakTime", (Object)this.peakTime).add("perSecond", (Object)this.perSecond).add("averageTime", (Object)this.averageTime).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableJobType fromJson(Json json) {
        Builder builder = ImmutableJobType.builder();
        if (json.jobType != null) {
            builder.jobType(json.jobType);
        }
        if (json.inProgress != null) {
            builder.inProgress(json.inProgress);
        }
        if (json.peakTime != null) {
            builder.peakTime(json.peakTime);
        }
        if (json.perSecond != null) {
            builder.perSecond(json.perSecond);
        }
        if (json.averageTime != null) {
            builder.averageTime(json.averageTime);
        }
        return builder.build();
    }

    public static ImmutableJobType copyOf(ServerInfo.JobType instance) {
        if (instance instanceof ImmutableJobType) {
            return (ImmutableJobType)instance;
        }
        return ImmutableJobType.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ServerInfo.JobType", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_JOB_TYPE = 1L;
        private long initBits = 1L;
        @Nullable
        private String jobType;
        @Nullable
        private UnsignedInteger inProgress;
        @Nullable
        private UnsignedInteger peakTime;
        @Nullable
        private UnsignedInteger perSecond;
        @Nullable
        private UnsignedInteger averageTime;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ServerInfo.JobType instance) {
            Optional<UnsignedInteger> averageTimeOptional;
            Optional<UnsignedInteger> perSecondOptional;
            Optional<UnsignedInteger> peakTimeOptional;
            Objects.requireNonNull(instance, "instance");
            this.jobType(instance.jobType());
            Optional<UnsignedInteger> inProgressOptional = instance.inProgress();
            if (inProgressOptional.isPresent()) {
                this.inProgress(inProgressOptional);
            }
            if ((peakTimeOptional = instance.peakTime()).isPresent()) {
                this.peakTime(peakTimeOptional);
            }
            if ((perSecondOptional = instance.perSecond()).isPresent()) {
                this.perSecond(perSecondOptional);
            }
            if ((averageTimeOptional = instance.averageTime()).isPresent()) {
                this.averageTime(averageTimeOptional);
            }
            return this;
        }

        @JsonProperty(value="job_type")
        @CanIgnoreReturnValue
        public final Builder jobType(String jobType) {
            this.jobType = Objects.requireNonNull(jobType, "jobType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder inProgress(UnsignedInteger inProgress) {
            this.inProgress = Objects.requireNonNull(inProgress, "inProgress");
            return this;
        }

        @JsonProperty(value="in_progress")
        @CanIgnoreReturnValue
        public final Builder inProgress(Optional<? extends UnsignedInteger> inProgress) {
            this.inProgress = inProgress.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder peakTime(UnsignedInteger peakTime) {
            this.peakTime = Objects.requireNonNull(peakTime, "peakTime");
            return this;
        }

        @JsonProperty(value="peak_time")
        @CanIgnoreReturnValue
        public final Builder peakTime(Optional<? extends UnsignedInteger> peakTime) {
            this.peakTime = peakTime.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder perSecond(UnsignedInteger perSecond) {
            this.perSecond = Objects.requireNonNull(perSecond, "perSecond");
            return this;
        }

        @JsonProperty(value="per_second")
        @CanIgnoreReturnValue
        public final Builder perSecond(Optional<? extends UnsignedInteger> perSecond) {
            this.perSecond = perSecond.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder averageTime(UnsignedInteger averageTime) {
            this.averageTime = Objects.requireNonNull(averageTime, "averageTime");
            return this;
        }

        @JsonProperty(value="avg_time")
        @CanIgnoreReturnValue
        public final Builder averageTime(Optional<? extends UnsignedInteger> averageTime) {
            this.averageTime = averageTime.orElse(null);
            return this;
        }

        public ImmutableJobType build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJobType(this.jobType, this.inProgress, this.peakTime, this.perSecond, this.averageTime);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("jobType");
            }
            return "Cannot build JobType, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ServerInfo.JobType", generator="Immutables")
    static final class Json
    implements ServerInfo.JobType {
        @Nullable
        String jobType;
        @Nullable
        Optional<UnsignedInteger> inProgress = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> peakTime = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> perSecond = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> averageTime = Optional.empty();

        Json() {
        }

        @JsonProperty(value="job_type")
        public void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @JsonProperty(value="in_progress")
        public void setInProgress(Optional<UnsignedInteger> inProgress) {
            this.inProgress = inProgress;
        }

        @JsonProperty(value="peak_time")
        public void setPeakTime(Optional<UnsignedInteger> peakTime) {
            this.peakTime = peakTime;
        }

        @JsonProperty(value="per_second")
        public void setPerSecond(Optional<UnsignedInteger> perSecond) {
            this.perSecond = perSecond;
        }

        @JsonProperty(value="avg_time")
        public void setAverageTime(Optional<UnsignedInteger> averageTime) {
            this.averageTime = averageTime;
        }

        @Override
        public String jobType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> inProgress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> peakTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> perSecond() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> averageTime() {
            throw new UnsupportedOperationException();
        }
    }
}

