/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.serverinfo;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.serverinfo.ClioServerInfo;
import org.xrpl.xrpl4j.model.client.serverinfo.ServerInfo;
import org.xrpl.xrpl4j.model.transactions.NetworkId;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ClioServerInfo", generator="Immutables")
@Immutable
public final class ImmutableClioServerInfo
implements ClioServerInfo {
    private final ImmutableList<Range<UnsignedLong>> completeLedgers;
    @Nullable
    private final BigDecimal loadFactor;
    @Nullable
    private final ServerInfo.ValidatedLedger validatedLedger;
    @Nullable
    private final UnsignedInteger validationQuorum;
    @Nullable
    private final NetworkId networkId;
    private final String clioVersion;
    @Nullable
    private final String rippledVersion;

    private ImmutableClioServerInfo(ImmutableList<Range<UnsignedLong>> completeLedgers, @Nullable BigDecimal loadFactor, @Nullable ServerInfo.ValidatedLedger validatedLedger, @Nullable UnsignedInteger validationQuorum, @Nullable NetworkId networkId, String clioVersion, @Nullable String rippledVersion) {
        this.completeLedgers = completeLedgers;
        this.loadFactor = loadFactor;
        this.validatedLedger = validatedLedger;
        this.validationQuorum = validationQuorum;
        this.networkId = networkId;
        this.clioVersion = clioVersion;
        this.rippledVersion = rippledVersion;
    }

    @JsonProperty(value="complete_ledgers")
    @JsonDeserialize(using=ServerInfo.CompleteLedgersDeserializer.class)
    public ImmutableList<Range<UnsignedLong>> completeLedgers() {
        return this.completeLedgers;
    }

    @Override
    @JsonProperty(value="load_factor")
    public Optional<BigDecimal> loadFactor() {
        return Optional.ofNullable(this.loadFactor);
    }

    @Override
    @JsonProperty(value="validated_ledger")
    public Optional<ServerInfo.ValidatedLedger> validatedLedger() {
        return Optional.ofNullable(this.validatedLedger);
    }

    @Override
    @JsonProperty(value="validation_quorum")
    public Optional<UnsignedInteger> validationQuorum() {
        return Optional.ofNullable(this.validationQuorum);
    }

    @Override
    @JsonProperty(value="network_id")
    public Optional<NetworkId> networkId() {
        return Optional.ofNullable(this.networkId);
    }

    @Override
    @JsonProperty(value="clio_version")
    public String clioVersion() {
        return this.clioVersion;
    }

    @Override
    @JsonProperty(value="rippled_version")
    public Optional<String> rippledVersion() {
        return Optional.ofNullable(this.rippledVersion);
    }

    @SafeVarargs
    public final ImmutableClioServerInfo withCompleteLedgers(Range<UnsignedLong> ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableClioServerInfo((ImmutableList<Range<UnsignedLong>>)newValue, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.clioVersion, this.rippledVersion);
    }

    public final ImmutableClioServerInfo withCompleteLedgers(Iterable<? extends Range<UnsignedLong>> elements) {
        if (this.completeLedgers == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableClioServerInfo((ImmutableList<Range<UnsignedLong>>)newValue, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.clioVersion, this.rippledVersion);
    }

    public final ImmutableClioServerInfo withLoadFactor(BigDecimal value) {
        BigDecimal newValue = Objects.requireNonNull(value, "loadFactor");
        if (Objects.equals(this.loadFactor, newValue)) {
            return this;
        }
        return new ImmutableClioServerInfo(this.completeLedgers, newValue, this.validatedLedger, this.validationQuorum, this.networkId, this.clioVersion, this.rippledVersion);
    }

    public final ImmutableClioServerInfo withLoadFactor(Optional<? extends BigDecimal> optional) {
        BigDecimal value = optional.orElse(null);
        if (Objects.equals(this.loadFactor, value)) {
            return this;
        }
        return new ImmutableClioServerInfo(this.completeLedgers, value, this.validatedLedger, this.validationQuorum, this.networkId, this.clioVersion, this.rippledVersion);
    }

    public final ImmutableClioServerInfo withValidatedLedger(ServerInfo.ValidatedLedger value) {
        ServerInfo.ValidatedLedger newValue = Objects.requireNonNull(value, "validatedLedger");
        if (this.validatedLedger == newValue) {
            return this;
        }
        return new ImmutableClioServerInfo(this.completeLedgers, this.loadFactor, newValue, this.validationQuorum, this.networkId, this.clioVersion, this.rippledVersion);
    }

    public final ImmutableClioServerInfo withValidatedLedger(Optional<? extends ServerInfo.ValidatedLedger> optional) {
        ServerInfo.ValidatedLedger value = optional.orElse(null);
        if (this.validatedLedger == value) {
            return this;
        }
        return new ImmutableClioServerInfo(this.completeLedgers, this.loadFactor, value, this.validationQuorum, this.networkId, this.clioVersion, this.rippledVersion);
    }

    public final ImmutableClioServerInfo withValidationQuorum(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "validationQuorum");
        if (Objects.equals(this.validationQuorum, newValue)) {
            return this;
        }
        return new ImmutableClioServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, newValue, this.networkId, this.clioVersion, this.rippledVersion);
    }

    public final ImmutableClioServerInfo withValidationQuorum(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.validationQuorum, value)) {
            return this;
        }
        return new ImmutableClioServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, value, this.networkId, this.clioVersion, this.rippledVersion);
    }

    public final ImmutableClioServerInfo withNetworkId(NetworkId value) {
        NetworkId newValue = Objects.requireNonNull(value, "networkId");
        if (this.networkId == newValue) {
            return this;
        }
        return new ImmutableClioServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, newValue, this.clioVersion, this.rippledVersion);
    }

    public final ImmutableClioServerInfo withNetworkId(Optional<? extends NetworkId> optional) {
        NetworkId value = optional.orElse(null);
        if (this.networkId == value) {
            return this;
        }
        return new ImmutableClioServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, value, this.clioVersion, this.rippledVersion);
    }

    public final ImmutableClioServerInfo withClioVersion(String value) {
        String newValue = Objects.requireNonNull(value, "clioVersion");
        if (this.clioVersion.equals(newValue)) {
            return this;
        }
        return new ImmutableClioServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, newValue, this.rippledVersion);
    }

    public final ImmutableClioServerInfo withRippledVersion(String value) {
        String newValue = Objects.requireNonNull(value, "rippledVersion");
        if (Objects.equals(this.rippledVersion, newValue)) {
            return this;
        }
        return new ImmutableClioServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.clioVersion, newValue);
    }

    public final ImmutableClioServerInfo withRippledVersion(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.rippledVersion, value)) {
            return this;
        }
        return new ImmutableClioServerInfo(this.completeLedgers, this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.clioVersion, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableClioServerInfo && this.equalTo(0, (ImmutableClioServerInfo)another);
    }

    private boolean equalTo(int synthetic, ImmutableClioServerInfo another) {
        return this.completeLedgers.equals(another.completeLedgers) && Objects.equals(this.loadFactor, another.loadFactor) && Objects.equals(this.validatedLedger, another.validatedLedger) && Objects.equals(this.validationQuorum, another.validationQuorum) && Objects.equals(this.networkId, another.networkId) && this.clioVersion.equals(another.clioVersion) && Objects.equals(this.rippledVersion, another.rippledVersion);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.completeLedgers.hashCode();
        h += (h << 5) + Objects.hashCode(this.loadFactor);
        h += (h << 5) + Objects.hashCode(this.validatedLedger);
        h += (h << 5) + Objects.hashCode(this.validationQuorum);
        h += (h << 5) + Objects.hashCode(this.networkId);
        h += (h << 5) + this.clioVersion.hashCode();
        h += (h << 5) + Objects.hashCode(this.rippledVersion);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ClioServerInfo").omitNullValues().add("completeLedgers", this.completeLedgers).add("loadFactor", (Object)this.loadFactor).add("validatedLedger", (Object)this.validatedLedger).add("validationQuorum", (Object)this.validationQuorum).add("networkId", (Object)this.networkId).add("clioVersion", (Object)this.clioVersion).add("rippledVersion", (Object)this.rippledVersion).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableClioServerInfo fromJson(Json json) {
        Builder builder = ImmutableClioServerInfo.builder();
        if (json.completeLedgers != null) {
            builder.addAllCompleteLedgers(json.completeLedgers);
        }
        if (json.loadFactor != null) {
            builder.loadFactor(json.loadFactor);
        }
        if (json.validatedLedger != null) {
            builder.validatedLedger(json.validatedLedger);
        }
        if (json.validationQuorum != null) {
            builder.validationQuorum(json.validationQuorum);
        }
        if (json.networkId != null) {
            builder.networkId(json.networkId);
        }
        if (json.clioVersion != null) {
            builder.clioVersion(json.clioVersion);
        }
        if (json.rippledVersion != null) {
            builder.rippledVersion(json.rippledVersion);
        }
        return builder.build();
    }

    public static ImmutableClioServerInfo copyOf(ClioServerInfo instance) {
        if (instance instanceof ImmutableClioServerInfo) {
            return (ImmutableClioServerInfo)instance;
        }
        return ImmutableClioServerInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ClioServerInfo", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CLIO_VERSION = 1L;
        private long initBits = 1L;
        private ImmutableList.Builder<Range<UnsignedLong>> completeLedgers = ImmutableList.builder();
        @Nullable
        private BigDecimal loadFactor;
        @Nullable
        private ServerInfo.ValidatedLedger validatedLedger;
        @Nullable
        private UnsignedInteger validationQuorum;
        @Nullable
        private NetworkId networkId;
        @Nullable
        private String clioVersion;
        @Nullable
        private String rippledVersion;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ServerInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ClioServerInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ServerInfo instance;
            long bits = 0L;
            if (object instanceof ServerInfo) {
                instance = (ServerInfo)object;
                if ((bits & 4L) == 0L) {
                    this.addAllCompleteLedgers(instance.completeLedgers());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    Optional<UnsignedInteger> validationQuorumOptional = instance.validationQuorum();
                    if (validationQuorumOptional.isPresent()) {
                        this.validationQuorum(validationQuorumOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    Optional<NetworkId> networkIdOptional = instance.networkId();
                    if (networkIdOptional.isPresent()) {
                        this.networkId(networkIdOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 1L) == 0L) {
                    Optional<BigDecimal> loadFactorOptional = instance.loadFactor();
                    if (loadFactorOptional.isPresent()) {
                        this.loadFactor(loadFactorOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    Optional<ServerInfo.ValidatedLedger> validatedLedgerOptional = instance.validatedLedger();
                    if (validatedLedgerOptional.isPresent()) {
                        this.validatedLedger(validatedLedgerOptional);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof ClioServerInfo) {
                instance = (ClioServerInfo)object;
                Optional<String> rippledVersionOptional = instance.rippledVersion();
                if (rippledVersionOptional.isPresent()) {
                    this.rippledVersion(rippledVersionOptional);
                }
                if ((bits & 1L) == 0L) {
                    Optional<BigDecimal> loadFactorOptional = instance.loadFactor();
                    if (loadFactorOptional.isPresent()) {
                        this.loadFactor(loadFactorOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    Optional<ServerInfo.ValidatedLedger> validatedLedgerOptional = instance.validatedLedger();
                    if (validatedLedgerOptional.isPresent()) {
                        this.validatedLedger(validatedLedgerOptional);
                    }
                    bits |= 2L;
                }
                this.clioVersion(instance.clioVersion());
                if ((bits & 4L) == 0L) {
                    this.addAllCompleteLedgers(instance.completeLedgers());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    Optional<UnsignedInteger> validationQuorumOptional = instance.validationQuorum();
                    if (validationQuorumOptional.isPresent()) {
                        this.validationQuorum(validationQuorumOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    Optional<NetworkId> networkIdOptional = instance.networkId();
                    if (networkIdOptional.isPresent()) {
                        this.networkId(networkIdOptional);
                    }
                    bits |= 0x10L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder addCompleteLedgers(Range<UnsignedLong> element) {
            this.completeLedgers.add(element);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addCompleteLedgers(Range<UnsignedLong> ... elements) {
            this.completeLedgers.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="complete_ledgers")
        @JsonDeserialize(using=ServerInfo.CompleteLedgersDeserializer.class)
        @CanIgnoreReturnValue
        public final Builder completeLedgers(Iterable<? extends Range<UnsignedLong>> elements) {
            this.completeLedgers = ImmutableList.builder();
            return this.addAllCompleteLedgers(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCompleteLedgers(Iterable<? extends Range<UnsignedLong>> elements) {
            this.completeLedgers.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder loadFactor(BigDecimal loadFactor) {
            this.loadFactor = Objects.requireNonNull(loadFactor, "loadFactor");
            return this;
        }

        @JsonProperty(value="load_factor")
        @CanIgnoreReturnValue
        public final Builder loadFactor(Optional<? extends BigDecimal> loadFactor) {
            this.loadFactor = loadFactor.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder validatedLedger(ServerInfo.ValidatedLedger validatedLedger) {
            this.validatedLedger = Objects.requireNonNull(validatedLedger, "validatedLedger");
            return this;
        }

        @JsonProperty(value="validated_ledger")
        @CanIgnoreReturnValue
        public final Builder validatedLedger(Optional<? extends ServerInfo.ValidatedLedger> validatedLedger) {
            this.validatedLedger = validatedLedger.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder validationQuorum(UnsignedInteger validationQuorum) {
            this.validationQuorum = Objects.requireNonNull(validationQuorum, "validationQuorum");
            return this;
        }

        @JsonProperty(value="validation_quorum")
        @CanIgnoreReturnValue
        public final Builder validationQuorum(Optional<? extends UnsignedInteger> validationQuorum) {
            this.validationQuorum = validationQuorum.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder networkId(NetworkId networkId) {
            this.networkId = Objects.requireNonNull(networkId, "networkId");
            return this;
        }

        @JsonProperty(value="network_id")
        @CanIgnoreReturnValue
        public final Builder networkId(Optional<? extends NetworkId> networkId) {
            this.networkId = networkId.orElse(null);
            return this;
        }

        @JsonProperty(value="clio_version")
        @CanIgnoreReturnValue
        public final Builder clioVersion(String clioVersion) {
            this.clioVersion = Objects.requireNonNull(clioVersion, "clioVersion");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rippledVersion(String rippledVersion) {
            this.rippledVersion = Objects.requireNonNull(rippledVersion, "rippledVersion");
            return this;
        }

        @JsonProperty(value="rippled_version")
        @CanIgnoreReturnValue
        public final Builder rippledVersion(Optional<String> rippledVersion) {
            this.rippledVersion = rippledVersion.orElse(null);
            return this;
        }

        public ImmutableClioServerInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableClioServerInfo(this.completeLedgers.build(), this.loadFactor, this.validatedLedger, this.validationQuorum, this.networkId, this.clioVersion, this.rippledVersion);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("clioVersion");
            }
            return "Cannot build ClioServerInfo, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ClioServerInfo", generator="Immutables")
    static final class Json
    implements ClioServerInfo {
        @Nullable
        List<Range<UnsignedLong>> completeLedgers = ImmutableList.of();
        @Nullable
        Optional<BigDecimal> loadFactor = Optional.empty();
        @Nullable
        Optional<ServerInfo.ValidatedLedger> validatedLedger = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> validationQuorum = Optional.empty();
        @Nullable
        Optional<NetworkId> networkId = Optional.empty();
        @Nullable
        String clioVersion;
        @Nullable
        Optional<String> rippledVersion = Optional.empty();

        Json() {
        }

        @JsonProperty(value="complete_ledgers")
        @JsonDeserialize(using=ServerInfo.CompleteLedgersDeserializer.class)
        public void setCompleteLedgers(List<Range<UnsignedLong>> completeLedgers) {
            this.completeLedgers = completeLedgers;
        }

        @JsonProperty(value="load_factor")
        public void setLoadFactor(Optional<BigDecimal> loadFactor) {
            this.loadFactor = loadFactor;
        }

        @JsonProperty(value="validated_ledger")
        public void setValidatedLedger(Optional<ServerInfo.ValidatedLedger> validatedLedger) {
            this.validatedLedger = validatedLedger;
        }

        @JsonProperty(value="validation_quorum")
        public void setValidationQuorum(Optional<UnsignedInteger> validationQuorum) {
            this.validationQuorum = validationQuorum;
        }

        @JsonProperty(value="network_id")
        public void setNetworkId(Optional<NetworkId> networkId) {
            this.networkId = networkId;
        }

        @JsonProperty(value="clio_version")
        public void setClioVersion(String clioVersion) {
            this.clioVersion = clioVersion;
        }

        @JsonProperty(value="rippled_version")
        public void setRippledVersion(Optional<String> rippledVersion) {
            this.rippledVersion = rippledVersion;
        }

        @Override
        public List<Range<UnsignedLong>> completeLedgers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<BigDecimal> loadFactor() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ServerInfo.ValidatedLedger> validatedLedger() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> validationQuorum() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<NetworkId> networkId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String clioVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> rippledVersion() {
            throw new UnsupportedOperationException();
        }
    }
}

