/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.path;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.path.PathCurrency;
import org.xrpl.xrpl4j.model.transactions.Address;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PathCurrency", generator="Immutables")
@Immutable
public final class ImmutablePathCurrency
implements PathCurrency {
    private final String currency;
    @Nullable
    private final Address issuer;

    private ImmutablePathCurrency(String currency, @Nullable Address issuer) {
        this.currency = currency;
        this.issuer = issuer;
    }

    @Override
    @JsonProperty(value="currency")
    public String currency() {
        return this.currency;
    }

    @Override
    @JsonProperty(value="issuer")
    public Optional<Address> issuer() {
        return Optional.ofNullable(this.issuer);
    }

    public final ImmutablePathCurrency withCurrency(String value) {
        String newValue = Objects.requireNonNull(value, "currency");
        if (this.currency.equals(newValue)) {
            return this;
        }
        return new ImmutablePathCurrency(newValue, this.issuer);
    }

    public final ImmutablePathCurrency withIssuer(Address value) {
        Address newValue = Objects.requireNonNull(value, "issuer");
        if (this.issuer == newValue) {
            return this;
        }
        return new ImmutablePathCurrency(this.currency, newValue);
    }

    public final ImmutablePathCurrency withIssuer(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.issuer == value) {
            return this;
        }
        return new ImmutablePathCurrency(this.currency, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePathCurrency && this.equalTo(0, (ImmutablePathCurrency)another);
    }

    private boolean equalTo(int synthetic, ImmutablePathCurrency another) {
        return this.currency.equals(another.currency) && Objects.equals(this.issuer, another.issuer);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.currency.hashCode();
        h += (h << 5) + Objects.hashCode(this.issuer);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PathCurrency").omitNullValues().add("currency", (Object)this.currency).add("issuer", (Object)this.issuer).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePathCurrency fromJson(Json json) {
        Builder builder = ImmutablePathCurrency.builder();
        if (json.currency != null) {
            builder.currency(json.currency);
        }
        if (json.issuer != null) {
            builder.issuer(json.issuer);
        }
        return builder.build();
    }

    public static ImmutablePathCurrency copyOf(PathCurrency instance) {
        if (instance instanceof ImmutablePathCurrency) {
            return (ImmutablePathCurrency)instance;
        }
        return ImmutablePathCurrency.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PathCurrency", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CURRENCY = 1L;
        private long initBits = 1L;
        @Nullable
        private String currency;
        @Nullable
        private Address issuer;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PathCurrency instance) {
            Objects.requireNonNull(instance, "instance");
            this.currency(instance.currency());
            Optional<Address> issuerOptional = instance.issuer();
            if (issuerOptional.isPresent()) {
                this.issuer(issuerOptional);
            }
            return this;
        }

        @JsonProperty(value="currency")
        @CanIgnoreReturnValue
        public final Builder currency(String currency) {
            this.currency = Objects.requireNonNull(currency, "currency");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder issuer(Address issuer) {
            this.issuer = Objects.requireNonNull(issuer, "issuer");
            return this;
        }

        @JsonProperty(value="issuer")
        @CanIgnoreReturnValue
        public final Builder issuer(Optional<? extends Address> issuer) {
            this.issuer = issuer.orElse(null);
            return this;
        }

        public ImmutablePathCurrency build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePathCurrency(this.currency, this.issuer);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("currency");
            }
            return "Cannot build PathCurrency, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PathCurrency", generator="Immutables")
    static final class Json
    implements PathCurrency {
        @Nullable
        String currency;
        @Nullable
        Optional<Address> issuer = Optional.empty();

        Json() {
        }

        @JsonProperty(value="currency")
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @JsonProperty(value="issuer")
        public void setIssuer(Optional<Address> issuer) {
            this.issuer = issuer;
        }

        @Override
        public String currency() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Address> issuer() {
            throw new UnsupportedOperationException();
        }
    }
}

