/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.path;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.XrplResult;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.client.path.DepositAuthorizedResult;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DepositAuthorizedResult", generator="Immutables")
@Immutable
public final class ImmutableDepositAuthorizedResult
implements DepositAuthorizedResult {
    @Nullable
    private final String status;
    private final Address sourceAccount;
    private final Address destinationAccount;
    private final boolean depositAuthorized;
    @Nullable
    private final Hash256 ledgerHash;
    @Nullable
    private final LedgerIndex ledgerIndex;
    @Nullable
    private final LedgerIndex ledgerCurrentIndex;
    private final boolean validated;

    private ImmutableDepositAuthorizedResult(Builder builder) {
        this.status = builder.status;
        this.sourceAccount = builder.sourceAccount;
        this.destinationAccount = builder.destinationAccount;
        this.depositAuthorized = builder.depositAuthorized;
        this.ledgerHash = builder.ledgerHash;
        this.ledgerIndex = builder.ledgerIndex;
        this.ledgerCurrentIndex = builder.ledgerCurrentIndex;
        this.validated = builder.validatedIsSet() ? builder.validated : DepositAuthorizedResult.super.validated();
    }

    private ImmutableDepositAuthorizedResult(@Nullable String status, Address sourceAccount, Address destinationAccount, boolean depositAuthorized, @Nullable Hash256 ledgerHash, @Nullable LedgerIndex ledgerIndex, @Nullable LedgerIndex ledgerCurrentIndex, boolean validated) {
        this.status = status;
        this.sourceAccount = sourceAccount;
        this.destinationAccount = destinationAccount;
        this.depositAuthorized = depositAuthorized;
        this.ledgerHash = ledgerHash;
        this.ledgerIndex = ledgerIndex;
        this.ledgerCurrentIndex = ledgerCurrentIndex;
        this.validated = validated;
    }

    @Override
    @JsonProperty(value="status")
    public Optional<String> status() {
        return Optional.ofNullable(this.status);
    }

    @Override
    @JsonProperty(value="source_account")
    public Address sourceAccount() {
        return this.sourceAccount;
    }

    @Override
    @JsonProperty(value="destination_account")
    public Address destinationAccount() {
        return this.destinationAccount;
    }

    @Override
    @JsonProperty(value="deposit_authorized")
    public boolean depositAuthorized() {
        return this.depositAuthorized;
    }

    @Override
    @JsonProperty(value="ledger_hash")
    public Optional<Hash256> ledgerHash() {
        return Optional.ofNullable(this.ledgerHash);
    }

    @Override
    @JsonProperty(value="ledger_index")
    public Optional<LedgerIndex> ledgerIndex() {
        return Optional.ofNullable(this.ledgerIndex);
    }

    @Override
    @JsonProperty(value="ledger_current_index")
    public Optional<LedgerIndex> ledgerCurrentIndex() {
        return Optional.ofNullable(this.ledgerCurrentIndex);
    }

    @Override
    @JsonProperty(value="validated")
    public boolean validated() {
        return this.validated;
    }

    public final ImmutableDepositAuthorizedResult withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (Objects.equals(this.status, newValue)) {
            return this;
        }
        return new ImmutableDepositAuthorizedResult(newValue, this.sourceAccount, this.destinationAccount, this.depositAuthorized, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, this.validated);
    }

    public final ImmutableDepositAuthorizedResult withStatus(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.status, value)) {
            return this;
        }
        return new ImmutableDepositAuthorizedResult(value, this.sourceAccount, this.destinationAccount, this.depositAuthorized, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, this.validated);
    }

    public final ImmutableDepositAuthorizedResult withSourceAccount(Address value) {
        if (this.sourceAccount == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "sourceAccount");
        return new ImmutableDepositAuthorizedResult(this.status, newValue, this.destinationAccount, this.depositAuthorized, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, this.validated);
    }

    public final ImmutableDepositAuthorizedResult withDestinationAccount(Address value) {
        if (this.destinationAccount == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "destinationAccount");
        return new ImmutableDepositAuthorizedResult(this.status, this.sourceAccount, newValue, this.depositAuthorized, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, this.validated);
    }

    public final ImmutableDepositAuthorizedResult withDepositAuthorized(boolean value) {
        if (this.depositAuthorized == value) {
            return this;
        }
        return new ImmutableDepositAuthorizedResult(this.status, this.sourceAccount, this.destinationAccount, value, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, this.validated);
    }

    public final ImmutableDepositAuthorizedResult withLedgerHash(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "ledgerHash");
        if (this.ledgerHash == newValue) {
            return this;
        }
        return new ImmutableDepositAuthorizedResult(this.status, this.sourceAccount, this.destinationAccount, this.depositAuthorized, newValue, this.ledgerIndex, this.ledgerCurrentIndex, this.validated);
    }

    public final ImmutableDepositAuthorizedResult withLedgerHash(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.ledgerHash == value) {
            return this;
        }
        return new ImmutableDepositAuthorizedResult(this.status, this.sourceAccount, this.destinationAccount, this.depositAuthorized, value, this.ledgerIndex, this.ledgerCurrentIndex, this.validated);
    }

    public final ImmutableDepositAuthorizedResult withLedgerIndex(LedgerIndex value) {
        LedgerIndex newValue = Objects.requireNonNull(value, "ledgerIndex");
        if (this.ledgerIndex == newValue) {
            return this;
        }
        return new ImmutableDepositAuthorizedResult(this.status, this.sourceAccount, this.destinationAccount, this.depositAuthorized, this.ledgerHash, newValue, this.ledgerCurrentIndex, this.validated);
    }

    public final ImmutableDepositAuthorizedResult withLedgerIndex(Optional<? extends LedgerIndex> optional) {
        LedgerIndex value = optional.orElse(null);
        if (this.ledgerIndex == value) {
            return this;
        }
        return new ImmutableDepositAuthorizedResult(this.status, this.sourceAccount, this.destinationAccount, this.depositAuthorized, this.ledgerHash, value, this.ledgerCurrentIndex, this.validated);
    }

    public final ImmutableDepositAuthorizedResult withLedgerCurrentIndex(LedgerIndex value) {
        LedgerIndex newValue = Objects.requireNonNull(value, "ledgerCurrentIndex");
        if (this.ledgerCurrentIndex == newValue) {
            return this;
        }
        return new ImmutableDepositAuthorizedResult(this.status, this.sourceAccount, this.destinationAccount, this.depositAuthorized, this.ledgerHash, this.ledgerIndex, newValue, this.validated);
    }

    public final ImmutableDepositAuthorizedResult withLedgerCurrentIndex(Optional<? extends LedgerIndex> optional) {
        LedgerIndex value = optional.orElse(null);
        if (this.ledgerCurrentIndex == value) {
            return this;
        }
        return new ImmutableDepositAuthorizedResult(this.status, this.sourceAccount, this.destinationAccount, this.depositAuthorized, this.ledgerHash, this.ledgerIndex, value, this.validated);
    }

    public final ImmutableDepositAuthorizedResult withValidated(boolean value) {
        if (this.validated == value) {
            return this;
        }
        return new ImmutableDepositAuthorizedResult(this.status, this.sourceAccount, this.destinationAccount, this.depositAuthorized, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDepositAuthorizedResult && this.equalTo(0, (ImmutableDepositAuthorizedResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableDepositAuthorizedResult another) {
        return Objects.equals(this.status, another.status) && this.sourceAccount.equals(another.sourceAccount) && this.destinationAccount.equals(another.destinationAccount) && this.depositAuthorized == another.depositAuthorized && Objects.equals(this.ledgerHash, another.ledgerHash) && Objects.equals(this.ledgerIndex, another.ledgerIndex) && Objects.equals(this.ledgerCurrentIndex, another.ledgerCurrentIndex) && this.validated == another.validated;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + this.sourceAccount.hashCode();
        h += (h << 5) + this.destinationAccount.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.depositAuthorized);
        h += (h << 5) + Objects.hashCode(this.ledgerHash);
        h += (h << 5) + Objects.hashCode(this.ledgerIndex);
        h += (h << 5) + Objects.hashCode(this.ledgerCurrentIndex);
        h += (h << 5) + Booleans.hashCode((boolean)this.validated);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DepositAuthorizedResult").omitNullValues().add("status", (Object)this.status).add("sourceAccount", (Object)this.sourceAccount).add("destinationAccount", (Object)this.destinationAccount).add("depositAuthorized", this.depositAuthorized).add("ledgerHash", (Object)this.ledgerHash).add("ledgerIndex", (Object)this.ledgerIndex).add("ledgerCurrentIndex", (Object)this.ledgerCurrentIndex).add("validated", this.validated).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDepositAuthorizedResult fromJson(Json json) {
        Builder builder = ImmutableDepositAuthorizedResult.builder();
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.sourceAccount != null) {
            builder.sourceAccount(json.sourceAccount);
        }
        if (json.destinationAccount != null) {
            builder.destinationAccount(json.destinationAccount);
        }
        if (json.depositAuthorizedIsSet) {
            builder.depositAuthorized(json.depositAuthorized);
        }
        if (json.ledgerHash != null) {
            builder.ledgerHash(json.ledgerHash);
        }
        if (json.ledgerIndex != null) {
            builder.ledgerIndex(json.ledgerIndex);
        }
        if (json.ledgerCurrentIndex != null) {
            builder.ledgerCurrentIndex(json.ledgerCurrentIndex);
        }
        if (json.validatedIsSet) {
            builder.validated(json.validated);
        }
        return builder.build();
    }

    public static ImmutableDepositAuthorizedResult copyOf(DepositAuthorizedResult instance) {
        if (instance instanceof ImmutableDepositAuthorizedResult) {
            return (ImmutableDepositAuthorizedResult)instance;
        }
        return ImmutableDepositAuthorizedResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DepositAuthorizedResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SOURCE_ACCOUNT = 1L;
        private static final long INIT_BIT_DESTINATION_ACCOUNT = 2L;
        private static final long INIT_BIT_DEPOSIT_AUTHORIZED = 4L;
        private static final long OPT_BIT_VALIDATED = 1L;
        private long initBits = 7L;
        private long optBits;
        @Nullable
        private String status;
        @Nullable
        private Address sourceAccount;
        @Nullable
        private Address destinationAccount;
        private boolean depositAuthorized;
        @Nullable
        private Hash256 ledgerHash;
        @Nullable
        private LedgerIndex ledgerIndex;
        @Nullable
        private LedgerIndex ledgerCurrentIndex;
        private boolean validated;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DepositAuthorizedResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(XrplResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            XrplResult instance;
            long bits = 0L;
            if (object instanceof DepositAuthorizedResult) {
                instance = (DepositAuthorizedResult)object;
                this.depositAuthorized(instance.depositAuthorized());
                Optional<Hash256> ledgerHashOptional = instance.ledgerHash();
                if (ledgerHashOptional.isPresent()) {
                    this.ledgerHash(ledgerHashOptional);
                }
                this.sourceAccount(instance.sourceAccount());
                this.validated(instance.validated());
                Optional<LedgerIndex> ledgerIndexOptional = instance.ledgerIndex();
                if (ledgerIndexOptional.isPresent()) {
                    this.ledgerIndex(ledgerIndexOptional);
                }
                this.destinationAccount(instance.destinationAccount());
                Optional<LedgerIndex> ledgerCurrentIndexOptional = instance.ledgerCurrentIndex();
                if (ledgerCurrentIndexOptional.isPresent()) {
                    this.ledgerCurrentIndex(ledgerCurrentIndexOptional);
                }
                if ((bits & 1L) == 0L) {
                    Optional<String> statusOptional = instance.status();
                    if (statusOptional.isPresent()) {
                        this.status(statusOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof XrplResult) {
                instance = (XrplResult)object;
                if ((bits & 1L) == 0L) {
                    Optional<String> statusOptional = instance.status();
                    if (statusOptional.isPresent()) {
                        this.status(statusOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder status(String status) {
            this.status = Objects.requireNonNull(status, "status");
            return this;
        }

        @JsonProperty(value="status")
        @CanIgnoreReturnValue
        public final Builder status(Optional<String> status) {
            this.status = status.orElse(null);
            return this;
        }

        @JsonProperty(value="source_account")
        @CanIgnoreReturnValue
        public final Builder sourceAccount(Address sourceAccount) {
            this.sourceAccount = Objects.requireNonNull(sourceAccount, "sourceAccount");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="destination_account")
        @CanIgnoreReturnValue
        public final Builder destinationAccount(Address destinationAccount) {
            this.destinationAccount = Objects.requireNonNull(destinationAccount, "destinationAccount");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="deposit_authorized")
        @CanIgnoreReturnValue
        public final Builder depositAuthorized(boolean depositAuthorized) {
            this.depositAuthorized = depositAuthorized;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ledgerHash(Hash256 ledgerHash) {
            this.ledgerHash = Objects.requireNonNull(ledgerHash, "ledgerHash");
            return this;
        }

        @JsonProperty(value="ledger_hash")
        @CanIgnoreReturnValue
        public final Builder ledgerHash(Optional<? extends Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ledgerIndex(LedgerIndex ledgerIndex) {
            this.ledgerIndex = Objects.requireNonNull(ledgerIndex, "ledgerIndex");
            return this;
        }

        @JsonProperty(value="ledger_index")
        @CanIgnoreReturnValue
        public final Builder ledgerIndex(Optional<? extends LedgerIndex> ledgerIndex) {
            this.ledgerIndex = ledgerIndex.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ledgerCurrentIndex(LedgerIndex ledgerCurrentIndex) {
            this.ledgerCurrentIndex = Objects.requireNonNull(ledgerCurrentIndex, "ledgerCurrentIndex");
            return this;
        }

        @JsonProperty(value="ledger_current_index")
        @CanIgnoreReturnValue
        public final Builder ledgerCurrentIndex(Optional<? extends LedgerIndex> ledgerCurrentIndex) {
            this.ledgerCurrentIndex = ledgerCurrentIndex.orElse(null);
            return this;
        }

        @JsonProperty(value="validated")
        @CanIgnoreReturnValue
        public final Builder validated(boolean validated) {
            this.validated = validated;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableDepositAuthorizedResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDepositAuthorizedResult(this);
        }

        private boolean validatedIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sourceAccount");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("destinationAccount");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("depositAuthorized");
            }
            return "Cannot build DepositAuthorizedResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DepositAuthorizedResult", generator="Immutables")
    static final class Json
    implements DepositAuthorizedResult {
        @Nullable
        Optional<String> status = Optional.empty();
        @Nullable
        Address sourceAccount;
        @Nullable
        Address destinationAccount;
        boolean depositAuthorized;
        boolean depositAuthorizedIsSet;
        @Nullable
        Optional<Hash256> ledgerHash = Optional.empty();
        @Nullable
        Optional<LedgerIndex> ledgerIndex = Optional.empty();
        @Nullable
        Optional<LedgerIndex> ledgerCurrentIndex = Optional.empty();
        boolean validated;
        boolean validatedIsSet;

        Json() {
        }

        @JsonProperty(value="status")
        public void setStatus(Optional<String> status) {
            this.status = status;
        }

        @JsonProperty(value="source_account")
        public void setSourceAccount(Address sourceAccount) {
            this.sourceAccount = sourceAccount;
        }

        @JsonProperty(value="destination_account")
        public void setDestinationAccount(Address destinationAccount) {
            this.destinationAccount = destinationAccount;
        }

        @JsonProperty(value="deposit_authorized")
        public void setDepositAuthorized(boolean depositAuthorized) {
            this.depositAuthorized = depositAuthorized;
            this.depositAuthorizedIsSet = true;
        }

        @JsonProperty(value="ledger_hash")
        public void setLedgerHash(Optional<Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash;
        }

        @JsonProperty(value="ledger_index")
        public void setLedgerIndex(Optional<LedgerIndex> ledgerIndex) {
            this.ledgerIndex = ledgerIndex;
        }

        @JsonProperty(value="ledger_current_index")
        public void setLedgerCurrentIndex(Optional<LedgerIndex> ledgerCurrentIndex) {
            this.ledgerCurrentIndex = ledgerCurrentIndex;
        }

        @JsonProperty(value="validated")
        public void setValidated(boolean validated) {
            this.validated = validated;
            this.validatedIsSet = true;
        }

        @Override
        public Optional<String> status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address sourceAccount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address destinationAccount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean depositAuthorized() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> ledgerHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerIndex> ledgerIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerIndex> ledgerCurrentIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean validated() {
            throw new UnsupportedOperationException();
        }
    }
}

