/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.path;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.common.LedgerSpecifier;
import org.xrpl.xrpl4j.model.client.path.DepositAuthorizedRequestParams;
import org.xrpl.xrpl4j.model.transactions.Address;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DepositAuthorizedRequestParams", generator="Immutables")
@Immutable
public final class ImmutableDepositAuthorizedRequestParams
implements DepositAuthorizedRequestParams {
    private final Address sourceAccount;
    private final Address destinationAccount;
    private final LedgerSpecifier ledgerSpecifier;

    private ImmutableDepositAuthorizedRequestParams(Builder builder) {
        this.sourceAccount = builder.sourceAccount;
        this.destinationAccount = builder.destinationAccount;
        this.ledgerSpecifier = builder.ledgerSpecifier != null ? builder.ledgerSpecifier : Objects.requireNonNull(DepositAuthorizedRequestParams.super.ledgerSpecifier(), "ledgerSpecifier");
    }

    private ImmutableDepositAuthorizedRequestParams(Address sourceAccount, Address destinationAccount, LedgerSpecifier ledgerSpecifier) {
        this.sourceAccount = sourceAccount;
        this.destinationAccount = destinationAccount;
        this.ledgerSpecifier = ledgerSpecifier;
    }

    @Override
    @JsonProperty(value="source_account")
    public Address sourceAccount() {
        return this.sourceAccount;
    }

    @Override
    @JsonProperty(value="destination_account")
    public Address destinationAccount() {
        return this.destinationAccount;
    }

    @Override
    @JsonProperty(value="ledgerSpecifier")
    @JsonUnwrapped
    public LedgerSpecifier ledgerSpecifier() {
        return this.ledgerSpecifier;
    }

    public final ImmutableDepositAuthorizedRequestParams withSourceAccount(Address value) {
        if (this.sourceAccount == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "sourceAccount");
        return new ImmutableDepositAuthorizedRequestParams(newValue, this.destinationAccount, this.ledgerSpecifier);
    }

    public final ImmutableDepositAuthorizedRequestParams withDestinationAccount(Address value) {
        if (this.destinationAccount == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "destinationAccount");
        return new ImmutableDepositAuthorizedRequestParams(this.sourceAccount, newValue, this.ledgerSpecifier);
    }

    public final ImmutableDepositAuthorizedRequestParams withLedgerSpecifier(LedgerSpecifier value) {
        if (this.ledgerSpecifier == value) {
            return this;
        }
        LedgerSpecifier newValue = Objects.requireNonNull(value, "ledgerSpecifier");
        return new ImmutableDepositAuthorizedRequestParams(this.sourceAccount, this.destinationAccount, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDepositAuthorizedRequestParams && this.equalTo(0, (ImmutableDepositAuthorizedRequestParams)another);
    }

    private boolean equalTo(int synthetic, ImmutableDepositAuthorizedRequestParams another) {
        return this.sourceAccount.equals(another.sourceAccount) && this.destinationAccount.equals(another.destinationAccount) && this.ledgerSpecifier.equals(another.ledgerSpecifier);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.sourceAccount.hashCode();
        h += (h << 5) + this.destinationAccount.hashCode();
        h += (h << 5) + this.ledgerSpecifier.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DepositAuthorizedRequestParams").omitNullValues().add("sourceAccount", (Object)this.sourceAccount).add("destinationAccount", (Object)this.destinationAccount).add("ledgerSpecifier", (Object)this.ledgerSpecifier).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDepositAuthorizedRequestParams fromJson(Json json) {
        Builder builder = ImmutableDepositAuthorizedRequestParams.builder();
        if (json.sourceAccount != null) {
            builder.sourceAccount(json.sourceAccount);
        }
        if (json.destinationAccount != null) {
            builder.destinationAccount(json.destinationAccount);
        }
        if (json.ledgerSpecifier != null) {
            builder.ledgerSpecifier(json.ledgerSpecifier);
        }
        return builder.build();
    }

    public static ImmutableDepositAuthorizedRequestParams copyOf(DepositAuthorizedRequestParams instance) {
        if (instance instanceof ImmutableDepositAuthorizedRequestParams) {
            return (ImmutableDepositAuthorizedRequestParams)instance;
        }
        return ImmutableDepositAuthorizedRequestParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DepositAuthorizedRequestParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SOURCE_ACCOUNT = 1L;
        private static final long INIT_BIT_DESTINATION_ACCOUNT = 2L;
        private long initBits = 3L;
        @Nullable
        private Address sourceAccount;
        @Nullable
        private Address destinationAccount;
        @Nullable
        private LedgerSpecifier ledgerSpecifier;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DepositAuthorizedRequestParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.sourceAccount(instance.sourceAccount());
            this.destinationAccount(instance.destinationAccount());
            this.ledgerSpecifier(instance.ledgerSpecifier());
            return this;
        }

        @JsonProperty(value="source_account")
        @CanIgnoreReturnValue
        public final Builder sourceAccount(Address sourceAccount) {
            this.sourceAccount = Objects.requireNonNull(sourceAccount, "sourceAccount");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="destination_account")
        @CanIgnoreReturnValue
        public final Builder destinationAccount(Address destinationAccount) {
            this.destinationAccount = Objects.requireNonNull(destinationAccount, "destinationAccount");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="ledgerSpecifier")
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder ledgerSpecifier(LedgerSpecifier ledgerSpecifier) {
            this.ledgerSpecifier = Objects.requireNonNull(ledgerSpecifier, "ledgerSpecifier");
            return this;
        }

        public ImmutableDepositAuthorizedRequestParams build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDepositAuthorizedRequestParams(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sourceAccount");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("destinationAccount");
            }
            return "Cannot build DepositAuthorizedRequestParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DepositAuthorizedRequestParams", generator="Immutables")
    static final class Json
    implements DepositAuthorizedRequestParams {
        @Nullable
        Address sourceAccount;
        @Nullable
        Address destinationAccount;
        @Nullable
        LedgerSpecifier ledgerSpecifier;

        Json() {
        }

        @JsonProperty(value="source_account")
        public void setSourceAccount(Address sourceAccount) {
            this.sourceAccount = sourceAccount;
        }

        @JsonProperty(value="destination_account")
        public void setDestinationAccount(Address destinationAccount) {
            this.destinationAccount = destinationAccount;
        }

        @JsonProperty(value="ledgerSpecifier")
        @JsonUnwrapped
        public void setLedgerSpecifier(LedgerSpecifier ledgerSpecifier) {
            this.ledgerSpecifier = ledgerSpecifier;
        }

        @Override
        public Address sourceAccount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address destinationAccount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LedgerSpecifier ledgerSpecifier() {
            throw new UnsupportedOperationException();
        }
    }
}

