/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.path;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.XrplResult;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.client.path.BookOffersOffer;
import org.xrpl.xrpl4j.model.client.path.BookOffersResult;
import org.xrpl.xrpl4j.model.transactions.Hash256;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="BookOffersResult", generator="Immutables")
@Immutable
public final class ImmutableBookOffersResult
implements BookOffersResult {
    @Nullable
    private final String status;
    private final ImmutableList<BookOffersOffer> offers;
    @Nullable
    private final Hash256 ledgerHash;
    @Nullable
    private final LedgerIndex ledgerIndex;
    @Nullable
    private final LedgerIndex ledgerCurrentIndex;

    private ImmutableBookOffersResult(@Nullable String status, ImmutableList<BookOffersOffer> offers, @Nullable Hash256 ledgerHash, @Nullable LedgerIndex ledgerIndex, @Nullable LedgerIndex ledgerCurrentIndex) {
        this.status = status;
        this.offers = offers;
        this.ledgerHash = ledgerHash;
        this.ledgerIndex = ledgerIndex;
        this.ledgerCurrentIndex = ledgerCurrentIndex;
    }

    @Override
    @JsonProperty(value="status")
    public Optional<String> status() {
        return Optional.ofNullable(this.status);
    }

    @JsonProperty(value="offers")
    public ImmutableList<BookOffersOffer> offers() {
        return this.offers;
    }

    @Override
    @JsonProperty(value="ledger_hash")
    public Optional<Hash256> ledgerHash() {
        return Optional.ofNullable(this.ledgerHash);
    }

    @Override
    @JsonProperty(value="ledger_index")
    public Optional<LedgerIndex> ledgerIndex() {
        return Optional.ofNullable(this.ledgerIndex);
    }

    @Override
    @JsonProperty(value="ledger_current_index")
    public Optional<LedgerIndex> ledgerCurrentIndex() {
        return Optional.ofNullable(this.ledgerCurrentIndex);
    }

    public final ImmutableBookOffersResult withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (Objects.equals(this.status, newValue)) {
            return this;
        }
        return new ImmutableBookOffersResult(newValue, this.offers, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex);
    }

    public final ImmutableBookOffersResult withStatus(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.status, value)) {
            return this;
        }
        return new ImmutableBookOffersResult(value, this.offers, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex);
    }

    public final ImmutableBookOffersResult withOffers(BookOffersOffer ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableBookOffersResult(this.status, (ImmutableList<BookOffersOffer>)newValue, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex);
    }

    public final ImmutableBookOffersResult withOffers(Iterable<? extends BookOffersOffer> elements) {
        if (this.offers == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableBookOffersResult(this.status, (ImmutableList<BookOffersOffer>)newValue, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex);
    }

    public final ImmutableBookOffersResult withLedgerHash(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "ledgerHash");
        if (this.ledgerHash == newValue) {
            return this;
        }
        return new ImmutableBookOffersResult(this.status, this.offers, newValue, this.ledgerIndex, this.ledgerCurrentIndex);
    }

    public final ImmutableBookOffersResult withLedgerHash(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.ledgerHash == value) {
            return this;
        }
        return new ImmutableBookOffersResult(this.status, this.offers, value, this.ledgerIndex, this.ledgerCurrentIndex);
    }

    public final ImmutableBookOffersResult withLedgerIndex(LedgerIndex value) {
        LedgerIndex newValue = Objects.requireNonNull(value, "ledgerIndex");
        if (this.ledgerIndex == newValue) {
            return this;
        }
        return new ImmutableBookOffersResult(this.status, this.offers, this.ledgerHash, newValue, this.ledgerCurrentIndex);
    }

    public final ImmutableBookOffersResult withLedgerIndex(Optional<? extends LedgerIndex> optional) {
        LedgerIndex value = optional.orElse(null);
        if (this.ledgerIndex == value) {
            return this;
        }
        return new ImmutableBookOffersResult(this.status, this.offers, this.ledgerHash, value, this.ledgerCurrentIndex);
    }

    public final ImmutableBookOffersResult withLedgerCurrentIndex(LedgerIndex value) {
        LedgerIndex newValue = Objects.requireNonNull(value, "ledgerCurrentIndex");
        if (this.ledgerCurrentIndex == newValue) {
            return this;
        }
        return new ImmutableBookOffersResult(this.status, this.offers, this.ledgerHash, this.ledgerIndex, newValue);
    }

    public final ImmutableBookOffersResult withLedgerCurrentIndex(Optional<? extends LedgerIndex> optional) {
        LedgerIndex value = optional.orElse(null);
        if (this.ledgerCurrentIndex == value) {
            return this;
        }
        return new ImmutableBookOffersResult(this.status, this.offers, this.ledgerHash, this.ledgerIndex, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBookOffersResult && this.equalTo(0, (ImmutableBookOffersResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableBookOffersResult another) {
        return Objects.equals(this.status, another.status) && this.offers.equals(another.offers) && Objects.equals(this.ledgerHash, another.ledgerHash) && Objects.equals(this.ledgerIndex, another.ledgerIndex) && Objects.equals(this.ledgerCurrentIndex, another.ledgerCurrentIndex);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + this.offers.hashCode();
        h += (h << 5) + Objects.hashCode(this.ledgerHash);
        h += (h << 5) + Objects.hashCode(this.ledgerIndex);
        h += (h << 5) + Objects.hashCode(this.ledgerCurrentIndex);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"BookOffersResult").omitNullValues().add("status", (Object)this.status).add("offers", this.offers).add("ledgerHash", (Object)this.ledgerHash).add("ledgerIndex", (Object)this.ledgerIndex).add("ledgerCurrentIndex", (Object)this.ledgerCurrentIndex).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableBookOffersResult fromJson(Json json) {
        Builder builder = ImmutableBookOffersResult.builder();
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.offers != null) {
            builder.addAllOffers(json.offers);
        }
        if (json.ledgerHash != null) {
            builder.ledgerHash(json.ledgerHash);
        }
        if (json.ledgerIndex != null) {
            builder.ledgerIndex(json.ledgerIndex);
        }
        if (json.ledgerCurrentIndex != null) {
            builder.ledgerCurrentIndex(json.ledgerCurrentIndex);
        }
        return builder.build();
    }

    public static ImmutableBookOffersResult copyOf(BookOffersResult instance) {
        if (instance instanceof ImmutableBookOffersResult) {
            return (ImmutableBookOffersResult)instance;
        }
        return ImmutableBookOffersResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BookOffersResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String status;
        private ImmutableList.Builder<BookOffersOffer> offers = ImmutableList.builder();
        @Nullable
        private Hash256 ledgerHash;
        @Nullable
        private LedgerIndex ledgerIndex;
        @Nullable
        private LedgerIndex ledgerCurrentIndex;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BookOffersResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(XrplResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            XrplResult instance;
            long bits = 0L;
            if (object instanceof BookOffersResult) {
                Optional<LedgerIndex> ledgerCurrentIndexOptional;
                Optional<LedgerIndex> ledgerIndexOptional;
                instance = (BookOffersResult)object;
                this.addAllOffers(instance.offers());
                Optional<Hash256> ledgerHashOptional = instance.ledgerHash();
                if (ledgerHashOptional.isPresent()) {
                    this.ledgerHash(ledgerHashOptional);
                }
                if ((ledgerIndexOptional = instance.ledgerIndex()).isPresent()) {
                    this.ledgerIndex(ledgerIndexOptional);
                }
                if ((ledgerCurrentIndexOptional = instance.ledgerCurrentIndex()).isPresent()) {
                    this.ledgerCurrentIndex(ledgerCurrentIndexOptional);
                }
                if ((bits & 1L) == 0L) {
                    Optional<String> statusOptional = instance.status();
                    if (statusOptional.isPresent()) {
                        this.status(statusOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof XrplResult) {
                instance = (XrplResult)object;
                if ((bits & 1L) == 0L) {
                    Optional<String> statusOptional = instance.status();
                    if (statusOptional.isPresent()) {
                        this.status(statusOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder status(String status) {
            this.status = Objects.requireNonNull(status, "status");
            return this;
        }

        @JsonProperty(value="status")
        @CanIgnoreReturnValue
        public final Builder status(Optional<String> status) {
            this.status = status.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addOffers(BookOffersOffer element) {
            this.offers.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addOffers(BookOffersOffer ... elements) {
            this.offers.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="offers")
        @CanIgnoreReturnValue
        public final Builder offers(Iterable<? extends BookOffersOffer> elements) {
            this.offers = ImmutableList.builder();
            return this.addAllOffers(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllOffers(Iterable<? extends BookOffersOffer> elements) {
            this.offers.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ledgerHash(Hash256 ledgerHash) {
            this.ledgerHash = Objects.requireNonNull(ledgerHash, "ledgerHash");
            return this;
        }

        @JsonProperty(value="ledger_hash")
        @CanIgnoreReturnValue
        public final Builder ledgerHash(Optional<? extends Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ledgerIndex(LedgerIndex ledgerIndex) {
            this.ledgerIndex = Objects.requireNonNull(ledgerIndex, "ledgerIndex");
            return this;
        }

        @JsonProperty(value="ledger_index")
        @CanIgnoreReturnValue
        public final Builder ledgerIndex(Optional<? extends LedgerIndex> ledgerIndex) {
            this.ledgerIndex = ledgerIndex.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ledgerCurrentIndex(LedgerIndex ledgerCurrentIndex) {
            this.ledgerCurrentIndex = Objects.requireNonNull(ledgerCurrentIndex, "ledgerCurrentIndex");
            return this;
        }

        @JsonProperty(value="ledger_current_index")
        @CanIgnoreReturnValue
        public final Builder ledgerCurrentIndex(Optional<? extends LedgerIndex> ledgerCurrentIndex) {
            this.ledgerCurrentIndex = ledgerCurrentIndex.orElse(null);
            return this;
        }

        public ImmutableBookOffersResult build() {
            return new ImmutableBookOffersResult(this.status, this.offers.build(), this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="BookOffersResult", generator="Immutables")
    static final class Json
    implements BookOffersResult {
        @Nullable
        Optional<String> status = Optional.empty();
        @Nullable
        List<BookOffersOffer> offers = ImmutableList.of();
        @Nullable
        Optional<Hash256> ledgerHash = Optional.empty();
        @Nullable
        Optional<LedgerIndex> ledgerIndex = Optional.empty();
        @Nullable
        Optional<LedgerIndex> ledgerCurrentIndex = Optional.empty();

        Json() {
        }

        @JsonProperty(value="status")
        public void setStatus(Optional<String> status) {
            this.status = status;
        }

        @JsonProperty(value="offers")
        public void setOffers(List<BookOffersOffer> offers) {
            this.offers = offers;
        }

        @JsonProperty(value="ledger_hash")
        public void setLedgerHash(Optional<Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash;
        }

        @JsonProperty(value="ledger_index")
        public void setLedgerIndex(Optional<LedgerIndex> ledgerIndex) {
            this.ledgerIndex = ledgerIndex;
        }

        @JsonProperty(value="ledger_current_index")
        public void setLedgerCurrentIndex(Optional<LedgerIndex> ledgerCurrentIndex) {
            this.ledgerCurrentIndex = ledgerCurrentIndex;
        }

        @Override
        public Optional<String> status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<BookOffersOffer> offers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> ledgerHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerIndex> ledgerIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerIndex> ledgerCurrentIndex() {
            throw new UnsupportedOperationException();
        }
    }
}

