/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.path;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.common.LedgerSpecifier;
import org.xrpl.xrpl4j.model.client.path.BookOffersRequestParams;
import org.xrpl.xrpl4j.model.ledger.Issue;
import org.xrpl.xrpl4j.model.transactions.Address;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="BookOffersRequestParams", generator="Immutables")
@Immutable
public final class ImmutableBookOffersRequestParams
implements BookOffersRequestParams {
    private final Issue takerGets;
    private final Issue takerPays;
    @Nullable
    private final Address taker;
    private final LedgerSpecifier ledgerSpecifier;
    @Nullable
    private final UnsignedInteger limit;

    private ImmutableBookOffersRequestParams(Issue takerGets, Issue takerPays, @Nullable Address taker, LedgerSpecifier ledgerSpecifier, @Nullable UnsignedInteger limit) {
        this.takerGets = takerGets;
        this.takerPays = takerPays;
        this.taker = taker;
        this.ledgerSpecifier = ledgerSpecifier;
        this.limit = limit;
    }

    @Override
    @JsonProperty(value="taker_gets")
    public Issue takerGets() {
        return this.takerGets;
    }

    @Override
    @JsonProperty(value="taker_pays")
    public Issue takerPays() {
        return this.takerPays;
    }

    @Override
    @JsonProperty(value="taker")
    public Optional<Address> taker() {
        return Optional.ofNullable(this.taker);
    }

    @Override
    @JsonProperty(value="ledgerSpecifier")
    @JsonUnwrapped
    public LedgerSpecifier ledgerSpecifier() {
        return this.ledgerSpecifier;
    }

    @Override
    @JsonProperty(value="limit")
    public Optional<UnsignedInteger> limit() {
        return Optional.ofNullable(this.limit);
    }

    public final ImmutableBookOffersRequestParams withTakerGets(Issue value) {
        if (this.takerGets == value) {
            return this;
        }
        Issue newValue = Objects.requireNonNull(value, "takerGets");
        return new ImmutableBookOffersRequestParams(newValue, this.takerPays, this.taker, this.ledgerSpecifier, this.limit);
    }

    public final ImmutableBookOffersRequestParams withTakerPays(Issue value) {
        if (this.takerPays == value) {
            return this;
        }
        Issue newValue = Objects.requireNonNull(value, "takerPays");
        return new ImmutableBookOffersRequestParams(this.takerGets, newValue, this.taker, this.ledgerSpecifier, this.limit);
    }

    public final ImmutableBookOffersRequestParams withTaker(Address value) {
        Address newValue = Objects.requireNonNull(value, "taker");
        if (this.taker == newValue) {
            return this;
        }
        return new ImmutableBookOffersRequestParams(this.takerGets, this.takerPays, newValue, this.ledgerSpecifier, this.limit);
    }

    public final ImmutableBookOffersRequestParams withTaker(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.taker == value) {
            return this;
        }
        return new ImmutableBookOffersRequestParams(this.takerGets, this.takerPays, value, this.ledgerSpecifier, this.limit);
    }

    public final ImmutableBookOffersRequestParams withLedgerSpecifier(LedgerSpecifier value) {
        if (this.ledgerSpecifier == value) {
            return this;
        }
        LedgerSpecifier newValue = Objects.requireNonNull(value, "ledgerSpecifier");
        return new ImmutableBookOffersRequestParams(this.takerGets, this.takerPays, this.taker, newValue, this.limit);
    }

    public final ImmutableBookOffersRequestParams withLimit(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "limit");
        if (Objects.equals(this.limit, newValue)) {
            return this;
        }
        return new ImmutableBookOffersRequestParams(this.takerGets, this.takerPays, this.taker, this.ledgerSpecifier, newValue);
    }

    public final ImmutableBookOffersRequestParams withLimit(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.limit, value)) {
            return this;
        }
        return new ImmutableBookOffersRequestParams(this.takerGets, this.takerPays, this.taker, this.ledgerSpecifier, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBookOffersRequestParams && this.equalTo(0, (ImmutableBookOffersRequestParams)another);
    }

    private boolean equalTo(int synthetic, ImmutableBookOffersRequestParams another) {
        return this.takerGets.equals(another.takerGets) && this.takerPays.equals(another.takerPays) && Objects.equals(this.taker, another.taker) && this.ledgerSpecifier.equals(another.ledgerSpecifier) && Objects.equals(this.limit, another.limit);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.takerGets.hashCode();
        h += (h << 5) + this.takerPays.hashCode();
        h += (h << 5) + Objects.hashCode(this.taker);
        h += (h << 5) + this.ledgerSpecifier.hashCode();
        h += (h << 5) + Objects.hashCode(this.limit);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"BookOffersRequestParams").omitNullValues().add("takerGets", (Object)this.takerGets).add("takerPays", (Object)this.takerPays).add("taker", (Object)this.taker).add("ledgerSpecifier", (Object)this.ledgerSpecifier).add("limit", (Object)this.limit).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableBookOffersRequestParams fromJson(Json json) {
        Builder builder = ImmutableBookOffersRequestParams.builder();
        if (json.takerGets != null) {
            builder.takerGets(json.takerGets);
        }
        if (json.takerPays != null) {
            builder.takerPays(json.takerPays);
        }
        if (json.taker != null) {
            builder.taker(json.taker);
        }
        if (json.ledgerSpecifier != null) {
            builder.ledgerSpecifier(json.ledgerSpecifier);
        }
        if (json.limit != null) {
            builder.limit(json.limit);
        }
        return builder.build();
    }

    public static ImmutableBookOffersRequestParams copyOf(BookOffersRequestParams instance) {
        if (instance instanceof ImmutableBookOffersRequestParams) {
            return (ImmutableBookOffersRequestParams)instance;
        }
        return ImmutableBookOffersRequestParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BookOffersRequestParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TAKER_GETS = 1L;
        private static final long INIT_BIT_TAKER_PAYS = 2L;
        private static final long INIT_BIT_LEDGER_SPECIFIER = 4L;
        private long initBits = 7L;
        @Nullable
        private Issue takerGets;
        @Nullable
        private Issue takerPays;
        @Nullable
        private Address taker;
        @Nullable
        private LedgerSpecifier ledgerSpecifier;
        @Nullable
        private UnsignedInteger limit;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BookOffersRequestParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.takerGets(instance.takerGets());
            this.takerPays(instance.takerPays());
            Optional<Address> takerOptional = instance.taker();
            if (takerOptional.isPresent()) {
                this.taker(takerOptional);
            }
            this.ledgerSpecifier(instance.ledgerSpecifier());
            Optional<UnsignedInteger> limitOptional = instance.limit();
            if (limitOptional.isPresent()) {
                this.limit(limitOptional);
            }
            return this;
        }

        @JsonProperty(value="taker_gets")
        @CanIgnoreReturnValue
        public final Builder takerGets(Issue takerGets) {
            this.takerGets = Objects.requireNonNull(takerGets, "takerGets");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="taker_pays")
        @CanIgnoreReturnValue
        public final Builder takerPays(Issue takerPays) {
            this.takerPays = Objects.requireNonNull(takerPays, "takerPays");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder taker(Address taker) {
            this.taker = Objects.requireNonNull(taker, "taker");
            return this;
        }

        @JsonProperty(value="taker")
        @CanIgnoreReturnValue
        public final Builder taker(Optional<? extends Address> taker) {
            this.taker = taker.orElse(null);
            return this;
        }

        @JsonProperty(value="ledgerSpecifier")
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder ledgerSpecifier(LedgerSpecifier ledgerSpecifier) {
            this.ledgerSpecifier = Objects.requireNonNull(ledgerSpecifier, "ledgerSpecifier");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder limit(UnsignedInteger limit) {
            this.limit = Objects.requireNonNull(limit, "limit");
            return this;
        }

        @JsonProperty(value="limit")
        @CanIgnoreReturnValue
        public final Builder limit(Optional<? extends UnsignedInteger> limit) {
            this.limit = limit.orElse(null);
            return this;
        }

        public ImmutableBookOffersRequestParams build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBookOffersRequestParams(this.takerGets, this.takerPays, this.taker, this.ledgerSpecifier, this.limit);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("takerGets");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("takerPays");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("ledgerSpecifier");
            }
            return "Cannot build BookOffersRequestParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="BookOffersRequestParams", generator="Immutables")
    static final class Json
    implements BookOffersRequestParams {
        @Nullable
        Issue takerGets;
        @Nullable
        Issue takerPays;
        @Nullable
        Optional<Address> taker = Optional.empty();
        @Nullable
        LedgerSpecifier ledgerSpecifier;
        @Nullable
        Optional<UnsignedInteger> limit = Optional.empty();

        Json() {
        }

        @JsonProperty(value="taker_gets")
        public void setTakerGets(Issue takerGets) {
            this.takerGets = takerGets;
        }

        @JsonProperty(value="taker_pays")
        public void setTakerPays(Issue takerPays) {
            this.takerPays = takerPays;
        }

        @JsonProperty(value="taker")
        public void setTaker(Optional<Address> taker) {
            this.taker = taker;
        }

        @JsonProperty(value="ledgerSpecifier")
        @JsonUnwrapped
        public void setLedgerSpecifier(LedgerSpecifier ledgerSpecifier) {
            this.ledgerSpecifier = ledgerSpecifier;
        }

        @JsonProperty(value="limit")
        public void setLimit(Optional<UnsignedInteger> limit) {
            this.limit = limit;
        }

        @Override
        public Issue takerGets() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Issue takerPays() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Address> taker() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LedgerSpecifier ledgerSpecifier() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> limit() {
            throw new UnsupportedOperationException();
        }
    }
}

