/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.path;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.primitives.UnsignedInteger;
import java.math.BigDecimal;
import java.util.Optional;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.client.path.ImmutableBookOffersOffer;
import org.xrpl.xrpl4j.model.flags.OfferFlags;
import org.xrpl.xrpl4j.model.ledger.LedgerObject;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.CurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.Hash256;

@JsonSerialize(as=ImmutableBookOffersOffer.class)
@JsonDeserialize(as=ImmutableBookOffersOffer.class)
@Value.Immutable
public interface BookOffersOffer {
    public static ImmutableBookOffersOffer.Builder builder() {
        return ImmutableBookOffersOffer.builder();
    }

    @JsonProperty(value="LedgerEntryType")
    @Value.Derived
    default public LedgerObject.LedgerEntryType ledgerEntryType() {
        return LedgerObject.LedgerEntryType.OFFER;
    }

    @JsonProperty(value="Account")
    public Address account();

    @JsonProperty(value="Flags")
    public OfferFlags flags();

    @JsonProperty(value="Sequence")
    public UnsignedInteger sequence();

    @JsonProperty(value="TakerPays")
    public CurrencyAmount takerPays();

    @JsonProperty(value="TakerGets")
    public CurrencyAmount takerGets();

    @JsonProperty(value="BookDirectory")
    public Hash256 bookDirectory();

    @JsonProperty(value="BookNode")
    public String bookNode();

    @JsonProperty(value="OwnerNode")
    public String ownerNode();

    @JsonProperty(value="PreviousTxnID")
    public Hash256 previousTransactionId();

    @JsonProperty(value="PreviousTxnLgrSeq")
    public UnsignedInteger previousTransactionLedgerSequence();

    @JsonProperty(value="Expiration")
    public Optional<UnsignedInteger> expiration();

    public Hash256 index();

    @JsonProperty(value="owner_funds")
    public Optional<String> ownerFundsString();

    @JsonIgnore
    @Value.Derived
    default public Optional<BigDecimal> ownerFunds() {
        return this.ownerFundsString().map(BigDecimal::new);
    }

    @JsonProperty(value="taker_gets_funded")
    public Optional<CurrencyAmount> takerGetsFunded();

    @JsonProperty(value="taker_pays_funded")
    public Optional<CurrencyAmount> takerPaysFunded();

    @JsonProperty(value="quality")
    public String qualityString();

    @JsonIgnore
    @Value.Derived
    default public BigDecimal quality() {
        return new BigDecimal(this.qualityString());
    }
}

