/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.nft;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.nft.SellOffer;
import org.xrpl.xrpl4j.model.flags.NfTokenOfferFlags;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.CurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.Hash256;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SellOffer", generator="Immutables")
@Immutable
public final class ImmutableSellOffer
implements SellOffer {
    private final CurrencyAmount amount;
    private final NfTokenOfferFlags flags;
    private final Hash256 nftOfferIndex;
    private final Address owner;

    private ImmutableSellOffer(CurrencyAmount amount, NfTokenOfferFlags flags, Hash256 nftOfferIndex, Address owner) {
        this.amount = amount;
        this.flags = flags;
        this.nftOfferIndex = nftOfferIndex;
        this.owner = owner;
    }

    @Override
    @JsonProperty(value="amount")
    public CurrencyAmount amount() {
        return this.amount;
    }

    @Override
    @JsonProperty(value="flags")
    public NfTokenOfferFlags flags() {
        return this.flags;
    }

    @Override
    @JsonProperty(value="nft_offer_index")
    public Hash256 nftOfferIndex() {
        return this.nftOfferIndex;
    }

    @Override
    @JsonProperty(value="owner")
    public Address owner() {
        return this.owner;
    }

    public final ImmutableSellOffer withAmount(CurrencyAmount value) {
        if (this.amount == value) {
            return this;
        }
        CurrencyAmount newValue = Objects.requireNonNull(value, "amount");
        return new ImmutableSellOffer(newValue, this.flags, this.nftOfferIndex, this.owner);
    }

    public final ImmutableSellOffer withFlags(NfTokenOfferFlags value) {
        if (this.flags == value) {
            return this;
        }
        NfTokenOfferFlags newValue = Objects.requireNonNull(value, "flags");
        return new ImmutableSellOffer(this.amount, newValue, this.nftOfferIndex, this.owner);
    }

    public final ImmutableSellOffer withNftOfferIndex(Hash256 value) {
        if (this.nftOfferIndex == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "nftOfferIndex");
        return new ImmutableSellOffer(this.amount, this.flags, newValue, this.owner);
    }

    public final ImmutableSellOffer withOwner(Address value) {
        if (this.owner == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "owner");
        return new ImmutableSellOffer(this.amount, this.flags, this.nftOfferIndex, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSellOffer && this.equalTo(0, (ImmutableSellOffer)another);
    }

    private boolean equalTo(int synthetic, ImmutableSellOffer another) {
        return this.amount.equals(another.amount) && this.flags.equals(another.flags) && this.nftOfferIndex.equals(another.nftOfferIndex) && this.owner.equals(another.owner);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.amount.hashCode();
        h += (h << 5) + this.flags.hashCode();
        h += (h << 5) + this.nftOfferIndex.hashCode();
        h += (h << 5) + this.owner.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SellOffer").omitNullValues().add("amount", (Object)this.amount).add("flags", (Object)this.flags).add("nftOfferIndex", (Object)this.nftOfferIndex).add("owner", (Object)this.owner).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSellOffer fromJson(Json json) {
        Builder builder = ImmutableSellOffer.builder();
        if (json.amount != null) {
            builder.amount(json.amount);
        }
        if (json.flags != null) {
            builder.flags(json.flags);
        }
        if (json.nftOfferIndex != null) {
            builder.nftOfferIndex(json.nftOfferIndex);
        }
        if (json.owner != null) {
            builder.owner(json.owner);
        }
        return builder.build();
    }

    public static ImmutableSellOffer copyOf(SellOffer instance) {
        if (instance instanceof ImmutableSellOffer) {
            return (ImmutableSellOffer)instance;
        }
        return ImmutableSellOffer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SellOffer", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_AMOUNT = 1L;
        private static final long INIT_BIT_FLAGS = 2L;
        private static final long INIT_BIT_NFT_OFFER_INDEX = 4L;
        private static final long INIT_BIT_OWNER = 8L;
        private long initBits = 15L;
        @Nullable
        private CurrencyAmount amount;
        @Nullable
        private NfTokenOfferFlags flags;
        @Nullable
        private Hash256 nftOfferIndex;
        @Nullable
        private Address owner;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SellOffer instance) {
            Objects.requireNonNull(instance, "instance");
            this.amount(instance.amount());
            this.flags(instance.flags());
            this.nftOfferIndex(instance.nftOfferIndex());
            this.owner(instance.owner());
            return this;
        }

        @JsonProperty(value="amount")
        @CanIgnoreReturnValue
        public final Builder amount(CurrencyAmount amount) {
            this.amount = Objects.requireNonNull(amount, "amount");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="flags")
        @CanIgnoreReturnValue
        public final Builder flags(NfTokenOfferFlags flags) {
            this.flags = Objects.requireNonNull(flags, "flags");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="nft_offer_index")
        @CanIgnoreReturnValue
        public final Builder nftOfferIndex(Hash256 nftOfferIndex) {
            this.nftOfferIndex = Objects.requireNonNull(nftOfferIndex, "nftOfferIndex");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="owner")
        @CanIgnoreReturnValue
        public final Builder owner(Address owner) {
            this.owner = Objects.requireNonNull(owner, "owner");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableSellOffer build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSellOffer(this.amount, this.flags, this.nftOfferIndex, this.owner);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("amount");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("flags");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("nftOfferIndex");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("owner");
            }
            return "Cannot build SellOffer, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SellOffer", generator="Immutables")
    static final class Json
    implements SellOffer {
        @Nullable
        CurrencyAmount amount;
        @Nullable
        NfTokenOfferFlags flags;
        @Nullable
        Hash256 nftOfferIndex;
        @Nullable
        Address owner;

        Json() {
        }

        @JsonProperty(value="amount")
        public void setAmount(CurrencyAmount amount) {
            this.amount = amount;
        }

        @JsonProperty(value="flags")
        public void setFlags(NfTokenOfferFlags flags) {
            this.flags = flags;
        }

        @JsonProperty(value="nft_offer_index")
        public void setNftOfferIndex(Hash256 nftOfferIndex) {
            this.nftOfferIndex = nftOfferIndex;
        }

        @JsonProperty(value="owner")
        public void setOwner(Address owner) {
            this.owner = owner;
        }

        @Override
        public CurrencyAmount amount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NfTokenOfferFlags flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 nftOfferIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address owner() {
            throw new UnsupportedOperationException();
        }
    }
}

