/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.nft;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.common.LedgerSpecifier;
import org.xrpl.xrpl4j.model.client.nft.NftSellOffersRequestParams;
import org.xrpl.xrpl4j.model.transactions.Marker;
import org.xrpl.xrpl4j.model.transactions.NfTokenId;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="NftSellOffersRequestParams", generator="Immutables")
@Immutable
public final class ImmutableNftSellOffersRequestParams
implements NftSellOffersRequestParams {
    private final NfTokenId nfTokenId;
    private final LedgerSpecifier ledgerSpecifier;
    @Nullable
    private final UnsignedInteger limit;
    @Nullable
    private final Marker marker;

    private ImmutableNftSellOffersRequestParams(Builder builder) {
        this.nfTokenId = builder.nfTokenId;
        this.limit = builder.limit;
        this.marker = builder.marker;
        this.ledgerSpecifier = builder.ledgerSpecifier != null ? builder.ledgerSpecifier : Objects.requireNonNull(NftSellOffersRequestParams.super.ledgerSpecifier(), "ledgerSpecifier");
    }

    private ImmutableNftSellOffersRequestParams(NfTokenId nfTokenId, LedgerSpecifier ledgerSpecifier, @Nullable UnsignedInteger limit, @Nullable Marker marker) {
        this.nfTokenId = nfTokenId;
        this.ledgerSpecifier = ledgerSpecifier;
        this.limit = limit;
        this.marker = marker;
    }

    @Override
    @JsonProperty(value="nft_id")
    public NfTokenId nfTokenId() {
        return this.nfTokenId;
    }

    @Override
    @JsonProperty(value="ledgerSpecifier")
    @JsonUnwrapped
    public LedgerSpecifier ledgerSpecifier() {
        return this.ledgerSpecifier;
    }

    @Override
    @JsonProperty(value="limit")
    public Optional<UnsignedInteger> limit() {
        return Optional.ofNullable(this.limit);
    }

    @Override
    @JsonProperty(value="marker")
    public Optional<Marker> marker() {
        return Optional.ofNullable(this.marker);
    }

    public final ImmutableNftSellOffersRequestParams withNfTokenId(NfTokenId value) {
        if (this.nfTokenId == value) {
            return this;
        }
        NfTokenId newValue = Objects.requireNonNull(value, "nfTokenId");
        return new ImmutableNftSellOffersRequestParams(newValue, this.ledgerSpecifier, this.limit, this.marker);
    }

    public final ImmutableNftSellOffersRequestParams withLedgerSpecifier(LedgerSpecifier value) {
        if (this.ledgerSpecifier == value) {
            return this;
        }
        LedgerSpecifier newValue = Objects.requireNonNull(value, "ledgerSpecifier");
        return new ImmutableNftSellOffersRequestParams(this.nfTokenId, newValue, this.limit, this.marker);
    }

    public final ImmutableNftSellOffersRequestParams withLimit(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "limit");
        if (Objects.equals(this.limit, newValue)) {
            return this;
        }
        return new ImmutableNftSellOffersRequestParams(this.nfTokenId, this.ledgerSpecifier, newValue, this.marker);
    }

    public final ImmutableNftSellOffersRequestParams withLimit(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.limit, value)) {
            return this;
        }
        return new ImmutableNftSellOffersRequestParams(this.nfTokenId, this.ledgerSpecifier, value, this.marker);
    }

    public final ImmutableNftSellOffersRequestParams withMarker(Marker value) {
        Marker newValue = Objects.requireNonNull(value, "marker");
        if (this.marker == newValue) {
            return this;
        }
        return new ImmutableNftSellOffersRequestParams(this.nfTokenId, this.ledgerSpecifier, this.limit, newValue);
    }

    public final ImmutableNftSellOffersRequestParams withMarker(Optional<? extends Marker> optional) {
        Marker value = optional.orElse(null);
        if (this.marker == value) {
            return this;
        }
        return new ImmutableNftSellOffersRequestParams(this.nfTokenId, this.ledgerSpecifier, this.limit, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNftSellOffersRequestParams && this.equalTo(0, (ImmutableNftSellOffersRequestParams)another);
    }

    private boolean equalTo(int synthetic, ImmutableNftSellOffersRequestParams another) {
        return this.nfTokenId.equals(another.nfTokenId) && this.ledgerSpecifier.equals(another.ledgerSpecifier) && Objects.equals(this.limit, another.limit) && Objects.equals(this.marker, another.marker);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.nfTokenId.hashCode();
        h += (h << 5) + this.ledgerSpecifier.hashCode();
        h += (h << 5) + Objects.hashCode(this.limit);
        h += (h << 5) + Objects.hashCode(this.marker);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NftSellOffersRequestParams").omitNullValues().add("nfTokenId", (Object)this.nfTokenId).add("ledgerSpecifier", (Object)this.ledgerSpecifier).add("limit", (Object)this.limit).add("marker", (Object)this.marker).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableNftSellOffersRequestParams fromJson(Json json) {
        Builder builder = ImmutableNftSellOffersRequestParams.builder();
        if (json.nfTokenId != null) {
            builder.nfTokenId(json.nfTokenId);
        }
        if (json.ledgerSpecifier != null) {
            builder.ledgerSpecifier(json.ledgerSpecifier);
        }
        if (json.limit != null) {
            builder.limit(json.limit);
        }
        if (json.marker != null) {
            builder.marker(json.marker);
        }
        return builder.build();
    }

    public static ImmutableNftSellOffersRequestParams copyOf(NftSellOffersRequestParams instance) {
        if (instance instanceof ImmutableNftSellOffersRequestParams) {
            return (ImmutableNftSellOffersRequestParams)instance;
        }
        return ImmutableNftSellOffersRequestParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NftSellOffersRequestParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NF_TOKEN_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private NfTokenId nfTokenId;
        @Nullable
        private LedgerSpecifier ledgerSpecifier;
        @Nullable
        private UnsignedInteger limit;
        @Nullable
        private Marker marker;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(NftSellOffersRequestParams instance) {
            Optional<Marker> markerOptional;
            Objects.requireNonNull(instance, "instance");
            this.nfTokenId(instance.nfTokenId());
            this.ledgerSpecifier(instance.ledgerSpecifier());
            Optional<UnsignedInteger> limitOptional = instance.limit();
            if (limitOptional.isPresent()) {
                this.limit(limitOptional);
            }
            if ((markerOptional = instance.marker()).isPresent()) {
                this.marker(markerOptional);
            }
            return this;
        }

        @JsonProperty(value="nft_id")
        @CanIgnoreReturnValue
        public final Builder nfTokenId(NfTokenId nfTokenId) {
            this.nfTokenId = Objects.requireNonNull(nfTokenId, "nfTokenId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="ledgerSpecifier")
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder ledgerSpecifier(LedgerSpecifier ledgerSpecifier) {
            this.ledgerSpecifier = Objects.requireNonNull(ledgerSpecifier, "ledgerSpecifier");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder limit(UnsignedInteger limit) {
            this.limit = Objects.requireNonNull(limit, "limit");
            return this;
        }

        @JsonProperty(value="limit")
        @CanIgnoreReturnValue
        public final Builder limit(Optional<? extends UnsignedInteger> limit) {
            this.limit = limit.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder marker(Marker marker) {
            this.marker = Objects.requireNonNull(marker, "marker");
            return this;
        }

        @JsonProperty(value="marker")
        @CanIgnoreReturnValue
        public final Builder marker(Optional<? extends Marker> marker) {
            this.marker = marker.orElse(null);
            return this;
        }

        public ImmutableNftSellOffersRequestParams build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNftSellOffersRequestParams(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("nfTokenId");
            }
            return "Cannot build NftSellOffersRequestParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="NftSellOffersRequestParams", generator="Immutables")
    static final class Json
    implements NftSellOffersRequestParams {
        @Nullable
        NfTokenId nfTokenId;
        @Nullable
        LedgerSpecifier ledgerSpecifier;
        @Nullable
        Optional<UnsignedInteger> limit = Optional.empty();
        @Nullable
        Optional<Marker> marker = Optional.empty();

        Json() {
        }

        @JsonProperty(value="nft_id")
        public void setNfTokenId(NfTokenId nfTokenId) {
            this.nfTokenId = nfTokenId;
        }

        @JsonProperty(value="ledgerSpecifier")
        @JsonUnwrapped
        public void setLedgerSpecifier(LedgerSpecifier ledgerSpecifier) {
            this.ledgerSpecifier = ledgerSpecifier;
        }

        @JsonProperty(value="limit")
        public void setLimit(Optional<UnsignedInteger> limit) {
            this.limit = limit;
        }

        @JsonProperty(value="marker")
        public void setMarker(Optional<Marker> marker) {
            this.marker = marker;
        }

        @Override
        public NfTokenId nfTokenId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LedgerSpecifier ledgerSpecifier() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> limit() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Marker> marker() {
            throw new UnsupportedOperationException();
        }
    }
}

