/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.nft;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.XrplResult;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.client.nft.NftInfoResult;
import org.xrpl.xrpl4j.model.flags.NfTokenFlags;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.NfTokenId;
import org.xrpl.xrpl4j.model.transactions.NfTokenUri;
import org.xrpl.xrpl4j.model.transactions.TransferFee;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="NftInfoResult", generator="Immutables")
@Immutable
public final class ImmutableNftInfoResult
implements NftInfoResult {
    @Nullable
    private final String status;
    private final NfTokenId nftId;
    private final LedgerIndex ledgerIndex;
    private final Address owner;
    private final boolean burned;
    private final NfTokenFlags flags;
    private final TransferFee transferFee;
    private final Address issuer;
    private final UnsignedLong nftTaxon;
    private final UnsignedInteger nftSerial;
    @Nullable
    private final NfTokenUri uri;

    private ImmutableNftInfoResult(@Nullable String status, NfTokenId nftId, LedgerIndex ledgerIndex, Address owner, boolean burned, NfTokenFlags flags, TransferFee transferFee, Address issuer, UnsignedLong nftTaxon, UnsignedInteger nftSerial, @Nullable NfTokenUri uri) {
        this.status = status;
        this.nftId = nftId;
        this.ledgerIndex = ledgerIndex;
        this.owner = owner;
        this.burned = burned;
        this.flags = flags;
        this.transferFee = transferFee;
        this.issuer = issuer;
        this.nftTaxon = nftTaxon;
        this.nftSerial = nftSerial;
        this.uri = uri;
    }

    @Override
    @JsonProperty(value="status")
    public Optional<String> status() {
        return Optional.ofNullable(this.status);
    }

    @Override
    @JsonProperty(value="nft_id")
    public NfTokenId nftId() {
        return this.nftId;
    }

    @Override
    @JsonProperty(value="ledger_index")
    public LedgerIndex ledgerIndex() {
        return this.ledgerIndex;
    }

    @Override
    @JsonProperty(value="owner")
    public Address owner() {
        return this.owner;
    }

    @Override
    @JsonProperty(value="is_burned")
    public boolean burned() {
        return this.burned;
    }

    @Override
    @JsonProperty(value="flags")
    public NfTokenFlags flags() {
        return this.flags;
    }

    @Override
    @JsonProperty(value="transfer_fee")
    public TransferFee transferFee() {
        return this.transferFee;
    }

    @Override
    @JsonProperty(value="issuer")
    public Address issuer() {
        return this.issuer;
    }

    @Override
    @JsonProperty(value="nft_taxon")
    public UnsignedLong nftTaxon() {
        return this.nftTaxon;
    }

    @Override
    @JsonProperty(value="nft_serial")
    public UnsignedInteger nftSerial() {
        return this.nftSerial;
    }

    @Override
    @JsonProperty(value="uri")
    public Optional<NfTokenUri> uri() {
        return Optional.ofNullable(this.uri);
    }

    public final ImmutableNftInfoResult withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (Objects.equals(this.status, newValue)) {
            return this;
        }
        return new ImmutableNftInfoResult(newValue, this.nftId, this.ledgerIndex, this.owner, this.burned, this.flags, this.transferFee, this.issuer, this.nftTaxon, this.nftSerial, this.uri);
    }

    public final ImmutableNftInfoResult withStatus(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.status, value)) {
            return this;
        }
        return new ImmutableNftInfoResult(value, this.nftId, this.ledgerIndex, this.owner, this.burned, this.flags, this.transferFee, this.issuer, this.nftTaxon, this.nftSerial, this.uri);
    }

    public final ImmutableNftInfoResult withNftId(NfTokenId value) {
        if (this.nftId == value) {
            return this;
        }
        NfTokenId newValue = Objects.requireNonNull(value, "nftId");
        return new ImmutableNftInfoResult(this.status, newValue, this.ledgerIndex, this.owner, this.burned, this.flags, this.transferFee, this.issuer, this.nftTaxon, this.nftSerial, this.uri);
    }

    public final ImmutableNftInfoResult withLedgerIndex(LedgerIndex value) {
        if (this.ledgerIndex == value) {
            return this;
        }
        LedgerIndex newValue = Objects.requireNonNull(value, "ledgerIndex");
        return new ImmutableNftInfoResult(this.status, this.nftId, newValue, this.owner, this.burned, this.flags, this.transferFee, this.issuer, this.nftTaxon, this.nftSerial, this.uri);
    }

    public final ImmutableNftInfoResult withOwner(Address value) {
        if (this.owner == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "owner");
        return new ImmutableNftInfoResult(this.status, this.nftId, this.ledgerIndex, newValue, this.burned, this.flags, this.transferFee, this.issuer, this.nftTaxon, this.nftSerial, this.uri);
    }

    public final ImmutableNftInfoResult withBurned(boolean value) {
        if (this.burned == value) {
            return this;
        }
        return new ImmutableNftInfoResult(this.status, this.nftId, this.ledgerIndex, this.owner, value, this.flags, this.transferFee, this.issuer, this.nftTaxon, this.nftSerial, this.uri);
    }

    public final ImmutableNftInfoResult withFlags(NfTokenFlags value) {
        if (this.flags == value) {
            return this;
        }
        NfTokenFlags newValue = Objects.requireNonNull(value, "flags");
        return new ImmutableNftInfoResult(this.status, this.nftId, this.ledgerIndex, this.owner, this.burned, newValue, this.transferFee, this.issuer, this.nftTaxon, this.nftSerial, this.uri);
    }

    public final ImmutableNftInfoResult withTransferFee(TransferFee value) {
        if (this.transferFee == value) {
            return this;
        }
        TransferFee newValue = Objects.requireNonNull(value, "transferFee");
        return new ImmutableNftInfoResult(this.status, this.nftId, this.ledgerIndex, this.owner, this.burned, this.flags, newValue, this.issuer, this.nftTaxon, this.nftSerial, this.uri);
    }

    public final ImmutableNftInfoResult withIssuer(Address value) {
        if (this.issuer == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "issuer");
        return new ImmutableNftInfoResult(this.status, this.nftId, this.ledgerIndex, this.owner, this.burned, this.flags, this.transferFee, newValue, this.nftTaxon, this.nftSerial, this.uri);
    }

    public final ImmutableNftInfoResult withNftTaxon(UnsignedLong value) {
        UnsignedLong newValue = Objects.requireNonNull(value, "nftTaxon");
        if (this.nftTaxon.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableNftInfoResult(this.status, this.nftId, this.ledgerIndex, this.owner, this.burned, this.flags, this.transferFee, this.issuer, newValue, this.nftSerial, this.uri);
    }

    public final ImmutableNftInfoResult withNftSerial(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "nftSerial");
        if (this.nftSerial.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableNftInfoResult(this.status, this.nftId, this.ledgerIndex, this.owner, this.burned, this.flags, this.transferFee, this.issuer, this.nftTaxon, newValue, this.uri);
    }

    public final ImmutableNftInfoResult withUri(NfTokenUri value) {
        NfTokenUri newValue = Objects.requireNonNull(value, "uri");
        if (this.uri == newValue) {
            return this;
        }
        return new ImmutableNftInfoResult(this.status, this.nftId, this.ledgerIndex, this.owner, this.burned, this.flags, this.transferFee, this.issuer, this.nftTaxon, this.nftSerial, newValue);
    }

    public final ImmutableNftInfoResult withUri(Optional<? extends NfTokenUri> optional) {
        NfTokenUri value = optional.orElse(null);
        if (this.uri == value) {
            return this;
        }
        return new ImmutableNftInfoResult(this.status, this.nftId, this.ledgerIndex, this.owner, this.burned, this.flags, this.transferFee, this.issuer, this.nftTaxon, this.nftSerial, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNftInfoResult && this.equalTo(0, (ImmutableNftInfoResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableNftInfoResult another) {
        return Objects.equals(this.status, another.status) && this.nftId.equals(another.nftId) && this.ledgerIndex.equals(another.ledgerIndex) && this.owner.equals(another.owner) && this.burned == another.burned && this.flags.equals(another.flags) && this.transferFee.equals(another.transferFee) && this.issuer.equals(another.issuer) && this.nftTaxon.equals((Object)another.nftTaxon) && this.nftSerial.equals((Object)another.nftSerial) && Objects.equals(this.uri, another.uri);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + this.nftId.hashCode();
        h += (h << 5) + this.ledgerIndex.hashCode();
        h += (h << 5) + this.owner.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.burned);
        h += (h << 5) + this.flags.hashCode();
        h += (h << 5) + this.transferFee.hashCode();
        h += (h << 5) + this.issuer.hashCode();
        h += (h << 5) + this.nftTaxon.hashCode();
        h += (h << 5) + this.nftSerial.hashCode();
        h += (h << 5) + Objects.hashCode(this.uri);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NftInfoResult").omitNullValues().add("status", (Object)this.status).add("nftId", (Object)this.nftId).add("ledgerIndex", (Object)this.ledgerIndex).add("owner", (Object)this.owner).add("burned", this.burned).add("flags", (Object)this.flags).add("transferFee", (Object)this.transferFee).add("issuer", (Object)this.issuer).add("nftTaxon", (Object)this.nftTaxon).add("nftSerial", (Object)this.nftSerial).add("uri", (Object)this.uri).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableNftInfoResult fromJson(Json json) {
        Builder builder = ImmutableNftInfoResult.builder();
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.nftId != null) {
            builder.nftId(json.nftId);
        }
        if (json.ledgerIndex != null) {
            builder.ledgerIndex(json.ledgerIndex);
        }
        if (json.owner != null) {
            builder.owner(json.owner);
        }
        if (json.burnedIsSet) {
            builder.burned(json.burned);
        }
        if (json.flags != null) {
            builder.flags(json.flags);
        }
        if (json.transferFee != null) {
            builder.transferFee(json.transferFee);
        }
        if (json.issuer != null) {
            builder.issuer(json.issuer);
        }
        if (json.nftTaxon != null) {
            builder.nftTaxon(json.nftTaxon);
        }
        if (json.nftSerial != null) {
            builder.nftSerial(json.nftSerial);
        }
        if (json.uri != null) {
            builder.uri(json.uri);
        }
        return builder.build();
    }

    public static ImmutableNftInfoResult copyOf(NftInfoResult instance) {
        if (instance instanceof ImmutableNftInfoResult) {
            return (ImmutableNftInfoResult)instance;
        }
        return ImmutableNftInfoResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NftInfoResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NFT_ID = 1L;
        private static final long INIT_BIT_LEDGER_INDEX = 2L;
        private static final long INIT_BIT_OWNER = 4L;
        private static final long INIT_BIT_BURNED = 8L;
        private static final long INIT_BIT_FLAGS = 16L;
        private static final long INIT_BIT_TRANSFER_FEE = 32L;
        private static final long INIT_BIT_ISSUER = 64L;
        private static final long INIT_BIT_NFT_TAXON = 128L;
        private static final long INIT_BIT_NFT_SERIAL = 256L;
        private long initBits = 511L;
        @Nullable
        private String status;
        @Nullable
        private NfTokenId nftId;
        @Nullable
        private LedgerIndex ledgerIndex;
        @Nullable
        private Address owner;
        private boolean burned;
        @Nullable
        private NfTokenFlags flags;
        @Nullable
        private TransferFee transferFee;
        @Nullable
        private Address issuer;
        @Nullable
        private UnsignedLong nftTaxon;
        @Nullable
        private UnsignedInteger nftSerial;
        @Nullable
        private NfTokenUri uri;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(NftInfoResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(XrplResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            XrplResult instance;
            long bits = 0L;
            if (object instanceof NftInfoResult) {
                instance = (NftInfoResult)object;
                this.owner(instance.owner());
                this.nftTaxon(instance.nftTaxon());
                this.ledgerIndex(instance.ledgerIndex());
                this.flags(instance.flags());
                this.transferFee(instance.transferFee());
                this.nftId(instance.nftId());
                this.nftSerial(instance.nftSerial());
                Optional<NfTokenUri> uriOptional = instance.uri();
                if (uriOptional.isPresent()) {
                    this.uri(uriOptional);
                }
                this.issuer(instance.issuer());
                if ((bits & 1L) == 0L) {
                    Optional<String> statusOptional = instance.status();
                    if (statusOptional.isPresent()) {
                        this.status(statusOptional);
                    }
                    bits |= 1L;
                }
                this.burned(instance.burned());
            }
            if (object instanceof XrplResult) {
                instance = (XrplResult)object;
                if ((bits & 1L) == 0L) {
                    Optional<String> statusOptional = instance.status();
                    if (statusOptional.isPresent()) {
                        this.status(statusOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder status(String status) {
            this.status = Objects.requireNonNull(status, "status");
            return this;
        }

        @JsonProperty(value="status")
        @CanIgnoreReturnValue
        public final Builder status(Optional<String> status) {
            this.status = status.orElse(null);
            return this;
        }

        @JsonProperty(value="nft_id")
        @CanIgnoreReturnValue
        public final Builder nftId(NfTokenId nftId) {
            this.nftId = Objects.requireNonNull(nftId, "nftId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="ledger_index")
        @CanIgnoreReturnValue
        public final Builder ledgerIndex(LedgerIndex ledgerIndex) {
            this.ledgerIndex = Objects.requireNonNull(ledgerIndex, "ledgerIndex");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="owner")
        @CanIgnoreReturnValue
        public final Builder owner(Address owner) {
            this.owner = Objects.requireNonNull(owner, "owner");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="is_burned")
        @CanIgnoreReturnValue
        public final Builder burned(boolean burned) {
            this.burned = burned;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="flags")
        @CanIgnoreReturnValue
        public final Builder flags(NfTokenFlags flags) {
            this.flags = Objects.requireNonNull(flags, "flags");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="transfer_fee")
        @CanIgnoreReturnValue
        public final Builder transferFee(TransferFee transferFee) {
            this.transferFee = Objects.requireNonNull(transferFee, "transferFee");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="issuer")
        @CanIgnoreReturnValue
        public final Builder issuer(Address issuer) {
            this.issuer = Objects.requireNonNull(issuer, "issuer");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="nft_taxon")
        @CanIgnoreReturnValue
        public final Builder nftTaxon(UnsignedLong nftTaxon) {
            this.nftTaxon = Objects.requireNonNull(nftTaxon, "nftTaxon");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @JsonProperty(value="nft_serial")
        @CanIgnoreReturnValue
        public final Builder nftSerial(UnsignedInteger nftSerial) {
            this.nftSerial = Objects.requireNonNull(nftSerial, "nftSerial");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder uri(NfTokenUri uri) {
            this.uri = Objects.requireNonNull(uri, "uri");
            return this;
        }

        @JsonProperty(value="uri")
        @CanIgnoreReturnValue
        public final Builder uri(Optional<? extends NfTokenUri> uri) {
            this.uri = uri.orElse(null);
            return this;
        }

        public ImmutableNftInfoResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNftInfoResult(this.status, this.nftId, this.ledgerIndex, this.owner, this.burned, this.flags, this.transferFee, this.issuer, this.nftTaxon, this.nftSerial, this.uri);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("nftId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ledgerIndex");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("owner");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("burned");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("flags");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("transferFee");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("issuer");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("nftTaxon");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("nftSerial");
            }
            return "Cannot build NftInfoResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="NftInfoResult", generator="Immutables")
    static final class Json
    implements NftInfoResult {
        @Nullable
        Optional<String> status = Optional.empty();
        @Nullable
        NfTokenId nftId;
        @Nullable
        LedgerIndex ledgerIndex;
        @Nullable
        Address owner;
        boolean burned;
        boolean burnedIsSet;
        @Nullable
        NfTokenFlags flags;
        @Nullable
        TransferFee transferFee;
        @Nullable
        Address issuer;
        @Nullable
        UnsignedLong nftTaxon;
        @Nullable
        UnsignedInteger nftSerial;
        @Nullable
        Optional<NfTokenUri> uri = Optional.empty();

        Json() {
        }

        @JsonProperty(value="status")
        public void setStatus(Optional<String> status) {
            this.status = status;
        }

        @JsonProperty(value="nft_id")
        public void setNftId(NfTokenId nftId) {
            this.nftId = nftId;
        }

        @JsonProperty(value="ledger_index")
        public void setLedgerIndex(LedgerIndex ledgerIndex) {
            this.ledgerIndex = ledgerIndex;
        }

        @JsonProperty(value="owner")
        public void setOwner(Address owner) {
            this.owner = owner;
        }

        @JsonProperty(value="is_burned")
        public void setBurned(boolean burned) {
            this.burned = burned;
            this.burnedIsSet = true;
        }

        @JsonProperty(value="flags")
        public void setFlags(NfTokenFlags flags) {
            this.flags = flags;
        }

        @JsonProperty(value="transfer_fee")
        public void setTransferFee(TransferFee transferFee) {
            this.transferFee = transferFee;
        }

        @JsonProperty(value="issuer")
        public void setIssuer(Address issuer) {
            this.issuer = issuer;
        }

        @JsonProperty(value="nft_taxon")
        public void setNftTaxon(UnsignedLong nftTaxon) {
            this.nftTaxon = nftTaxon;
        }

        @JsonProperty(value="nft_serial")
        public void setNftSerial(UnsignedInteger nftSerial) {
            this.nftSerial = nftSerial;
        }

        @JsonProperty(value="uri")
        public void setUri(Optional<NfTokenUri> uri) {
            this.uri = uri;
        }

        @Override
        public Optional<String> status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NfTokenId nftId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LedgerIndex ledgerIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address owner() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean burned() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NfTokenFlags flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TransferFee transferFee() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address issuer() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedLong nftTaxon() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger nftSerial() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<NfTokenUri> uri() {
            throw new UnsupportedOperationException();
        }
    }
}

